/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.ArmourType;
import com.zarkonnen.airships.Body;
import com.zarkonnen.airships.Bonus;
import com.zarkonnen.airships.Combat;
import com.zarkonnen.airships.CombatSound;
import com.zarkonnen.airships.CrewAnimation;
import com.zarkonnen.airships.CrewAnimator;
import com.zarkonnen.airships.CrewType;
import com.zarkonnen.airships.Data;
import com.zarkonnen.airships.Direction;
import com.zarkonnen.airships.FireMode;
import com.zarkonnen.airships.GridBody;
import com.zarkonnen.airships.GridRef;
import com.zarkonnen.airships.Job;
import com.zarkonnen.airships.LandFormation;
import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.Module;
import com.zarkonnen.airships.ModuleType;
import com.zarkonnen.airships.Particle;
import com.zarkonnen.airships.PhysicsRect;
import com.zarkonnen.airships.Rect2D;
import com.zarkonnen.airships.Resource;
import com.zarkonnen.airships.Shot;
import com.zarkonnen.airships.Tile;
import com.zarkonnen.catengine.Draw;
import com.zarkonnen.catengine.util.Clr;
import com.zarkonnen.catengine.util.Pt;
import com.zarkonnen.catengine.util.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import org.json.JSONArray;
import org.json.JSONObject;
import org.newdawn.slick.Image;

public strictfp class Crewman
extends PhysicsRect {
    public static final double HEAL_P_MS = 2.9999999999999997E-5;
    public static final double FIRE_HARM_P_MS = 5.0E-5;
    public static final int SHOUT_LENGTH = 1800;
    public static final int BIG_SHOUT_LENGTH = 1800;
    public static final int SHOUT_MIN_DELAY = 4000;
    public static final int SHOUT_MAX_DELAY = 9000;
    public static final int RECALC_JUMP_POINT_WAIT = 300;
    public static final double HOOK_SPEED = 0.5;
    public static final double WINCH_SPEED = 0.1;
    public static final int NEW_THROW_WAIT = 3000;
    public static final int ROPE_LENGTH = 300;
    public static final int ROPE_LENGTH_SQ = 90000;
    public static final int ROPE_SAFE_LENGTH = 250;
    public static final int ROPE_SAFE_LENGTH_SQ = 62500;
    public static final double JUMP_STRENGTH = 0.15;
    public static final double OUTSIDE_SPEED = 0.035;
    public static final double MAX_JUMP_DOWN = 120.0;
    public static final double JUMP_STRAIGHT_DOWN = 128.0;
    public static final double ASSUMED_JUMP_DIST = 50.0;
    public CrewType type;
    public int hp = 5;
    public Airship ship;
    public Airship boardingShip;
    public boolean occupied = false;
    public Tile currentTile;
    public Tile movingTowards;
    public Module target;
    public Crewman headingFor;
    public int msSinceMoved;
    public int giveResourceWait;
    public int weaponReload;
    public int msUntilRecalcJumpPoint;
    public int msUntilRecalcWalkPoint;
    public Job job;
    public Resource carrying;
    public Crewman injuredCarried;
    public transient String shout;
    public transient int shoutOriginX;
    public transient int shoutOriginY;
    public transient int shoutX;
    public transient int shoutY;
    public transient int shoutW;
    public transient int shoutH;
    public transient int shoutMs;
    public transient int shoutCooldown;
    public transient int initialShoutCooldown;
    public transient boolean bigShout;
    public transient int fallingTime;
    public transient boolean standing;
    public transient CrewAnimator anim = new CrewAnimator(this);
    public transient Tile boardExitTarget;
    public double mvXOffset = 0.0;
    public double dx;
    public double dy;
    public double mvDx;
    public double mvDy;
    public Body attachedTo;
    public Body ignoring;
    public GridBody ultimateBoardTarget;
    public GridBody proximateBoardTarget;
    public GridRef walkToTargetGR;
    public GridRef walkToGR;
    public GridRef jumpSourceGR;
    public GridRef entryPoint;
    public Body dispersed;
    public boolean hookLaunched;
    public GridRef hookedGR;
    public boolean winching;
    public Pt hookSource;
    public Pt hookTarget;
    public GridBody hookTargetBody;
    public double hookProgress;
    public double hookDist;
    public int newThrowWait = 0;
    public GridRef jumpTargetGR;
    private static final HashMap<String, ArrayList<String>> shouts = new HashMap();
    public static final int W = 5;
    public static final int H = 13;

    private static void loadShouts() {
        if (shouts.isEmpty()) {
            JSONObject o = Data.get("crewShouts");
            for (Object key : o.keySet()) {
                String k = (String)key;
                JSONArray a = o.getJSONArray(k);
                ArrayList<String> l = new ArrayList<String>(a.length());
                for (int i = 0; i < a.length(); ++i) {
                    l.add(a.getString(i));
                }
                shouts.put(k, l);
            }
        }
    }

    public Crewman(Airship ship, Tile tile, CrewType type) {
        this.type = type;
        this.ship = ship;
        this.currentTile = tile;
        this.hp = type.maxHP;
        this.shoutCooldown = AGame.ANIM_R.nextInt(5000) + 4000;
        this.initialShoutCooldown = 4000;
    }

    private static double guardNaN(double v) {
        return Double.isNaN(v) || Double.isInfinite(v) ? 0.0 : v;
    }

    public JSONObject toJSON(Combat c) {
        JSONObject o = new JSONObject().put("msSinceMoved", this.msSinceMoved).put("giveResourceWait", this.giveResourceWait).put("weaponReload", this.weaponReload).put("hp", this.hp).put("type", this.type.name()).put("occupied", this.occupied).put("msUntilRecalcJumpPoint", this.msUntilRecalcJumpPoint).put("msUntilRecalcWalkPoint", this.msUntilRecalcWalkPoint);
        if (this.carrying != null) {
            o.put("carrying", this.carrying.name());
        }
        if (this.ship != null) {
            o.put("tile", this.ship.tiles.indexOf(this.currentTile));
            if (this.target != null) {
                o.put("target", this.ship.modules.indexOf(this.target));
            }
            if (this.job != null) {
                o.put("jobModule", this.ship.modules.indexOf(this.job.module()));
                o.put("jobIndex", this.job.module().jobs().indexOf(this.job));
            }
            if (this.injuredCarried != null && this.ship.crew.contains(this.injuredCarried)) {
                o.put("injuredCarried", this.ship.crew.indexOf(this.injuredCarried));
            }
            if (this.headingFor != null && this.ship.crew.contains(this.headingFor)) {
                o.put("headingFor", this.ship.crew.indexOf(this.headingFor));
            }
            if (this.movingTowards != null && this.ship.tiles.contains(this.movingTowards)) {
                o.put("movingTowards", this.ship.tiles.indexOf(this.movingTowards));
            }
        }
        if (c != null && this.isOutside()) {
            o.put("x", Crewman.guardNaN(this.x)).put("y", Crewman.guardNaN(this.y)).put("dx", Crewman.guardNaN(this.dx)).put("dy", Crewman.guardNaN(this.dy)).put("mvDx", Crewman.guardNaN(this.mvDx)).put("mvDy", Crewman.guardNaN(this.mvDy));
            if (this.attachedTo != null && c.physics.bodies.contains(this.attachedTo)) {
                o.put("attachedToIndex", c.physics.bodies.indexOf(this.attachedTo));
            }
            if (this.ignoring != null && c.physics.bodies.contains(this.ignoring)) {
                o.put("ignoringIndex", c.physics.bodies.indexOf(this.ignoring));
            }
            this.putBody(o, "boardTarget", this.ultimateBoardTarget, c);
            this.putGridRef(o, "jumpSourceTile", this.jumpSourceGR, c);
            this.putGridRef(o, "jumpTargetTile", this.jumpTargetGR, c);
            this.putGridRef(o, "entryPoint", this.entryPoint, c);
            this.putGridRef(o, "hookedTile", this.hookedGR, c);
            this.putGridRef(o, "walkToTargetGR", this.walkToTargetGR, c);
            this.putGridRef(o, "walkToGR", this.walkToGR, c);
            o.put("hookLaunched", this.hookLaunched);
            o.put("winching", this.winching);
            if (this.hookSource != null) {
                o.put("hookSourceX", this.hookSource.x);
                o.put("hookSourceY", this.hookSource.y);
            }
            if (this.hookTarget != null) {
                o.put("hookTargetX", this.hookTarget.x);
                o.put("hookTargetY", this.hookTarget.y);
            }
            this.putBody(o, "hookTarget", this.hookTargetBody, c);
            o.put("hookProgress", this.hookProgress);
            o.put("hookDist", this.hookDist);
            o.put("newThrowWait", this.newThrowWait);
        }
        return o;
    }

    private void putBody(JSONObject o, String name, GridBody gb, Combat c) {
        if (gb != null && c != null) {
            Airship s;
            Combat.Side side;
            if (gb instanceof Airship && (side = c.sideOf(s = (Airship)gb)) != null) {
                o.put(name + "SideIndex", c.sides.indexOf(side));
                o.put(name + "ShipIndex", side.ships.indexOf(gb));
            }
            if (gb instanceof LandFormation && c.landFormations.indexOf(gb) != -1) {
                o.put(name + "LFIndex", c.landFormations.indexOf(gb));
            }
        }
    }

    private void putGridRef(JSONObject o, String name, GridRef gr, Combat c) {
        if (gr != null && c != null) {
            this.putBody(o, name, gr.body, c);
            o.put(name + "X", gr.gridX);
            o.put(name + "Y", gr.gridY);
        }
    }

    public Crewman(JSONObject o, Airship ship) {
        this.ship = ship;
        if (ship != null) {
            this.currentTile = ship.tiles.get(o.getInt("tile"));
            if (o.has("target")) {
                this.target = ship.modules.get(o.getInt("target"));
            }
            if (o.has("jobModule") && ship.modules.size() > o.getInt("jobModule") && ship.modules.get(o.getInt("jobModule")).jobs().size() > o.getInt("jobIndex")) {
                this.job = ship.modules.get(o.getInt("jobModule")).jobs().get(o.getInt("jobIndex"));
            }
            if (o.has("movingTowards")) {
                this.movingTowards = ship.tiles.get(o.getInt("movingTowards"));
            }
        }
        this.msSinceMoved = o.getInt("msSinceMoved");
        this.weaponReload = o.optInt("weaponReload", 0);
        this.msUntilRecalcJumpPoint = o.optInt("msUntilRecalcJumpPoint", 0);
        this.msUntilRecalcWalkPoint = o.optInt("msUntilRecalcWalkPoint", 0);
        this.hp = o.getInt("hp");
        if (o.has("giveResourceWait")) {
            this.giveResourceWait = o.getInt("giveResourceWait");
        }
        if (o.has("carrying")) {
            this.carrying = Resource.valueOf(o.getString("carrying"));
        }
        this.type = CrewType.valueOf(o.optString("type", CrewType.SAILOR.name()));
        this.occupied = o.optBoolean("occupied", false);
        this.x = o.optDouble("x", 0.0);
        this.y = o.optDouble("y", 0.0);
        this.dx = o.optDouble("dx", 0.0);
        this.dy = o.optDouble("dy", 0.0);
        this.mvDx = o.optDouble("mvDx", 0.0);
        this.mvDy = o.optDouble("mvDy", 0.0);
    }

    public void finishLoading(JSONObject o, Combat c) {
        if (this.ship != null) {
            if (o.has("injuredCarried")) {
                this.injuredCarried = this.ship.crew.get(o.getInt("injuredCarried"));
            }
            if (o.has("headingFor")) {
                this.headingFor = this.ship.crew.get(o.getInt("headingFor"));
            }
        }
        if (c != null) {
            if (o.has("attachedToIndex")) {
                this.attachedTo = c.physics.bodies.get(o.getInt("attachedToIndex"));
            }
            if (o.has("ignoringIndex")) {
                this.ignoring = c.physics.bodies.get(o.getInt("ignoringIndex"));
            }
            this.ultimateBoardTarget = this.getBody(o, "boardTarget", c);
            this.jumpSourceGR = this.getGridRef(o, "jumpSourceTile", c);
            this.jumpTargetGR = this.getGridRef(o, "jumpTargetTile", c);
            this.walkToTargetGR = this.getGridRef(o, "walkToTargetGR", c);
            this.walkToGR = this.getGridRef(o, "walkToGR", c);
            this.entryPoint = this.getGridRef(o, "entryPoint", c);
            this.hookedGR = this.getGridRef(o, "hookedTile", c);
            this.hookLaunched = o.optBoolean("hookLaunched");
            this.winching = o.optBoolean("winching");
            if (o.has("hookSourceX")) {
                this.hookSource = new Pt(o.getDouble("hookSourceX"), o.getDouble("hookSourceY"));
            }
            if (o.has("hookTargetX")) {
                this.hookTarget = new Pt(o.getDouble("hookTargetX"), o.getDouble("hookTargetY"));
            }
            this.hookTargetBody = this.getBody(o, "hookTarget", c);
            this.hookProgress = o.optDouble("hookProgress", 0.0);
            this.hookDist = o.optDouble("hookDist", 0.0);
            this.newThrowWait = o.optInt("newThrowWait", 0);
        }
    }

    private GridBody getBody(JSONObject o, String name, Combat c) {
        if (c != null && o.has(name + "SideIndex")) {
            Combat.Side side = c.sides.get(o.getInt(name + "SideIndex"));
            return side.ships.get(o.getInt(name + "ShipIndex"));
        }
        if (c != null && o.has(name + "LFIndex")) {
            return c.landFormations.get(o.getInt(name + "LFIndex"));
        }
        return null;
    }

    private GridRef getGridRef(JSONObject o, String name, Combat c) {
        GridBody gb = this.getBody(o, name, c);
        if (gb != null) {
            return new GridRef(o.getInt(name + "X"), o.getInt(name + "Y"), gb);
        }
        return null;
    }

    public Crewman carrier() {
        Airship sh = this.ship == null ? this.boardingShip : this.ship;
        int csz = sh.crew.size();
        for (int ci = 0; ci < csz; ++ci) {
            Crewman cm = sh.crew.get(ci);
            if (cm.injuredCarried != this) continue;
            return cm;
        }
        return null;
    }

    public boolean beingCarried() {
        Airship sh = this.ship == null ? this.boardingShip : this.ship;
        int csz = sh.crew.size();
        for (int ci = 0; ci < csz; ++ci) {
            Crewman cm = sh.crew.get(ci);
            if (cm.injuredCarried != this) continue;
            return true;
        }
        return false;
    }

    public boolean needsRescue() {
        if (!this.alive() || this.active() || this.currentTile.module.type.getSickbay() > 0 && this.currentTile.module.hp > 0 && this.currentTile.module.somewhatStaffed()) {
            return false;
        }
        int csz = this.ship.crew.size();
        for (int ci = 0; ci < csz; ++ci) {
            Crewman cm = this.ship.crew.get(ci);
            if (cm.headingFor != this && cm.injuredCarried != this) continue;
            return false;
        }
        return true;
    }

    public boolean active() {
        return this.hp >= this.type.minWorkingHP;
    }

    public boolean alive() {
        return this.hp > 0;
    }

    public double speed(Tile targetTile) {
        double s;
        Airship sh = this.ship == null ? this.boardingShip : this.ship;
        double d = s = sh.currentBonuses.contains((Object)Bonus.WILL_TO_SURVIVE) ? 1.0 : 1.0 * (double)this.hp / (double)this.type.maxHP;
        if (this.carrying != null) {
            s *= this.type.carrySpeedMult;
        }
        if (targetTile.y < this.currentTile.y) {
            s *= this.type.goingUpSpeedMult;
        }
        if (targetTile.module.fire > 0) {
            s *= this.type.fireSpeedMult;
        }
        return s *= 1.0 + (double)(this.currentTile.module.getMaxHP() - this.currentTile.module.hp) * this.type.dmgWorstSpeedMalus / (double)this.currentTile.module.getMaxHP();
    }

    public void sanityCheck(Combat c) {
        if (this.carrying != Resource.INJURED && this.injuredCarried != null) {
            System.out.println("Carrying person but carrying resource: " + this.carrying.name() + " with job " + this.job + ".");
        }
        if (this.target != null && this.job == null) {
            System.out.println("Target without job.");
            System.out.println(this.target.type.getName());
            System.out.println((Object)this.carrying);
        }
        if (this.target != null && this.headingFor != null) {
            System.out.println("Both module and CM target.");
        }
    }

    private void dropCarried() {
        this.carrying = null;
        if (this.injuredCarried != null) {
            this.injuredCarried.currentTile = this.currentTile;
            this.injuredCarried.msSinceMoved = 0;
            this.injuredCarried = null;
        }
    }

    public void abandonJob() {
        this.target = null;
        this.headingFor = null;
        this.job = null;
        this.dropCarried();
    }

    public void tick(int ms, Combat c, Combat.Side mySide, boolean won, boolean lost) {
        this.anim.tick(ms);
        if (this.ship != null && this.crewTick(ms, c, mySide, won, lost)) {
            return;
        }
        if (this.boardingShip != null) {
            this.boarderTick(ms, c, won, lost);
        }
        this.shoot(c, ms);
        if (!this.occupied && this.ship != null && this.anim.specialDuration <= 0 && won) {
            this.anim.animate(CrewAnimation.HAPPY, 4000, null);
        }
        if (!this.occupied && this.ship != null && this.anim.specialDuration <= 0 && lost) {
            this.anim.animate(CrewAnimation.SAD, 4000, null);
        }
    }

    public void shoot(Combat c, int ms) {
        this.weaponReload -= ms;
        if (!this.active() || this.weaponReload > 0) {
            return;
        }
        boolean interesting = this.interesting(this.currentTile.module);
        if (this.type == CrewType.SAILOR && this.hp == this.type.maxHP && !interesting) {
            return;
        }
        Crewman victim = null;
        if (this.ship != null) {
            int bsz = this.ship.boarders.size();
            for (int bi = 0; bi < bsz; ++bi) {
                Crewman b = this.ship.boarders.get(bi);
                if (!b.active() || b.currentTile.module != this.currentTile.module || !interesting && b.type == CrewType.SAILOR && b.hp >= this.type.maxHP) continue;
                victim = b;
                break;
            }
        }
        if (this.boardingShip != null) {
            int csz = this.boardingShip.crew.size();
            for (int ci = 0; ci < csz; ++ci) {
                Crewman cm = this.boardingShip.crew.get(ci);
                if (!cm.active() || cm.currentTile.module != this.currentTile.module || !interesting && cm.type == CrewType.SAILOR && cm.hp >= this.type.maxHP) continue;
                victim = cm;
                break;
            }
        }
        if (victim == null) {
            return;
        }
        Airship sh = this.ship == null ? this.boardingShip : this.ship;
        double sx = sh.x + (double)(sh.gridXToWorldX(this.currentTile.x, 1) * 16) + 8.0;
        double sy = sh.y + (double)(this.currentTile.y * 16) + 8.0;
        c.particles.add(new Particle(Particle.Type.MUZZLE_SMALL, sx, sy));
        c.sounds.add(new CombatSound("rifle" + AGame.ANIM_R.nextInt(2), (int)sx, (int)sy, 1.0));
        Tile t2 = this.movingTowards;
        if (t2 != null) {
            sx = sh.flipped ? (sx -= (double)(t2.x - this.currentTile.x) * 1.0 * (double)this.msSinceMoved / (double)this.currentTile.getMoveDelay() * this.speed(t2) * 16.0) : (sx += (double)(t2.x - this.currentTile.x) * 1.0 * (double)this.msSinceMoved / (double)this.currentTile.getMoveDelay() * this.speed(t2) * 16.0);
            sy += (double)(t2.y - this.currentTile.y) * 1.0 * (double)this.msSinceMoved / (double)this.currentTile.getMoveDelay() * this.speed(t2) * 16.0;
        }
        double tx = sh.x + (double)(sh.gridXToWorldX(victim.currentTile.x, 1) * 16) + 8.0;
        double ty = sh.y + (double)(victim.currentTile.y * 16) + 8.0;
        c.shots.add(new Shot(sh, tx, ty, this, sx, sy, this.type.shotDamage, this.ship != null));
        this.weaponReload = this.weaponReload(c);
        this.anim.animate(victim.currentTile.x > this.currentTile.x != sh.flipped ? CrewAnimation.SHOOT_RIGHT : CrewAnimation.SHOOT_LEFT, 500, null);
    }

    public int weaponReload(Combat c) {
        Combat.Side mySide;
        int rel = this.type.weaponReload;
        if (this.ship != null) {
            rel = (int)((double)rel * 0.75);
        }
        if ((mySide = c.sideOf(this.boardingShip == null ? this.ship : this.boardingShip)) != null && mySide.bonuses.contains((Object)Bonus.DANGEROUS_FIGHTERS)) {
            rel = (int)((double)rel * 0.67);
        }
        return rel;
    }

    public boolean interesting(Module m) {
        Airship sh;
        if (m == null) {
            return false;
        }
        Airship airship = sh = this.ship == null ? this.boardingShip : this.ship;
        if (m.type.isWeapon() || m.type.getCommand() > 0 || m.type.getPropulsion() > 0.0) {
            int csz = sh.crew.size();
            for (int ci = 0; ci < csz; ++ci) {
                Crewman cm = sh.crew.get(ci);
                if (!cm.active() || cm.currentTile.module != m) continue;
                return true;
            }
        } else {
            int csz = sh.crew.size();
            for (int ci = 0; ci < csz; ++ci) {
                Crewman cm = sh.crew.get(ci);
                if (cm.type == CrewType.MARINE || !cm.active() || cm.currentTile.module != m) continue;
                return true;
            }
        }
        return false;
    }

    public void boarderTick(int ms, Combat c, boolean won, boolean lost) {
        ArrayList<Tile> path;
        Module m;
        int mi;
        int msz;
        int best;
        this.boarderShout(ms, c);
        if (!this.active()) {
            return;
        }
        if (this.interesting(this.currentTile.module)) {
            this.target = null;
        } else if (!this.interesting(this.target)) {
            this.target = null;
            best = 0;
            msz = this.boardingShip.modules.size();
            for (mi = 0; mi < msz; ++mi) {
                m = this.boardingShip.modules.get(mi);
                if (!this.interesting(m) || (path = this.boardingShip.getPath(this.currentTile, m)) == null || this.target != null && best <= path.size()) continue;
                this.target = m;
                best = path.size();
            }
        }
        if (this.target == null) {
            best = 0;
            msz = this.boardingShip.modules.size();
            for (mi = 0; mi < msz; ++mi) {
                m = this.boardingShip.modules.get(mi);
                if (m.type.getCommand() <= 0 || m.hp <= 0 || (path = this.boardingShip.getPath(this.currentTile, m)) == null || this.target != null && best <= path.size()) continue;
                this.target = m;
                best = path.size();
            }
        }
        if (this.target == null) {
            int csz = this.boardingShip.crew.size();
            int best2 = 0;
            for (int ci = 0; ci < csz; ++ci) {
                Module m2;
                ArrayList<Tile> path2;
                Crewman cm = this.boardingShip.crew.get(ci);
                if (cm.type == CrewType.SAILOR || !cm.active() || (path2 = this.boardingShip.getPath(this.currentTile, m2 = cm.currentTile.module)) == null || this.target != null && best2 <= path2.size()) continue;
                this.target = m2;
                best2 = path2.size();
            }
        }
        Tile targetTile = null;
        if (this.target != null && this.currentTile.module != this.target) {
            ArrayList<Tile> path3 = this.boardingShip.getPath(this.currentTile, this.target);
            if (path3 == null) {
                this.target = null;
                targetTile = null;
            } else {
                targetTile = path3.get(0);
            }
        }
        if (targetTile != this.movingTowards) {
            this.msSinceMoved -= 2 * ms;
            if (this.msSinceMoved <= 0) {
                this.msSinceMoved *= -1;
                this.movingTowards = targetTile;
            }
        } else {
            this.msSinceMoved += ms;
        }
        if (this.movingTowards != null && (double)this.msSinceMoved >= (double)this.currentTile.getMoveDelay() / this.speed(this.movingTowards)) {
            this.msSinceMoved = (int)((double)this.msSinceMoved - (double)this.currentTile.getMoveDelay() / this.speed(this.movingTowards));
            this.currentTile = this.movingTowards;
        }
    }

    public boolean crewTick(int ms, Combat c, Combat.Side mySide, boolean won, boolean lost) {
        ArrayList<Tile> path;
        ArrayList<Tile> path2;
        double gameX = this.ship.getX() + this.ship.gridXToWorldX(this.currentTile.x, 1) * 16 + 8;
        double gameY = this.ship.getY() + this.currentTile.y * 16 + 8;
        this.shout(ms, c, won, lost);
        if (this.currentTile.module.fire > 0 && c.r.nextDouble() < (double)this.currentTile.module.fire * 5.0E-5 * (double)ms && this.hp > 0) {
            this.hp = Math.max(0, this.hp - 1);
            c.play("cough" + AGame.ANIM_R.nextInt(4), (int)gameX, (int)gameY, 0.3);
        }
        if (this.alive() && this.hp < this.type.maxHP && this.currentTile.module.fullyStaffed() && this.currentTile.module.type.getSickbay() > 0 && c.r.nextDouble() < (double)(this.currentTile.module.type.getSickbay() * ms) * 2.9999999999999997E-5) {
            ++this.hp;
            for (int i = 0; i < 5; ++i) {
                c.particles.add(new Particle(Particle.Type.HEALING, gameX, gameY));
            }
        }
        this.giveResourceWait -= ms;
        if (this.giveResourceWait > 0) {
            return false;
        }
        if (this.job != null) {
            if (!this.ship.modules.contains(this.job.module()) || !this.active() || !this.job.active() || this.headingFor != null && !this.headingFor.alive()) {
                this.abandonJob();
                return false;
            }
            if (this.job.resource() != null || this.currentTile.module != this.job.module()) {
                this.msSinceMoved += ms;
            }
            if (this.job.resource() != null && this.job.resource() != this.carrying && this.job.resource() != Resource.INJURED) {
                int closest = 0;
                Module best = null;
                int msz = this.ship.modules.size();
                for (int mi = 0; mi < msz; ++mi) {
                    ArrayList<Tile> modulePath;
                    Module m = this.ship.modules.get(mi);
                    if (m.getResource(this.job.resource()) <= 0 || (path2 = this.ship.getPath(this.currentTile, m)) == null || (modulePath = this.ship.getPath(path2.isEmpty() ? this.currentTile : path2.get(path2.size() - 1), this.job.module())) == null) continue;
                    int d = path2.size() + modulePath.size();
                    if (best != null && d >= closest) continue;
                    best = m;
                    closest = d;
                }
                this.target = best;
            } else {
                this.target = null;
            }
            if (this.job.resource() == null || this.job.resource() == this.carrying) {
                this.target = this.job.module();
            }
        }
        if (this.job == null) {
            this.abandonJob();
        }
        if (this.target != null && !this.ship.modules.contains(this.target) || this.headingFor != null && !this.ship.tiles.contains(this.headingFor.currentTile)) {
            this.abandonJob();
        }
        Tile targetTile = null;
        if (this.ultimateBoardTarget != null && this.ultimateBoardTarget != this.ship) {
            if (this.currentTile.enterable()) {
                this.popOut(mySide, c);
                return true;
            }
            if (!(this.boardExitTarget == null || this.boardExitTarget.enterable() && this.ship.tiles.contains(this.boardExitTarget))) {
                this.boardExitTarget = null;
            }
            if (this.boardExitTarget == null) {
                int tsz = this.ship.tiles.size();
                int closestDist = 0;
                for (int ti = 0; ti < tsz; ++ti) {
                    Tile t = this.ship.tiles.get(ti);
                    if (!t.enterable() || (path2 = this.ship.getPath(this.currentTile, t)) == null || this.boardExitTarget != null && path2.size() >= closestDist) continue;
                    this.boardExitTarget = t;
                    closestDist = path2.size();
                }
            }
            if (this.boardExitTarget != null && (path = this.ship.getPath(this.currentTile, this.boardExitTarget)) != null) {
                targetTile = path.get(0);
                this.msSinceMoved += ms;
            }
        } else if (this.target != null && this.currentTile.module != this.target) {
            path = this.ship.getPath(this.currentTile, this.target);
            if (path == null) {
                this.abandonJob();
            } else {
                targetTile = path.get(0);
            }
        }
        if (this.headingFor != null && this.currentTile != this.headingFor.currentTile) {
            ArrayList<Tile> pathTo = this.ship.getPath(this.currentTile, this.headingFor.currentTile);
            if (pathTo == null) {
                this.abandonJob();
            } else {
                targetTile = pathTo.get(0);
            }
        }
        if (targetTile != this.movingTowards) {
            this.msSinceMoved -= 2 * ms;
            if (this.msSinceMoved <= 0) {
                this.msSinceMoved *= -1;
                this.movingTowards = targetTile;
            }
        }
        if (this.movingTowards != null && (double)this.msSinceMoved >= (double)this.currentTile.getMoveDelay() / this.speed(this.movingTowards)) {
            this.msSinceMoved = (int)((double)this.msSinceMoved - (double)this.currentTile.getMoveDelay() / this.speed(this.movingTowards));
            this.currentTile = this.movingTowards;
        }
        if (this.job != null) {
            if (this.job.resource() != null && this.carrying != this.job.resource() && this.currentTile.module.getResource(this.job.resource()) > 0 && this.msSinceMoved >= this.pickupCost()) {
                this.msSinceMoved -= this.pickupCost();
                this.currentTile.module.takeResource(this.job.resource());
                int cap = this.ship.getTotalResourceCapacity(this.job.resource());
                int left = this.ship.getTotalResource(this.job.resource());
                if (left == 0) {
                    this.doShout(this.pickShout("outOf" + this.job.resource().name()));
                } else if ((double)left < 0.05 * (double)cap) {
                    this.doShout(this.pickShout("veryLow" + this.job.resource().name()));
                } else if ((double)left < 0.2 * (double)cap) {
                    this.doShout(this.pickShout("low" + this.job.resource().name()));
                }
                this.dropCarried();
                this.carrying = this.job.resource();
            }
            if (this.job.resource() == Resource.INJURED && this.headingFor != null && this.headingFor.currentTile == this.currentTile && this.msSinceMoved >= this.pickupCost()) {
                this.dropCarried();
                this.msSinceMoved -= this.pickupCost();
                this.carrying = Resource.INJURED;
                this.injuredCarried = this.headingFor;
                this.headingFor = null;
            }
            if (this.job.resource() != null && this.job.resource() == this.carrying && this.currentTile.module == this.job.module()) {
                boolean repairing = this.carrying == Resource.REPAIR && this.currentTile.module.hp <= 0 && this.currentTile.module.type != ModuleType.CORRIDOR;
                this.currentTile.module.giveResource(this.carrying, c);
                if (repairing && this.currentTile.module.hp > 0) {
                    this.shout("repaired");
                }
                this.giveResourceWait = this.giveCost();
                if (this.carrying == Resource.REPAIR) {
                    this.anim.animate(CrewAnimation.REPAIR, this.giveResourceWait, null);
                } else {
                    this.anim.animate(this.anim.lastFlipped ? CrewAnimation.GIVE_LEFT : CrewAnimation.GIVE_RIGHT, 500, this.injuredCarried == null ? this.carrying : Resource.INJURED);
                }
                if (this.carrying == Resource.WATER) {
                    double mx = this.ship.x + (double)(this.ship.gridXToWorldX(this.currentTile.module.x, this.currentTile.module.type.getW()) * 16) + (double)(this.currentTile.module.type.getW() * 16 / 2);
                    double my = this.ship.y + (double)(this.currentTile.module.y * 16) + (double)(this.currentTile.module.type.getH() * 16 / 2);
                    for (int i = 0; i < 16; ++i) {
                        c.particles.add(new Particle(Particle.Type.WATER, mx, my));
                    }
                }
                this.abandonJob();
            }
        }
        this.sanityCheck(c);
        return false;
    }

    private int giveCost() {
        if (this.carrying == Resource.REPAIR) {
            return this.type.repairTime;
        }
        return 500;
    }

    private int pickupCost() {
        int c = this.type.pickupMs;
        if (this.currentTile.module.fire > 0) {
            c = (int)((double)c * this.type.pickupFireMult);
        }
        c = (int)((double)c * (1.0 + (double)(this.currentTile.module.getMaxHP() - this.currentTile.module.hp) * this.type.pickupDmgMaxMalus / (double)this.currentTile.module.getMaxHP()));
        return c;
    }

    public void simpleDraw(Draw d, double tx, double ty, int ms, Image[] light, float lightStrength, float ambient) {
        if (this.beingCarried()) {
            return;
        }
        Airship sh = this.ship == null ? this.boardingShip : this.ship;
        Tile t2 = this.movingTowards;
        if (t2 != null) {
            tx = sh.flipped ? (tx -= (double)(t2.x - this.currentTile.x) * 1.0 * (double)this.msSinceMoved / (double)this.currentTile.getMoveDelay() * this.speed(t2) * 16.0) : (tx += (double)(t2.x - this.currentTile.x) * 1.0 * (double)this.msSinceMoved / (double)this.currentTile.getMoveDelay() * this.speed(t2) * 16.0);
            ty += (double)(t2.y - this.currentTile.y) * 1.0 * (double)this.msSinceMoved / (double)this.currentTile.getMoveDelay() * this.speed(t2) * 16.0;
        }
        this.type.simpleLook.draw(d, tx, ty, ms, sh.flipped, light, lightStrength, ambient);
        if (this.carrying != null) {
            this.carrying.carryApp.draw(d, tx, ty, ms, sh.flipped, light, lightStrength, ambient);
        }
    }

    public void draw(Draw d, double tx, double ty, int ms, Image[] light, float lightStrength, float ambient, Clr ambientTint) {
        if (this.beingCarried()) {
            return;
        }
        Airship sh = this.ship == null ? this.boardingShip : this.ship;
        Tile t2 = this.movingTowards;
        if (t2 != null) {
            tx = sh.flipped ? (tx -= (double)(t2.x - this.currentTile.x) * 1.0 * (double)this.msSinceMoved / (double)this.currentTile.getMoveDelay() * this.speed(t2) * 16.0) : (tx += (double)(t2.x - this.currentTile.x) * 1.0 * (double)this.msSinceMoved / (double)this.currentTile.getMoveDelay() * this.speed(t2) * 16.0);
            ty += (double)(t2.y - this.currentTile.y) * 1.0 * (double)this.msSinceMoved / (double)this.currentTile.getMoveDelay() * this.speed(t2) * 16.0;
        }
        this.anim.draw(d, tx + 8.0, ty + 2.0, sh.flipped, light, lightStrength, ambient, ambientTint);
    }

    public boolean isOutside() {
        return this.ship == null && this.boardingShip == null;
    }

    public boolean canPopOut() {
        return this.currentTile.enterable();
    }

    public void popOut(Combat.Side mySide, Combat c) {
        Airship sh = this.ship == null ? this.boardingShip : this.ship;
        Tile t2 = this.movingTowards;
        this.x = sh.x + (double)(sh.gridXToWorldX(this.currentTile.x, 1) * 16) + 8.0;
        this.y = sh.y + (double)(this.currentTile.y * 16) + 16.0 - 13.0;
        if (t2 != null) {
            this.x = sh.flipped ? (this.x -= (double)(t2.x - this.currentTile.x) * 1.0 * (double)this.msSinceMoved / (double)this.currentTile.getMoveDelay() * this.speed(t2) * 16.0) : (this.x += (double)(t2.x - this.currentTile.x) * 1.0 * (double)this.msSinceMoved / (double)this.currentTile.getMoveDelay() * this.speed(t2) * 16.0);
            this.y += (double)(t2.y - this.currentTile.y) * 1.0 * (double)this.msSinceMoved / (double)this.currentTile.getMoveDelay() * this.speed(t2) * 16.0;
        }
        sh.crew.remove(this);
        sh.boarders.remove(this);
        this.currentTile = null;
        this.movingTowards = null;
        this.attachedTo = sh;
        this.ship = null;
        this.boardingShip = null;
        mySide.troops.add(this);
        this.msUntilRecalcJumpPoint = c.r.nextInt(300);
    }

    public boolean canPopIn(Airship target) {
        return this.popInTile(target) != null;
    }

    public Tile popInTile(Airship target) {
        if (!Rect2D.intersects(this.x, this.y, 5.0, 13.0, target.x, target.y, target.getBBWidth(), target.getBBHeight())) {
            return null;
        }
        for (int yOffset = 0; yOffset < 2; ++yOffset) {
            for (int xOffset = 0; xOffset < 2; ++xOffset) {
                int tgy;
                double ox = this.x + (double)(5 * xOffset) - target.x;
                double oy = this.y + (double)(13 * yOffset) - target.y;
                int tgx = target.flipped ? (int)(target.getBBWidth() - ox) / 16 : (int)(ox / 16.0);
                tgx = Math.min(target.getWidth() - 1, Math.max(0, tgx));
                Tile t = target.tileAt(tgx, tgy = Math.min(target.getHeight() - 1, Math.max(0, (int)(oy / 16.0))));
                if (t == null || !t.canOccupy || !t.enterable()) continue;
                return t;
            }
        }
        return null;
    }

    public boolean popIn(Airship target, boolean asBoarder) {
        Tile t = this.popInTile(target);
        if (t == null) {
            return false;
        }
        if (asBoarder) {
            this.boardingShip = target;
            target.boarders.add(this);
        } else {
            this.ship = target;
            target.crew.add(this);
        }
        this.currentTile = t;
        this.attachedTo = null;
        this.ignoring = null;
        this.ultimateBoardTarget = null;
        this.proximateBoardTarget = null;
        return true;
    }

    public void drop() {
        this.ignoring = this.attachedTo;
        this.attachedTo = null;
    }

    public void jump(double angle, double speed) {
        this.drop();
        this.dx += Math.cos(angle) * speed;
        this.dy -= Math.sin(angle) * speed;
        this.mvDx = 0.0;
        this.mvDy = 0.0;
    }

    public GridRef findJumpPoint(Combat.Side side, boolean jumpDownOnly) {
        if (!(this.attachedTo instanceof GridBody)) {
            return null;
        }
        GridBody att = (GridBody)this.attachedTo;
        GridRef best = null;
        double shortestDsq = 0.0;
        for (int tgy = 0; tgy < att.getGridHeight(); ++tgy) {
            block1: for (int tgx = 0; tgx < att.getGridWidth(); ++tgx) {
                if (!att.solidAt(tgx, tgy)) continue;
                double tx = att.x + (double)(tgx * 16);
                double ty = att.y + (double)(tgy * 16) - 13.0 + 0.5;
                double angle = this.findJumpAngle(tx, ty, null);
                if (!(jumpDownOnly ? angle == 128.0 : !Double.isNaN(angle))) continue;
                double dsq = (tx - this.x) * (tx - this.x) + (ty - this.y) * (ty - this.y);
                if (best != null && !(dsq < shortestDsq)) continue;
                int csz = side.troops.size();
                for (int ci = 0; ci < csz; ++ci) {
                    GridRef jsgr = side.troops.get((int)ci).jumpSourceGR;
                    if (jsgr != null && jsgr.gridX == tgx && jsgr.gridY == tgy) continue block1;
                }
                best = new GridRef(tgx, tgy, att);
                shortestDsq = dsq;
            }
        }
        return best;
    }

    public double findJumpAngle(double sourceX, double sourceY, GridRef[] tt) {
        int bw = this.proximateBoardTarget.getGridWidth();
        int bh = this.proximateBoardTarget.getGridHeight();
        double bestAngle = Double.NaN;
        for (int borderIndex = 0; borderIndex < bw + bh; ++borderIndex) {
            double angle;
            int tgy;
            int tgx;
            int n = borderIndex < bw ? borderIndex : (tgx = sourceX < this.proximateBoardTarget.x ? 0 : bw - 1);
            int n2 = borderIndex < bw ? (sourceY < this.proximateBoardTarget.y + this.proximateBoardTarget.getBBHeight() ? this.proximateBoardTarget.firstSolidBlockYAt(tgx) : bh - 1) : (tgy = borderIndex - bw);
            if (!this.proximateBoardTarget.solidAt(tgx, tgy) || Double.isNaN(angle = Crewman.findJumpAngle(sourceX, sourceY, this.proximateBoardTarget.x + (double)(tgx * 16), this.proximateBoardTarget.y + (double)(tgy * 16) - 13.0 + 0.5, 0.15))) continue;
            if (tt != null) {
                tt[0] = new GridRef(tgx, tgy, this.proximateBoardTarget);
            }
            bestAngle = angle;
            if (angle != 128.0) continue;
            return angle;
        }
        return bestAngle;
    }

    public GridRef findHookPoint(Combat.Side side) {
        if (!(this.attachedTo instanceof GridBody)) {
            return null;
        }
        GridBody att = (GridBody)this.attachedTo;
        GridRef best = null;
        double shortestDsq = 0.0;
        for (int tgy = 0; tgy < att.getGridHeight(); ++tgy) {
            block1: for (int tgx = 0; tgx < att.getGridWidth(); ++tgx) {
                double ty;
                double tx;
                int quality;
                if (!att.solidAt(tgx, tgy) || (quality = this.canHookFrom(tx = this.attachedTo.x + (double)(tgx * 16), ty = this.attachedTo.y + (double)(tgy * 16) - 13.0 + 0.5)) <= 0) continue;
                int csz = side.troops.size();
                for (int ci = 0; ci < csz; ++ci) {
                    GridRef jsgr = side.troops.get((int)ci).jumpSourceGR;
                    if (jsgr != null && jsgr.gridX == tgx && jsgr.gridY == tgy) continue block1;
                }
                double dsq = (tx - this.x) * (tx - this.x) + (ty - this.y) * (ty - this.y);
                dsq /= (double)(quality * quality);
                if (best != null && !(dsq < shortestDsq)) continue;
                best = new GridRef(tgx, tgy, att);
                shortestDsq = dsq;
            }
        }
        return best;
    }

    public Utils.Pair<Pt, GridRef> findHookTarget(double sourceX, double sourceY, Combat.Side side) {
        int bw = this.proximateBoardTarget.getGridWidth();
        int bh = this.proximateBoardTarget.getGridHeight();
        boolean bestEnterable = false;
        Pt bestPt = null;
        GridRef targetGR = null;
        double bestDsq = 0.0;
        block0: for (int borderIndex = 0; borderIndex < bw + bh; ++borderIndex) {
            int tgy;
            int tgx;
            int n = borderIndex < bw ? borderIndex : (tgx = sourceX < this.proximateBoardTarget.x ? 0 : bw - 1);
            int n2 = borderIndex < bw ? (sourceY < this.proximateBoardTarget.y + this.proximateBoardTarget.getBBHeight() ? 0 : bh - 1) : (tgy = borderIndex - bw);
            if (!this.proximateBoardTarget.solidAt(tgx, tgy)) continue;
            double tx = this.proximateBoardTarget.x + (double)(tgx * 16);
            double ty = this.proximateBoardTarget.y + (double)(tgy * 16);
            if (this.attachedTo.isImmobile() && Math.abs(sourceX - tx) > 32.0) continue;
            double dsq = (sourceX - tx) * (sourceX - tx) + (sourceY - ty) * (sourceY - ty);
            boolean enterable = this.proximateBoardTarget.enterableAt(tgx, tgy);
            if (!(dsq < 62500.0) || bestPt != null && !(dsq < bestDsq) && (!enterable || bestEnterable)) continue;
            int csz = side.troops.size();
            for (int ci = 0; ci < csz; ++ci) {
                GridRef jsgr = side.troops.get((int)ci).jumpSourceGR;
                if (jsgr != null && jsgr.gridX == tgx && jsgr.gridY == tgy) continue block0;
            }
            bestPt = new Pt(tx + 8.0, ty + 2.0);
            targetGR = new GridRef(tgx, tgy, this.proximateBoardTarget);
            bestEnterable = enterable;
            bestDsq = dsq;
        }
        return bestPt == null ? null : new Utils.Pair(bestPt, targetGR);
    }

    public int canHookFrom(double sourceX, double sourceY) {
        int bw = this.proximateBoardTarget.getGridWidth();
        int bh = this.proximateBoardTarget.getGridHeight();
        boolean found = false;
        for (int borderIndex = 0; borderIndex < bw + bh; ++borderIndex) {
            double dsq;
            int tgy;
            int tgx;
            int n = borderIndex < bw ? borderIndex : (tgx = sourceX < this.proximateBoardTarget.x ? 0 : bw - 1);
            int n2 = borderIndex < bw ? (sourceY < this.proximateBoardTarget.y ? 0 : bh - 1) : (tgy = borderIndex - bw);
            if (!this.proximateBoardTarget.solidAt(tgx, tgy)) continue;
            double tx = this.proximateBoardTarget.x + (double)(tgx * 16);
            double ty = this.proximateBoardTarget.y + (double)(tgy * 16);
            if (this.attachedTo.isImmobile() && Math.abs(sourceX - tx) > 32.0 || !((dsq = (sourceX - tx) * (sourceX - tx) + (sourceY - ty) * (sourceY - ty)) < 62500.0)) continue;
            if (this.proximateBoardTarget.enterableAt(tgx, tgy)) {
                return 2;
            }
            found = true;
        }
        return found ? 1 : 0;
    }

    public static double findJumpAngle(double sourceX, double sourceY, double targetX, double targetY, double v) {
        double angle;
        double y = sourceY - targetY;
        if (y < -120.0) {
            return Double.NaN;
        }
        double x = Math.abs(targetX - sourceX);
        if (y <= 0.0 && x < 16.0) {
            return 128.0;
        }
        double g = 0.001;
        double a = Math.atan((v * v + Math.sqrt(v * v * v * v - g * (g * x * x + 2.0 * y * v * v))) / (g * x));
        double b = Math.atan((v * v - Math.sqrt(v * v * v * v - g * (g * x * x + 2.0 * y * v * v))) / (g * x));
        double d = angle = Double.isNaN(a) ? b : a;
        if (Double.isNaN(angle)) {
            return angle;
        }
        return targetX < sourceX ? Direction.flipHorizontal(angle) : angle;
    }

    public GridRef findEntryPoint() {
        GridRef best = null;
        double bestDsq = 0.0;
        for (int tgy = 0; tgy < this.ultimateBoardTarget.getGridHeight(); ++tgy) {
            for (int tgx = 0; tgx < this.ultimateBoardTarget.getGridWidth(); ++tgx) {
                if (!this.ultimateBoardTarget.enterableAt(tgx, tgy)) continue;
                double tx = this.ultimateBoardTarget.x + (double)(tgx * 16);
                double ty = this.ultimateBoardTarget.y + (double)(tgy * 16) - 13.0 + 0.5;
                double dsq = (this.x - tx) * (this.x - tx) + (this.y - ty) * (this.y - ty);
                if (best != null && !(dsq < bestDsq)) continue;
                best = new GridRef(tgx, tgy, this.ultimateBoardTarget);
                bestDsq = dsq;
            }
        }
        return best;
    }

    private GridRef findWalkTo() {
        if (!(this.attachedTo instanceof GridBody)) {
            return null;
        }
        GridBody att = (GridBody)this.attachedTo;
        int attW = att.getGridWidth();
        for (int gx = 0; gx < attW; ++gx) {
            int gy = att.firstSolidBlockYAt(gx);
            if (!this.canBoardFromGridPos(gx, gy)) continue;
            return new GridRef(gx, gy, att);
        }
        return null;
    }

    private boolean walkToIsValidForBoarding() {
        return this.walkToTargetGR != null && this.canBoardFromGridPos(this.walkToTargetGR.gridX, this.walkToTargetGR.gridY);
    }

    private boolean canBoardFromGridPos(int gx, int gy) {
        if (this.proximateBoardTarget == null) {
            return false;
        }
        double crewWorldX = this.attachedTo.x + (double)(gx * 16) + 2.0;
        double crewWorldY = this.attachedTo.y + (double)(gy * 16) - 6.0 + 0.5;
        return this.canSwitchToBoardTarget(crewWorldX, crewWorldY);
    }

    private GridRef disperse(Combat c, GridBody att) {
        int newGridY;
        int currentGridX = (int)Math.floor((this.x - att.x) / 16.0);
        int newGridX = currentGridX + c.r.nextInt(7) - 4;
        if (att.solidAt(newGridX, newGridY = att.firstSolidBlockYAt(newGridX))) {
            return new GridRef(newGridX, newGridY, att);
        }
        return null;
    }

    private boolean canSwitchToBoardTarget(double wx, double wy) {
        if (this.attachedTo == this.proximateBoardTarget) {
            return false;
        }
        int btGx = (int)Math.floor((wx - this.proximateBoardTarget.x) / 16.0);
        int btGy = (int)Math.floor((wy - this.proximateBoardTarget.y) / 16.0);
        return this.proximateBoardTarget.solidAt(btGx, btGy);
    }

    private void switchToBoardTarget() {
        this.ignoring = this.attachedTo;
        this.attachedTo = this.proximateBoardTarget;
        this.walkToTargetGR = null;
    }

    public boolean outsideTick(int ms, Combat c, Combat.Side side) {
        GridRef dis;
        if (this.mvXOffset == 0.0) {
            this.mvXOffset = c.r.nextDouble() * 16.0 / 2.0 - 4.0;
        }
        if (this.ultimateBoardTarget != null && this.ultimateBoardTarget instanceof Airship && c.sideOf((Airship)this.ultimateBoardTarget) == null) {
            this.ultimateBoardTarget = null;
            this.proximateBoardTarget = null;
        }
        this.msUntilRecalcJumpPoint -= ms;
        this.msUntilRecalcWalkPoint -= ms;
        this.anim.tick(ms);
        this.shoutCooldown -= ms;
        this.initialShoutCooldown -= ms;
        this.shoutMs -= ms;
        if (this.shoutMs <= 0) {
            this.shout = null;
        }
        this.mvDx = 0.0;
        this.mvDy = 0.0;
        if (this.attachedTo == this.proximateBoardTarget) {
            this.proximateBoardTarget = null;
            this.hookLaunched = false;
            this.jumpTargetGR = null;
        }
        if (this.ultimateBoardTarget != null && this.attachedTo instanceof GridBody) {
            if (!c.bodyPathing.connected((GridBody)this.attachedTo, this.proximateBoardTarget, this.type.hasHook ? 1 : 2, c)) {
                this.proximateBoardTarget = null;
            }
            if (this.proximateBoardTarget == null) {
                this.proximateBoardTarget = c.bodyPathing.getNextInPath((GridBody)this.attachedTo, this.ultimateBoardTarget, this.type.hasHook ? 1 : 2, c);
            }
        }
        if (this.attachedTo == this.ultimateBoardTarget && this.ultimateBoardTarget != null) {
            this.hookLaunched = false;
            this.jumpTargetGR = null;
            if (this.ultimateBoardTarget instanceof Airship) {
                boolean asBoarder;
                Airship boardTargetShip = (Airship)this.ultimateBoardTarget;
                boolean bl = asBoarder = side != c.sideOf(boardTargetShip);
                if (this.canPopIn(boardTargetShip) && this.popIn(boardTargetShip, asBoarder)) {
                    return true;
                }
                if (this.entryPoint != null && !this.entryPoint.enterable()) {
                    this.entryPoint = null;
                }
                if (this.entryPoint == null) {
                    this.entryPoint = this.findEntryPoint();
                }
                if (this.entryPoint != null) {
                    this.moveTowardsOutside(this.entryPoint, this.ultimateBoardTarget);
                }
            } else {
                this.ultimateBoardTarget = null;
            }
        } else if (this.hookLaunched) {
            if (this.hookedGR != null) {
                if (!this.winching) {
                    this.drop();
                    this.winching = true;
                } else {
                    this.hookProgress -= 0.1 * (double)ms;
                    if (this.hookProgress < 0.0) {
                        this.hookProgress = 0.0;
                        this.hookLaunched = false;
                        this.jumpTargetGR = null;
                        this.ignoring = null;
                    }
                    if (!this.hookedGR.solid()) {
                        this.hookLaunched = false;
                        this.jumpTargetGR = null;
                        this.ignoring = null;
                    }
                }
            } else {
                this.hookProgress += 0.5 * (double)ms;
                if (this.hookProgress >= this.hookDist) {
                    int tileX = (int)((this.hookTarget.x - this.hookTargetBody.x) / 16.0);
                    int tileY = (int)((this.hookTarget.y - this.hookTargetBody.y) / 16.0);
                    GridRef hitGR = new GridRef(tileX, tileY, this.hookTargetBody);
                    if (hitGR.solid()) {
                        c.sounds.add(new CombatSound("hookimpact", (int)this.hookTarget.x, (int)this.hookTarget.y, 2.0));
                        double tx = this.hookTargetBody.x + (double)(hitGR.gridX * 16);
                        double ty = this.hookTargetBody.y + (double)(hitGR.gridY * 16);
                        this.hookedGR = hitGR;
                        this.hookDist = this.hookProgress = Math.sqrt((this.x - this.hookTarget.x) * (this.x - this.hookTarget.x) + (this.y - this.hookTarget.y) * (this.y - this.hookTarget.y));
                        this.hookTarget = new Pt(this.hookTarget.x - tx, this.hookTarget.y - ty);
                    } else {
                        this.hookLaunched = false;
                        this.jumpTargetGR = null;
                        this.newThrowWait = 3000;
                    }
                }
            }
        } else if (this.proximateBoardTarget != null && this.attachedTo != null) {
            GridBody att;
            GridRef[] tt = new GridRef[1];
            double ja = this.findJumpAngle(this.x, this.y, tt);
            boolean walking = false;
            if (this.attachedTo instanceof GridBody) {
                att = (GridBody)this.attachedTo;
                if (this.jumpSourceGR == null && this.walkToTargetGR == null && this.msUntilRecalcWalkPoint <= 0) {
                    this.walkToTargetGR = this.findWalkTo();
                    this.msUntilRecalcWalkPoint = 300;
                }
                if (this.walkToTargetGR != null && this.walkToIsValidForBoarding()) {
                    this.moveTowardsOutside(this.walkToTargetGR, att);
                    walking = true;
                } else if (this.walkToTargetGR != null) {
                    this.walkToTargetGR = null;
                }
                if (this.canSwitchToBoardTarget(this.x, this.y)) {
                    this.switchToBoardTarget();
                    this.walkToTargetGR = null;
                    walking = true;
                }
            }
            if (!walking) {
                if (this.type.hasHook) {
                    if (ja == 128.0) {
                        this.drop();
                        this.jumpTargetGR = tt[0];
                    } else if (this.newThrowWait > 0) {
                        this.newThrowWait -= ms;
                    } else if (this.canHookFrom(this.x, this.y) > 0) {
                        Utils.Pair<Pt, GridRef> ht = this.findHookTarget(this.x, this.y, side);
                        if (ht != null) {
                            this.hookTarget = (Pt)ht.a;
                            this.jumpTargetGR = (GridRef)ht.b;
                            this.hookLaunched = true;
                            this.hookedGR = null;
                            this.hookSource = new Pt(this.x, this.y);
                            this.hookDist = 1.0 + Math.sqrt((this.hookSource.x - this.hookTarget.x) * (this.hookSource.x - this.hookTarget.x) + (this.hookSource.y - this.hookTarget.y) * (this.hookSource.y - this.hookTarget.y));
                            this.hookTargetBody = this.proximateBoardTarget;
                            this.hookProgress = 0.0;
                            c.sounds.add(new CombatSound("throw" + AGame.ANIM_R.nextInt(3), (int)this.x, (int)this.y, 1.0));
                        }
                    } else if (this.attachedTo instanceof GridBody) {
                        att = (GridBody)this.attachedTo;
                        if (this.jumpSourceGR != null) {
                            if (this.jumpSourceGR.solid()) {
                                double tx = att.x + (double)(this.jumpSourceGR.gridX * 16);
                                double ty = att.y + (double)(this.jumpSourceGR.gridY * 16);
                                if (Double.isNaN(this.findJumpAngle(tx, ty, null)) && this.canHookFrom(tx, ty) == 0) {
                                    this.jumpSourceGR = null;
                                }
                            } else {
                                this.jumpSourceGR = null;
                            }
                        }
                        if (this.jumpSourceGR == null && this.msUntilRecalcJumpPoint <= 0) {
                            this.jumpSourceGR = this.findHookPoint(side);
                            if (this.jumpSourceGR == null) {
                                this.jumpSourceGR = this.findJumpPoint(side, true);
                            }
                            this.msUntilRecalcJumpPoint = 300;
                        }
                        if (this.jumpSourceGR != null) {
                            this.moveTowardsOutside(this.jumpSourceGR, att);
                        }
                    }
                } else if (!Double.isNaN(ja)) {
                    if (ja == 128.0) {
                        this.drop();
                    } else {
                        this.jump(ja, 0.15);
                    }
                    this.jumpTargetGR = tt[0];
                } else if (this.attachedTo instanceof GridBody) {
                    att = (GridBody)this.attachedTo;
                    if (this.jumpSourceGR != null) {
                        if (this.jumpSourceGR.solid()) {
                            if (Double.isNaN(this.findJumpAngle(this.jumpSourceGR.worldX(), this.jumpSourceGR.worldY(), null))) {
                                this.jumpSourceGR = null;
                            }
                        } else {
                            this.jumpSourceGR = null;
                        }
                    }
                    if (this.jumpSourceGR == null && this.msUntilRecalcJumpPoint <= 0) {
                        this.jumpSourceGR = this.findJumpPoint(side, false);
                        this.msUntilRecalcJumpPoint = 300;
                    }
                    if (this.jumpSourceGR != null) {
                        this.moveTowardsOutside(this.jumpSourceGR, att);
                    }
                }
            }
        }
        if (this.attachedTo instanceof GridBody && this.dispersed != this.attachedTo && this.jumpSourceGR == null && this.walkToTargetGR == null && this.proximateBoardTarget == null && this.attachedTo != this.ultimateBoardTarget && (dis = this.disperse(c, (GridBody)this.attachedTo)) != null) {
            this.walkToGR = dis;
            this.dispersed = this.attachedTo;
        }
        if (this.attachedTo instanceof GridBody && this.walkToTargetGR == null && this.jumpSourceGR == null && this.attachedTo != this.ultimateBoardTarget) {
            GridBody att = (GridBody)this.attachedTo;
            if (this.walkToGR == null && this.msUntilRecalcWalkPoint <= 0) {
                int gx = (int)Math.floor((this.x - this.attachedTo.x) / 16.0);
                this.walkToGR = new GridRef(gx, att.firstSolidBlockYAt(gx), att);
                this.msUntilRecalcWalkPoint = 300;
            }
            if (this.walkToGR != null && this.walkToGR.body == this.attachedTo) {
                this.moveTowardsOutside(this.walkToGR, att);
            }
        }
        return !this.active();
    }

    private void moveTowardsOutside(GridRef gr, GridBody att) {
        double tx = att.x + (double)(gr.gridX * 16) + this.mvXOffset + 8.0 - 2.0;
        double ty = att.y + (double)(gr.gridY * 16) - 13.0 + 0.5;
        double d = Math.abs(this.x - tx) + Math.abs(this.y - ty);
        if (this.attachedTo != null && this.attachedTo.isImmobile() && this.attachedTo instanceof LandFormation) {
            LandFormation lf = (LandFormation)this.attachedTo;
            if (this.x - tx < -1.0) {
                double leadingY = lf.yBoundaryAt(this.x + 4.5) - 13.0 + 0.5;
                if (leadingY < this.y - 0.1) {
                    this.mvDx = 0.0;
                    this.mvDy = -0.035;
                } else {
                    this.mvDx = 0.035;
                    this.mvDy = 0.0;
                }
            } else if (this.x - tx > 1.0) {
                double leadingY = lf.yBoundaryAt(this.x + 0.5) - 13.0 + 0.5;
                if (leadingY < this.y - 0.1) {
                    this.mvDx = 0.0;
                    this.mvDy = -0.035;
                } else {
                    this.mvDx = -0.035;
                    this.mvDy = 0.0;
                }
            } else {
                this.mvDx = 0.0;
                this.mvDy = 0.0;
            }
        } else if (d < 0.5) {
            this.mvDx = 0.0;
            this.mvDy = 0.0;
        } else {
            this.mvDx = 0.035 * (tx - this.x) / d;
            this.mvDy = 0.035 * (ty - this.y) / d;
        }
    }

    @Override
    public double getBBWidth() {
        return 5.0;
    }

    @Override
    public double getBBHeight() {
        return 13.0;
    }

    public String pickShout(String type) {
        Crewman.loadShouts();
        ArrayList<String> l = shouts.get(type);
        return l == null || l.isEmpty() ? "!" : l.get(AGame.ANIM_R.nextInt(l.size()));
    }

    public void shout(String type) {
        if (this.shoutCooldown <= 0) {
            this.doShout(this.pickShout(type));
        }
    }

    public void doShout(String sh) {
        Airship myShip;
        if (this.initialShoutCooldown > 0) {
            return;
        }
        this.shout = "[333333]" + Lang._t(sh, new Object[0]);
        this.bigShout = false;
        this.shoutCooldown = AGame.ANIM_R.nextInt(5000) + 4000;
        this.shoutMs = 1800;
        Airship airship = myShip = this.ship == null ? this.boardingShip : this.ship;
        if (myShip != null) {
            this.shoutOriginX = (int)(myShip.x + (double)(myShip.gridXToWorldX(this.currentTile.x, 1) * 16) + 8.0);
            this.shoutOriginY = (int)(myShip.y + (double)(this.currentTile.y * 16) + 8.0);
        } else {
            this.shoutOriginX = (int)this.x;
            this.shoutOriginY = (int)this.y;
        }
        this.shoutW = 0;
    }

    private void bigShout(String sh) {
        Airship myShip;
        if (this.initialShoutCooldown > 0) {
            return;
        }
        this.shout = "[BLACK]" + Lang._t(sh, new Object[0]).toUpperCase();
        this.bigShout = true;
        this.shoutCooldown = AGame.ANIM_R.nextInt(5000) + 4000;
        this.shoutMs = 1800;
        Airship airship = myShip = this.ship == null ? this.boardingShip : this.ship;
        if (myShip != null) {
            this.shoutOriginX = (int)(myShip.x + (double)(this.ship.gridXToWorldX(this.currentTile.x, 1) * 16) + 8.0);
            this.shoutOriginY = (int)(myShip.y + (double)(this.currentTile.y * 16) + 8.0);
        } else {
            this.shoutOriginX = (int)this.x;
            this.shoutOriginY = (int)this.y;
        }
        this.shoutW = 0;
    }

    private void boarderShout(int ms, Combat c) {
        this.shoutCooldown -= ms;
        this.shoutMs -= ms;
        if (this.shoutMs <= 0) {
            this.shout = null;
            if (this.active()) {
                if (this.currentTile.module.type.getCommand() > 0) {
                    this.doShout(this.pickShout("boarderReachedBridge"));
                } else {
                    this.doShout(this.pickShout("boarder"));
                }
            } else if (this.hp > 0) {
                this.doShout(this.pickShout("injured"));
            }
        }
    }

    private void shout(int ms, Combat c, boolean won, boolean lost) {
        this.shoutCooldown -= ms;
        this.initialShoutCooldown -= ms;
        this.shoutMs -= ms;
        this.fallingTime = this.ship.ySpeed > 0.3 ? (this.fallingTime += ms) : 0;
        if (this.shoutMs <= 0) {
            this.shout = null;
            if (this.ship.braking > 0 && this.job != null && this.job.isCaptain()) {
                this.doShout(this.pickShout("braking"));
            } else if (this.job != null && this.currentTile.module == this.job.module() && this.currentTile.module.type == ModuleType.SUSPENDIUM_CHAMBER && this.currentTile.module.msUntilCoal <= 0) {
                this.bigShout(this.pickShout("suspOffline"));
            } else if (this.job != null && this.currentTile.module == this.job.module() && this.currentTile.module.type.getCoalReload() > 0 && this.currentTile.module.msUntilCoal <= Math.max(1000, this.currentTile.module.type.getCoalReload() / 10)) {
                this.bigShout(this.pickShout("needCoal"));
            } else if (this.shoutCooldown <= 0) {
                if (this.hp < this.type.minWorkingHP && this.hp > 0) {
                    this.doShout(this.pickShout("injured"));
                } else if (this.currentTile.module.fire > 0) {
                    if (this.currentTile.module.type.getExplodeHP() > 0 && this.currentTile.module.hp < this.currentTile.module.type.getExplodeHP() * this.currentTile.module.maxHP / this.currentTile.module.type.getHp()) {
                        this.bigShout(this.pickShout("aboutToExplode"));
                    } else {
                        this.doShout(this.pickShout("fire"));
                    }
                } else if (this.job != null && this.job.isCaptain() && this.ship.ramming && !this.ship.ramOrderSpoken) {
                    this.ship.ramOrderSpoken = true;
                    this.doShout(this.pickShout("ramming"));
                } else if (this.job != null && this.job.isCaptain() && this.ship.fireMode == FireMode.AIMED && !this.ship.fireOrderSpoken) {
                    this.ship.fireOrderSpoken = true;
                    this.doShout(this.pickShout("aimedFire"));
                } else if (this.job != null && this.job.isCaptain() && this.ship.fireMode == FireMode.RAPID && !this.ship.fireOrderSpoken) {
                    this.ship.fireOrderSpoken = true;
                    this.doShout(this.pickShout("rapidFire"));
                } else if (this.job != null && this.currentTile.module == this.job.module() && this.currentTile.module.type.getClip() > 1 && this.currentTile.module.ammoLeft == 0 && this.ship.getTotalResource(Resource.AMMO) > 0) {
                    this.doShout(this.pickShout("needAmmo"));
                } else if (this.currentTile.module.hp < this.currentTile.module.maxHP / 2 && !this.currentTile.module.damageReported) {
                    this.currentTile.module.damageReported = true;
                    this.doShout(this.pickShout("damageReport"));
                } else if (this.currentTile.armour.hp <= 0 && !this.currentTile.armour.window && this.currentTile.armour.type != ArmourType.NONE && !this.currentTile.module.armourDamageReported && this.currentTile.module.type != ModuleType.CORRIDOR) {
                    this.currentTile.module.armourDamageReported = true;
                    this.doShout(this.pickShout("hullBreach"));
                } else if (this.fallingTime > 500) {
                    this.doShout(this.pickShout("falling"));
                } else if (!this.occupied && won && AGame.ANIM_R.nextInt(80) == 0) {
                    this.doShout(this.pickShout("victory"));
                } else if (!this.occupied && lost && AGame.ANIM_R.nextInt(80) == 0) {
                    this.doShout(this.pickShout("defeat"));
                } else if (!this.ship.boarders.isEmpty()) {
                    int bsz = this.ship.boarders.size();
                    for (int bi = 0; bi < bsz; ++bi) {
                        if (this.ship.boarders.get((int)bi).currentTile.module != this.currentTile.module) continue;
                        this.doShout(this.pickShout("boarders"));
                        break;
                    }
                }
            }
        }
    }
}

