/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.ModuleType;
import com.zarkonnen.catengine.Img;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Random;
import javax.imageio.ImageIO;

public class DamagedAppGen {
    public static void main(String[] args) throws IOException {
        BufferedImage spritesheet = ImageIO.read(new File("src/com/zarkonnen/airships/images/spritesheet.png"));
        BufferedImage fragsheet = ImageIO.read(new File("src/com/zarkonnen/airships/images/fragments_sheet.png"));
        BufferedImage dmgSheet = new BufferedImage(1024, 1024, 2);
        Graphics2D g = dmgSheet.createGraphics();
        g.drawImage((Image)spritesheet, 0, 0, null);
        Random r = new Random(223098L);
        for (ModuleType mt : ModuleType.values()) {
            if (mt.isFlipped()) continue;
            for (Img img : mt.getApp().frames) {
                if (mt.getApp().frames.indexOf(img) >= mt.getAppFragments().size()) continue;
                ArrayList<ModuleType.FragmentImg> frags = new ArrayList<ModuleType.FragmentImg>((Collection)mt.getAppFragments().get(mt.getApp().frames.indexOf(img)));
                Collections.shuffle(frags, r);
                DamagedAppGen.process(frags, r, img, g, fragsheet);
            }
            for (ModuleType.ExternalApp ea : mt.getExternalApps()) {
                if (mt.getExternalApps().indexOf(ea) >= mt.getExternalFragments().size()) continue;
                for (Img img : ea.app.frames) {
                    ArrayList<ModuleType.FragmentImg> frags = new ArrayList<ModuleType.FragmentImg>((Collection)mt.getExternalFragments().get(mt.getExternalApps().indexOf(ea)).get(ea.app.frames.indexOf(img)));
                    Collections.shuffle(frags, r);
                    DamagedAppGen.process(frags, r, img, g, fragsheet);
                }
            }
        }
        ImageIO.write((RenderedImage)dmgSheet, "PNG", new File("src/com/zarkonnen/airships/images/damage_sheet.png"));
        BufferedImage bump = ImageIO.read(new File("src/com/zarkonnen/airships/images/bump.png"));
        BufferedImage dmgBump = new BufferedImage(1024, 1024, 2);
        g = dmgBump.createGraphics();
        g.drawImage((Image)bump, 0, 0, null);
        g.setColor(new Color(0, 0, 0, 80));
        g.fillRect(0, 0, 1024, 1024);
        ImageIO.write((RenderedImage)dmgBump, "PNG", new File("src/com/zarkonnen/airships/images/damage_bump.png"));
    }

    static void process(ArrayList<ModuleType.FragmentImg> frags, Random r, Img img, Graphics2D g, BufferedImage fragsheet) {
        g.setColor(new Color(97, 63, 45, 200));
        for (int i = 0; i < frags.size(); ++i) {
            if (i > frags.size() * 3 / 8) {
                g.setColor(new Color(97, 63, 45, 110));
            }
            ModuleType.FragmentImg fi = frags.get(i);
            for (int y = 0; y < fi.img.srcHeight * 3 / 4; ++y) {
                int fragY = fi.img.srcY + y;
                int dmgY = img.srcY + fi.dy + y;
                for (int x = 0; x < fi.img.srcWidth; ++x) {
                    int fragX = fi.img.srcX + x;
                    int dmgX = img.srcX + fi.dx + x;
                    int alpha = fragsheet.getAlphaRaster().getSample(fragX, fragY, 0);
                    if (alpha <= 0) continue;
                    g.fillRect(dmgX - 1, dmgY - 1, 1, 1);
                }
            }
        }
    }
}

