/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.Appearance;
import com.zarkonnen.airships.CoatOfArms;
import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.MyDraw;
import com.zarkonnen.catengine.Draw;
import com.zarkonnen.catengine.Fount;
import com.zarkonnen.catengine.Img;
import com.zarkonnen.catengine.util.Clr;
import org.newdawn.slick.Image;

public enum DecalType {
    TINY_COA(2, 2){

        @Override
        public void draw(MyDraw d, double x, double y, int ms, boolean flipped, CoatOfArms coa, String name, Image[] light, float lightStrength, float ambient) {
        }

        @Override
        public void drawNonShader(MyDraw d, double x, double y, int ms, boolean flipped, CoatOfArms coa, String name, Clr tint) {
            coa.draw(d, x, y, 32, tint);
        }
    }
    ,
    SMALL_COA(3, 3){

        @Override
        public void draw(MyDraw d, double x, double y, int ms, boolean flipped, CoatOfArms coa, String name, Image[] light, float lightStrength, float ambient) {
        }

        @Override
        public void drawNonShader(MyDraw d, double x, double y, int ms, boolean flipped, CoatOfArms coa, String name, Clr tint) {
            coa.draw(d, x, y, 48, tint);
        }
    }
    ,
    MEDIUM_COA(4, 4){

        @Override
        public void draw(MyDraw d, double x, double y, int ms, boolean flipped, CoatOfArms coa, String name, Image[] light, float lightStrength, float ambient) {
        }

        @Override
        public void drawNonShader(MyDraw d, double x, double y, int ms, boolean flipped, CoatOfArms coa, String name, Clr tint) {
            coa.draw(d, x, y, 64, tint);
        }
    }
    ,
    LARGE_COA(5, 5){

        @Override
        public void draw(MyDraw d, double x, double y, int ms, boolean flipped, CoatOfArms coa, String name, Image[] light, float lightStrength, float ambient) {
        }

        @Override
        public void drawNonShader(MyDraw d, double x, double y, int ms, boolean flipped, CoatOfArms coa, String name, Clr tint) {
            coa.draw(d, x, y, 80, tint);
        }
    }
    ,
    SMALL_ROUNDEL(1, 1){

        @Override
        public void draw(MyDraw d, double x, double y, int ms, boolean flipped, CoatOfArms coa, String name, Image[] light, float lightStrength, float ambient) {
            CoatOfArms.Tincture[] ts = coa.getRoundelTinctures();
            SMALL_ROUNDEL_1.draw(d, x, y, 0, ts[2].tint, false, light, lightStrength, ambient);
            SMALL_ROUNDEL_2.draw(d, x, y, 0, ts[1].tint, false, light, lightStrength, ambient);
            SMALL_ROUNDEL_3.draw(d, x, y, 0, ts[0].tint, false, light, lightStrength, ambient);
        }

        @Override
        public void drawNonShader(MyDraw d, double x, double y, int ms, boolean flipped, CoatOfArms coa, String name, Clr tint) {
        }
    }
    ,
    MEDIUM_ROUNDEL(2, 2){

        @Override
        public void draw(MyDraw d, double x, double y, int ms, boolean flipped, CoatOfArms coa, String name, Image[] light, float lightStrength, float ambient) {
            CoatOfArms.Tincture[] ts = coa.getRoundelTinctures();
            MEDIUM_ROUNDEL_1.draw(d, x, y, 0, ts[2].tint, false, light, lightStrength, ambient);
            MEDIUM_ROUNDEL_2.draw(d, x, y, 0, ts[1].tint, false, light, lightStrength, ambient);
            MEDIUM_ROUNDEL_3.draw(d, x, y, 0, ts[0].tint, false, light, lightStrength, ambient);
        }

        @Override
        public void drawNonShader(MyDraw d, double x, double y, int ms, boolean flipped, CoatOfArms coa, String name, Clr tint) {
        }
    }
    ,
    LARGE_ROUNDEL(3, 3){

        @Override
        public void draw(MyDraw d, double x, double y, int ms, boolean flipped, CoatOfArms coa, String name, Image[] light, float lightStrength, float ambient) {
            CoatOfArms.Tincture[] ts = coa.getRoundelTinctures();
            LARGE_ROUNDEL_1.draw(d, x, y, 0, ts[2].tint, false, light, lightStrength, ambient);
            LARGE_ROUNDEL_2.draw(d, x, y, 0, ts[1].tint, false, light, lightStrength, ambient);
            LARGE_ROUNDEL_3.draw(d, x, y, 0, ts[0].tint, false, light, lightStrength, ambient);
        }

        @Override
        public void drawNonShader(MyDraw d, double x, double y, int ms, boolean flipped, CoatOfArms coa, String name, Clr tint) {
        }
    }
    ,
    MEDIUM_ROUNDEL_CHARGE(2, 2){

        @Override
        public void draw(MyDraw d, double x, double y, int ms, boolean flipped, CoatOfArms coa, String name, Image[] light, float lightStrength, float ambient) {
            CoatOfArms.Tincture[] ts = coa.getRoundelTinctures();
            MEDIUM_ROUNDEL_1.draw(d, x, y, 0, ts[1].tint, false, light, lightStrength, ambient);
            if (coa.charge[0] != null) {
                coa.charge[0].app.draw(d, x + 8.0, y + 8.0, 0, ts[0].tint, false, light, lightStrength, ambient);
            }
        }

        @Override
        public void drawNonShader(MyDraw d, double x, double y, int ms, boolean flipped, CoatOfArms coa, String name, Clr tint) {
            if (coa.charge[0] == null) {
                CoatOfArms.Tincture[] ts = coa.getRoundelTinctures();
                d.drawSpecialCharge(coa.specialCharge[0], ts[0].tint.mult(tint), x + 8.0, y + 8.0, 16.0, 16.0);
            }
        }
    }
    ,
    SHIP_NAME_SHORT(5, 1){

        @Override
        public void draw(MyDraw d, double x, double y, int ms, boolean flipped, CoatOfArms coa, String name, Image[] light, float lightStrength, float ambient) {
            NAME_BACK_WOOD.draw(d, x, y, ms, null, false, light, lightStrength, ambient);
        }

        @Override
        public void drawNonShader(MyDraw d, double x, double y, int ms, boolean flipped, CoatOfArms coa, String name, Clr tint) {
            9.pixelateStencil();
            int textW = (int)d.textSize((String)name.toUpperCase(), (Fount)AGame.STENCIL).x;
            d.text("[000000f7]" + name.toUpperCase(), AGame.STENCIL, x + 40.0 - (double)(textW / 2), y + 3.0);
        }
    }
    ,
    SHIP_NAME_SHORT_METAL(5, 1){

        @Override
        public void draw(MyDraw d, double x, double y, int ms, boolean flipped, CoatOfArms coa, String name, Image[] light, float lightStrength, float ambient) {
            NAME_BACK_STEEL.draw(d, x, y, ms, null, false, light, lightStrength, ambient);
        }

        @Override
        public void drawNonShader(MyDraw d, double x, double y, int ms, boolean flipped, CoatOfArms coa, String name, Clr tint) {
            10.pixelateStencil();
            int textW = (int)d.textSize((String)name.toUpperCase(), (Fount)AGame.STENCIL).x;
            d.text("[000000f7]" + name.toUpperCase(), AGame.STENCIL, x + 40.0 - (double)(textW / 2), y + 3.0);
        }
    }
    ,
    SHIP_NAME_LONG(9, 1){

        @Override
        public void draw(MyDraw d, double x, double y, int ms, boolean flipped, CoatOfArms coa, String name, Image[] light, float lightStrength, float ambient) {
            NAME_BACK_WOOD_LONG.draw(d, x, y, ms, null, false, light, lightStrength, ambient);
        }

        @Override
        public void drawNonShader(MyDraw d, double x, double y, int ms, boolean flipped, CoatOfArms coa, String name, Clr tint) {
            11.pixelateStencil();
            int textW = (int)d.textSize((String)name.toUpperCase(), (Fount)AGame.STENCIL).x;
            d.text("[000000f7]" + name.toUpperCase(), AGame.STENCIL, x + 72.0 - (double)(textW / 2), y + 3.0);
        }
    }
    ,
    SHIP_NAME_LONG_METAL(9, 1){

        @Override
        public void draw(MyDraw d, double x, double y, int ms, boolean flipped, CoatOfArms coa, String name, Image[] light, float lightStrength, float ambient) {
            NAME_BACK_STEEL_LONG.draw(d, x, y, ms, null, false, light, lightStrength, ambient);
        }

        @Override
        public void drawNonShader(MyDraw d, double x, double y, int ms, boolean flipped, CoatOfArms coa, String name, Clr tint) {
            12.pixelateStencil();
            int textW = (int)d.textSize((String)name.toUpperCase(), (Fount)AGame.STENCIL).x;
            d.text("[000000f7]" + name.toUpperCase(), AGame.STENCIL, x + 72.0 - (double)(textW / 2), y + 3.0);
        }
    }
    ,
    EYE(1, 1){

        @Override
        public void draw(MyDraw d, double x, double y, int ms, boolean flipped, CoatOfArms coa, String name, Image[] light, float lightStrength, float ambient) {
            EYE_A.draw((Draw)d, x, y, 0, flipped, light, lightStrength, ambient);
        }

        @Override
        public void drawNonShader(MyDraw d, double x, double y, int ms, boolean flipped, CoatOfArms coa, String name, Clr tint) {
        }
    }
    ,
    MOUTH(2, 1){

        @Override
        public void draw(MyDraw d, double x, double y, int ms, boolean flipped, CoatOfArms coa, String name, Image[] light, float lightStrength, float ambient) {
            MOUTH_A.draw((Draw)d, x, y, 0, flipped, light, lightStrength, ambient);
        }

        @Override
        public void drawNonShader(MyDraw d, double x, double y, int ms, boolean flipped, CoatOfArms coa, String name, Clr tint) {
        }
    }
    ,
    LARGE_MOUTH(3, 2){

        @Override
        public void draw(MyDraw d, double x, double y, int ms, boolean flipped, CoatOfArms coa, String name, Image[] light, float lightStrength, float ambient) {
            LARGE_MOUTH_A.draw((Draw)d, x, y, 0, flipped, light, lightStrength, ambient);
        }

        @Override
        public void drawNonShader(MyDraw d, double x, double y, int ms, boolean flipped, CoatOfArms coa, String name, Clr tint) {
        }
    }
    ,
    GOLD_LEAF_1(1, 1){

        @Override
        public void draw(MyDraw d, double x, double y, int ms, boolean flipped, CoatOfArms coa, String name, Image[] light, float lightStrength, float ambient) {
            GILT_1.draw((Draw)d, x, y, 0, false, light, lightStrength, ambient);
        }

        @Override
        public void drawNonShader(MyDraw d, double x, double y, int ms, boolean flipped, CoatOfArms coa, String name, Clr tint) {
        }
    }
    ,
    GOLD_LEAF_2(1, 1){

        @Override
        public void draw(MyDraw d, double x, double y, int ms, boolean flipped, CoatOfArms coa, String name, Image[] light, float lightStrength, float ambient) {
            GILT_2.draw((Draw)d, x, y, 0, false, light, lightStrength, ambient);
        }

        @Override
        public void drawNonShader(MyDraw d, double x, double y, int ms, boolean flipped, CoatOfArms coa, String name, Clr tint) {
        }
    }
    ,
    GOLD_LEAF_3(1, 1){

        @Override
        public void draw(MyDraw d, double x, double y, int ms, boolean flipped, CoatOfArms coa, String name, Image[] light, float lightStrength, float ambient) {
            GILT_3.draw((Draw)d, x, y, 0, false, light, lightStrength, ambient);
        }

        @Override
        public void drawNonShader(MyDraw d, double x, double y, int ms, boolean flipped, CoatOfArms coa, String name, Clr tint) {
        }
    }
    ,
    GOLD_LEAF_4(1, 1){

        @Override
        public void draw(MyDraw d, double x, double y, int ms, boolean flipped, CoatOfArms coa, String name, Image[] light, float lightStrength, float ambient) {
            GILT_4.draw((Draw)d, x, y, 0, false, light, lightStrength, ambient);
        }

        @Override
        public void drawNonShader(MyDraw d, double x, double y, int ms, boolean flipped, CoatOfArms coa, String name, Clr tint) {
        }
    };

    public static final Clr COA_OVER;
    public static final Appearance SMALL_ROUNDEL_1;
    public static final Appearance SMALL_ROUNDEL_2;
    public static final Appearance SMALL_ROUNDEL_3;
    public static final Appearance MEDIUM_ROUNDEL_1;
    public static final Appearance MEDIUM_ROUNDEL_2;
    public static final Appearance MEDIUM_ROUNDEL_3;
    public static final Appearance LARGE_ROUNDEL_1;
    public static final Appearance LARGE_ROUNDEL_2;
    public static final Appearance LARGE_ROUNDEL_3;
    public static final Appearance NAME_BACK_WOOD;
    public static final Appearance NAME_BACK_STEEL;
    public static final Appearance NAME_BACK_WOOD_LONG;
    public static final Appearance NAME_BACK_STEEL_LONG;
    public static final Clr STENCIL;
    public static final Appearance EYE_A;
    public static final Appearance MOUTH_A;
    public static final Appearance LARGE_MOUTH_A;
    public static final Appearance GILT_1;
    public static final Appearance GILT_2;
    public static final Appearance GILT_3;
    public static final Appearance GILT_4;
    public final int w;
    public final int h;

    static void pixelateStencil() {
        for (Img img : AGame.STENCIL.imgs) {
            if (img == null || img.machineImgCache == null) continue;
            ((Image)img.machineImgCache).setFilter(9728);
        }
        for (Img img : AGame.STENCIL.extended.values()) {
            if (img == null || img.machineImgCache == null) continue;
            ((Image)img.machineImgCache).setFilter(9728);
        }
    }

    public abstract void draw(MyDraw var1, double var2, double var4, int var6, boolean var7, CoatOfArms var8, String var9, Image[] var10, float var11, float var12);

    public abstract void drawNonShader(MyDraw var1, double var2, double var4, int var6, boolean var7, CoatOfArms var8, String var9, Clr var10);

    private DecalType(int w, int h) {
        this.w = w;
        this.h = h;
    }

    public String getName() {
        return Lang._t("decal_" + this.name(), new Object[0]);
    }

    static {
        COA_OVER = Clr.fromHex((String)"45260033");
        SMALL_ROUNDEL_1 = new Appearance().frame(0, 39, 1, 1);
        SMALL_ROUNDEL_2 = new Appearance().frame(1, 39, 1, 1);
        SMALL_ROUNDEL_3 = new Appearance().frame(2, 39, 1, 1);
        MEDIUM_ROUNDEL_1 = new Appearance().frame(0, 40, 2, 2);
        MEDIUM_ROUNDEL_2 = new Appearance().frame(2, 40, 2, 2);
        MEDIUM_ROUNDEL_3 = new Appearance().frame(4, 40, 2, 2);
        LARGE_ROUNDEL_1 = new Appearance().frame(6, 39, 3, 3);
        LARGE_ROUNDEL_2 = new Appearance().frame(9, 39, 3, 3);
        LARGE_ROUNDEL_3 = new Appearance().frame(12, 39, 3, 3);
        NAME_BACK_WOOD = new Appearance().frame(27, 12, 5, 1);
        NAME_BACK_STEEL = new Appearance().frame(27, 13, 5, 1);
        NAME_BACK_WOOD_LONG = new Appearance().frame(32, 12, 9, 1);
        NAME_BACK_STEEL_LONG = new Appearance().frame(32, 13, 9, 1);
        STENCIL = Clr.fromHex((String)"000000cc");
        EYE_A = new Appearance().frame(27, 8);
        MOUTH_A = new Appearance().frame(29, 8, 2, 1);
        LARGE_MOUTH_A = new Appearance().frame(28, 9, 3, 2);
        GILT_1 = new Appearance().frame(26, 9);
        GILT_2 = new Appearance().frame(27, 9);
        GILT_3 = new Appearance().frame(26, 10);
        GILT_4 = new Appearance().frame(27, 10);
    }
}

