/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.City;
import com.zarkonnen.airships.Empire;
import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.RefitFromDefencesIntent;
import com.zarkonnen.airships.ShipEditorUtils;
import com.zarkonnen.airships.UniScreen;
import com.zarkonnen.catengine.Input;

public class DoRefitFromDefencesButton
extends UniScreen.Button {
    @Override
    public boolean visible(UniScreen us) {
        return us.intent instanceof RefitFromDefencesIntent;
    }

    @Override
    public boolean enabled(UniScreen us) {
        RefitFromDefencesIntent rfdi = (RefitFromDefencesIntent)us.intent;
        return ShipEditorUtils.shipErrors(rfdi.getShip(us), true, true, us.wm.owner((City)us.city).money, us.wm.owner(us.city).bonuses(), ((RefitFromDefencesIntent)us.intent).original, us).isEmpty();
    }

    @Override
    public String text(UniScreen us) {
        return Lang._t("Refit", new Object[0]);
    }

    @Override
    public void click(Input in, UniScreen us) {
        RefitFromDefencesIntent rfdi = (RefitFromDefencesIntent)us.intent;
        Airship original = rfdi.getOriginal(us);
        Airship ship = rfdi.getShip(us);
        int cost = ship.getRefitCost(original);
        Empire owner = us.wm.owner(us.city);
        owner.money -= cost;
        owner.remove(ship, us.wm);
        us.city.constructing = ship;
        us.city.constructionCost = cost;
        us.city.constructionProgress = 0;
        us.intent = ((RefitFromDefencesIntent)us.intent).di;
        us.tool = UniScreen.NAVIGATE;
    }

    @Override
    public String hotkey(UniScreen us) {
        return "R";
    }
}

