/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.EditFromDefencesIntent;
import com.zarkonnen.airships.EditShipIntent;
import com.zarkonnen.airships.Empire;
import com.zarkonnen.airships.MyDraw;
import com.zarkonnen.airships.RefitFromDefencesIntent;
import com.zarkonnen.airships.ShipEditorUtils;
import com.zarkonnen.airships.SingleShipIntent;
import com.zarkonnen.airships.UniScreen;
import com.zarkonnen.catengine.Fount;
import com.zarkonnen.catengine.Input;
import com.zarkonnen.catengine.util.Pt;
import com.zarkonnen.catengine.util.ScreenMode;
import java.util.ArrayList;

public class EditErrorsPanel
implements UniScreen.InfoPanel {
    @Override
    public void draw(MyDraw d, Pt cursor, ScreenMode sm, UniScreen us) {
        ArrayList<String> errList;
        if (us.hideUI) {
            return;
        }
        if (!(us.intent instanceof EditShipIntent)) {
            return;
        }
        Airship ship = ((SingleShipIntent)((Object)us.intent)).getShip(us);
        StringBuilder sb = new StringBuilder();
        sb.append("[bg=880000]");
        if (us.intent instanceof EditFromDefencesIntent) {
            Empire owner = us.wm.owner(us.city);
            Airship original = us.intent instanceof RefitFromDefencesIntent ? ((RefitFromDefencesIntent)us.intent).original : null;
            errList = ShipEditorUtils.shipErrors(ship, true, true, owner.money, owner.bonuses(), original, us);
        } else {
            errList = ShipEditorUtils.shipErrors(ship, false, false, 0, null, null, us);
        }
        for (String err : errList) {
            sb.append(err).append("\n");
        }
        ArrayList<String> warnList = ShipEditorUtils.shipWarnings(ship);
        sb.append("[bg=888800]");
        for (String warn : warnList) {
            sb.append(warn).append("\n");
        }
        String text = sb.toString();
        int w = (int)d.textSize((String)text, (Fount)AGame.FOUNT, (double)0.0, (double)0.0, (int)295).width;
        d.text(sb.toString(), AGame.FOUNT, sm.width - w - 5, 30.0, 295);
    }

    @Override
    public void tick(Input in, int ms, UniScreen us) {
    }

    @Override
    public boolean chatEnabled(UniScreen us) {
        return false;
    }

    @Override
    public boolean doScroll(UniScreen us, int scrollAmt, Pt cursor, ScreenMode sm) {
        return false;
    }

    @Override
    public boolean arrowKeysInUse(UniScreen us) {
        return false;
    }
}

