/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.City;
import com.zarkonnen.airships.DesignFromStrategicIntent;
import com.zarkonnen.airships.EditFromDefencesIntent;
import com.zarkonnen.airships.EditShipIntent;
import com.zarkonnen.airships.Empire;
import com.zarkonnen.airships.MyDraw;
import com.zarkonnen.airships.RefitFromDefencesIntent;
import com.zarkonnen.airships.RefitFromStrategicIntent;
import com.zarkonnen.airships.ScrollBar;
import com.zarkonnen.airships.ShipEditorUtils;
import com.zarkonnen.airships.SingleShipIntent;
import com.zarkonnen.airships.UniScreen;
import com.zarkonnen.catengine.Fount;
import com.zarkonnen.catengine.Input;
import com.zarkonnen.catengine.util.Pt;
import com.zarkonnen.catengine.util.ScreenMode;
import java.util.ArrayList;
import java.util.Collections;

public class EditInfoPanel
implements UniScreen.InfoPanel {
    public int myHeight = 200;
    private static final ScrollBar infoScrollBar = new ScrollBar();
    private static final StringAdapter stringAdapter = new StringAdapter();

    @Override
    public void draw(MyDraw d, Pt cursor, ScreenMode sm, UniScreen us) {
        ArrayList<String> errList;
        if (us.hideUI) {
            return;
        }
        if (!(us.intent instanceof EditShipIntent)) {
            return;
        }
        Airship ship = ((SingleShipIntent)((Object)us.intent)).getShip(us);
        int budget = 0;
        if (us.city != null) {
            budget = us.wm.owner((City)us.city).money;
        }
        if (us.intent instanceof RefitFromStrategicIntent) {
            budget = ((RefitFromStrategicIntent)us.intent).ss.w.player.money;
        }
        if (us.intent instanceof DesignFromStrategicIntent) {
            budget = ((DesignFromStrategicIntent)us.intent).ss.w.player.money;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("[ff9999]");
        if (us.intent instanceof EditFromDefencesIntent) {
            Empire owner = us.wm.owner(us.city);
            Airship original = us.intent instanceof RefitFromDefencesIntent ? ((RefitFromDefencesIntent)us.intent).original : null;
            errList = ShipEditorUtils.shipErrors(ship, true, true, owner.money, owner.bonuses(), original, us);
        } else {
            errList = ShipEditorUtils.shipErrors(ship, false, false, 0, null, null, us);
        }
        for (String err : errList) {
            sb.append(err).append("\n");
        }
        ArrayList<String> warnList = ShipEditorUtils.shipWarnings(ship);
        for (String warn : warnList) {
            sb.append(warn).append("\n");
        }
        sb.append("[]");
        sb.append(ShipEditorUtils.getStats(ship, budget, us.intent instanceof EditShipIntent ? ((EditShipIntent)us.intent).getOriginal(us) : null));
        String text = sb.toString();
        int x = 0;
        int y = 43;
        int w = 320;
        int h = this.myHeight;
        d.drawLeftSideWindow(sm, w, y);
        infoScrollBar.draw(d, x += 6, y += 6, w -= 18, h -= 6, Collections.singletonList(text), stringAdapter);
    }

    @Override
    public void tick(Input in, int ms, UniScreen us) {
        infoScrollBar.tick(in, 10, 55, 320, 300);
    }

    @Override
    public boolean chatEnabled(UniScreen us) {
        return false;
    }

    @Override
    public boolean doScroll(UniScreen us, int scrollAmt, Pt cursor, ScreenMode sm) {
        return false;
    }

    @Override
    public boolean arrowKeysInUse(UniScreen us) {
        return false;
    }

    private static class StringAdapter
    implements ScrollBar.ScrollElementAdapter<String> {
        private StringAdapter() {
        }

        @Override
        public int getHeight(String str, MyDraw d, int availableWidth) {
            return (int)d.textSize((String)str, (Fount)AGame.FOUNT, (double)0.0, (double)0.0, (int)availableWidth).height;
        }

        @Override
        public void draw(String t, MyDraw d, int x, int y, int width) {
            d.drawWoodGrain(x, y, width, this.getHeight(t, d, width));
            d.text(t, AGame.FOUNT, x, y, width);
        }
    }
}

