/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.Appearance;
import com.zarkonnen.airships.ArmourType;
import com.zarkonnen.airships.CoatOfArms;
import com.zarkonnen.airships.DecalType;
import com.zarkonnen.airships.EditPalettePanel;
import com.zarkonnen.airships.Empire;
import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.ModuleCategory;
import com.zarkonnen.airships.ModuleType;
import com.zarkonnen.airships.MyDraw;
import com.zarkonnen.airships.PaintArmourTool;
import com.zarkonnen.airships.PlaceArmourTool;
import com.zarkonnen.airships.PlaceDecalTool;
import com.zarkonnen.airships.PlaceModuleTool;
import com.zarkonnen.airships.ScrollBar;
import com.zarkonnen.airships.ShipEditorUtils;
import com.zarkonnen.airships.Tile;
import com.zarkonnen.airships.UniScreen;
import com.zarkonnen.catengine.Hook;
import com.zarkonnen.catengine.Img;
import com.zarkonnen.catengine.Input;
import com.zarkonnen.catengine.util.Pt;
import java.util.ArrayList;
import java.util.List;

public enum EditMode implements ScrollBar.ScrollElementAdapter<Object>
{
    MODULES("M", false){

        @Override
        public int getHeight(Object t, MyDraw d, int availableWidth) {
            Entry e = (Entry)t;
            if (e.o == null || e.o instanceof ModuleCategory) {
                return 30;
            }
            return ((ModuleType)((Object)e.o)).getH() * 16 + 6 + 12;
        }

        @Override
        public void stepSelect(int delta, UniScreen us, EditPalettePanel p, Airship ship) {
            List<Object> l = this.getList(us, p, ship);
            if (l.isEmpty()) {
                return;
            }
            int currentIndex = -1;
            if (us.tool instanceof PlaceModuleTool) {
                for (int i = 0; i < l.size(); ++i) {
                    if (!(l.get(i) instanceof Entry)) continue;
                    Entry e = (Entry)l.get(i);
                    if (e.o != ((PlaceModuleTool)us.tool).mt) continue;
                    currentIndex = i;
                }
            }
            int newIndex = (currentIndex + delta + l.size()) % l.size();
            us.tool = new PlaceModuleTool((ModuleType)((Object)((Entry)l.get((int)newIndex)).o));
        }

        @Override
        public void selectFirst(UniScreen us, EditPalettePanel p, Airship ship) {
            List<Object> l = this.getList(us, p, ship);
            if (l.isEmpty()) {
                return;
            }
            us.tool = new PlaceModuleTool((ModuleType)((Object)((Entry)l.get((int)0)).o));
        }

        @Override
        public void draw(Object t, MyDraw d, int x, int y, int width) {
            boolean selected;
            final Entry entry = (Entry)t;
            boolean bl = selected = entry.us.tool instanceof PlaceModuleTool && entry.p.modSel(entry.us) == entry.o;
            if (entry.o == null) {
                d.blit(EditPalettePanel.REMOVE, x + 4, y + 4);
                d.hook(x, y, width, 22.0, new Hook(new Hook.Type[]{Hook.Type.MOUSE_1_CLICKED}){

                    public void run(Input in, Pt p, Hook.Type type) {
                        entry.us.tool = new PlaceModuleTool(null);
                        entry.p.searchSelectionMade = true;
                    }
                });
                d.text((selected ? "[c8b84f]" : "") + Lang._t("Remove_module", new Object[0]), AGame.FOUNT, x + 48 + 6 + 6, y);
            } else if (entry.o instanceof ModuleCategory) {
                final Entry e = (Entry)t;
                final boolean open = e.p.openCategories.contains(e.o);
                d.hook(x, y, width, 22.0, new Hook(new Hook.Type[]{Hook.Type.MOUSE_1_CLICKED}){

                    public void run(Input in, Pt p, Hook.Type type) {
                        if (open) {
                            e.p.openCategories.remove(e.o);
                        } else {
                            e.p.openCategories.add((ModuleCategory)((Object)e.o));
                        }
                    }
                });
                d.blit(open ? MyDraw.TRIANGLE_OPEN : MyDraw.TRIANGLE_CLOSED, x + 4, y);
                d.text(((ModuleCategory)((Object)e.o)).getName(), AGame.FOUNT, x + 4 + 16 + 6, y);
            } else {
                final Entry e = (Entry)t;
                d.blit(new Img("blueprint", 0, 0, 56, ((ModuleType)((Object)e.o)).getH() * 16 + 8, false), x + 2, y + 2);
                if (((ModuleType)((Object)e.o)).weaponAppearance() != null && ((ModuleType)((Object)e.o)).weaponAppearance().barrel != null) {
                    Img barrel = ((ModuleType)((Object)e.o)).weaponAppearance().barrel;
                    Appearance.drawAsBlueprint(barrel, d, (double)(6 + x) + ((ModuleType)((Object)e.o)).weaponAppearance().barrelOffset.x, (double)(4 + y) + ((ModuleType)((Object)e.o)).weaponAppearance().barrelOffset.y, barrel.srcWidth, barrel.srcHeight, ((ModuleType)((Object)e.o)).isFlipped(), 1.0f);
                }
                ((ModuleType)((Object)e.o)).getApp().drawAsBlueprint(d, 6 + x, 6 + y, 0, e.ship.flipped, 0.8f);
                d.drawWoodGrain(10 + x + 48, y, width, ((ModuleType)((Object)e.o)).getH() * 16 + 12 + 24);
                d.drawPanelBorder(x, y, 60, ((ModuleType)((Object)e.o)).getH() * 16 + 12);
                d.hook(x, y, width, ((ModuleType)((Object)e.o)).getH() * 16 + 6 + 8, new Hook(new Hook.Type[]{Hook.Type.MOUSE_1_CLICKED}){

                    public void run(Input in, Pt p, Hook.Type type) {
                        e.us.tool = new PlaceModuleTool((ModuleType)((Object)e.o));
                        e.p.searchSelectionMade = true;
                    }
                });
                d.tooltip(x, y, width, ((ModuleType)((Object)e.o)).getH() * 16 + 6 + 4, ((ModuleType)((Object)e.o)).getDescription(e.ship.constructionBonuses));
                boolean fixer = ShipEditorUtils.isModuleAFixer(e.ship, (ModuleType)((Object)e.o), e.ship.constructionBonuses);
                d.text((selected ? "[c8b84f]" : (fixer ? "[f5edb5]" : "")) + ShipEditorUtils.indent(((ModuleType)((Object)e.o)).getName(), 23) + "$" + ((ModuleType)((Object)e.o)).getCost(e.ship.constructionBonuses), AGame.FOUNT, x + 48 + 6 + 10, y);
            }
        }

        @Override
        public List<Object> getList(UniScreen us, EditPalettePanel p, Airship ship) {
            ArrayList<Object> l = new ArrayList<Object>();
            if (!p.searching || Lang._t("Remove_module", new Object[0]).toLowerCase().contains(p.searchField.text.toLowerCase())) {
                l.add(new Entry<Object>(null, us, p, ship));
            }
            Empire owner = p.owner(us);
            if (p.searching && !p.searchField.text.isEmpty()) {
                for (ModuleType mt : ModuleType.values()) {
                    if (!mt.availableFor(ship.type) || owner != null && mt.getRequired() != null && !owner.bonuses().contains((Object)mt.getRequired()) || !mt.getName().toLowerCase().contains(p.searchField.text.toLowerCase())) continue;
                    l.add(new Entry<ModuleType>(mt, us, p, ship));
                }
            } else {
                for (ModuleCategory mc : ModuleCategory.values()) {
                    boolean empty = true;
                    for (ModuleType mt : mc.getContents()) {
                        if (!mt.availableFor(ship.type) || owner != null && mt.getRequired() != null && !owner.bonuses().contains((Object)mt.getRequired())) continue;
                        empty = false;
                        break;
                    }
                    if (empty) continue;
                    l.add(new Entry<ModuleCategory>(mc, us, p, ship));
                    if (!p.openCategories.contains((Object)mc)) continue;
                    for (ModuleType mt : mc.getContents()) {
                        if (!mt.availableFor(ship.type) || owner != null && mt.getRequired() != null && !owner.bonuses().contains((Object)mt.getRequired())) continue;
                        l.add(new Entry<ModuleType>(mt, us, p, ship));
                    }
                }
            }
            return l;
        }
    }
    ,
    ARMOUR("A", true){

        @Override
        public int getHeight(Object t, MyDraw d, int availableWidth) {
            return 26;
        }

        @Override
        public void stepSelect(int delta, UniScreen us, EditPalettePanel p, Airship ship) {
            List<Object> l = this.getList(us, p, ship);
            if (l.isEmpty()) {
                return;
            }
            int currentIndex = -1;
            if (us.tool instanceof PlaceArmourTool) {
                for (int i = 0; i < l.size(); ++i) {
                    if (!(l.get(i) instanceof Entry)) continue;
                    Entry e = (Entry)l.get(i);
                    if (e.o != ((PlaceArmourTool)us.tool).at) continue;
                    currentIndex = i;
                }
            }
            int newIndex = (currentIndex + delta + l.size()) % l.size();
            us.tool = new PlaceArmourTool((ArmourType)((Object)((Entry)l.get((int)newIndex)).o));
        }

        @Override
        public void selectFirst(UniScreen us, EditPalettePanel p, Airship ship) {
            List<Object> l = this.getList(us, p, ship);
            if (l.isEmpty()) {
                return;
            }
            us.tool = new PlaceArmourTool((ArmourType)((Object)((Entry)l.get((int)0)).o));
        }

        @Override
        public void draw(Object t, MyDraw d, int x, int y, int width) {
            d.drawWoodGrain(x, y, width, 26);
            final Entry e = (Entry)t;
            d.drawPanel(x, y, 20, 20);
            ((ArmourType)((Object)e.o)).damagedApps.get(0).draw(d, x + 2, y + 2, 0, false);
            boolean selected = e.p.armSel(e.us) == e.o;
            String text = ShipEditorUtils.indent(((ArmourType)((Object)e.o)).getName(), 28) + "$" + ((ArmourType)((Object)e.o)).getCost(e.ship.constructionBonuses);
            d.text(selected ? "[c8b84f]" + text : text, AGame.FOUNT, x + 16 + 6 + 4, y);
            d.hook(x, y, width, 32.0, new Hook(new Hook.Type[]{Hook.Type.MOUSE_1_CLICKED}){

                public void run(Input in, Pt p, Hook.Type type) {
                    e.us.tool = new PlaceArmourTool((ArmourType)((Object)e.o));
                    e.p.lastArmourType = (ArmourType)((Object)e.o);
                    e.p.searchSelectionMade = true;
                }
            });
            d.tooltip(x, y, width, 32.0, ((ArmourType)((Object)e.o)).getDescription(e.ship.constructionBonuses));
        }

        @Override
        public List<Object> getList(UniScreen us, EditPalettePanel p, Airship ship) {
            ArrayList<Object> l = new ArrayList<Object>();
            Empire owner = p.owner(us);
            for (ArmourType at : ArmourType.values()) {
                if (at == ArmourType.NONE || at.required != null && owner != null && !owner.bonuses().contains((Object)at.required) || p.searching && !at.getName().toLowerCase().contains(p.searchField.text.toLowerCase())) continue;
                l.add(new Entry<ArmourType>(at, us, p, ship));
            }
            return l;
        }

        @Override
        public void fill(UniScreen us, EditPalettePanel p, Airship ship) {
            for (Tile t : ship.tiles) {
                if (t.module.type.isExternal()) continue;
                t.armour.setType(p.armSel(us));
            }
        }

        @Override
        public boolean fillEnabled(UniScreen us, EditPalettePanel p, Airship ship) {
            return p.armSel(us) != null;
        }
    }
    ,
    PAINT("P", true){

        @Override
        public int getHeight(Object t, MyDraw d, int availableWidth) {
            return 26;
        }

        @Override
        public void stepSelect(int delta, UniScreen us, EditPalettePanel p, Airship ship) {
            List<Object> l = this.getList(us, p, ship);
            if (l.isEmpty()) {
                return;
            }
            int currentIndex = -1;
            if (us.tool instanceof PaintArmourTool) {
                for (int i = 0; i < l.size(); ++i) {
                    if (!(l.get(i) instanceof Entry)) continue;
                    Entry e = (Entry)l.get(i);
                    if (e.o != ((PaintArmourTool)us.tool).tinc) continue;
                    currentIndex = i;
                }
            }
            int newIndex = (currentIndex + delta + l.size()) % l.size();
            us.tool = new PaintArmourTool((CoatOfArms.Tincture)((Object)((Entry)l.get((int)newIndex)).o));
        }

        @Override
        public void selectFirst(UniScreen us, EditPalettePanel p, Airship ship) {
            List<Object> l = this.getList(us, p, ship);
            if (l.isEmpty()) {
                return;
            }
            us.tool = new PaintArmourTool((CoatOfArms.Tincture)((Object)((Entry)l.get((int)0)).o));
        }

        @Override
        public void draw(Object t, MyDraw d, int x, int y, int width) {
            d.drawWoodGrain(x, y, width, 26);
            final Entry e = (Entry)t;
            d.drawPanel(x, y, 20, 20);
            if (e.o != null) {
                d.rect(((CoatOfArms.Tincture)((Object)e.o)).tint, x + 2, y + 2, 16.0, 16.0);
            }
            boolean selected = e.p.paintSel(e.us) == e.o;
            String text = ShipEditorUtils.indent(e.o == null ? Lang._t("Remove_paint", new Object[0]) : ((CoatOfArms.Tincture)((Object)e.o)).getName(), 28);
            d.text(selected ? "[c8b84f]" + text : text, AGame.FOUNT, x + 16 + 6 + 4, y);
            d.hook(x, y, width, 32.0, new Hook(new Hook.Type[]{Hook.Type.MOUSE_1_CLICKED}){

                public void run(Input in, Pt p, Hook.Type type) {
                    e.us.tool = new PaintArmourTool((CoatOfArms.Tincture)((Object)e.o));
                    e.p.searchSelectionMade = true;
                }
            });
        }

        @Override
        public List<Object> getList(UniScreen us, EditPalettePanel p, Airship ship) {
            ArrayList<Object> l = new ArrayList<Object>();
            if (!p.searching || Lang._t("Remove_paint", new Object[0]).toLowerCase().contains(p.searchField.text.toLowerCase())) {
                l.add(new Entry<Object>(null, us, p, ship));
            }
            for (CoatOfArms.Tincture t : CoatOfArms.Tincture.values()) {
                if (p.searching && !t.getName().toLowerCase().contains(p.searchField.text.toLowerCase())) continue;
                l.add(new Entry<CoatOfArms.Tincture>(t, us, p, ship));
            }
            return l;
        }

        @Override
        public void fill(UniScreen us, EditPalettePanel p, Airship ship) {
            for (Tile t : ship.tiles) {
                if (t.module.type.isExternal()) continue;
                t.armour.paint = p.paintSel(us);
            }
        }

        @Override
        public boolean fillEnabled(UniScreen us, EditPalettePanel p, Airship ship) {
            return true;
        }
    }
    ,
    DECALS("D", false){

        @Override
        public int getHeight(Object t, MyDraw d, int availableWidth) {
            Entry e = (Entry)t;
            if (e.o == null) {
                return 30;
            }
            return ((DecalType)((Object)e.o)).h * 16 + 6 + 8;
        }

        @Override
        public void stepSelect(int delta, UniScreen us, EditPalettePanel p, Airship ship) {
            List<Object> l = this.getList(us, p, ship);
            if (l.isEmpty()) {
                return;
            }
            int currentIndex = -1;
            if (us.tool instanceof PlaceDecalTool) {
                for (int i = 0; i < l.size(); ++i) {
                    if (!(l.get(i) instanceof Entry)) continue;
                    Entry e = (Entry)l.get(i);
                    if (e.o != ((PlaceDecalTool)us.tool).dt) continue;
                    currentIndex = i;
                }
            }
            int newIndex = (currentIndex + delta + l.size()) % l.size();
            us.tool = new PlaceDecalTool((DecalType)((Object)((Entry)l.get((int)newIndex)).o));
        }

        @Override
        public void selectFirst(UniScreen us, EditPalettePanel p, Airship ship) {
            List<Object> l = this.getList(us, p, ship);
            if (l.isEmpty()) {
                return;
            }
            us.tool = new PlaceDecalTool((DecalType)((Object)((Entry)l.get((int)0)).o));
        }

        @Override
        public void draw(Object t, MyDraw d, int x, int y, int width) {
            boolean selected;
            final Entry e = (Entry)t;
            boolean bl = selected = e.us.tool instanceof PlaceDecalTool && e.p.decSel(e.us) == e.o;
            if (e.o == null) {
                d.blit(EditPalettePanel.REMOVE, x + 4, y + 4);
                d.hook(x, y, width, 22.0, new Hook(new Hook.Type[]{Hook.Type.MOUSE_1_CLICKED}){

                    public void run(Input in, Pt p, Hook.Type type) {
                        e.us.tool = new PlaceDecalTool(null);
                        e.p.searchSelectionMade = true;
                    }
                });
                d.text((selected ? "[c8b84f]" : "") + Lang._t("Remove_decal", new Object[0]), AGame.FOUNT, x + 48 + 6 + 6, y);
            } else {
                d.rect(AGame.SKY, x + 2, y + 2, 52.0, ((DecalType)((Object)e.o)).h * 16 + 4);
                ((DecalType)((Object)e.o)).draw(d, 4 + x, 4 + y, 0, false, e.p.coa, "NAME", null, 1.0f, 1.0f);
                ((DecalType)((Object)e.o)).drawNonShader(d, 4 + x, 4 + y, 0, false, e.p.coa, "NAME", null);
                d.drawWoodGrain(6 + x + 48, y, width, ((DecalType)((Object)e.o)).h * 16 + 8 + 24);
                d.drawPanelBorder(x, y, 56, ((DecalType)((Object)e.o)).h * 16 + 8);
                d.hook(x, y, width, ((DecalType)((Object)e.o)).h * 16 + 6 + 8, new Hook(new Hook.Type[]{Hook.Type.MOUSE_1_CLICKED}){

                    public void run(Input in, Pt p, Hook.Type type) {
                        e.us.tool = new PlaceDecalTool((DecalType)((Object)e.o));
                        e.p.searchSelectionMade = true;
                    }
                });
                d.text((selected ? "[c8b84f]" : "") + ShipEditorUtils.indent(((DecalType)((Object)e.o)).getName(), 23), AGame.FOUNT, x + 48 + 6 + 6, y);
            }
        }

        @Override
        public List<Object> getList(UniScreen us, EditPalettePanel p, Airship ship) {
            ArrayList<Object> l = new ArrayList<Object>();
            if (!p.searching || Lang._t("Remove_decal", new Object[0]).toLowerCase().contains(p.searchField.text.toLowerCase())) {
                l.add(new Entry<Object>(null, us, p, ship));
            }
            for (DecalType dt : DecalType.values()) {
                if (p.searching && !dt.getName().toLowerCase().contains(p.searchField.text.toLowerCase())) continue;
                l.add(new Entry<DecalType>(dt, us, p, ship));
            }
            return l;
        }
    };

    private final String shortcut;
    public final boolean canFill;

    public String getName() {
        return Lang._t("editmode_" + this.name(), new Object[0]);
    }

    public String getShortcut() {
        return this.shortcut;
    }

    private EditMode(String shortcut, boolean canFill) {
        this.shortcut = shortcut;
        this.canFill = canFill;
    }

    @Override
    public abstract int getHeight(Object var1, MyDraw var2, int var3);

    @Override
    public abstract void draw(Object var1, MyDraw var2, int var3, int var4, int var5);

    public void fill(UniScreen us, EditPalettePanel p, Airship ship) {
    }

    public boolean fillEnabled(UniScreen us, EditPalettePanel p, Airship ship) {
        return false;
    }

    public abstract void stepSelect(int var1, UniScreen var2, EditPalettePanel var3, Airship var4);

    public abstract void selectFirst(UniScreen var1, EditPalettePanel var2, Airship var3);

    public abstract List<Object> getList(UniScreen var1, EditPalettePanel var2, Airship var3);

    private static class Entry<T> {
        public final T o;
        public final UniScreen us;
        public final EditPalettePanel p;
        public final Airship ship;

        public Entry(T t, UniScreen us, EditPalettePanel p, Airship ship) {
            this.o = t;
            this.us = us;
            this.p = p;
            this.ship = ship;
        }
    }
}

