/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.ArmourType;
import com.zarkonnen.airships.CoatOfArms;
import com.zarkonnen.airships.DecalType;
import com.zarkonnen.airships.DesignFromStrategicIntent;
import com.zarkonnen.airships.EditInfoPanel;
import com.zarkonnen.airships.EditMode;
import com.zarkonnen.airships.EditShipIntent;
import com.zarkonnen.airships.Empire;
import com.zarkonnen.airships.InputRunnable;
import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.ModuleCategory;
import com.zarkonnen.airships.ModuleType;
import com.zarkonnen.airships.MyDraw;
import com.zarkonnen.airships.PaintArmourTool;
import com.zarkonnen.airships.PlaceArmourTool;
import com.zarkonnen.airships.PlaceDecalTool;
import com.zarkonnen.airships.PlaceModuleTool;
import com.zarkonnen.airships.RefitFromStrategicIntent;
import com.zarkonnen.airships.ScrollBar;
import com.zarkonnen.airships.SingleShipIntent;
import com.zarkonnen.airships.TextField;
import com.zarkonnen.airships.Tile;
import com.zarkonnen.airships.UniScreen;
import com.zarkonnen.catengine.Img;
import com.zarkonnen.catengine.Input;
import com.zarkonnen.catengine.util.Clr;
import com.zarkonnen.catengine.util.Pt;
import com.zarkonnen.catengine.util.ScreenMode;
import java.util.EnumMap;
import java.util.EnumSet;

public class EditPalettePanel
implements UniScreen.InfoPanel {
    public static final Clr HOVER = new Clr(255, 255, 255, 30);
    public static final Img REMOVE = new Img("spritesheet", 64, 256, 16, 16, false);
    public int ms;
    public ArmourType lastArmourType = ArmourType.MED_WOOD;
    public Airship lastShip = null;
    public TextField searchField = new TextField();
    public boolean searching = false;
    public boolean searchSelectionMade = false;
    public EnumSet<ModuleCategory> openCategories = EnumSet.of(ModuleCategory.BASIC);
    public CoatOfArms coa;
    private final EnumMap<EditMode, ScrollBar> modeBars = new EnumMap(EditMode.class);

    public EditPalettePanel() {
        for (EditMode em : EditMode.values()) {
            this.modeBars.put(em, new ScrollBar());
        }
        this.searchField.help = Lang._t("Search", new Object[0]);
    }

    @Override
    public void draw(MyDraw d, Pt cursor, ScreenMode sm, final UniScreen us) {
        if (us.hideUI) {
            return;
        }
        if (!(us.intent instanceof EditShipIntent)) {
            return;
        }
        final EditShipIntent esi = (EditShipIntent)us.intent;
        final Airship ship = ((SingleShipIntent)((Object)us.intent)).getShip(us);
        this.coa = esi.getArms(us);
        int x = 6;
        int y = us.panel(EditInfoPanel.class).myHeight + 43 + 3;
        int w = 302;
        int buttonW = (w - 3) / 2;
        boolean rightColumn = false;
        for (final EditMode em : EditMode.values()) {
            d.toggle(x + (rightColumn ? buttonW + 3 : 0), y, buttonW, em.getName(), em.getShortcut(), new InputRunnable(){

                @Override
                public void run(Input in) {
                    esi.mode = em;
                }
            }, esi.mode == em, true);
            if (rightColumn) {
                y += 27;
                rightColumn = false;
                continue;
            }
            rightColumn = true;
        }
        if (rightColumn) {
            y += 27;
        }
        final EditPalettePanel epp = this;
        d.toggle(x, y, w, Lang._t("Search", new Object[0]), "ENTER", new InputRunnable(){

            @Override
            public void run(Input in) {
                if (!EditPalettePanel.this.searchSelectionMade) {
                    esi.mode.selectFirst(us, epp, ship);
                }
                ((ScrollBar)((EditPalettePanel)EditPalettePanel.this).modeBars.get((Object)esi.mode)).offset = 0;
                EditPalettePanel.this.searching = !EditPalettePanel.this.searching;
                EditPalettePanel.this.searchField.text = "";
                EditPalettePanel.this.searchSelectionMade = false;
            }
        }, this.searching, true);
        y += 27;
        if (this.searching) {
            this.searchField.render(x, y, w, d, sm, d.hs, cursor);
            y += 27;
        }
        int h = sm.height - y - 6;
        final EditPalettePanel p = this;
        if (esi.mode.canFill) {
            h -= 27;
            d.button(x, sm.height - 24 - 6, w, Lang._t("Fill", new Object[0]), "I", new Runnable(){

                @Override
                public void run() {
                    esi.mode.fill(us, p, EditPalettePanel.this.lastShip);
                }
            }, esi.mode.fillEnabled(us, this, ship));
        }
        this.modeBars.get(esi.mode).draw(d, x, y, w, h, esi.mode.getList(us, this, ship), esi.mode);
    }

    public static ArmourType guessArmourType(Airship ship) {
        ArmourType best = ship.type.mobile ? ArmourType.MED_WOOD : ArmourType.STONE_WALL;
        int bestCount = 0;
        for (ArmourType at : ArmourType.values()) {
            if (at == ArmourType.NONE) continue;
            int count = 0;
            for (Tile t : ship.tiles) {
                if (t.armour.type != at) continue;
                ++count;
            }
            if (count <= bestCount) continue;
            best = at;
            bestCount = count;
        }
        return best;
    }

    @Override
    public void tick(Input in, int ms, UniScreen us) {
        if (!(us.intent instanceof EditShipIntent)) {
            return;
        }
        this.ms += ms;
        EditShipIntent esi = (EditShipIntent)us.intent;
        Airship ship = esi.getShip(us);
        int x = 6;
        int y = us.panel(EditInfoPanel.class).myHeight + 43 + 3;
        int w = 302;
        int h = in.mode().height - y - 6;
        this.modeBars.get(esi.mode).tick(in, x, y, w, h);
        if (this.lastShip != ship) {
            this.lastShip = ship;
            if (this.lastShip != null) {
                this.lastArmourType = EditPalettePanel.guessArmourType(this.lastShip);
            }
        }
        if (!us.textInputOccurring()) {
            for (EditMode em : EditMode.values()) {
                if (!in.keyPressed(em.getShortcut())) continue;
                esi.mode = em;
            }
            if (in.keyPressed("I") && esi.mode.canFill && esi.mode.fillEnabled(us, this, ship)) {
                esi.mode.fill(us, this, ship);
            }
        }
        if (this.searching) {
            this.searchField.input(in, null, null, null, ms);
            if (!this.searchField.text.isEmpty()) {
                if (in.keyPressed("DOWN")) {
                    esi.mode.stepSelect(1, us, this, ship);
                    this.searchSelectionMade = true;
                }
                if (in.keyPressed("UP")) {
                    esi.mode.stepSelect(-1, us, this, ship);
                    this.searchSelectionMade = true;
                }
            }
        }
        if (in.keyPressed("ENTER")) {
            if (!this.searchSelectionMade && !this.searchField.text.isEmpty()) {
                esi.mode.selectFirst(us, this, ship);
            }
            this.modeBars.get((Object)esi.mode).offset = 0;
            this.searching = !this.searching;
            this.searchField.text = "";
            this.searchSelectionMade = false;
        }
        if (this.searching && in.keyPressed("ESCAPE")) {
            this.modeBars.get((Object)esi.mode).offset = 0;
            this.searching = !this.searching;
            this.searchField.text = "";
            this.searchSelectionMade = false;
        }
    }

    public ArmourType armSel(UniScreen us) {
        return us.tool instanceof PlaceArmourTool ? ((PlaceArmourTool)us.tool).at : null;
    }

    public DecalType decSel(UniScreen us) {
        return us.tool instanceof PlaceDecalTool ? ((PlaceDecalTool)us.tool).dt : null;
    }

    public ModuleType modSel(UniScreen us) {
        return us.tool instanceof PlaceModuleTool ? ((PlaceModuleTool)us.tool).mt : null;
    }

    public CoatOfArms.Tincture paintSel(UniScreen us) {
        return us.tool instanceof PaintArmourTool ? ((PaintArmourTool)us.tool).tinc : null;
    }

    @Override
    public boolean chatEnabled(UniScreen us) {
        return this.searching;
    }

    @Override
    public boolean arrowKeysInUse(UniScreen us) {
        return this.searching;
    }

    public Empire owner(UniScreen us) {
        Empire owner;
        Empire empire = owner = us.city == null ? null : us.wm.owner(us.city);
        if (us.intent instanceof DesignFromStrategicIntent) {
            owner = ((DesignFromStrategicIntent)us.intent).ss.w.player;
        }
        if (us.intent instanceof RefitFromStrategicIntent) {
            owner = ((RefitFromStrategicIntent)us.intent).ss.w.player;
        }
        return owner;
    }

    @Override
    public boolean doScroll(UniScreen us, int scrollAmt, Pt cursor, ScreenMode sm) {
        if (us.hideUI) {
            return false;
        }
        if (!(us.intent instanceof EditShipIntent)) {
            return false;
        }
        return cursor != null && cursor.x <= 320.0;
    }
}

