/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.City;
import com.zarkonnen.airships.CoatOfArms;
import com.zarkonnen.airships.EditMode;
import com.zarkonnen.airships.Empire;
import com.zarkonnen.airships.PlaceShipTool;
import com.zarkonnen.airships.ShipEditorUtils;
import com.zarkonnen.airships.ShipType;
import com.zarkonnen.airships.SingleShipIntent;
import com.zarkonnen.airships.UniScreen;
import com.zarkonnen.airships.ZoomToFitButton;
import com.zarkonnen.catengine.Input;

public abstract class EditShipIntent
implements UniScreen.Intent,
SingleShipIntent {
    public boolean justSaved = true;
    public boolean pleaseZoomToShip;
    public EditMode mode = EditMode.MODULES;
    public boolean firstTick = true;
    public boolean prevErrorFree;

    public abstract Empire getPlayerEmpire();

    @Override
    public void tick(Input in, int ms, UniScreen us) {
        boolean errorFree;
        if (this.pleaseZoomToShip) {
            ZoomToFitButton.zoomToEditShip(in, us);
            this.pleaseZoomToShip = false;
        }
        Airship ship = this.getShip(us);
        if (ship.type.onGround) {
            if (us.city != null) {
                ship.y = PlaceShipTool.getAdjustedY(ship, ship.x, ship.y, us, true);
            }
            if (ship.type == ShipType.BUILDING && this.firstTick && (this.getPlayerEmpire() == null || !ship.modules.isEmpty())) {
                ZoomToFitButton.zoomToEditShip(in, us);
                us.zoom = Math.min(us.zoom, 1.0);
                this.firstTick = false;
            }
        }
        if ((errorFree = ShipEditorUtils.shipErrors(ship, false, false, 0, null, null, us).isEmpty()) && !this.prevErrorFree) {
            in.play("spin_up", 1.0, 1.0 * us.g.volume, 0.0, 0.0);
        }
        this.prevErrorFree = errorFree;
    }

    public Airship getOriginal(UniScreen us) {
        return null;
    }

    @Override
    public ShipType type(UniScreen us) {
        return this.getShip((UniScreen)us).type;
    }

    public void centerShip(UniScreen us) {
        this.pleaseZoomToShip = true;
    }

    @Override
    public void justSaved(UniScreen us) {
        this.justSaved = true;
    }

    @Override
    public void modified(UniScreen us) {
        this.justSaved = false;
    }

    public CoatOfArms getArms(UniScreen us) {
        if (us.city != null) {
            return us.wm.owner((City)us.city).arms;
        }
        return us.g.getBestCOA();
    }

    @Override
    public boolean showOutside() {
        return this.mode != EditMode.MODULES;
    }

    @Override
    public boolean showDecals() {
        return this.mode == EditMode.DECALS;
    }

    @Override
    public boolean drawAsBlueprint() {
        return true;
    }
}

