/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.Bonus;
import com.zarkonnen.airships.City;
import com.zarkonnen.airships.CoatOfArms;
import com.zarkonnen.airships.ConstructionAffinity;
import com.zarkonnen.airships.Fleet;
import com.zarkonnen.airships.SecretPoliceLevel;
import com.zarkonnen.airships.Spy;
import com.zarkonnen.airships.TakeoverMethod;
import com.zarkonnen.airships.WorldMap;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONObject;

public class Empire {
    public static final int MS_PER_INCOME = 2000;
    public int spyActionsDone = 0;
    public String name;
    public CoatOfArms arms;
    public Bonus bonus;
    public int money;
    public SecretPoliceLevel policeLevel = SecretPoliceLevel.LAX;
    public ArrayList<City> cities = new ArrayList();
    public ArrayList<Fleet> fleets = new ArrayList();
    public ArrayList<Spy> spies = new ArrayList();
    public ArrayList<Message> messages = new ArrayList();
    public int moneyMs;
    public Personality personality;
    public ConstructionAffinity constructionAffinity = ConstructionAffinity.NONE;
    public int warConsiderDelay;
    public double aggressiveness;
    public TakeoverMethod takeoverMethod;

    public CoatOfArms.Tincture getMainTincture() {
        int ti;
        CoatOfArms.Tincture[] ts = this.arms.getRoundelTinctures();
        for (ti = 0; ti < ts.length && ts[ti].metal; ++ti) {
        }
        return ts[ti];
    }

    public CoatOfArms.Tincture getSecondaryTincture() {
        int ti;
        CoatOfArms.Tincture[] ts = this.arms.getRoundelTinctures();
        for (ti = 0; ti < ts.length && !ts[ti].metal; ++ti) {
        }
        return ts[ti];
    }

    public Spy getSpyFor(City c) {
        for (Spy s : this.spies) {
            if (s.location != c) continue;
            return s;
        }
        return null;
    }

    public Empire(String name, CoatOfArms arms, Bonus bonus, int money, Personality p, double aggressiveness, TakeoverMethod takeoverMethod) {
        this.name = name;
        this.arms = arms;
        this.bonus = bonus;
        this.money = money;
        this.personality = p;
        this.aggressiveness = aggressiveness;
        this.takeoverMethod = takeoverMethod;
        this.warConsiderDelay = AGame.ANIM_R.nextInt(30000);
    }

    public void scrap(Airship askForScrap, WorldMap wm) {
        for (Fleet f : this.fleets) {
            if (f.actives.contains(askForScrap)) {
                f.actives.remove(askForScrap);
                this.money += askForScrap.getCost() / 8;
                if (f.actives.isEmpty() && f.reserve.isEmpty()) {
                    this.fleets.remove(f);
                    f.broadcastDestroyed(wm);
                }
                return;
            }
            if (!f.reserve.contains(askForScrap)) continue;
            f.reserve.remove(askForScrap);
            this.money += askForScrap.getCost() / 8;
            if (f.actives.isEmpty() && f.reserve.isEmpty()) {
                this.fleets.remove(f);
                f.broadcastDestroyed(wm);
            }
            return;
        }
        for (City c : this.cities) {
            if (!c.hasDefence(askForScrap)) continue;
            c.removeDefence(askForScrap);
            this.money += askForScrap.getCost() / 8;
            return;
        }
    }

    public void remove(Airship remove, WorldMap wm) {
        for (Fleet f : this.fleets) {
            if (f.actives.contains(remove)) {
                f.actives.remove(remove);
                if (f.actives.isEmpty() && f.reserve.isEmpty()) {
                    this.fleets.remove(f);
                    f.broadcastDestroyed(wm);
                }
                return;
            }
            if (!f.reserve.contains(remove)) continue;
            f.reserve.remove(remove);
            if (f.actives.isEmpty() && f.reserve.isEmpty()) {
                this.fleets.remove(f);
                f.broadcastDestroyed(wm);
            }
            return;
        }
        for (City c : this.cities) {
            if (!c.hasDefence(remove)) continue;
            c.removeDefence(remove);
            return;
        }
    }

    public void replace(Airship a, Airship b, WorldMap wm) {
        if (b == null) {
            this.remove(a, wm);
            return;
        }
        for (Fleet f : this.fleets) {
            if (f.actives.contains(a)) {
                f.actives.set(f.actives.indexOf(a), b);
                return;
            }
            if (!f.reserve.contains(a)) continue;
            f.reserve.set(f.reserve.indexOf(a), b);
            return;
        }
        for (City c : this.cities) {
            if (!c.hasDefence(a)) continue;
            c.replaceDefence(a, b);
            return;
        }
    }

    public Empire(JSONObject o) {
        int i;
        this.name = o.getString("name");
        this.arms = new CoatOfArms(o.getJSONObject("arms"));
        this.bonus = Bonus.valueOf(o.getString("bonus"));
        this.money = o.getInt("money");
        this.moneyMs = o.getInt("moneyMs");
        this.personality = Personality.CONQUEROR;
        this.warConsiderDelay = o.optInt("warConsiderDelay", AGame.ANIM_R.nextInt(30000));
        this.aggressiveness = o.optDouble("aggressiveness", 1.0);
        this.takeoverMethod = TakeoverMethod.valueOf(o.optString("takeoverMethod", TakeoverMethod.GENTLE.name()));
        this.policeLevel = SecretPoliceLevel.valueOf(o.optString("policeLevel", SecretPoliceLevel.LAX.name()));
        this.constructionAffinity = ConstructionAffinity.valueOf(o.optString("constructionAffinity", ConstructionAffinity.NONE.name()));
        JSONArray a = o.getJSONArray("cities");
        for (i = 0; i < a.length(); ++i) {
            this.cities.add(new City(a.getJSONObject(i)));
        }
        a = o.getJSONArray("fleets");
        for (i = 0; i < a.length(); ++i) {
            this.fleets.add(new Fleet(a.getJSONObject(i)));
        }
    }

    public void finish(JSONObject o, WorldMap m) {
        int i;
        JSONArray a = o.getJSONArray("cities");
        for (i = 0; i < a.length(); ++i) {
            this.cities.get(i).finish(a.getJSONObject(i), m);
        }
        a = o.optJSONArray("spies");
        if (a != null) {
            for (i = 0; i < a.length(); ++i) {
                Spy spy = new Spy(a.getJSONObject(i));
                spy.finish(a.getJSONObject(i), m);
                this.spies.add(spy);
            }
        }
        if ((a = o.optJSONArray("messages")) != null) {
            for (i = 0; i < a.length(); ++i) {
                this.messages.add(new Message(a.getJSONObject(i), this));
            }
        }
    }

    public void finishFleets(JSONObject o, WorldMap m) {
        JSONArray a = o.getJSONArray("fleets");
        for (int i = 0; i < a.length(); ++i) {
            this.fleets.get(i).finish(a.getJSONObject(i), m);
        }
    }

    public JSONObject toJSON(WorldMap m) {
        JSONObject o = new JSONObject().put("name", this.name).put("arms", this.arms.toJSON()).put("bonus", this.bonus.name()).put("money", this.money).put("moneyMs", this.moneyMs).put("personality", this.personality.name()).put("aggressiveness", this.aggressiveness).put("takeoverMethod", this.takeoverMethod.name()).put("policeLevel", this.policeLevel.name()).put("warConsiderDelay", this.warConsiderDelay).put("constructionAffinity", this.constructionAffinity.name());
        JSONArray a = new JSONArray();
        o.put("cities", a);
        for (City c : this.cities) {
            a.put(c.toJSON(m));
        }
        a = new JSONArray();
        o.put("fleets", a);
        for (Fleet f : this.fleets) {
            a.put(f.toJSON(m));
        }
        a = new JSONArray();
        o.put("spies", a);
        for (Spy s : this.spies) {
            a.put(s.toJSON(m));
        }
        a = new JSONArray();
        o.put("messages", a);
        for (Message msg : this.messages) {
            a.put(msg.toJSON(this));
        }
        return o;
    }

    public EnumSet<Bonus> bonuses() {
        EnumSet<Bonus> bs = EnumSet.noneOf(Bonus.class);
        bs.add(this.bonus);
        for (City c : this.cities) {
            bs.add(c.bonus);
        }
        return bs;
    }

    public boolean hasBonus(Bonus b) {
        if (this.bonus == b) {
            return true;
        }
        for (City c : this.cities) {
            if (this.bonus != c.bonus) continue;
            return true;
        }
        return false;
    }

    public int incomeBalance() {
        return this.totalIncome() - this.totalFleetCosts() - this.totalDefencesCost() - this.totalSpiesCost() - this.totalPoliceCosts();
    }

    public int totalPoliceCosts() {
        return this.totalPoliceCosts(this.policeLevel);
    }

    public int totalPoliceCosts(SecretPoliceLevel spl) {
        return (int)(10.0 * (Math.pow(this.cities.size(), 1.5) - 0.8) * spl.costMult);
    }

    public int totalFleetCosts() {
        int c = 0;
        for (Fleet f : this.fleets) {
            c += f.maintenanceCost();
        }
        return c;
    }

    public int totalDefencesCost() {
        int cost = 0;
        for (City c : this.cities) {
            cost += c.defencesMaintenanceCost();
        }
        return cost;
    }

    public int totalSpiesCost() {
        return this.spies.size() * 5;
    }

    public int totalIncome() {
        int in = 0;
        for (City c : this.cities) {
            in += c.adjustedIncome();
        }
        return in;
    }

    public void tick(int ms, WorldMap map) {
        for (City c : this.cities) {
            c.tick(ms, this, map);
        }
        Iterator<Object> it = this.fleets.iterator();
        while (it.hasNext()) {
            Fleet f = it.next();
            if (!f.tick(ms, this, map)) continue;
            it.remove();
            f.broadcastDestroyed(map);
        }
        it = this.spies.iterator();
        while (it.hasNext()) {
            Spy s = (Spy)it.next();
            if (this.cities.contains(s.location)) {
                it.remove();
                continue;
            }
            s.tick(ms, this, map);
        }
        this.moneyMs += ms;
        if (this.moneyMs >= 2000) {
            this.moneyMs -= 2000;
            this.money += this.incomeBalance();
        }
        this.warConsiderDelay -= ms;
    }

    public void addShipAt(Airship ship, City location) {
        for (Fleet f : this.fleets) {
            if (f.location != location) continue;
            f.reserve.add(ship);
            location.layoutGarrison(f);
            return;
        }
        Fleet f = new Fleet(location);
        f.reserve.add(ship);
        this.fleets.add(f);
        location.layoutGarrison(f);
    }

    public static class Message {
        public MessageType type;
        public City c;
        public String text;

        public Message(MessageType type, City c, String text) {
            this.type = type;
            this.c = c;
            this.text = text;
        }

        public Message(JSONObject o, Empire e) {
            this.type = MessageType.valueOf(o.getString("type"));
            this.c = e.cities.get(o.getInt("city"));
            this.text = o.getString("text");
        }

        public JSONObject toJSON(Empire e) {
            return new JSONObject().put("type", this.type.name()).put("city", e.cities.indexOf(this.c)).put("text", this.text);
        }
    }

    public static enum MessageType {
        SPY_CAUGHT,
        SPY_ACTION,
        ENEMY_LANDSHIPS_CAUGHT,
        ENEMY_REMAINING_LANDSHIPS_DESTROYED,
        ENEMY_ABANDONED_LANDSHIPS;

    }

    public static enum Personality {
        CONQUEROR,
        POLICE,
        PASSIVE;

    }
}

