/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.InputRunnable;
import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.MyDraw;
import com.zarkonnen.airships.Screen;
import com.zarkonnen.airships.ScrollBar;
import com.zarkonnen.airships.TextField;
import com.zarkonnen.airships.TimeOfDay;
import com.zarkonnen.catengine.Fount;
import com.zarkonnen.catengine.Hook;
import com.zarkonnen.catengine.Hooks;
import com.zarkonnen.catengine.Img;
import com.zarkonnen.catengine.Input;
import com.zarkonnen.catengine.util.Clr;
import com.zarkonnen.catengine.util.Pt;
import com.zarkonnen.catengine.util.ScreenMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;

public strictfp class FileScreen
implements Screen {
    public static final Clr SCROLL_HIGHLIGHT = new Clr(140, 140, 140);
    public static final Clr BG_SHADE = new Clr(12, 12, 12);
    public static final Img ASCENDING = new Img("spritesheet", 208, 512, 16, 16, false);
    public static final Img DESCENDING = new Img("spritesheet", 192, 512, 16, 16, false);
    public final Backend backend;
    public final Mission mission;
    public final HelperWidget helper;
    public InlineInfo inlineInfo = NO_INFO;
    private int selected = -1;
    private TextField input;
    private List<String> l;
    private int msSinceKeyScroll = 0;
    private int msSinceClickSelect = 0;
    private boolean calledBack = false;
    private String actionName = null;
    private boolean cancelled = false;
    private String overwriteConfirm = null;
    private String deleteConfirm = null;
    public Filter enabledFilter = EVERYTHING;
    public boolean allowOpeningDisabledItems = false;
    public Sorter currentSorter;
    public boolean sorterDescending;
    public boolean showFilterSettings;
    public ScrollBar filterScrollBar = new ScrollBar();
    public HashMap<SettableFilter, FilterState> filterStates = new HashMap();
    public boolean reloadRequired = false;
    private final FilterAdapter filterAdapter = new FilterAdapter();
    private final ScrollBar fileScrollBar = new ScrollBar();
    public static final Filter EVERYTHING = new Filter(){

        @Override
        public boolean retain(String filename) {
            return true;
        }
    };
    public static final InlineInfo NO_INFO = new InlineInfo(){

        @Override
        public int width() {
            return 0;
        }

        @Override
        public String info(String filename) {
            return "";
        }
    };
    private static final Img REMOVE = new Img("spritesheet", 144, 416, 16, 16, false);
    private final FileAdapter fileAdapter = new FileAdapter();

    public FileScreen(Backend backend, Mission mission, HelperWidget helper, InlineInfo inlineInfo) {
        this.backend = backend;
        this.mission = mission;
        this.helper = helper;
        this.inlineInfo = inlineInfo;
        this.currentSorter = backend.sorters().get(0);
    }

    private void setSelected(int index) {
        if (index == -1) {
            return;
        }
        if (this.l.isEmpty()) {
            return;
        }
        this.selected = index;
        this.input.text = this.l.get(index);
        if (this.helper != null) {
            this.helper.setSelectedFile(this.l.get(index));
        }
    }

    private void action() {
        switch (this.mission.mode()) {
            case OPEN: {
                if (this.selected == -1) break;
                this.actionName = this.l.get(this.selected);
                break;
            }
            case SAVE: {
                if (!this.backend.isValidName(this.input.text)) break;
                this.actionName = this.input.text;
            }
        }
    }

    private void cancel() {
        this.cancelled = true;
    }

    private void delete(String name) {
        this.backend.delete(name);
        this.reloadList();
        if (this.selected >= this.l.size()) {
            --this.selected;
        }
    }

    private boolean canDoAction() {
        return this.selected == -1 || this.enabledFilter.retain(this.l.get(this.selected)) || this.allowOpeningDisabledItems && this.backend.list().get(this.selected) != null;
    }

    public List<String> list() {
        ArrayList<String> list = new ArrayList<String>();
        block0: for (String name : this.backend.list()) {
            for (SettableFilter sf : this.filterStates.keySet()) {
                FilterState fs = this.filterStates.get(sf);
                if (fs == FilterState.ALLOWED) continue;
                FilterCheckResult fcr = sf.check(name);
                if (fcr == FilterCheckResult.UNKNOWN) {
                    this.reloadRequired = true;
                }
                if ((fs != FilterState.FORBIDDEN || fcr != FilterCheckResult.YES) && (fs != FilterState.REQUIRED || fcr != FilterCheckResult.NO)) continue;
                continue block0;
            }
            list.add(name);
        }
        Collections.sort(list, this.sorterDescending ? this.currentSorter.descending() : this.currentSorter.ascending());
        return list;
    }

    private void reloadList() {
        String sel = null;
        if (this.l != null && this.selected != -1) {
            sel = this.l.get(this.selected);
        }
        this.l = this.list();
        this.setSelected(this.l.indexOf(sel));
    }

    @Override
    public void input(Input in, MyDraw.State drawState, Pt cursor, Pt click, int ms) {
        if (this.l == null) {
            this.reloadList();
            this.input = new TextField(false, " qwertyuiopasdfghjklzxcvbnmQWERTYUIOPASDFGHJKLZXCVBNM1234567890-=+_!?<>,\"'@\u00a3$%^&*()[]{}|~\u00b1\u00e4\u00f6\u00fc\u00c4\u00d6\u00dc\u00c9\u00ca\u00c8\u00e9\u00ea\u00e8\u00eb\u00c7\u00e7\u00c0\u00e0\u00e2\u00fb");
            this.input.text = this.mission.initialInput();
            if (this.l.contains(this.input.text)) {
                this.setSelected(this.l.indexOf(this.input.text));
            }
        }
        if (this.currentSorter.popUpdateNeeded() || this.reloadRequired) {
            this.reloadRequired = false;
            this.reloadList();
        }
        ScreenMode sm = in.mode();
        int x = this.helper == null ? sm.width / 4 : 10;
        int w = this.helper == null ? sm.width / 2 : (sm.width - 20 - 12) / 2;
        int y = 10 + AGame.BIG_FOUNT.height;
        int h = sm.height - 20 - AGame.BIG_FOUNT.height - 24 - 3;
        this.fileScrollBar.tick(in, x, y, w, h);
        if (this.showFilterSettings) {
            this.filterScrollBar.tick(in, x + w + 12, y, w, h);
        }
        this.msSinceKeyScroll += ms;
        this.msSinceClickSelect += ms;
        if (this.overwriteConfirm != null) {
            if (in.keyDown("ENTER") && drawState.canClick() && this.canDoAction()) {
                this.action();
                drawState.hasClicked();
            }
            if (in.keyDown("ESCAPE") && drawState.canClick()) {
                this.overwriteConfirm = null;
                drawState.hasClicked();
            }
        } else if (this.deleteConfirm != null) {
            if (in.keyDown("ESCAPE") && drawState.canClick()) {
                this.deleteConfirm = null;
                drawState.hasClicked();
            }
        } else {
            if (this.mission.mode() == Mode.SAVE) {
                this.input.input(in, drawState, cursor, click, ms);
            }
            if (this.msSinceKeyScroll >= 150) {
                if (in.keyDown("DOWN") && !this.l.isEmpty()) {
                    if (this.selected == -1) {
                        this.setSelected(0);
                    } else if (this.selected < this.l.size() - 1) {
                        this.setSelected(this.selected + 1);
                    }
                    this.msSinceKeyScroll = 0;
                }
                if (in.keyDown("UP") && !this.l.isEmpty()) {
                    if (this.selected == -1) {
                        this.setSelected(this.l.size() - 1);
                    } else if (this.selected > 0) {
                        this.setSelected(this.selected - 1);
                    }
                    this.msSinceKeyScroll = 0;
                }
            }
            if (in.keyDown("ENTER") && drawState.canClick() && this.backend.isValidName(this.input.text) && this.canDoAction()) {
                if (this.mission.mode() == Mode.SAVE && this.backend.list().contains(this.input.text)) {
                    this.overwriteConfirm = this.input.text;
                } else {
                    this.action();
                }
                drawState.hasClicked();
            }
            if (in.keyDown("ESCAPE") && drawState.canClick()) {
                drawState.hasClicked();
                this.cancel();
            }
        }
        if (!this.calledBack) {
            if (this.cancelled) {
                this.calledBack = true;
                this.mission.cancelled();
            } else if (this.actionName != null) {
                this.calledBack = true;
                this.mission.fileSelected(this.actionName);
                if (this.mission.mode() == Mode.SAVE && this.helper != null) {
                    this.helper.clearCacheFor(this.actionName);
                }
            }
        }
    }

    @Override
    public void render(MyDraw d, ScreenMode sm, Hooks hs, Pt cursor) {
        d.drawBG(AGame.CAST_IRON, sm);
        if (this.l == null) {
            return;
        }
        this.selected = Math.min(this.selected, this.l.size() - 1);
        int x = this.helper == null && !this.showFilterSettings ? sm.width / 4 : 10;
        int w = this.helper == null && !this.showFilterSettings ? sm.width / 2 : (sm.width - 20 - 12) / 2;
        int y = 10;
        d.text(this.mission.text(), AGame.BIG_FOUNT, x, y);
        y += AGame.BIG_FOUNT.height + 12;
        int sx = x;
        for (final Sorter s : this.backend.sorters()) {
            d.text(Lang._t(s.getNameKey(), new Object[0]), AGame.FOUNT, sx, y + 12 - AGame.FOUNT.height / 2);
            sx = (int)((double)sx + (d.textSize((String)Lang._t((String)s.getNameKey(), (Object[])new Object[0]), (Fount)AGame.FOUNT).x + 12.0));
            d.iconToggle(sx, y, ASCENDING, new Runnable(){

                @Override
                public void run() {
                    FileScreen.this.currentSorter = s;
                    FileScreen.this.sorterDescending = false;
                    FileScreen.this.reloadList();
                }
            }, this.currentSorter == s && !this.sorterDescending, true);
            d.iconToggle(sx += 27, y, DESCENDING, new Runnable(){

                @Override
                public void run() {
                    FileScreen.this.currentSorter = s;
                    FileScreen.this.sorterDescending = true;
                    FileScreen.this.reloadList();
                }
            }, this.currentSorter == s && this.sorterDescending, true);
            sx += 36;
        }
        if (!this.backend.filters().isEmpty()) {
            d.toggle(sx, y, 100, Lang._t("Filter", new Object[0]), null, new InputRunnable(){

                @Override
                public void run(Input in) {
                    FileScreen.this.showFilterSettings = !FileScreen.this.showFilterSettings;
                }
            }, this.showFilterSettings, true);
        }
        int h = sm.height - 20 - AGame.BIG_FOUNT.height - 24 - 3 - 24 - 24;
        int bottom = (y += 36) + h;
        if (this.showFilterSettings) {
            this.filterScrollBar.draw(d, x + w + 12, y, w, h, this.backend.filters(), this.filterAdapter);
        } else if (this.helper != null) {
            this.helper.render(d, sm, hs, cursor, x + w + 12, y, w, h);
        }
        this.fileScrollBar.draw(d, x, y, w, h, this.l, this.fileAdapter);
        if (this.mission.mode() == Mode.SAVE) {
            this.input.showValid = this.backend.isValidName(this.input.text);
            this.input.render(x, bottom + 3, w - 160 - 3 - 3, d, sm, hs, cursor);
        }
        d.button(x + w - 80, bottom + 3, 80, this.mission.fileSelectionText(), null, new Runnable(){

            @Override
            public void run() {
                if (FileScreen.this.mission.mode() == Mode.SAVE && FileScreen.this.backend.list().contains(((FileScreen)FileScreen.this).input.text)) {
                    FileScreen.this.overwriteConfirm = ((FileScreen)FileScreen.this).input.text;
                } else {
                    FileScreen.this.action();
                }
            }
        }, this.backend.isValidName(this.input.text) && this.canDoAction());
        d.button(x + w - 80 - 3 - 80, bottom + 3, 80, Lang._t("Cancel", new Object[0]), new Runnable(){

            @Override
            public void run() {
                FileScreen.this.cancel();
            }
        });
        if (this.overwriteConfirm != null) {
            d.confirmDialog(sm.width / 2 - (w + 40) / 2, sm.height / 2 - 150, w + 40, Lang._t("Overwrite_x", this.overwriteConfirm), new Runnable(){

                @Override
                public void run() {
                    FileScreen.this.overwriteConfirm = null;
                    FileScreen.this.action();
                }
            }, new Runnable(){

                @Override
                public void run() {
                    FileScreen.this.overwriteConfirm = null;
                }
            });
        }
        if (this.deleteConfirm != null) {
            d.confirmDialog(sm.width / 2 - (w + 40) / 2, sm.height / 2 - 150, w + 40, Lang._t("Delete_x", this.deleteConfirm), new Runnable(){

                @Override
                public void run() {
                    FileScreen.this.delete(FileScreen.this.deleteConfirm);
                    FileScreen.this.deleteConfirm = null;
                }
            }, new Runnable(){

                @Override
                public void run() {
                    FileScreen.this.deleteConfirm = null;
                }
            });
        }
    }

    @Override
    public ArrayList<String> music() {
        return null;
    }

    @Override
    public String appearancePostfix() {
        return TimeOfDay.DAY.name();
    }

    @Override
    public boolean alwaysUseAppearancePostfix() {
        return true;
    }

    strictfp class FilterAdapter
    implements ScrollBar.ScrollElementAdapter<SettableFilter> {
        FilterAdapter() {
        }

        @Override
        public int getHeight(SettableFilter t, MyDraw d, int availableWidth) {
            return AGame.FOUNT.height + 24 + 12;
        }

        @Override
        public void draw(final SettableFilter sf, MyDraw d, int x, int y, int width) {
            d.drawWoodGrain(x, y, width, AGame.FOUNT.height + 24 + 6 + 12);
            d.text(Lang._t(sf.getNameKey(), new Object[0]), AGame.FOUNT, x, y);
            y += AGame.FOUNT.height;
            FilterState currentFS = FilterState.ALLOWED;
            if (FileScreen.this.filterStates.containsKey(sf)) {
                currentFS = FileScreen.this.filterStates.get(sf);
            }
            for (final FilterState fs : FilterState.values()) {
                d.toggle(x, y, 110, Lang._t(fs.name(), new Object[0]), null, new InputRunnable(){

                    @Override
                    public void run(Input in) {
                        FileScreen.this.filterStates.put(sf, fs);
                        FileScreen.this.reloadList();
                    }
                }, fs == currentFS, true);
                x += 113;
            }
        }
    }

    private strictfp class FileAdapter
    implements ScrollBar.ScrollElementAdapter<String> {
        private FileAdapter() {
        }

        @Override
        public int getHeight(String fileName, MyDraw d, int availableWidth) {
            return 30;
        }

        @Override
        public void draw(String fileName, final MyDraw d, int x, int y, int w) {
            final int index = FileScreen.this.l.indexOf(fileName);
            String clr = "";
            if (!FileScreen.this.enabledFilter.retain(fileName)) {
                clr = "[aaaaaa]";
            } else if (index == FileScreen.this.selected) {
                clr = "[c8b84f]";
            }
            d.text(clr + (String)FileScreen.this.l.get(index), AGame.FOUNT, x + 2 + 4, y + 5);
            d.hook(x, y, w - 24, 24.0, new Hook(new Hook.Type[]{Hook.Type.MOUSE_1_CLICKED}){

                public void run(Input in, Pt p, Hook.Type type) {
                    if (d.state.canClick()) {
                        if (FileScreen.this.selected == index && FileScreen.this.msSinceClickSelect <= 450 && FileScreen.this.canDoAction()) {
                            ((FileScreen)FileScreen.this).input.text = (String)FileScreen.this.l.get(index);
                            if (FileScreen.this.mission.mode() == Mode.OPEN) {
                                FileScreen.this.action();
                            } else {
                                FileScreen.this.overwriteConfirm = ((FileScreen)FileScreen.this).input.text;
                            }
                        } else {
                            FileScreen.this.setSelected(index);
                        }
                        FileScreen.this.msSinceClickSelect = 0;
                        d.state.hasClicked();
                    }
                }
            });
            d.text(FileScreen.this.inlineInfo.info((String)FileScreen.this.l.get(index)), AGame.FOUNT, x + w - 24 - 3 - FileScreen.this.inlineInfo.width() * AGame.FOUNT.displayWidth, y + 5);
            d.iconButton(x + w - 24, y, REMOVE, new Runnable(){

                @Override
                public void run() {
                    FileScreen.this.deleteConfirm = (String)FileScreen.this.l.get(index);
                }
            }, true);
        }
    }

    public strictfp static class DummyHW
    implements HelperWidget {
        private String name = null;

        @Override
        public void setSelectedFile(String name) {
            this.name = name;
        }

        @Override
        public void render(MyDraw d, ScreenMode sm, Hooks hs, Pt cursor, int x, int y, int w, int h) {
            d.rect(Clr.WHITE, x, y, w, h);
            d.rect(Clr.BLACK, x + 2, y + 2, w - 4, h - 4);
            d.text("Helper Widget: " + this.name, AGame.FOUNT, x, y);
        }

        @Override
        public void close() {
        }

        @Override
        public void clearCacheFor(String name) {
        }
    }

    public static interface HelperWidget {
        public void setSelectedFile(String var1);

        public void clearCacheFor(String var1);

        public void render(MyDraw var1, ScreenMode var2, Hooks var3, Pt var4, int var5, int var6, int var7, int var8);

        public void close();
    }

    public static interface Mission {
        public Mode mode();

        public String text();

        public String initialInput();

        public String fileSelectionText();

        public void fileSelected(String var1);

        public void cancelled();
    }

    public static interface Backend {
        public List<String> list();

        public boolean isValidName(String var1);

        public void delete(String var1);

        public ArrayList<Sorter> sorters();

        public ArrayList<SettableFilter> filters();
    }

    public static interface SettableFilter {
        public String getNameKey();

        public FilterCheckResult check(String var1);
    }

    public strictfp static enum FilterState {
        ALLOWED,
        REQUIRED,
        FORBIDDEN;

    }

    public strictfp static enum FilterCheckResult {
        YES,
        NO,
        UNKNOWN;

    }

    public static interface Sorter {
        public String getNameKey();

        public Comparator<String> ascending();

        public Comparator<String> descending();

        public boolean popUpdateNeeded();
    }

    public static interface InlineInfo {
        public int width();

        public String info(String var1);
    }

    public static interface Filter {
        public boolean retain(String var1);
    }

    public strictfp static enum Mode {
        OPEN,
        SAVE;

    }
}

