/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.AirshipGame;
import com.zarkonnen.airships.City;
import com.zarkonnen.airships.Empire;
import com.zarkonnen.airships.Road;
import com.zarkonnen.airships.ShipList;
import com.zarkonnen.airships.WorldMap;
import com.zarkonnen.catengine.util.Pt;
import java.util.ArrayList;
import java.util.HashSet;
import org.json.JSONArray;
import org.json.JSONObject;

public class Fleet
implements ShipList {
    public static final double SPEED_TO_MAP_PX_PER_MS = 0.05;
    public City location;
    public double sx;
    public double sy;
    public City destination;
    public double progress;
    public boolean fleeDestinationNeeded;
    public Road usingRoad;
    public ArrayList<Airship> actives = new ArrayList();
    public ArrayList<Airship> reserve = new ArrayList();
    public Pt interceptPoint;
    public Itinerary interceptItinerary;
    public Fleet interceptTarget;
    static boolean reportedDupe = false;

    public static boolean canFly(ArrayList<Airship> ships) {
        for (Airship s : ships) {
            if (!s.type.onGround) continue;
            return false;
        }
        return true;
    }

    public boolean canFly() {
        return Fleet.canFly(this.actives) && Fleet.canFly(this.reserve);
    }

    public boolean groundOnly() {
        for (Airship s : this.actives) {
            if (s.type.onGround) continue;
            return false;
        }
        for (Airship s : this.reserve) {
            if (s.type.onGround) continue;
            return false;
        }
        return true;
    }

    public boolean inTransit() {
        return this.destination != null || this.interceptPoint != null || this.interceptItinerary != null;
    }

    public int roadIndex() {
        if (this.interceptItinerary != null) {
            double p = this.progress;
            for (Segment s : this.interceptItinerary.segments) {
                if (p < (double)s.length()) {
                    return s.startIndex + s.direction * (int)Math.floor(p);
                }
                p -= (double)s.length();
            }
            return this.interceptItinerary.segments.get((int)(this.interceptItinerary.segments.size() - 1)).endIndex;
        }
        if (this.destination == this.usingRoad.src) {
            return (int)Math.max(0.0, Math.min((double)(this.usingRoad.path.size() - 1), Math.floor((double)this.usingRoad.path.size() - this.progress)));
        }
        return (int)Math.max(0.0, Math.min((double)(this.usingRoad.path.size() - 1), Math.floor(this.progress)));
    }

    public static int roadIndex(Road usingRoad, City destination, double progress) {
        if (destination == usingRoad.src) {
            return (int)Math.max(0.0, Math.min((double)(usingRoad.path.size() - 1), Math.floor((double)usingRoad.path.size() - progress)));
        }
        return (int)Math.max(0.0, Math.min((double)(usingRoad.path.size() - 1), Math.floor(progress)));
    }

    public double transitDistance() {
        if (this.destination == null && this.interceptTarget == null) {
            return 0.0;
        }
        if (this.interceptPoint != null) {
            return Math.sqrt((this.sx - this.interceptPoint.x) * (this.sx - this.interceptPoint.x) + (this.sy - this.interceptPoint.y) * (this.sy - this.interceptPoint.y));
        }
        if (this.interceptItinerary != null) {
            int sum = this.interceptItinerary.finalWait;
            for (Segment s : this.interceptItinerary.segments) {
                sum += s.length();
            }
            return sum;
        }
        if (this.usingRoad != null) {
            return this.usingRoad.path.size();
        }
        return Math.sqrt((this.sx - (double)this.destination.x) * (this.sx - (double)this.destination.x) + (this.sy - (double)this.destination.y) * (this.sy - (double)this.destination.y));
    }

    public double realX() {
        if (this.inTransit()) {
            if (this.usingRoad != null) {
                return this.usingRoad.path.get(this.roadIndex())[0];
            }
            if (this.interceptPoint != null) {
                return this.sx + (this.interceptPoint.x - this.sx) * Math.min(1.0, this.progress / this.transitDistance());
            }
            return this.sx + ((double)this.destination.x - this.sx) * Math.min(1.0, this.progress / this.transitDistance());
        }
        if (this.location == null) {
            return this.sx;
        }
        return this.location.x;
    }

    public double realY() {
        if (this.inTransit()) {
            if (this.usingRoad != null) {
                return this.usingRoad.path.get(this.roadIndex())[1];
            }
            if (this.interceptPoint != null) {
                return this.sy + (this.interceptPoint.y - this.sy) * Math.min(1.0, this.progress / this.transitDistance());
            }
            return this.sy + ((double)this.destination.y - this.sy) * Math.min(1.0, this.progress / this.transitDistance());
        }
        if (this.location == null) {
            return this.sy;
        }
        return this.location.y;
    }

    public double displayX() {
        if (this.location != null) {
            return this.location.x - 34;
        }
        return this.realX();
    }

    public double displayY() {
        return this.realY();
    }

    public int maintenanceCost() {
        int c = 0;
        for (Airship ship : this.actives) {
            c += ship.maintenanceCost();
        }
        for (Airship ship : this.reserve) {
            c += ship.maintenanceCost();
        }
        return c;
    }

    public static double speed(ArrayList<Airship> ships) {
        double speed = 2.0;
        for (Airship s : ships) {
            speed = Math.min(speed, s.getMainMapSpeed());
        }
        return speed;
    }

    public double speed() {
        return Math.min(Fleet.speed(this.actives), Fleet.speed(this.reserve));
    }

    public Fleet(City location) {
        this.location = location;
    }

    public Fleet(Fleet original) {
        this.actives.addAll(original.actives);
        this.destination = original.destination;
        this.fleeDestinationNeeded = original.fleeDestinationNeeded;
        this.interceptPoint = original.interceptPoint;
        this.interceptItinerary = original.interceptItinerary;
        this.interceptTarget = original.interceptTarget;
        this.location = original.location;
        this.progress = original.progress;
        this.reserve.addAll(original.reserve);
        this.sx = original.sx;
        this.sy = original.sy;
        this.usingRoad = original.usingRoad;
    }

    public Fleet(JSONObject o) {
        int i;
        this.sx = o.getDouble("sx");
        this.sy = o.getDouble("sy");
        this.progress = o.optDouble("progress", 0.0);
        this.fleeDestinationNeeded = o.getBoolean("fleeDestinationNeeded");
        JSONArray a = o.getJSONArray("ships");
        for (i = 0; i < a.length(); ++i) {
            this.actives.add(new Airship(a.getJSONObject(i)));
        }
        if (o.has("reserve")) {
            a = o.getJSONArray("reserve");
            for (i = 0; i < a.length(); ++i) {
                this.reserve.add(new Airship(a.getJSONObject(i)));
            }
        }
        if (o.has("interceptPointX")) {
            this.interceptPoint = new Pt(o.getDouble("interceptPointX"), o.getDouble("interceptPointY"));
        }
    }

    public void finish(JSONObject o, WorldMap m) {
        if (o.has("locationEmpire")) {
            this.location = m.empires.get((int)o.getInt((String)"locationEmpire")).cities.get(o.getInt("locationCity"));
        }
        if (o.has("destinationEmpire")) {
            this.destination = m.empires.get((int)o.getInt((String)"destinationEmpire")).cities.get(o.getInt("destinationCity"));
        }
        if (o.has("interceptTargetEmpireIndex")) {
            this.interceptTarget = m.empires.get((int)o.getInt((String)"interceptTargetEmpireIndex")).fleets.get(o.getInt("interceptTargetIndex"));
        }
        if (o.has("usingRoad")) {
            this.usingRoad = m.roads.get(o.getInt("usingRoad"));
        }
        if (o.has("interceptItinerary")) {
            this.interceptItinerary = new Itinerary(o.getJSONObject("interceptItinerary"), m);
        }
    }

    private static double guardNaN(double v) {
        return Double.isNaN(v) || Double.isInfinite(v) ? 0.0 : v;
    }

    public JSONObject toJSON(WorldMap m) {
        JSONObject o = new JSONObject().put("sx", Fleet.guardNaN(this.sx)).put("sy", Fleet.guardNaN(this.sy)).put("fleeDestinationNeeded", this.fleeDestinationNeeded).put("progress", Fleet.guardNaN(this.progress));
        if (this.location != null) {
            for (Empire e : m.empires) {
                if (!e.cities.contains(this.location)) continue;
                o.put("locationEmpire", m.empires.indexOf(e));
                o.put("locationCity", e.cities.indexOf(this.location));
            }
        }
        if (this.destination != null) {
            for (Empire e : m.empires) {
                if (!e.cities.contains(this.destination)) continue;
                o.put("destinationEmpire", m.empires.indexOf(e));
                o.put("destinationCity", e.cities.indexOf(this.destination));
            }
        }
        if (this.usingRoad != null) {
            o.put("usingRoad", m.roads.indexOf(this.usingRoad));
        }
        if (this.interceptPoint != null) {
            o.put("interceptPointX", this.interceptPoint.x);
            o.put("interceptPointY", this.interceptPoint.y);
        }
        if (this.interceptItinerary != null) {
            o.put("interceptItinerary", this.interceptItinerary.toJSON(m));
        }
        if (this.interceptTarget != null) {
            Empire e = m.owner(this.interceptTarget);
            o.put("interceptTargetEmpireIndex", m.empires.indexOf(e));
            o.put("interceptTargetIndex", e.fleets.indexOf(this.interceptTarget));
        }
        JSONArray a = new JSONArray();
        o.put("ships", a);
        for (Airship ship : this.actives) {
            a.put(ship.toJSON(null));
        }
        a = new JSONArray();
        o.put("reserve", a);
        for (Airship ship : this.reserve) {
            a.put(ship.toJSON(null));
        }
        return o;
    }

    public boolean canTravelTo(City destination, WorldMap wm, Empire owner) {
        if (this.destination == destination) {
            return true;
        }
        if (this.canFly()) {
            return true;
        }
        if (this.usingRoad != null) {
            return this.usingRoad.src == destination || this.usingRoad.dst == destination;
        }
        Road road = wm.getConnection(this.location, destination);
        return road != null && (!road.seaRoute || owner == wm.owner(destination));
    }

    public boolean travelTo(City destination, WorldMap wm) {
        if (this.destination == destination) {
            return true;
        }
        if (this.canFly()) {
            this.sx = this.realX();
            this.sy = this.realY();
            this.destination = destination;
            this.location = null;
            this.progress = 0.0;
            this.interceptPoint = null;
            this.interceptItinerary = null;
            this.interceptTarget = null;
            this.fleeDestinationNeeded = false;
            this.usingRoad = null;
            this.broadcastChangedDirection(wm);
            return true;
        }
        if (this.usingRoad != null) {
            if (this.usingRoad.src == destination || this.usingRoad.dst == destination) {
                this.progress = this.usingRoad.dst == destination ? (double)this.roadIndex() : (double)(this.usingRoad.path.size() - this.roadIndex());
                this.interceptTarget = null;
                this.interceptItinerary = null;
                this.destination = destination;
                this.fleeDestinationNeeded = false;
                this.broadcastChangedDirection(wm);
                return true;
            }
            return false;
        }
        Road road = wm.getConnection(this.location, destination);
        if (!(road == null || road.seaRoute && wm.owner(this) != wm.owner(destination))) {
            this.usingRoad = road;
            this.location = null;
            this.destination = destination;
            this.progress = 0.0;
            this.interceptPoint = null;
            this.interceptItinerary = null;
            this.interceptTarget = null;
            this.fleeDestinationNeeded = false;
            this.broadcastChangedDirection(wm);
            return true;
        }
        return false;
    }

    public void stopAndAskForHelp() {
        if (this.location == null && this.usingRoad == null) {
            this.sx = this.realX();
            this.sy = this.realY();
            this.location = null;
            this.progress = 0.0;
        }
        if (this.usingRoad != null) {
            this.progress = this.roadIndex();
        }
        this.destination = null;
        this.interceptPoint = null;
        this.interceptItinerary = null;
        this.interceptTarget = null;
        this.fleeDestinationNeeded = true;
    }

    public boolean tick(int ms, Empire owner, WorldMap map) {
        if (!reportedDupe) {
            int n;
            boolean dupe = false;
            for (Airship s : this.actives) {
                n = 0;
                for (Airship s2 : this.actives) {
                    if (s != s2) continue;
                    ++n;
                }
                for (Airship s2 : this.reserve) {
                    if (s != s2) continue;
                    ++n;
                }
                if (n <= 1) continue;
                dupe = true;
            }
            for (Airship s : this.reserve) {
                n = 0;
                for (Airship s2 : this.actives) {
                    if (s != s2) continue;
                    ++n;
                }
                for (Airship s2 : this.reserve) {
                    if (s != s2) continue;
                    ++n;
                }
                if (n <= 1) continue;
                dupe = true;
            }
            if (dupe) {
                AirshipGame.instance.reportError("Dupe detected", null, "", false, true);
                reportedDupe = true;
                for (Airship s : new ArrayList<Airship>(this.actives)) {
                    n = 0;
                    for (Airship s2 : this.actives) {
                        if (s != s2) continue;
                        ++n;
                    }
                    for (Airship s2 : this.reserve) {
                        if (s != s2) continue;
                        ++n;
                    }
                    if (n <= 1) continue;
                    while (this.actives.contains(s)) {
                        this.actives.remove(s);
                    }
                    while (this.reserve.contains(s)) {
                        this.reserve.remove(s);
                    }
                    this.actives.add(s);
                }
                for (Airship s : new ArrayList<Airship>(this.reserve)) {
                    n = 0;
                    for (Airship s2 : this.actives) {
                        if (s != s2) continue;
                        ++n;
                    }
                    for (Airship s2 : this.reserve) {
                        if (s != s2) continue;
                        ++n;
                    }
                    if (n <= 1) continue;
                    while (this.actives.contains(s)) {
                        this.actives.remove(s);
                    }
                    while (this.reserve.contains(s)) {
                        this.reserve.remove(s);
                    }
                    this.reserve.add(s);
                }
            }
        }
        if (this.destination != null) {
            this.progress += (double)ms * this.speed() * 0.05;
            if (this.progress >= this.transitDistance()) {
                this.location = this.destination;
                this.destination = null;
                this.usingRoad = null;
                for (Fleet f : owner.fleets) {
                    if (f == this || f.location != this.location) continue;
                    f.actives.addAll(this.actives);
                    f.reserve.addAll(this.reserve);
                    this.location.layoutGarrison(map);
                    this.broadcastDestroyed(map);
                    return true;
                }
                this.broadcastArrived(map);
                this.location.layoutGarrison(map);
            }
        }
        if (!(this.interceptPoint == null && this.interceptItinerary == null || this.fleeDestinationNeeded)) {
            this.progress += (double)ms * this.speed() * 0.05;
            if (this.interceptItinerary != null) {
                this.usingRoad = null;
                double p = this.progress;
                for (Segment s : this.interceptItinerary.segments) {
                    if (p <= (double)s.length()) {
                        this.usingRoad = s.road;
                        break;
                    }
                    p -= (double)s.length();
                }
                if (this.usingRoad == null) {
                    this.usingRoad = this.interceptItinerary.segments.get((int)(this.interceptItinerary.segments.size() - 1)).road;
                }
            }
        }
        return false;
    }

    public boolean containsAny(Fleet oldF) {
        for (Airship s : this.actives) {
            if (!oldF.actives.contains(s) && !oldF.reserve.contains(s)) continue;
            return true;
        }
        for (Airship s : this.reserve) {
            if (!oldF.actives.contains(s) && !oldF.reserve.contains(s)) continue;
            return true;
        }
        return false;
    }

    public boolean doIntercept(Fleet target, WorldMap wm) {
        Intercept icept = this.getFlightIntercept(target, null, wm);
        if (icept == null) {
            return false;
        }
        this.sx = this.realX();
        this.sy = this.realY();
        this.progress = 0.0;
        this.location = null;
        this.destination = null;
        this.interceptPoint = icept.flyToPt;
        this.interceptItinerary = icept.itinerary;
        this.interceptTarget = target;
        this.fleeDestinationNeeded = false;
        return true;
    }

    public void broadcastChangedDirection(WorldMap wm) {
        for (Empire e : wm.empires) {
            for (Fleet f : e.fleets) {
                f.fleetChangedDirection(this, wm);
            }
        }
    }

    public void fleetChangedDirection(Fleet fl, WorldMap wm) {
        if (fl == this.interceptTarget) {
            if (!this.doIntercept(this.interceptTarget, wm)) {
                this.stopAndAskForHelp();
            }
            this.broadcastStopped(wm);
        }
    }

    public void broadcastArrived(WorldMap wm) {
        for (Empire e : wm.empires) {
            for (Fleet f : e.fleets) {
                f.fleetArrived(this, wm);
            }
        }
    }

    public void fleetArrived(Fleet fl, WorldMap wm) {
        if (fl == this.interceptTarget) {
            this.stopAndAskForHelp();
            this.broadcastStopped(wm);
        }
    }

    public void broadcastDestroyed(WorldMap wm) {
        for (Empire e : wm.empires) {
            for (Fleet f : e.fleets) {
                f.fleetDestroyed(this, wm);
            }
        }
    }

    public void fleetDestroyed(Fleet fl, WorldMap wm) {
        if (fl == this.interceptTarget) {
            this.stopAndAskForHelp();
            this.broadcastStopped(wm);
        }
    }

    public void broadcastStopped(WorldMap wm) {
        for (Empire e : wm.empires) {
            for (Fleet f : e.fleets) {
                f.fleetStopped(this, wm);
            }
        }
    }

    public void fleetStopped(Fleet fl, WorldMap wm) {
        if (fl == this.interceptTarget) {
            this.stopAndAskForHelp();
        }
    }

    public Intercept getFlightIntercept(Fleet target, ArrayList<Airship> shipsToSend, WorldMap wm) {
        if (shipsToSend == null) {
            shipsToSend = new ArrayList();
            shipsToSend.addAll(this.actives);
            shipsToSend.addAll(this.reserve);
        }
        if (target.location != null) {
            return null;
        }
        if (target.destination == null) {
            return null;
        }
        if (!Fleet.canFly(shipsToSend)) {
            if (target.usingRoad == null) {
                return null;
            }
            ArrayList<Itinerary> its = new ArrayList<Itinerary>();
            if (this.usingRoad != null) {
                its.add(new Itinerary(new Segment(this.usingRoad, this.roadIndex(), this.roadIndex(), 1)));
                its.add(new Itinerary(new Segment(this.usingRoad, this.roadIndex(), this.roadIndex(), -1)));
            } else if (this.location != null) {
                for (Road r : wm.roads) {
                    if (r.seaRoute) continue;
                    if (r.src == this.location) {
                        its.add(new Itinerary(new Segment(r, 0, 0, 1)));
                    }
                    if (r.dst != this.location) continue;
                    its.add(new Itinerary(new Segment(r, r.path.size() - 1, r.path.size() - 1, -1)));
                }
            } else {
                throw new RuntimeException("Fleet cannot fly, is not using road, and has no location!");
            }
            double mySpeed = Fleet.speed(shipsToSend);
            double targetSpeed = target.speed();
            double targetProgress = target.progress;
            boolean targetMovingForwards = target.usingRoad.dst == target.destination;
            HashSet<UsedForkPoint> ufps = new HashSet<UsedForkPoint>();
            ArrayList<Itinerary> l2 = new ArrayList<Itinerary>();
            while (!its.isEmpty()) {
                int targetRI = Fleet.roadIndex(target.usingRoad, target.destination, targetProgress);
                l2.clear();
                l2.addAll(its);
                for (Itinerary it : l2) {
                    Itinerary it2;
                    UsedForkPoint ufp;
                    int otherIndex;
                    int direction;
                    Segment seg = it.segments.get(it.segments.size() - 1);
                    if (seg.road.overlaps.get(seg.endIndex).containsKey(target.usingRoad)) {
                        int overlapRI = seg.road.overlaps.get(seg.endIndex).get(target.usingRoad);
                        if (targetMovingForwards) {
                            if (overlapRI >= targetRI) {
                                it.finalWait = (int)((double)(overlapRI - targetRI) / targetSpeed * mySpeed);
                                return new Intercept(it);
                            }
                        } else if (overlapRI <= targetRI) {
                            it.finalWait = (int)((double)(targetRI - overlapRI) / targetSpeed * mySpeed);
                            return new Intercept(it);
                        }
                    }
                    seg.endIndex += seg.direction;
                    if (seg.endIndex <= 0 || seg.endIndex >= seg.road.path.size() - 1) {
                        its.remove(it);
                        continue;
                    }
                    if (it.segments.size() >= 4 || Math.abs(seg.endIndex - seg.startIndex) <= 2 || seg.endIndex - seg.direction < 5 || seg.endIndex - seg.direction >= seg.road.path.size() - 5) continue;
                    HashSet<City> forkedToCities = new HashSet<City>();
                    for (Road coRoad : seg.road.overlaps.get(seg.endIndex - seg.direction).keySet()) {
                        if (coRoad.seaRoute || it.usedRoad(coRoad) || forkedToCities.contains(coRoad.src) || forkedToCities.contains(coRoad.dst) || seg.road.overlaps.get(seg.endIndex).containsKey(coRoad) || seg.endIndex - seg.direction * 2 < 0 || seg.endIndex - seg.direction * 2 >= seg.road.path.size() || !seg.road.overlaps.get(seg.endIndex - seg.direction * 2).containsKey(coRoad) || (direction = (otherIndex = seg.road.overlaps.get(seg.endIndex - seg.direction).get(coRoad).intValue()) - seg.road.overlaps.get(seg.endIndex - seg.direction * 2).get(coRoad)) == 0 || ufps.contains(ufp = new UsedForkPoint(coRoad, otherIndex))) continue;
                        ufps.add(ufp);
                        it2 = it.dupe();
                        it2.segments.get((int)(it2.segments.size() - 1)).endIndex -= it2.segments.get((int)(it2.segments.size() - 1)).direction;
                        it2.segments.add(new Segment(coRoad, otherIndex, otherIndex, direction));
                        its.add(it2);
                        forkedToCities.add(coRoad.src);
                        forkedToCities.add(coRoad.dst);
                    }
                    for (Road coRoad : seg.road.overlaps.get(seg.endIndex).keySet()) {
                        if (coRoad.seaRoute || it.usedRoad(coRoad) || forkedToCities.contains(coRoad.src) || forkedToCities.contains(coRoad.dst) || seg.road.overlaps.get(seg.endIndex - seg.direction).containsKey(coRoad) || seg.endIndex + seg.direction < 0 || seg.endIndex + seg.direction >= seg.road.path.size() || !seg.road.overlaps.get(seg.endIndex + seg.direction).containsKey(coRoad) || (direction = (otherIndex = seg.road.overlaps.get(seg.endIndex).get(coRoad).intValue()) - seg.road.overlaps.get(seg.endIndex + seg.direction).get(coRoad)) == 0 || ufps.contains(ufp = new UsedForkPoint(coRoad, otherIndex))) continue;
                        ufps.add(ufp);
                        it2 = it.dupe();
                        it2.segments.get((int)(it2.segments.size() - 1)).endIndex -= it2.segments.get((int)(it2.segments.size() - 1)).direction;
                        it2.segments.add(new Segment(coRoad, otherIndex, otherIndex, direction));
                        its.add(it2);
                        forkedToCities.add(coRoad.src);
                        forkedToCities.add(coRoad.dst);
                    }
                }
                if (!((targetProgress += targetSpeed / mySpeed) >= (double)target.usingRoad.path.size())) continue;
                break;
            }
            return null;
        }
        if (target.usingRoad == null) {
            double aStartX = this.realX();
            double aStartY = this.realY();
            double bStartX = target.realX();
            double bStartY = target.realY();
            double aSpeed = Fleet.speed(shipsToSend) * 0.05;
            double bSpeed = target.speed() * 0.05;
            double bDist = target.transitDistance() - target.progress;
            double bVelocityX = (double)target.destination.x - target.sx;
            double bVelocityY = (double)target.destination.y - target.sy;
            double vLength = Math.sqrt(bVelocityX * bVelocityX + bVelocityY * bVelocityY);
            bVelocityX = bVelocityX / vLength * bSpeed;
            bVelocityY = bVelocityY / vLength * bSpeed;
            double dx = bStartX - aStartX;
            double dy = bStartY - aStartY;
            double t = -1.0;
            if (this.speed() == target.speed()) {
                double angle = Math.atan2(bVelocityY, bVelocityX) - Math.atan2(-dy, -dx);
                if (angle >= 0.0) {
                    double hyp = Math.sqrt(dx * dx + dy * dy) / 2.0 / Math.cos(angle);
                    t = hyp / Math.sqrt(bVelocityX * bVelocityX + bVelocityY * bVelocityY);
                }
            } else {
                double tPlus = (-2.0 * (dx * bVelocityX + dy * bVelocityY) + Math.sqrt(4.0 * (dx * bVelocityX + dy * bVelocityY) * (dx * bVelocityX + dy * bVelocityY) - 4.0 * (-aSpeed * aSpeed + bVelocityX * bVelocityX + bVelocityY * bVelocityY) * (dx * dx + dy * dy))) / (2.0 * (-aSpeed * aSpeed + bVelocityX * bVelocityX + bVelocityY * bVelocityY));
                double tMinus = (-2.0 * (dx * bVelocityX + dy * bVelocityY) - Math.sqrt(4.0 * (dx * bVelocityX + dy * bVelocityY) * (dx * bVelocityX + dy * bVelocityY) - 4.0 * (-aSpeed * aSpeed + bVelocityX * bVelocityX + bVelocityY * bVelocityY) * (dx * dx + dy * dy))) / (2.0 * (-aSpeed * aSpeed + bVelocityX * bVelocityX + bVelocityY * bVelocityY));
                double d = t = Double.isNaN(tPlus) || Double.isInfinite(tPlus) || tPlus < 0.0 ? tMinus : tPlus;
            }
            if (t >= 0.0 && t < bDist / bSpeed) {
                double interceptX = bStartX + t * bVelocityX;
                double interceptY = bStartY + t * bVelocityY;
                return new Intercept(new Pt(interceptX, interceptY));
            }
        } else {
            double tProgress = target.progress;
            double tDistance = target.transitDistance();
            double tSpeed = target.speed() * 0.05;
            double mySpeed = Fleet.speed(shipsToSend) * 0.05;
            double myX = this.realX();
            double myY = this.realY();
            double myRadius = 0.0;
            while (!((tProgress += tSpeed) >= tDistance)) {
                int tY;
                myRadius += mySpeed;
                int n = target.destination == target.usingRoad.dst ? (int)Math.max(0.0, Math.min((double)(target.usingRoad.path.size() - 1), Math.floor(tProgress))) : (int)Math.max(0.0, Math.min((double)(target.usingRoad.path.size() - 1), Math.floor((double)target.usingRoad.path.size() - tProgress)));
                int tRoadIndex = n;
                int tX = target.usingRoad.path.get(tRoadIndex)[0];
                if (!(((double)tX - myX) * ((double)tX - myX) + ((double)(tY = target.usingRoad.path.get(tRoadIndex)[1]) - myY) * ((double)tY - myY) <= myRadius * myRadius)) continue;
                return new Intercept(new Pt((double)tX, (double)tY));
            }
        }
        return null;
    }

    public boolean canIntercept(Fleet target, ArrayList<Airship> shipsToSend, WorldMap wm) {
        return this.getFlightIntercept(target, shipsToSend, wm) != null;
    }

    public ArrayList<Airship> getAllShips() {
        ArrayList<Airship> l = new ArrayList<Airship>();
        l.addAll(this.actives);
        l.addAll(this.reserve);
        return l;
    }

    @Override
    public int size() {
        return this.actives.size();
    }

    @Override
    public Airship get(int index) {
        return this.actives.get(index);
    }

    public class UsedForkPoint {
        public final Road r;
        public final int index;

        public UsedForkPoint(Road r, int index) {
            this.r = r;
            this.index = index;
        }

        public boolean equals(Object o2) {
            return o2 instanceof UsedForkPoint && ((UsedForkPoint)o2).index == this.index && ((UsedForkPoint)o2).r == this.r;
        }

        public int hashCode() {
            return this.r.hashCode() + this.index;
        }
    }

    public static class Intercept {
        public final Pt flyToPt;
        public final Itinerary itinerary;

        public Intercept(Itinerary itinerary) {
            this.flyToPt = null;
            this.itinerary = itinerary;
        }

        public Intercept(Pt flyToPt) {
            this.flyToPt = flyToPt;
            this.itinerary = null;
        }
    }

    public static class Itinerary {
        public ArrayList<Segment> segments = new ArrayList();
        public int finalWait = 0;

        public Itinerary(Segment s) {
            this.segments.add(s);
        }

        public Itinerary(JSONObject o, WorldMap wm) {
            this.finalWait = o.getInt("finalWait");
            JSONArray segA = o.getJSONArray("segments");
            for (int i = 0; i < segA.length(); ++i) {
                this.segments.add(new Segment(segA.getJSONObject(i), wm));
            }
        }

        public JSONObject toJSON(WorldMap wm) {
            JSONObject o = new JSONObject().put("finalWait", this.finalWait);
            JSONArray a = new JSONArray();
            o.put("segments", a);
            for (Segment s : this.segments) {
                a.put(s.toJSON(wm));
            }
            return o;
        }

        private Itinerary() {
        }

        public Itinerary dupe() {
            Itinerary i2 = new Itinerary();
            for (Segment seg : this.segments) {
                i2.segments.add(seg.dupe());
            }
            return i2;
        }

        public boolean usedRoad(Road r) {
            for (Segment s : this.segments) {
                if (s.road != r) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            for (Segment s : this.segments) {
                sb.append(s.road).append(" ").append(s.startIndex).append("-").append(s.endIndex).append(", ");
            }
            sb.append(this.finalWait);
            return sb.toString();
        }
    }

    public static class Segment {
        public Road road;
        public int startIndex;
        public int endIndex;
        public int direction;

        public Segment(Road road, int startIndex, int endIndex, int direction) {
            this.road = road;
            this.startIndex = startIndex;
            this.endIndex = endIndex;
            this.direction = direction;
        }

        public Segment(JSONObject o, WorldMap wm) {
            this.road = wm.roads.get(o.getInt("road"));
            this.startIndex = o.getInt("startIndex");
            this.endIndex = o.getInt("endIndex");
            this.direction = o.getInt("direction");
        }

        public JSONObject toJSON(WorldMap wm) {
            return new JSONObject().put("road", wm.roads.indexOf(this.road)).put("startIndex", this.startIndex).put("endIndex", this.endIndex).put("direction", this.direction);
        }

        public Segment dupe() {
            return new Segment(this.road, this.startIndex, this.endIndex, this.direction);
        }

        public int length() {
            return Math.abs(this.endIndex - this.startIndex);
        }
    }
}

