/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.BackgroundFloatie;
import com.zarkonnen.airships.MyDraw;
import com.zarkonnen.airships.TimeOfDay;
import com.zarkonnen.airships.UniScreen;
import com.zarkonnen.catengine.Input;
import java.util.ArrayList;

public class FloatieVisualLayer
implements UniScreen.VisualLayer {
    public static final int N_FLOATIES = 4;
    public ArrayList<BackgroundFloatie> floaties = new ArrayList();

    @Override
    public void tick(Input in, int ms, UniScreen us) {
        int i;
        if (us.intent.drawAsBlueprint()) {
            return;
        }
        if (this.floaties.isEmpty()) {
            block0: for (i = 0; i < 4; ++i) {
                int roll = AGame.ANIM_R.nextInt(BackgroundFloatie.totalWeights());
                for (BackgroundFloatie.Type t : BackgroundFloatie.Type.values()) {
                    if ((roll -= t.weight) > 0) continue;
                    this.floaties.add(new BackgroundFloatie(t, false));
                    continue block0;
                }
            }
        }
        for (i = 0; i < this.floaties.size(); ++i) {
            this.floaties.get(i).tick(ms);
        }
    }

    @Override
    public void draw(MyDraw d, UniScreen us, double cropX, double cropY, double cropW, double cropH) {
        if (us.intent.drawAsBlueprint()) {
            return;
        }
        TimeOfDay tod = us.getTimeOfDay();
        for (int i = 0; i < this.floaties.size(); ++i) {
            this.floaties.get(i).draw(d, us.lightingMap, tod.lightStrength, tod.ambient);
        }
    }
}

