/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.Appearance;
import com.zarkonnen.airships.ArmourType;
import com.zarkonnen.airships.ModuleType;
import com.zarkonnen.catengine.Img;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.LinkedList;
import javax.imageio.ImageIO;

public class FragmentGen {
    static int finishedY = 0;

    public static void main(String[] args) throws IOException {
        BufferedImage fragMap = ImageIO.read(new File("src/com/zarkonnen/airships/images/fragments.png"));
        BufferedImage spritesheet = ImageIO.read(new File("src/com/zarkonnen/airships/images/spritesheet.png"));
        BufferedImage bump = ImageIO.read(new File("src/com/zarkonnen/airships/images/bump.png"));
        BufferedImage fragSheet = new BufferedImage(1024, 1024, 2);
        BufferedImage fragBump = new BufferedImage(1024, 1024, 2);
        PrintWriter out = new PrintWriter(new File("src/com/zarkonnen/airships/images/fragments.txt"));
        ArrayList<Rectangle> used = new ArrayList<Rectangle>();
        for (ModuleType moduleType : ModuleType.values()) {
            System.out.println(moduleType.name());
            FragmentGen.process(moduleType.getApp(), fragMap, spritesheet, bump, fragSheet, fragBump, used, moduleType.name(), out);
            for (ModuleType.ExternalApp ea : moduleType.getExternalApps()) {
                FragmentGen.process(ea.app, fragMap, spritesheet, bump, fragSheet, fragBump, used, moduleType.name() + " ex " + moduleType.getExternalApps().indexOf(ea), out);
            }
        }
        for (Enum enum_ : ArmourType.values()) {
            System.out.println(enum_.name());
            if (((ArmourType)enum_).damagedApps == null) continue;
            for (Appearance da : ((ArmourType)enum_).damagedApps) {
                FragmentGen.process(da, fragMap, spritesheet, bump, fragSheet, fragBump, used, "arm " + enum_.name() + " " + ((ArmourType)enum_).damagedApps.indexOf(da), out);
            }
        }
        out.flush();
        out.close();
        ImageIO.write((RenderedImage)fragSheet, "PNG", new File("src/com/zarkonnen/airships/images/fragments_sheet.png"));
        ImageIO.write((RenderedImage)fragBump, "PNG", new File("src/com/zarkonnen/airships/images/fragments_bump.png"));
    }

    private static void process(Appearance app, BufferedImage fragMap, BufferedImage spritesheet, BufferedImage bump, BufferedImage fragSheet, BufferedImage fragBump, ArrayList<Rectangle> used, String key, PrintWriter out) {
        for (Img frame : app.frames) {
            FragmentGen.process(frame, fragMap, spritesheet, bump, fragSheet, fragBump, used, key + " " + app.frames.indexOf(frame), out);
        }
    }

    private static void process(Img img, BufferedImage fragMap, BufferedImage spritesheet, BufferedImage bump, BufferedImage fragSheet, BufferedImage fragBump, ArrayList<Rectangle> used, String key, PrintWriter out) {
        int white = Color.WHITE.getRGB();
        boolean[][] taken = new boolean[img.srcHeight][img.srcWidth];
        for (int beginY = img.srcY; beginY < img.srcY + img.srcHeight; ++beginY) {
            for (int beginX = img.srcX; beginX < img.srcX + img.srcWidth; ++beginX) {
                int regionClr;
                if (taken[beginY - img.srcY][beginX - img.srcX] || (regionClr = fragMap.getRGB(beginX, beginY)) == white) continue;
                ArrayList<PxPos> currentRegion = FragmentGen.floodFill(regionClr, beginX, beginY, img, fragMap, taken);
                FragmentGen.emit(currentRegion, img, spritesheet, bump, fragSheet, fragBump, used, key, out);
            }
        }
    }

    static boolean blocked(Rectangle r, ArrayList<Rectangle> rs) {
        for (Rectangle r2 : rs) {
            if (!r2.intersects(r)) continue;
            return true;
        }
        return false;
    }

    static void emit(ArrayList<PxPos> region, Img img, BufferedImage spriteSheet, BufferedImage bump, BufferedImage fragSheet, BufferedImage fragBump, ArrayList<Rectangle> used, String key, PrintWriter out) {
        int regionLeft = 1024;
        int regionRight = 0;
        int regionTop = 1024;
        int regionBottom = 0;
        for (PxPos pxp : region) {
            regionLeft = Math.min(regionLeft, pxp.x);
            regionRight = Math.max(regionRight, pxp.x);
            regionTop = Math.min(regionTop, pxp.y);
            regionBottom = Math.max(regionBottom, pxp.y);
        }
        Rectangle regionRect = new Rectangle(0, Math.max(0, finishedY - 10), regionRight - regionLeft + 3, regionBottom - regionTop + 3);
        while (FragmentGen.blocked(regionRect, used)) {
            ++regionRect.x;
            if (regionRect.x + regionRect.width < 1024) continue;
            finishedY = ++regionRect.y;
            regionRect.x = 0;
        }
        used.add(regionRect);
        int xShift = regionRect.x + 1 - regionLeft;
        int yShift = regionRect.y + 1 - regionTop;
        Graphics2D fg = fragSheet.createGraphics();
        Graphics2D bg = fragBump.createGraphics();
        for (PxPos pxp : region) {
            int x = pxp.x;
            int y = pxp.y;
            fg.drawImage(spriteSheet, x + xShift, y + yShift, x + xShift + 1, y + yShift + 1, x, y, x + 1, y + 1, null);
            bg.drawImage(bump, x + xShift, y + yShift, x + xShift + 1, y + yShift + 1, x, y, x + 1, y + 1, null);
        }
        int xOffset = regionLeft - img.srcX;
        int yOffset = regionTop - img.srcY;
        out.println(key);
        out.println(regionRect.x + " " + regionRect.y + " " + regionRect.width + " " + regionRect.height + " " + xOffset + " " + yOffset);
    }

    static ArrayList<PxPos> floodFill(int regionClr, int beginX, int beginY, Img img, BufferedImage fragMap, boolean[][] taken) {
        LinkedList<PxPos> queue = new LinkedList<PxPos>();
        ArrayList<PxPos> l = new ArrayList<PxPos>();
        queue.add(new PxPos(beginX, beginY));
        taken[beginY - img.srcY][beginX - img.srcX] = true;
        while (!queue.isEmpty()) {
            PxPos pxp = (PxPos)queue.pollFirst();
            l.add(pxp);
            for (int dy = -1; dy < 2; ++dy) {
                for (int dx = -1; dx < 2; ++dx) {
                    int localClr;
                    int ny = pxp.y + dy;
                    int nx = pxp.x + dx;
                    if (ny < img.srcY || ny >= img.srcY + img.srcHeight || nx < img.srcX || nx >= img.srcX + img.srcWidth || taken[ny - img.srcY][nx - img.srcX] || (localClr = fragMap.getRGB(nx, ny)) != regionClr) continue;
                    taken[ny - img.srcY][nx - img.srcX] = true;
                    queue.add(new PxPos(nx, ny));
                }
            }
        }
        return l;
    }

    static class PxPos {
        final int x;
        final int y;

        public PxPos(int x, int y) {
            this.x = x;
            this.y = y;
        }

        public boolean equals(Object o2) {
            if (!(o2 instanceof PxPos)) {
                return false;
            }
            PxPos pp2 = (PxPos)o2;
            return pp2.x == this.x && pp2.y == this.y;
        }

        public int hashCode() {
            return this.x * 1024 + this.y;
        }
    }
}

