/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.AirshipGame;
import com.zarkonnen.airships.Bonus;
import com.zarkonnen.airships.CampaignWorld;
import com.zarkonnen.airships.City;
import com.zarkonnen.airships.CoatEditor;
import com.zarkonnen.airships.CoatOfArms;
import com.zarkonnen.airships.InputRunnable;
import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.LoadingScreen;
import com.zarkonnen.airships.MainMenu;
import com.zarkonnen.airships.MyDraw;
import com.zarkonnen.airships.Screen;
import com.zarkonnen.airships.TextField;
import com.zarkonnen.airships.TimeOfDay;
import com.zarkonnen.airships.WorldGenScreen;
import com.zarkonnen.airships.WorldMap;
import com.zarkonnen.catengine.Fount;
import com.zarkonnen.catengine.Hooks;
import com.zarkonnen.catengine.Input;
import com.zarkonnen.catengine.util.Pt;
import com.zarkonnen.catengine.util.ScreenMode;
import java.util.ArrayList;

public class GameSetupScreen
implements Screen {
    private final AirshipGame g;
    public TextField empireNameField;
    public CoatOfArms empireCOA;
    private WorldMap.Size size = WorldMap.Size.MEDIUM;

    public GameSetupScreen(AirshipGame g) {
        this.g = g;
        this.empireCOA = CoatEditor.getMyStrategicArms();
        while (this.empireCOA.getBonus() == Bonus.NO_BONUS) {
            this.empireCOA = CoatOfArms.getRandom();
        }
    }

    @Override
    public void input(Input in, MyDraw.State drawState, Pt cursor, Pt click, int ms) {
        if (this.empireNameField == null) {
            this.empireNameField = new TextField(false, " qwertyuiopasdfghjklzxcvbnmQWERTYUIOPASDFGHJKLZXCVBNM1234567890-=+_!?,.&()");
            this.empireNameField.text = City.NAMES[AGame.ANIM_R.nextInt(City.NAMES.length)];
        }
        this.empireNameField.input(in, drawState, cursor, click, ms);
        if (in.keyDown("ENTER") && drawState.canClick() && !this.empireNameField.text.isEmpty()) {
            this.startGame();
            drawState.hasClicked();
            return;
        }
        if (in.keyDown("ESCAPE") && drawState.canClick()) {
            this.g.s = new MainMenu(this.g);
            drawState.hasClicked();
        }
    }

    private void startGame() {
        this.g.s = new WorldGenScreen(new CampaignWorld(System.currentTimeMillis(), this.size, this.g, this.empireCOA), this.g, this.empireNameField.text, this.empireCOA);
    }

    private static String cap(String s) {
        return s.substring(0, 1).toUpperCase() + s.substring(1).toLowerCase();
    }

    @Override
    public void render(final MyDraw d, ScreenMode sm, Hooks hs, Pt cursor) {
        d.drawBG(AGame.CAST_IRON, sm);
        if (this.empireNameField == null) {
            return;
        }
        int shieldW = Math.min(sm.width, sm.height) / 2;
        int panelW = Math.min(250, (sm.width - shieldW) / 2 - 10 - 12);
        int x = sm.width / 2 - shieldW / 2;
        int y = sm.height / 2 - shieldW / 2;
        int glowSize = shieldW * 2;
        int coaX = sm.width / 2 - shieldW / 36 * 36 / 2;
        d.blit(LoadingScreen.glow, LoadingScreen.TITLE, sm.width / 2 - glowSize / 2, y - glowSize / 2 + shieldW / 2, glowSize, glowSize);
        this.empireCOA.layout.drawShield(this.empireCOA, d, coaX, y, shieldW / 36, LoadingScreen.TITLE);
        if (!this.empireNameField.text.isEmpty()) {
            Pt sz = d.textSize(this.empireNameField.text.toUpperCase(), AGame.HUGE_FOUNT);
            d.drawShadowedWindow(sm.width / 2 - (int)sz.x / 2 - 15, y + shieldW * 10 / 9, (int)sz.x + 30, 82);
            d.text("[f5edb5]" + this.empireNameField.text.toUpperCase(), AGame.HUGE_FOUNT, sm.width / 2 - (int)sz.x / 2, y + shieldW * 10 / 9 + 12 - 10);
        }
        d.drawWindow(x += shieldW + 12, y, panelW, panelW);
        d.text(this.empireCOA.blazon() + "\n\n" + this.empireCOA.getBonus().getDesc(), AGame.FOUNT, x + 12, y + 12, panelW - 24);
        final GameSetupScreen gss = this;
        d.button(x + 12, y + panelW - 12 - 3 - 48, panelW - 24, Lang._t("Edit_Arms", new Object[0]), new Runnable(){

            @Override
            public void run() {
                d.state.hasClicked();
                ((GameSetupScreen)GameSetupScreen.this).g.s = new CoatEditor(GameSetupScreen.this.g, gss);
            }
        });
        d.button(x + 12, y + panelW - 12 - 24, panelW - 24, Lang._t("Random_Arms", new Object[0]), new Runnable(){

            @Override
            public void run() {
                d.state.hasClicked();
                GameSetupScreen.this.empireCOA = CoatOfArms.getRandom();
            }
        });
        int titleW = (int)d.textSize((String)Lang._t((String)"Game_Setup", (Object[])new Object[0]), (Fount)AGame.HUGE_FOUNT).x;
        d.text("[f5edb5]" + Lang._t("Game_Setup", new Object[0]), AGame.HUGE_FOUNT, sm.width / 2 - titleW / 2, y - AGame.HUGE_FOUNT.height);
        this.empireNameField.render(x -= shieldW + panelW + 24, y, panelW, d, sm, hs, cursor);
        int oldY = y;
        y += 27;
        for (final WorldMap.Size sz : WorldMap.Size.values()) {
            d.toggle(x, y, panelW, sz.getName(), null, new InputRunnable(){

                @Override
                public void run(Input in) {
                    GameSetupScreen.this.size = sz;
                }
            }, this.size == sz, true);
            y += 27;
        }
        d.button(x, oldY + panelW - 48 - 3, panelW, Lang._t("Start_Game", new Object[0]), new Runnable(){

            @Override
            public void run() {
                GameSetupScreen.this.startGame();
            }
        });
        y += 27;
        d.button(x, oldY + panelW - 24, panelW, Lang._t("Cancel", new Object[0]), new Runnable(){

            @Override
            public void run() {
                ((GameSetupScreen)GameSetupScreen.this).g.s = new MainMenu(GameSetupScreen.this.g);
            }
        });
    }

    @Override
    public ArrayList<String> music() {
        return null;
    }

    @Override
    public String appearancePostfix() {
        return TimeOfDay.DAY.name();
    }

    @Override
    public boolean alwaysUseAppearancePostfix() {
        return false;
    }
}

