/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.LandFormation;
import com.zarkonnen.airships.MyDraw;
import com.zarkonnen.airships.UniScreen;
import com.zarkonnen.catengine.Input;
import com.zarkonnen.catengine.util.Pt;
import com.zarkonnen.catengine.util.ScreenMode;

public abstract class GroundTool
implements UniScreen.Tool {
    public LandFormation ground(UniScreen us) {
        if (us.combat != null) {
            return us.combat.landFormations.get(0);
        }
        if (us.city != null) {
            return us.city.ground;
        }
        if (us.setupGround != null) {
            return us.setupGround;
        }
        return null;
    }

    public int[] groundXY(UniScreen us, LandFormation ground, Pt p) {
        int x = (int)((us.screenToWorldX(p.x) - ground.x) / 16.0);
        int y = (int)((us.screenToWorldY(p.y) - ground.y) / 16.0);
        if (y >= 0 && y < ground.grid.length && x >= 0 && x < ground.grid[0].length) {
            return new int[]{x, y};
        }
        return null;
    }

    @Override
    public void draw(MyDraw d, Pt cursor, ScreenMode sm, UniScreen us) {
        int[] gxy;
        LandFormation gr = this.ground(us);
        if (gr != null && (gxy = this.groundXY(us, gr, cursor)) != null) {
            d.scale(us.zoom, us.zoom);
            d.shift(us.adjScrollX, us.adjScrollY);
            this.drawScaled(d, us, gr, gxy[0], gxy[1]);
            d.resetTransforms();
            this.drawUnscaled(d, us, gr, gxy[0], gxy[1], cursor);
        }
    }

    public abstract void drawScaled(MyDraw var1, UniScreen var2, LandFormation var3, int var4, int var5);

    public abstract void drawUnscaled(MyDraw var1, UniScreen var2, LandFormation var3, int var4, int var5, Pt var6);

    @Override
    public boolean click(Input in, Pt click, ScreenMode sm, UniScreen us) {
        int[] gxy;
        LandFormation gr = this.ground(us);
        if (gr != null && (gxy = this.groundXY(us, gr, click)) != null) {
            return this.click(in, us, gr, gxy[0], gxy[1]);
        }
        return false;
    }

    public abstract boolean click(Input var1, UniScreen var2, LandFormation var3, int var4, int var5);

    @Override
    public boolean rightClick(Input in, Pt click, ScreenMode sm, UniScreen us) {
        int[] gxy;
        LandFormation gr = this.ground(us);
        if (gr != null && (gxy = this.groundXY(us, gr, click)) != null) {
            return this.rightClick(in, us, gr, gxy[0], gxy[1]);
        }
        return false;
    }

    public abstract boolean rightClick(Input var1, UniScreen var2, LandFormation var3, int var4, int var5);

    @Override
    public boolean mouseDown(Input in, Pt click, ScreenMode sm, UniScreen us) {
        int[] gxy;
        LandFormation gr = this.ground(us);
        if (gr != null && (gxy = this.groundXY(us, gr, click)) != null) {
            return this.mouseDown(in, us, gr, gxy[0], gxy[1]);
        }
        return false;
    }

    public abstract boolean mouseDown(Input var1, UniScreen var2, LandFormation var3, int var4, int var5);
}

