/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.AirshipGame;
import com.zarkonnen.airships.Client;
import com.zarkonnen.airships.InputRunnable;
import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.MainMenu;
import com.zarkonnen.airships.MultiplayerSetupIntent;
import com.zarkonnen.airships.MyDraw;
import com.zarkonnen.airships.Screen;
import com.zarkonnen.airships.Server;
import com.zarkonnen.airships.TextField;
import com.zarkonnen.airships.TimeOfDay;
import com.zarkonnen.airships.UniScreen;
import com.zarkonnen.catengine.Fount;
import com.zarkonnen.catengine.Hook;
import com.zarkonnen.catengine.Hooks;
import com.zarkonnen.catengine.Input;
import com.zarkonnen.catengine.util.Pt;
import com.zarkonnen.catengine.util.ScreenMode;
import java.net.InetAddress;
import java.util.ArrayList;

public strictfp class HostOrJoinGameScreen
implements Screen {
    private TextField nameField;
    private TextField hostField;
    private final boolean doHost;
    private final AirshipGame g;
    public static final int[] COST_LIMITS = new int[]{200, 500, 1000, 2000, 5000, 10000};
    private int costLimit = 2000;
    private boolean oneShipOnly = false;
    private String yourIP = "";

    public HostOrJoinGameScreen(boolean doHost, AirshipGame g) {
        this.doHost = doHost;
        this.g = g;
        try {
            this.yourIP = Lang._t("Your_IP_address", new Object[0]) + ": " + InetAddress.getLocalHost().getHostAddress();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void input(Input in, MyDraw.State drawState, Pt cursor, Pt click, int ms) {
        if (this.nameField == null) {
            this.nameField = new TextField();
            this.nameField.help = Lang._t("Name", new Object[0]);
            this.hostField = new TextField();
            this.hostField.help = Lang._t("Host_IP", new Object[0]);
            this.hostField.focus = false;
            try {
                this.nameField.text = AirshipGame.PREFS.get("mpName", System.getProperty("user.name", ""));
                this.hostField.text = AirshipGame.PREFS.get("mpHost", "");
            }
            catch (Exception e) {
                this.g.reportError(Lang._t("Unable_to_load_prefs", new Object[0]), e, null, false);
            }
        }
        this.nameField.input(in, drawState, cursor, click, ms);
        this.hostField.input(in, drawState, cursor, click, ms);
        if (in.keyDown("TAB") && !this.doHost && drawState.canClick()) {
            if (this.nameField.focus) {
                this.hostField.focus = true;
                this.nameField.focus = false;
            } else {
                this.hostField.focus = false;
                this.nameField.focus = true;
            }
            drawState.hasClicked();
        }
        if (in.keyDown("ENTER") && drawState.canClick() && !this.nameField.text.isEmpty() && (this.doHost || !this.hostField.text.isEmpty())) {
            drawState.hasClicked();
            this.hostOrJoin();
        } else if (in.keyDown("ESCAPE") && drawState.canClick()) {
            this.g.s = new MainMenu(this.g);
            drawState.hasClicked();
        }
    }

    private void hostOrJoin() {
        try {
            AirshipGame.PREFS.put("mpName", this.nameField.text);
        }
        catch (Exception e) {
            this.g.reportError(Lang._t("Unable_to_store_prefs", new Object[0]), e, null, false);
        }
        if (this.doHost) {
            Server server = new Server();
            server.start();
            Client client = new Client("127.0.0.1", this.g);
            client.start();
            UniScreen us = new UniScreen(this.g, new MultiplayerSetupIntent(false, client, server, this.nameField.text, this.g.getBestCOA(), this.costLimit, this.oneShipOnly));
            us.setupFleet = new ArrayList();
            this.g.s = us;
        } else {
            try {
                AirshipGame.PREFS.put("mpHost", this.hostField.text);
            }
            catch (Exception e) {
                this.g.reportError(Lang._t("Unable_to_store_prefs", new Object[0]), e, null, false);
            }
            Client client = new Client(this.hostField.text, this.g);
            client.start();
            UniScreen us = new UniScreen(this.g, new MultiplayerSetupIntent(true, client, null, this.nameField.text, this.g.getBestCOA(), 0, false));
            us.setupFleet = new ArrayList();
            this.g.s = us;
        }
        try {
            AirshipGame.PREFS.flush();
        }
        catch (Exception e) {
            this.g.reportError(Lang._t("Unable_to_store_prefs", new Object[0]), e, null, false);
        }
    }

    @Override
    public void render(MyDraw d, ScreenMode sm, Hooks hs, Pt cursor) {
        d.drawBG(AGame.CAST_IRON, sm);
        if (this.nameField == null) {
            return;
        }
        int w = 264;
        int h = (this.doHost ? AGame.FOUNT.lineHeight * 2 + 36 - 3 : 12) + 27 * ((this.doHost ? COST_LIMITS.length : 0) + 4) - 3 + 24;
        int x = sm.width / 2 - w / 2;
        int y = sm.height / 2 - h / 2;
        d.drawWindow(x, y, w, h);
        int titleW = (int)d.textSize((String)(this.doHost ? Lang._t((String)"Host_LAN_Game", (Object[])new Object[0]) : Lang._t((String)"Join_LAN_Game", (Object[])new Object[0])), (Fount)AGame.HUGE_FOUNT).x;
        d.text("[f5edb5]" + (this.doHost ? Lang._t("Host_LAN_Game", new Object[0]) : Lang._t("Join_LAN_Game", new Object[0])), AGame.HUGE_FOUNT, sm.width / 2 - titleW / 2, y - AGame.HUGE_FOUNT.height);
        x += 12;
        y += 12;
        if (this.doHost) {
            d.text(Lang._t("Max_Fleet_Cost", new Object[0]), AGame.FOUNT, x, y);
            y += AGame.FOUNT.lineHeight;
            for (int i = 0; i < COST_LIMITS.length; ++i) {
                final int ii = i;
                d.toggle(x, y, 240, "" + COST_LIMITS[i], null, new InputRunnable(){

                    @Override
                    public void run(Input in) {
                        HostOrJoinGameScreen.this.costLimit = COST_LIMITS[ii];
                    }
                }, this.costLimit == COST_LIMITS[i], true);
                y += 27;
            }
            d.toggle(x, y += 9, 240, Lang._t("One_Ship_Only", new Object[0]), null, new InputRunnable(){

                @Override
                public void run(Input in) {
                    HostOrJoinGameScreen.this.oneShipOnly = !HostOrJoinGameScreen.this.oneShipOnly;
                }
            }, this.oneShipOnly, true);
            y += 36;
        }
        this.nameField.render(x, y, 240, d, sm, hs, cursor);
        d.hook(x, y, 240.0, 24.0, new Hook(new Hook.Type[]{Hook.Type.MOUSE_1_CLICKED}){

            public void run(Input in, Pt p, Hook.Type type) {
                ((HostOrJoinGameScreen)HostOrJoinGameScreen.this).nameField.focus = true;
                ((HostOrJoinGameScreen)HostOrJoinGameScreen.this).hostField.focus = false;
            }
        });
        y += 27;
        if (!this.doHost) {
            this.hostField.render(x, y, 240, d, sm, hs, cursor);
            d.hook(x, y, 240.0, 24.0, new Hook(new Hook.Type[]{Hook.Type.MOUSE_1_CLICKED}){

                public void run(Input in, Pt p, Hook.Type type) {
                    ((HostOrJoinGameScreen)HostOrJoinGameScreen.this).nameField.focus = false;
                    ((HostOrJoinGameScreen)HostOrJoinGameScreen.this).hostField.focus = true;
                }
            });
            y += 27;
        }
        d.button(x, y += 12, 240, this.doHost ? Lang._t("Host", new Object[0]) : Lang._t("Join", new Object[0]), null, new Runnable(){

            @Override
            public void run() {
                HostOrJoinGameScreen.this.hostOrJoin();
            }
        }, !this.nameField.text.isEmpty() && (this.doHost || !this.hostField.text.isEmpty()));
        d.button(x, y += 27, 240, Lang._t("Cancel", new Object[0]), new Runnable(){

            @Override
            public void run() {
                ((HostOrJoinGameScreen)HostOrJoinGameScreen.this).g.s = new MainMenu(HostOrJoinGameScreen.this.g);
            }
        });
        y += 36;
        if (this.doHost) {
            d.text(this.yourIP, AGame.FOUNT, x, y);
        }
    }

    @Override
    public ArrayList<String> music() {
        return AGame.MENU_MUSIC;
    }

    @Override
    public String appearancePostfix() {
        return TimeOfDay.DAY.name();
    }

    @Override
    public boolean alwaysUseAppearancePostfix() {
        return false;
    }
}

