/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.CoatOfArms;
import java.util.List;
import org.newdawn.slick.opengl.PNGImageData;

public interface IntegrationBackend {
    public void gotoForums(String var1, String var2);

    public void gotoCalendar(String var1, String var2);

    public String getMultiplayerServer();

    public void checkForNews(Receiver<NewsCallback> var1);

    public void sendFeedback(String var1, String var2, Receiver<FeedbackCallback> var3);

    public void register(String var1, String var2, String var3, Receiver<RegisterCallback> var4);

    public void authenticate(String var1, String var2, Receiver<AuthCallback> var3);

    public void addCode(String var1, String var2, String var3, Receiver<AddCodeCallback> var4);

    public void setArms(String var1, String var2, CoatOfArms var3, Receiver<SetArmsCallback> var4);

    public void getCharge(String var1, Receiver<GetChargeCallback> var2);

    public void checkArmsAvailable(CoatOfArms var1, Receiver<CheckArmsAvailableCallback> var2);

    public void steamGetInfo(String var1, Receiver<SteamGetInfoCallback> var2);

    public void steamSetArms(String var1, CoatOfArms var2, Receiver<SteamSetArmsCallback> var3);

    public void steamLinkUser(String var1, String var2, String var3, String var4, Receiver<SteamLinkUserCallback> var5);

    public static class SteamLinkUserCallback {
        public final boolean success;
        public final String errorMessage;

        public SteamLinkUserCallback(boolean success, String errorMessage) {
            this.success = success;
            this.errorMessage = errorMessage;
        }
    }

    public static class SteamSetArmsCallback {
        public final boolean success;
        public final String errorMessage;

        public SteamSetArmsCallback(boolean success, String errorMessage) {
            this.success = success;
            this.errorMessage = errorMessage;
        }
    }

    public static class SteamGetInfoCallback {
        public final boolean success;
        public final String errorMessage;
        public final CoatOfArms arms;
        public final String specialCharge;
        public final boolean unlinked;

        public SteamGetInfoCallback(CoatOfArms arms, String specialCharge, boolean unlinked) {
            this.success = true;
            this.arms = arms;
            this.specialCharge = specialCharge;
            this.unlinked = unlinked;
            this.errorMessage = null;
        }

        public SteamGetInfoCallback(String errorMessage) {
            this.success = false;
            this.arms = null;
            this.specialCharge = null;
            this.unlinked = true;
            this.errorMessage = errorMessage;
        }
    }

    public static class CheckArmsAvailableCallback {
        public final boolean success;
        public final String errorMessage;
        public final boolean available;

        public CheckArmsAvailableCallback(boolean available) {
            this.success = true;
            this.errorMessage = null;
            this.available = available;
        }

        public CheckArmsAvailableCallback(String errorMessage) {
            this.success = false;
            this.errorMessage = errorMessage;
            this.available = false;
        }
    }

    public static class GetChargeCallback {
        public final boolean success;
        public final String errorMessage;
        public final String chargeName;
        public final PNGImageData imgData;

        public GetChargeCallback(String chargeName, PNGImageData imgData) {
            this.success = true;
            this.errorMessage = null;
            this.chargeName = chargeName;
            this.imgData = imgData;
        }

        public GetChargeCallback(String errorMessage) {
            this.success = false;
            this.errorMessage = errorMessage;
            this.imgData = null;
            this.chargeName = null;
        }
    }

    public static class SetArmsCallback {
        public final boolean success;
        public final String errorMessage;

        public SetArmsCallback() {
            this.success = true;
            this.errorMessage = null;
        }

        public SetArmsCallback(String errorMessage) {
            this.success = false;
            this.errorMessage = errorMessage;
        }
    }

    public static class AddCodeCallback {
        public final boolean success;
        public final String errorMessage;

        public AddCodeCallback() {
            this.success = true;
            this.errorMessage = null;
        }

        public AddCodeCallback(String errorMessage) {
            this.success = false;
            this.errorMessage = errorMessage;
        }
    }

    public static class AuthCallback {
        public final boolean success;
        public final String username;
        public final String password;
        public final String errorMessage;
        public final CoatOfArms arms;
        public final String specialCharge;
        public final List<String> features;

        public AuthCallback(String errorMessage) {
            this.success = false;
            this.errorMessage = errorMessage;
            this.username = null;
            this.password = null;
            this.arms = null;
            this.specialCharge = null;
            this.features = null;
        }

        public AuthCallback(String username, String password, CoatOfArms arms, String specialCharge, List<String> features) {
            this.success = true;
            this.errorMessage = null;
            this.username = username;
            this.password = password;
            this.arms = arms;
            this.specialCharge = specialCharge;
            this.features = features;
        }
    }

    public static class RegisterCallback {
        public final boolean success;
        public final String errorMessage;
        public final String username;
        public final String password;

        public RegisterCallback(String username, String password) {
            this.success = true;
            this.errorMessage = null;
            this.username = username;
            this.password = password;
        }

        public RegisterCallback(String errorMessage) {
            this.success = false;
            this.errorMessage = errorMessage;
            this.username = null;
            this.password = null;
        }
    }

    public static class FeedbackCallback {
        public final boolean success;
        public final String errorMessage;

        public FeedbackCallback(String errorMessage) {
            this.success = false;
            this.errorMessage = errorMessage;
        }

        public FeedbackCallback() {
            this.success = true;
            this.errorMessage = null;
        }
    }

    public static class NewsCallback {
        public final boolean success;
        public final boolean hasNews;
        public final String errorMessage;
        public final String title;
        public final String text;
        public final String link;

        public NewsCallback(String errorMessage) {
            this.success = false;
            this.hasNews = false;
            this.errorMessage = errorMessage;
            this.title = null;
            this.text = null;
            this.link = null;
        }

        public NewsCallback(String title, String text, String link) {
            this.success = true;
            this.hasNews = true;
            this.errorMessage = null;
            this.title = title;
            this.text = text;
            this.link = link;
        }

        public NewsCallback() {
            this.success = true;
            this.hasNews = false;
            this.errorMessage = null;
            this.title = null;
            this.text = null;
            this.link = null;
        }
    }

    public static interface Receiver<T> {
        public void receive(T var1);
    }
}

