/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.FileScreen;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class JSONFileBackend
implements FileScreen.Backend {
    public final File dir;
    public ArrayList<FileScreen.Sorter> sorters = new ArrayList();
    public ArrayList<FileScreen.SettableFilter> filters = new ArrayList();

    public JSONFileBackend(File dir) {
        this.dir = dir;
        dir.mkdirs();
        this.sorters.add(new NameSorter());
        this.sorters.add(new DateSorter(dir));
    }

    @Override
    public ArrayList<FileScreen.Sorter> sorters() {
        return this.sorters;
    }

    @Override
    public ArrayList<FileScreen.SettableFilter> filters() {
        return this.filters;
    }

    @Override
    public List<String> list() {
        ArrayList<String> l = new ArrayList<String>();
        for (File f : this.dir.listFiles()) {
            if (!f.getName().endsWith(".json")) continue;
            String name = f.getName().substring(0, f.getName().length() - ".json".length());
            l.add(name);
        }
        Collections.sort(l);
        return l;
    }

    @Override
    public boolean isValidName(String name) {
        return name.matches("[0-9a-zA-Z -=+_!?,.&()]+");
    }

    @Override
    public void delete(String name) {
        if (!this.isValidName(name)) {
            return;
        }
        new File(this.dir, name + ".json").delete();
    }

    public static class DateSorter
    implements FileScreen.Sorter {
        public final File dir;
        Comparator<String> asc = new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                File f1 = new File(DateSorter.this.dir, o1 + ".json");
                File f2 = new File(DateSorter.this.dir, o2 + ".json");
                if (f1.exists()) {
                    if (f2.exists()) {
                        return Long.compare(f1.lastModified(), f2.lastModified());
                    }
                    return -1;
                }
                if (f2.exists()) {
                    return 1;
                }
                return 0;
            }
        };
        Comparator<String> desc = new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                File f1 = new File(DateSorter.this.dir, o1 + ".json");
                File f2 = new File(DateSorter.this.dir, o2 + ".json");
                if (f1.exists()) {
                    if (f2.exists()) {
                        return Long.compare(f2.lastModified(), f1.lastModified());
                    }
                    return -1;
                }
                if (f2.exists()) {
                    return 1;
                }
                return 0;
            }
        };

        public DateSorter(File dir) {
            this.dir = dir;
        }

        @Override
        public String getNameKey() {
            return "Date";
        }

        @Override
        public Comparator<String> ascending() {
            return this.asc;
        }

        @Override
        public Comparator<String> descending() {
            return this.desc;
        }

        @Override
        public boolean popUpdateNeeded() {
            return false;
        }
    }

    public static class NameSorter
    implements FileScreen.Sorter {
        Comparator<String> asc = new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareToIgnoreCase(o2);
            }
        };
        Comparator<String> desc = new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o2.compareToIgnoreCase(o1);
            }
        };

        @Override
        public String getNameKey() {
            return "Name";
        }

        @Override
        public Comparator<String> ascending() {
            return this.asc;
        }

        @Override
        public Comparator<String> descending() {
            return this.desc;
        }

        @Override
        public boolean popUpdateNeeded() {
            return false;
        }
    }
}

