/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.Appearance;
import com.zarkonnen.airships.Body;
import com.zarkonnen.airships.Combat;
import com.zarkonnen.airships.Foot;
import com.zarkonnen.airships.GridBody;
import com.zarkonnen.airships.JSONAble;
import com.zarkonnen.airships.LandBlockType;
import com.zarkonnen.airships.MyDraw;
import com.zarkonnen.airships.Particle;
import com.zarkonnen.airships.Perlin;
import com.zarkonnen.airships.PhysicsRect;
import com.zarkonnen.airships.Rect2D;
import com.zarkonnen.airships.Tile;
import com.zarkonnen.airships.TimeOfDay;
import com.zarkonnen.airships.WheelBody;
import com.zarkonnen.catengine.util.Clr;
import com.zarkonnen.catengine.util.Pt;
import com.zarkonnen.catengine.util.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import org.json.JSONObject;
import org.newdawn.slick.Image;

public strictfp class LandFormation
extends GridBody
implements JSONAble {
    LandBlockType[][] grid;
    boolean immobile;
    transient boolean[][] destroy;
    transient int[][] phase;
    transient boolean[][] edge;
    transient boolean ascCalced = false;
    transient int availableServiceCeiling = 0;
    transient ArrayList<Rect2D> rects = new ArrayList();
    transient int[][] chunkID;
    transient int[] heightMap;
    transient int[] opaqueHeightMap;
    transient boolean dirty = true;
    public static final int GROUND_LF_Y_OFFSET = 15;
    public static final int DISALLOWED = 0;
    public static final int ALLOWED = 1;
    public static final int REQUIRED = 2;
    static Clr[] CLRS = new Clr[]{Clr.BLUE, Clr.RED, Clr.GREEN, Clr.MAGENTA, Clr.CYAN, Clr.GREY, Clr.ORANGE};
    private static final int[][] PATCH9_SOLID = new int[][]{{1, 1, 1}, {1, 1, 1}, {1, 1, 1}};

    public LandFormation(JSONObject o) {
        this.x = o.getDouble("x");
        this.y = o.getDouble("y");
        this.immobile = o.getBoolean("immobile");
        this.grid = new LandBlockType[o.getInt("h")][o.getInt("w")];
        this.destroy = new boolean[this.grid.length][this.grid[0].length];
        this.phase = new int[this.grid.length][this.grid[0].length];
        this.edge = new boolean[this.grid.length][this.grid[0].length];
        this.chunkID = new int[this.grid.length][this.grid[0].length];
        this.heightMap = new int[this.grid[0].length];
        this.opaqueHeightMap = new int[this.grid[0].length];
        if (!o.optString("storage", "?").equals("hexString")) {
            throw new RuntimeException("Unknown data format for land formations. This file may be too new.");
        }
        String data = o.getString("data");
        int dIndex = 0;
        for (int gy = 0; gy < this.grid.length; ++gy) {
            for (int gx = 0; gx < this.grid[0].length; ++gx) {
                this.phase[gy][gx] = AGame.ANIM_R.nextInt(4);
                this.grid[gy][gx] = LandBlockType.values()[Integer.parseInt(data.substring(dIndex, dIndex + 1), 16)];
                ++dIndex;
            }
        }
        this.crop();
    }

    @Override
    public JSONObject toJSON() {
        JSONObject o = new JSONObject().put("storage", "hexString").put("h", this.grid.length).put("w", this.grid[0].length).put("x", this.x).put("y", this.y).put("immobile", this.immobile);
        StringBuilder data = new StringBuilder();
        for (int gy = 0; gy < this.grid.length; ++gy) {
            for (int gx = 0; gx < this.grid[0].length; ++gx) {
                data.append(Integer.toHexString(this.grid[gy][gx].ordinal()));
            }
        }
        o.put("data", data.toString());
        return o;
    }

    public LandFormation(double x, double y, LandBlockType[][] grid) {
        this.x = x;
        this.y = y;
        this.grid = grid;
        this.destroy = new boolean[grid.length][grid[0].length];
        this.phase = new int[grid.length][grid[0].length];
        this.edge = new boolean[grid.length][grid[0].length];
        this.chunkID = new int[grid.length][grid[0].length];
        this.heightMap = new int[grid[0].length];
        this.opaqueHeightMap = new int[grid[0].length];
        for (int gy = 0; gy < grid.length; ++gy) {
            for (int gx = 0; gx < grid[0].length; ++gx) {
                this.phase[gy][gx] = AGame.ANIM_R.nextInt(4);
            }
        }
    }

    public LandFormation(double x, double y, int w, int h) {
        this.x = x;
        this.y = y;
        this.grid = new LandBlockType[h][w];
        this.destroy = new boolean[h][w];
        this.phase = new int[h][w];
        this.edge = new boolean[h][w];
        this.chunkID = new int[h][w];
        this.heightMap = new int[this.grid[0].length];
        this.opaqueHeightMap = new int[this.grid[0].length];
        for (int gy = 0; gy < this.grid.length; ++gy) {
            for (int gx = 0; gx < this.grid[0].length; ++gx) {
                this.grid[gy][gx] = LandBlockType.AIR;
                this.phase[gy][gx] = AGame.ANIM_R.nextInt(4);
            }
        }
    }

    public int getVerticalPosition(Airship building, int tx, boolean ignoreSoftThings) {
        if (this.x > (double)tx + building.getBBWidth() || (double)tx > this.x + this.getBBWidth()) {
            return (int)building.y;
        }
        int[] hm = ignoreSoftThings ? this.opaqueHeightMap : this.heightMap;
        double targetY = this.y - building.getBBHeight() + this.getBBHeight();
        for (int shipGridX = 0; shipGridX < building.getWidth(); ++shipGridX) {
            int shipGridY;
            int sgx2 = building.flipped ? building.getWidth() - shipGridX - 1 : shipGridX;
            for (shipGridY = building.getHeight() - 1; shipGridY >= 0 && building.tileAt(sgx2, shipGridY) == null; --shipGridY) {
            }
            double leftX = tx + shipGridX * 16;
            targetY = Math.min(targetY, this.yBoundaryAt(leftX, hm) - (double)(shipGridY * 16) - 16.0);
            double rightX = tx + shipGridX * 16 + 16;
            targetY = Math.min(targetY, this.yBoundaryAt(rightX, hm) - (double)(shipGridY * 16) - 16.0);
        }
        return (int)Math.ceil(targetY) - 1;
    }

    public boolean isFullySupported(Airship building, double tx) {
        boolean levelFound = false;
        double level = 0.0;
        for (int gx = 0; gx < building.getWidth(); ++gx) {
            double opaqueLeftLevel;
            Tile t = building.tileAt(building.flipped ? building.getWidth() - gx - 1 : gx, building.getHeight() - 1);
            if (t == null) continue;
            double leftLevel = this.yBoundaryAt(tx + (double)(gx * 16), this.heightMap);
            if (Math.abs(leftLevel - (opaqueLeftLevel = this.yBoundaryAt(tx + (double)(gx * 16), this.opaqueHeightMap))) > 1.0) {
                return false;
            }
            if (!levelFound) {
                level = leftLevel;
                levelFound = true;
            } else if (Math.abs(level - leftLevel) > 0.1) {
                return false;
            }
            double rightLevel = this.yBoundaryAt(tx + (double)(gx * 16) + 16.0, this.heightMap);
            double opaqueRightLevel = this.yBoundaryAt(tx + (double)(gx * 16) + 16.0, this.opaqueHeightMap);
            if (Math.abs(rightLevel - opaqueRightLevel) > 1.0) {
                return false;
            }
            if (!(Math.abs(level - rightLevel) > 0.1)) continue;
            return false;
        }
        return true;
    }

    public static Utils.Pair<LandFormation, List<LandFormation>> generate(Random r) {
        LandFormation ground = new LandFormation(-1600.0, 272.0, 200, 26);
        ground.generateGround(r);
        ArrayList<LandFormation> floaters = new ArrayList<LandFormation>();
        int nf = r.nextInt(12);
        block0: for (int i = 0; i < nf; ++i) {
            LandFormation f = new LandFormation(-1600 + r.nextInt(2992), 0.0, 3 + r.nextInt(10), 4 + r.nextInt(6));
            f.generateFloater(r);
            f.y = 512 - f.availableServiceCeiling();
            if (Rect2D.intersects(f.x, f.y, f.getBBWidth(), f.getBBHeight(), ground.x, ground.y, ground.getBBWidth(), 10000.0)) continue;
            for (LandFormation f2 : floaters) {
                if (!Rect2D.intersects(f.x, f.y, f.getBBWidth(), f.getBBHeight(), f2.x, f2.y, f2.getBBWidth(), f2.getBBHeight())) continue;
                continue block0;
            }
            floaters.add(f);
        }
        return new Utils.Pair((Object)ground, floaters);
    }

    public void generateGround(Random r) {
        int gx;
        this.immobile = true;
        Perlin perlin = new Perlin(r);
        for (int gy = this.grid.length - 1; gy >= 10; --gy) {
            for (gx = 0; gx < this.grid[0].length; ++gx) {
                if (gy == this.grid.length - 1) {
                    this.grid[gy][gx] = LandBlockType.BEDROCK;
                } else {
                    double amt = (double)(gy - 10) * 2.5 / (double)this.grid.length + perlin.pnoise((double)gx * 0.05, (double)gy * 0.05, (double)(gx * gy) * 1.0E-5) * 1.0;
                    if (amt > 0.7) {
                        amt += perlin.pnoise((double)gy * 0.2 + 0.31, (double)gx * 0.35 + 0.22, 33.39) * 0.6;
                    }
                    this.grid[gy][gx] = amt > 2.5 ? LandBlockType.SUSPENDIUM_ORE : (amt > 1.5 ? LandBlockType.ROCK : (amt > 0.3 ? LandBlockType.SOIL : LandBlockType.AIR));
                    if (this.grid[gy + 1][gx] == LandBlockType.AIR) {
                        this.grid[gy][gx] = LandBlockType.AIR;
                    }
                    if (this.grid[gy + 1][gx] == LandBlockType.SOIL && this.grid[gy][gx] == LandBlockType.AIR) {
                        this.grid[gy + 1][gx] = LandBlockType.GRASS;
                    }
                    if (this.grid[gy][gx] == LandBlockType.SOIL && gy == 10) {
                        this.grid[gy][gx] = LandBlockType.GRASS;
                    }
                }
                this.phase[gy][gx] = AGame.ANIM_R.nextInt(4);
            }
        }
        if (r.nextInt(4) != 0) {
            int treeD = 6 + r.nextInt(4);
            for (gx = 5; gx < this.grid[0].length - 5; ++gx) {
                int gy2;
                if (r.nextInt(20) != 0) continue;
                int gy = 0;
                while (!this.grid[gy + 1][gx].solid) {
                    ++gy;
                }
                int h = 3 + r.nextInt(4);
                int w = 2 + r.nextInt(2);
                for (gy2 = gy - h - w; gy2 < gy - h + w; ++gy2) {
                    for (int gx2 = gx - w; gx2 <= gx + w; ++gx2) {
                        double d = (double)((gy2 - (gy - h)) * (gy2 - (gy - h)) + (gx2 - gx) * (gx2 - gx)) + perlin.pnoise((double)gy2 * 0.2 + 0.31, (double)Math.abs(gx2 - gx) * 0.35 + 0.22, 33.39) * 8.0;
                        if (!(d < (double)(w * w)) && Math.abs(gx2 - gx) >= 2) continue;
                        this.grid[gy2][gx2] = d < (double)(w * w / 4) ? LandBlockType.BRANCH : LandBlockType.LEAF;
                        this.phase[gy2][gx2] = AGame.ANIM_R.nextInt(4);
                    }
                }
                for (gy2 = gy - h; gy2 <= gy; ++gy2) {
                    this.grid[gy2][gx] = gy2 < gy - (h - w) ? LandBlockType.TRUNKBRANCH : LandBlockType.TRUNK;
                    this.phase[gy2][gx] = AGame.ANIM_R.nextInt(4);
                }
                gx += treeD;
            }
        }
        if (r.nextInt(4) != 0) {
            int freq = 5 + r.nextInt(20);
            for (gx = 0; gx < this.grid[0].length; ++gx) {
                if (r.nextInt(freq) != 0) continue;
                int gy = 0;
                while (!this.grid[gy + 1][gx].solid) {
                    ++gy;
                }
                if (this.grid[gy + 1][gx] != LandBlockType.GRASS) continue;
                this.grid[gy][gx] = LandBlockType.BUSH;
                this.phase[gy][gx] = AGame.ANIM_R.nextInt(4);
            }
        }
        this.crop();
    }

    public void generateFloater(Random r) {
        int gy;
        int start;
        for (int gy2 = 0; gy2 < this.grid.length; ++gy2) {
            for (int gx = 0; gx < this.grid[0].length; ++gx) {
                this.phase[gy2][gx] = AGame.ANIM_R.nextInt(4);
            }
        }
        for (int gx = 0; gx < this.grid[0].length; ++gx) {
            this.grid[this.grid.length - 1][gx] = r.nextBoolean() ? LandBlockType.SUSPENDIUM_ORE : LandBlockType.AIR;
        }
        for (int gy3 = start = this.grid.length / 2 - 1 + r.nextInt(4); gy3 < this.grid.length - 1; ++gy3) {
            for (int gx = 0; gx < this.grid[0].length; ++gx) {
                LandBlockType landBlockType = this.grid[gy3][gx] = r.nextInt(3) == 0 ? LandBlockType.ROCK : LandBlockType.SUSPENDIUM_ORE;
                if (gy3 == this.grid.length - 2 || gx != 0 && gx != this.grid[0].length || !r.nextBoolean()) continue;
                this.grid[gy3][gx] = LandBlockType.AIR;
            }
        }
        LandBlockType[] layers = new LandBlockType[]{LandBlockType.ROCK, r.nextBoolean() ? LandBlockType.ROCK : LandBlockType.SOIL, LandBlockType.SOIL, LandBlockType.GRASS};
        for (int layerIndex = 0; layerIndex < layers.length; ++layerIndex) {
            LandBlockType rainType = layers[layerIndex];
            for (int gx = 0; gx < this.grid[0].length; ++gx) {
                if (r.nextInt(5) == 0) continue;
                for (gy = 0; gy < this.grid.length && this.grid[gy][gx] == LandBlockType.AIR; ++gy) {
                }
                if (gy >= this.grid.length || gy <= 0 || this.grid[gy][gx] == LandBlockType.GRASS) continue;
                this.grid[gy - 1][gx] = rainType;
            }
        }
        try {
            int h = this.grid.length;
            int w = this.grid[0].length;
            this.crop();
            if (this.grid.length == 0 || this.grid[0].length == 0) {
                this.grid = new LandBlockType[h][w];
                this.destroy = new boolean[h][w];
                this.phase = new int[h][w];
                this.edge = new boolean[h][w];
                this.chunkID = new int[h][w];
                for (gy = 0; gy < this.grid.length; ++gy) {
                    for (int gx = 0; gx < this.grid[0].length; ++gx) {
                        this.grid[gy][gx] = LandBlockType.AIR;
                        this.phase[gy][gx] = AGame.ANIM_R.nextInt(4);
                    }
                }
                this.generateFloater(r);
            }
        }
        catch (NegativeArraySizeException e) {
            this.generateFloater(r);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.generateFloater(r);
        }
    }

    public void crop() {
        int gy;
        int gx;
        this.ascCalced = false;
        block0: for (gx = 0; gx < this.grid[0].length; ++gx) {
            for (int gy2 = 0; gy2 < this.grid.length; ++gy2) {
                if (this.grid[gy2][gx] != LandBlockType.AIR) break block0;
            }
        }
        int cropLeftAmt = gx;
        block2: for (gx = this.grid[0].length - 1; gx >= 0; --gx) {
            for (int gy3 = 0; gy3 < this.grid.length; ++gy3) {
                if (this.grid[gy3][gx] != LandBlockType.AIR) break block2;
            }
        }
        int cropRightAmt = this.grid[0].length - 1 - gx;
        block4: for (gy = 0; gy < this.grid.length; ++gy) {
            for (gx = 0; gx < this.grid[0].length; ++gx) {
                if (this.grid[gy][gx] != LandBlockType.AIR) break block4;
            }
        }
        int cropTopAmt = gy;
        block6: for (gy = this.grid.length - 1; gy >= 0; --gy) {
            for (gx = 0; gx < this.grid[0].length; ++gx) {
                if (this.grid[gy][gx] != LandBlockType.AIR) break block6;
            }
        }
        int cropBottomAmt = this.grid.length - 1 - gy;
        this.y += (double)(cropTopAmt * 16);
        if (this.grid.length - cropTopAmt - cropBottomAmt <= 0 || this.grid[0].length - cropLeftAmt - cropRightAmt <= 0) {
            this.grid = new LandBlockType[0][0];
            this.destroy = new boolean[0][0];
            this.phase = new int[0][0];
            this.edge = new boolean[0][0];
            this.chunkID = new int[0][0];
            this.removeUnstuckParticles();
            return;
        }
        if (cropTopAmt > 0 || cropBottomAmt > 0) {
            LandBlockType[][] grid2 = new LandBlockType[this.grid.length - cropTopAmt - cropBottomAmt][0];
            System.arraycopy(this.grid, cropTopAmt, grid2, 0, grid2.length);
            boolean[][] destroy2 = new boolean[this.grid.length - cropTopAmt - cropBottomAmt][0];
            System.arraycopy(this.destroy, cropTopAmt, destroy2, 0, destroy2.length);
            int[][] phase2 = new int[this.grid.length - cropTopAmt - cropBottomAmt][0];
            System.arraycopy(this.phase, cropTopAmt, phase2, 0, phase2.length);
            boolean[][] edge2 = new boolean[this.grid.length - cropTopAmt - cropBottomAmt][0];
            System.arraycopy(this.edge, cropTopAmt, edge2, 0, edge2.length);
            this.grid = grid2;
            this.destroy = destroy2;
            this.phase = phase2;
            this.edge = edge2;
        }
        this.x += (double)(cropLeftAmt * 16);
        if (cropLeftAmt > 0 || cropRightAmt > 0) {
            for (gy = 0; gy < this.grid.length; ++gy) {
                LandBlockType[] row2 = new LandBlockType[this.grid[gy].length - cropLeftAmt - cropRightAmt];
                System.arraycopy(this.grid[gy], cropLeftAmt, row2, 0, row2.length);
                this.grid[gy] = row2;
                boolean[] dRow2 = new boolean[this.destroy[gy].length - cropLeftAmt - cropRightAmt];
                System.arraycopy(this.destroy[gy], cropLeftAmt, dRow2, 0, dRow2.length);
                this.destroy[gy] = dRow2;
                int[] pRow2 = new int[this.phase[gy].length - cropLeftAmt - cropRightAmt];
                System.arraycopy(this.phase[gy], cropLeftAmt, pRow2, 0, pRow2.length);
                this.phase[gy] = pRow2;
                boolean[] eRow2 = new boolean[this.edge[gy].length - cropLeftAmt - cropRightAmt];
                System.arraycopy(this.edge[gy], cropLeftAmt, eRow2, 0, eRow2.length);
                this.edge[gy] = eRow2;
            }
        }
        for (gy = 0; gy < this.grid.length; ++gy) {
            block10: for (gx = 0; gx < this.grid[0].length; ++gx) {
                if (gy == 0 || gy == this.grid.length - 1 || gx == 0 || gx == this.grid[0].length - 1) {
                    this.edge[gy][gx] = true;
                    continue;
                }
                this.edge[gy][gx] = false;
                for (int dy = -1; dy < 2; ++dy) {
                    for (int dx = -1; dx < 2; ++dx) {
                        if (this.grid[gy + dy][gx + dx].opaque) continue;
                        this.edge[gy][gx] = true;
                        continue block10;
                    }
                }
            }
        }
        if (this.immobile && this.grid.length > 1) {
            for (gx = 0; gx < this.grid[0].length; ++gx) {
                this.edge[this.grid.length - 1][gx] = this.grid[this.grid.length - 2][gx] == LandBlockType.AIR;
            }
            for (gy = 1; gy < this.grid.length; ++gy) {
                this.edge[gy][0] = this.grid[gy - 1][0] == LandBlockType.AIR;
                this.edge[gy][this.grid[0].length - 1] = this.grid[gy - 1][this.grid[0].length - 1] == LandBlockType.AIR;
            }
        }
        int[][] coverage = new int[this.grid.length][this.grid[0].length];
        for (gy = 0; gy < this.grid.length; ++gy) {
            for (gx = 0; gx < this.grid[0].length; ++gx) {
                if (this.grid[gy][gx] == LandBlockType.AIR) continue;
                coverage[gy][gx] = this.edge[gy][gx] ? 1 : 2;
            }
        }
        if (this.grid[0].length != this.heightMap.length) {
            this.heightMap = new int[this.grid[0].length];
            this.opaqueHeightMap = new int[this.grid[0].length];
        }
        for (gx = 0; gx < this.heightMap.length; ++gx) {
            for (gy = 0; gy < this.grid.length && !this.grid[gy][gx].solid; ++gy) {
            }
            this.heightMap[gx] = gy;
            for (gy = 0; gy < this.grid.length && !this.grid[gy][gx].opaque; ++gy) {
            }
            this.opaqueHeightMap[gx] = gy;
        }
        for (Particle p : this.stuckParticles) {
            p.x -= (double)(cropLeftAmt * 16);
            p.y -= (double)(cropTopAmt * 16);
        }
        this.removeUnstuckParticles();
        this.chunkID = new int[this.grid.length][this.grid[0].length];
        this.rects.clear();
        int searchGy = 0;
        while (true) {
            int left = 0;
            int top = 0;
            boolean found = false;
            block22: while (searchGy < coverage.length) {
                for (gx = 0; gx < coverage[0].length; ++gx) {
                    if (coverage[searchGy][gx] != 2) continue;
                    left = gx;
                    top = searchGy;
                    found = true;
                    break block22;
                }
                ++searchGy;
            }
            if (!found) {
                return;
            }
            int w = 1;
            int h = 1;
            coverage[top][left] = 1;
            while (left + w < coverage[0].length && coverage[top][left + w] == 2) {
                coverage[top][left + w] = 1;
                ++w;
            }
            block25: while (top + h < coverage.length) {
                int xx;
                boolean req = false;
                for (xx = 0; xx < w; ++xx) {
                    if (coverage[top + h][left + xx] == 0) break block25;
                    if (coverage[top + h][left + xx] != 2) continue;
                    req = true;
                }
                if (!req) break;
                for (xx = 0; xx < w; ++xx) {
                    coverage[top + h][left + xx] = 1;
                }
                ++h;
            }
            this.rects.add(new Rect2D(left, top, w, h));
        }
    }

    public void drawSoil(MyDraw d, double cropX, double cropY, double cropW, double cropH, Image[] light, float lightStrength, float ambient, Clr soilTint) {
        int rsz = this.rects.size();
        for (int i = 0; i < rsz; ++i) {
            Rect2D r = this.rects.get(i);
            if (!Rect2D.intersects(cropX, cropY, cropW, cropH, this.x + r.x * 16.0, this.y + r.y * 16.0, r.w * 16.0, r.h * 16.0)) continue;
            d.rect(soilTint, this.x + r.x * 16.0, this.y + r.y * 16.0, r.w * 16.0, r.h * 16.0);
        }
    }

    public void drawNonSoil(MyDraw d, double cropX, double cropY, double cropW, double cropH, Image[] light, float lightStrength, float ambient, Clr soilTint, boolean snow) {
        for (int gy = 0; gy < this.grid.length; ++gy) {
            for (int gx = 0; gx < this.grid[0].length; ++gx) {
                LandBlockType lbt = this.grid[gy][gx];
                if (lbt.app == null || !this.edge[gy][gx]) continue;
                Appearance app = snow && (gy == 0 || !this.grid[gy - 1][gx].opaque) && lbt.topSnowApp != null ? lbt.topSnowApp : (snow && lbt.snowApp != null ? lbt.snowApp : lbt.app);
                app.drawBevelled(d, this.x + (double)(gx * 16), this.y + (double)((gy + 1 - lbt.app.height()) * 16), lbt.app.width() * 16, lbt.app.height() * 16, this.phase[gy][gx] * 300, null, false, light, lightStrength, ambient, gy == 0 || !this.grid[gy - 1][gx].solid ? 1 : 0, gy == this.grid.length - 1 || !this.grid[gy + 1][gx].solid ? 1 : 0, gx == 0 || !this.grid[gy][gx - 1].solid ? 1 : 0, gx == this.grid[0].length - 1 || !this.grid[gy][gx + 1].solid ? 1 : 0, PATCH9_SOLID, null);
            }
        }
    }

    public boolean tick(int ms, Combat c) {
        boolean doCrop = false;
        HashMap<String, Pt> destroySounds = new HashMap<String, Pt>();
        for (int gy = 0; gy < this.grid.length; ++gy) {
            for (int gx = 0; gx < this.grid[0].length; ++gx) {
                if (!this.destroy[gy][gx]) continue;
                String ds = this.grid[gy][gx].destroySound;
                if (ds != null) {
                    double sx = this.x + (double)(gx * 16);
                    double sy = this.y + (double)(gy * 16);
                    if (destroySounds.containsKey(ds)) {
                        Pt p = (Pt)destroySounds.get(ds);
                        destroySounds.put(ds, new Pt(p.x / 2.0 + sx / 2.0, p.y / 2.0 + sy / 2.0));
                    } else {
                        destroySounds.put(ds, new Pt(sx, sy));
                    }
                }
                this.grid[gy][gx] = LandBlockType.AIR;
                this.destroy[gy][gx] = false;
                doCrop = true;
                this.dirty = true;
            }
        }
        for (String sound : destroySounds.keySet()) {
            String soundName = sound + AGame.ANIM_R.nextInt(LandBlockType.numSounds.get(sound));
            Pt p = (Pt)destroySounds.get(sound);
            c.play(soundName, (int)p.x, (int)p.y, 1.0);
        }
        if (doCrop) {
            this.crop();
        } else if (this.dirty) {
            this.removeUnstuckParticles();
        }
        if (!this.immobile) {
            this.yForce = -this.availableSuspendiumForce();
        }
        return this.removeMe();
    }

    public int availableLift() {
        int lift = 0;
        for (int gy = 0; gy < this.grid.length; ++gy) {
            for (int gx = 0; gx < this.grid[0].length; ++gx) {
                lift += this.grid[gy][gx].liftGenerated;
            }
        }
        return lift;
    }

    public double availableSuspendiumForce() {
        double distanceFromFloor = 512.0 - this.y;
        return (double)(this.availableLift() * 300 * 2) / (300.0 + distanceFromFloor) * 0.001;
    }

    public int availableServiceCeiling() {
        if (this.immobile) {
            return 0;
        }
        if (this.ascCalced) {
            return this.availableServiceCeiling;
        }
        int mass = this.getMass();
        this.availableServiceCeiling = mass == 0 ? 0 : this.availableLift() * 300 * 2 / this.getMass() - 300;
        this.ascCalced = true;
        return this.availableServiceCeiling;
    }

    @Override
    public boolean canParticleStick(double px, double py) {
        if (this.grid.length == 0) {
            return false;
        }
        if (!Rect2D.contains(this.x, this.y, this.getBBWidth(), this.getBBHeight(), px, py)) {
            return false;
        }
        int gx = (int)Math.floor((px - this.x) / 16.0);
        int gy = (int)Math.floor((py - this.y) / 16.0);
        return this.grid[gy][gx].solid;
    }

    @Override
    public int getGridWidth() {
        return this.grid[0].length;
    }

    @Override
    public int getGridHeight() {
        return this.grid.length;
    }

    @Override
    public boolean solidAt(int x, int y) {
        return y >= 0 && x >= 0 && y < this.grid.length && x < this.grid[0].length && this.grid[y][x].opaque;
    }

    @Override
    public boolean enterableAt(int x, int y) {
        return false;
    }

    @Override
    public double yBoundaryAt(double probeX) {
        int gx = (int)Math.floor((probeX - this.x) / 16.0);
        gx = Math.max(0, Math.min(this.opaqueHeightMap.length - 1, gx));
        return this.y + (double)(this.opaqueHeightMap[gx] * 16);
    }

    private double yBoundaryAt(double probeX, int[] hm) {
        int gx = (int)Math.floor((probeX - this.x) / 16.0);
        gx = Math.max(0, Math.min(hm.length - 1, gx));
        return this.y + (double)(hm[gx] * 16);
    }

    @Override
    public int firstSolidBlockYAt(int gx) {
        if (gx < 0 || gx >= this.opaqueHeightMap.length) {
            return -1;
        }
        return this.opaqueHeightMap[gx];
    }

    @Override
    public boolean isAtSpeed() {
        return false;
    }

    public ArrayList<LandFormation> splitIntoChunksIfNeeded() {
        if (!this.dirty) {
            return null;
        }
        this.dirty = false;
        int chunkCount = this.countChunks();
        if (chunkCount < 2) {
            return null;
        }
        ArrayList<LandFormation> newLandForms = new ArrayList<LandFormation>();
        for (int chunkNum = 2; chunkNum <= chunkCount; ++chunkNum) {
            LandFormation lf2 = new LandFormation(this.x, this.y, this.grid[0].length, this.grid.length);
            for (int gy = 0; gy < this.grid.length; ++gy) {
                for (int gx = 0; gx < this.grid[0].length; ++gx) {
                    if (this.chunkID[gy][gx] != chunkNum) continue;
                    lf2.grid[gy][gx] = this.grid[gy][gx];
                    lf2.phase[gy][gx] = this.phase[gy][gx];
                    this.grid[gy][gx] = LandBlockType.AIR;
                }
            }
            for (Particle p : this.stuckParticles) {
                Particle p2 = new Particle(p.type, p.x - this.x + lf2.x, p.y - this.y + lf2.y, p.dx, p.dy);
                p2.life = p.life;
                p2.lifespan = p.lifespan;
                lf2.stuckParticles.add(p2);
            }
            lf2.crop();
            newLandForms.add(lf2);
        }
        this.crop();
        return newLandForms;
    }

    public int countChunks() {
        int currentChunkID = 0;
        for (int y = 0; y < this.chunkID.length; ++y) {
            Arrays.fill(this.chunkID[y], 0);
        }
        LinkedList<XY> stack = new LinkedList<XY>();
        for (int allTypes = 0; allTypes <= 1; ++allTypes) {
            boolean bedrockOnly = allTypes == 0;
            for (int startY = 0; startY < this.chunkID.length; ++startY) {
                for (int startX = 0; startX < this.chunkID[0].length; ++startX) {
                    if (!(bedrockOnly ? this.grid[startY][startX] == LandBlockType.BEDROCK : this.grid[startY][startX].solid) || this.chunkID[startY][startX] >= 1) continue;
                    currentChunkID = bedrockOnly ? 1 : ++currentChunkID;
                    stack.push(new XY(startX, startY));
                    while (!stack.isEmpty()) {
                        XY xy = (XY)stack.poll();
                        if (xy.y >= this.chunkID.length) {
                            System.out.println(xy.y + " y " + this.chunkID.length);
                        }
                        if (xy.x >= this.chunkID[0].length) {
                            System.out.println(xy.x + " x " + this.chunkID[0].length);
                        }
                        this.chunkID[xy.y][xy.x] = currentChunkID;
                        if (xy.y > 0 && this.chunkID[xy.y - 1][xy.x] == 0 && this.grid[xy.y - 1][xy.x].solid) {
                            stack.push(new XY(xy.x, xy.y - 1));
                            this.chunkID[xy.y - 1][xy.x] = -1;
                        }
                        if (xy.y < this.chunkID.length - 1 && this.chunkID[xy.y + 1][xy.x] == 0 && this.grid[xy.y + 1][xy.x].solid) {
                            stack.push(new XY(xy.x, xy.y + 1));
                            this.chunkID[xy.y + 1][xy.x] = -1;
                        }
                        if (xy.x > 0 && this.chunkID[xy.y][xy.x - 1] == 0 && this.grid[xy.y][xy.x - 1].solid) {
                            stack.push(new XY(xy.x - 1, xy.y));
                            this.chunkID[xy.y][xy.x - 1] = -1;
                        }
                        if (xy.x >= this.chunkID[0].length - 1 || this.chunkID[xy.y][xy.x + 1] != 0 || !this.grid[xy.y][xy.x + 1].solid) continue;
                        stack.push(new XY(xy.x + 1, xy.y));
                        this.chunkID[xy.y][xy.x + 1] = -1;
                    }
                }
            }
        }
        return currentChunkID;
    }

    @Override
    public int getCollisionMass() {
        return Math.min(500, this.getMass() / 5);
    }

    @Override
    public int getMass() {
        int m = 0;
        for (int gy = 0; gy < this.grid.length; ++gy) {
            for (int gx = 0; gx < this.grid[0].length; ++gx) {
                m += this.grid[gy][gx].weight;
            }
        }
        return m;
    }

    @Override
    public boolean isImmobile() {
        return this.immobile;
    }

    @Override
    public boolean removeMe() {
        for (int gy = 0; gy < this.grid.length; ++gy) {
            for (int gx = 0; gx < this.grid[0].length; ++gx) {
                if (this.grid[gy][gx] == LandBlockType.AIR) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public double elasticity() {
        return 0.0;
    }

    @Override
    public double horizontalAirFriction() {
        return 0.005 + (double)this.grid.length * 1.0 / (double)this.grid[0].length * 0.01;
    }

    @Override
    public double verticalAirFriction() {
        return 0.001 + (double)this.grid[0].length * 1.0 / (double)this.grid.length * 0.002;
    }

    @Override
    public double getBBWidth() {
        return this.grid.length == 0 ? 0.0 : (double)(16 * this.grid[0].length);
    }

    @Override
    public double getBBHeight() {
        return 16 * this.grid.length;
    }

    @Override
    public boolean collidesWith(PhysicsRect b2) {
        if (b2 instanceof Foot && !((Foot)b2).isDown) {
            return false;
        }
        if (b2 instanceof WheelBody) {
            return this.overlapsWith((WheelBody)b2);
        }
        if (b2 instanceof Airship) {
            return ((Airship)b2).collidesWith(this);
        }
        if (b2 instanceof LandFormation) {
            return this.overlapsWith((LandFormation)b2);
        }
        return this.collidesWithPR(b2);
    }

    private boolean overlapsWith(WheelBody lf2) {
        for (int gy = 0; gy < this.grid.length; ++gy) {
            for (int gx = 0; gx < this.grid[0].length; ++gx) {
                double ty;
                double tx;
                if (!this.grid[gy][gx].solid || !lf2.intersectsWithRect(tx = this.x + (double)(gx * 16), ty = this.y + (double)(gy * 16), 16.0, 16.0)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean overlapsWith(LandFormation lf2) {
        double lf2x = lf2.x;
        double lf2y = lf2.y;
        int lf2gw = lf2.grid[0].length;
        int lf2gh = lf2.grid.length;
        for (int gy = 0; gy < this.grid.length; ++gy) {
            for (int gx = 0; gx < this.grid[0].length; ++gx) {
                if (!this.grid[gy][gx].solid) continue;
                double tx = this.x + (double)(gx * 16);
                double ty = this.y + (double)(gy * 16);
                int lfgx = (int)Math.floor((tx - lf2x) / 16.0);
                int lfgy = (int)Math.floor((ty - lf2y) / 16.0);
                if (lfgy >= 0 && lfgy < lf2gh && lfgx >= 0 && lfgx < lf2gw && lf2.grid[lfgy][lfgx].solid) {
                    return true;
                }
                if (lfgy + 1 >= 0 && lfgy + 1 < lf2gh && lfgx + 1 >= 0 && lfgx + 1 < lf2gw && lf2.grid[lfgy + 1][lfgx + 1].solid) {
                    return true;
                }
                if (lfgy + 1 >= 0 && lfgy + 1 < lf2gh && lfgx >= 0 && lfgx < lf2gw && lf2.grid[lfgy + 1][lfgx].solid) {
                    return true;
                }
                if (lfgy < 0 || lfgy >= lf2gh || lfgx + 1 < 0 || lfgx + 1 >= lf2gw || !lf2.grid[lfgy][lfgx + 1].solid) continue;
                return true;
            }
        }
        return false;
    }

    private ArrayList<int[]> overlaps(WheelBody lf2) {
        ArrayList<int[]> l = new ArrayList<int[]>();
        for (int gy = 0; gy < this.grid.length; ++gy) {
            for (int gx = 0; gx < this.grid[0].length; ++gx) {
                double ty;
                double tx;
                if (!this.grid[gy][gx].solid || !lf2.intersectsWithRect(tx = this.x + (double)(gx * 16), ty = this.y + (double)(gy * 16), 16.0, 16.0)) continue;
                l.add(new int[]{gx, gy});
            }
        }
        return l;
    }

    private ArrayList<int[]> overlaps(LandFormation lf2) {
        ArrayList<int[]> l = new ArrayList<int[]>();
        double lf2x = lf2.x;
        double lf2y = lf2.y;
        int lf2gw = lf2.grid[0].length;
        int lf2gh = lf2.grid.length;
        for (int gy = 0; gy < this.grid.length; ++gy) {
            for (int gx = 0; gx < this.grid[0].length; ++gx) {
                if (!this.grid[gy][gx].solid) continue;
                double tx = this.x + (double)(gx * 16);
                double ty = this.y + (double)(gy * 16);
                int lfgx = (int)Math.floor((tx - lf2x) / 16.0);
                int lfgy = (int)Math.floor((ty - lf2y) / 16.0);
                if (!(lfgy >= 0 && lfgy < lf2gh && lfgx >= 0 && lfgx < lf2gw && lf2.grid[lfgy][lfgx].solid || lfgy + 1 >= 0 && lfgy + 1 < lf2gh && lfgx + 1 >= 0 && lfgx + 1 < lf2gw && lf2.grid[lfgy + 1][lfgx + 1].solid || lfgy + 1 >= 0 && lfgy + 1 < lf2gh && lfgx >= 0 && lfgx < lf2gw && lf2.grid[lfgy + 1][lfgx].solid) && (lfgy < 0 || lfgy >= lf2gh || lfgx + 1 < 0 || lfgx + 1 >= lf2gw || !lf2.grid[lfgy][lfgx + 1].solid)) continue;
                l.add(new int[]{gx, gy});
            }
        }
        return l;
    }

    private ArrayList<int[]> overlaps(Airship b) {
        ArrayList<int[]> l = new ArrayList<int[]>();
        int bTileW = b.getWidth();
        double bx = b.x;
        double by = b.y;
        for (int gy = 0; gy < this.grid.length; ++gy) {
            for (int gx = 0; gx < this.grid[0].length; ++gx) {
                double ty;
                int bty;
                if (!this.grid[gy][gx].solid) continue;
                double tx = this.x + (double)(gx * 16);
                int btx = b.flipped ? bTileW - (int)Math.floor((tx - bx) / 16.0) - 1 : (int)Math.floor((tx - bx) / 16.0);
                if (b.tileAt(btx, bty = (int)Math.floor(((ty = this.y + (double)(gy * 16)) - by) / 16.0)) == null && b.tileAt(btx + 1, bty + 1) == null && b.tileAt(btx + 1, bty) == null && b.tileAt(btx, bty + 1) == null) continue;
                l.add(new int[]{gx, gy});
            }
        }
        return l;
    }

    private ArrayList<int[]> overlaps(Body b2) {
        ArrayList<int[]> l = new ArrayList<int[]>();
        double b2W = b2.getBBWidth();
        double b2H = b2.getBBHeight();
        for (int gy = 0; gy < this.grid.length; ++gy) {
            for (int gx = 0; gx < this.grid[0].length; ++gx) {
                double gty;
                double gtx;
                if (!this.grid[gy][gx].solid || !Rect2D.intersects(gtx = this.x + (double)(gx * 16), gty = this.y + (double)(gy * 16), 16.0, 16.0, b2.x, b2.y, b2W, b2H)) continue;
                l.add(new int[]{gx, gy});
            }
        }
        return l;
    }

    private boolean collidesWithPR(PhysicsRect b2) {
        double b2W = b2.getBBWidth();
        double b2H = b2.getBBHeight();
        for (int gy = 0; gy < this.grid.length; ++gy) {
            for (int gx = 0; gx < this.grid[0].length; ++gx) {
                double gty;
                double gtx;
                if (!this.grid[gy][gx].solid || !Rect2D.intersects(gtx = this.x + (double)(gx * 16), gty = this.y + (double)(gy * 16), 16.0, 16.0, b2.x, b2.y, b2W, b2H)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void doCollision(Body b2, double hitEnergy, Combat combat, boolean atSpeed) {
        ArrayList<int[]> overlaps = b2 instanceof WheelBody ? this.overlaps((WheelBody)b2) : (b2 instanceof LandFormation ? this.overlaps((LandFormation)b2) : (b2 instanceof Airship ? this.overlaps((Airship)b2) : this.overlaps(b2)));
        this.collideWith(overlaps, hitEnergy, combat, atSpeed);
    }

    private void collideWith(ArrayList<int[]> overlaps, double hitEnergy, Combat combat, boolean atSpeed) {
        if (overlaps.isEmpty()) {
            return;
        }
        int dmg = (int)Math.floor(hitEnergy * 0.8 / (double)overlaps.size() + 0.99);
        if (dmg > 0) {
            boolean snow = combat.timeOfDay == TimeOfDay.SNOW;
            int osz = overlaps.size();
            for (int oi = 0; oi < osz; ++oi) {
                int gx = overlaps.get(oi)[0];
                int gy = overlaps.get(oi)[1];
                LandBlockType lbt = this.grid[gy][gx];
                if (!(!atSpeed || !(hitEnergy / (double)overlaps.size() > 1.0) || lbt != LandBlockType.GRASS && lbt != LandBlockType.SOIL || gy != 0 && this.grid[gy - 1][gx].solid)) {
                    Particle.Type t = combat.timeOfDay.effect.groundImpactParticle;
                    for (int n = 0; n < combat.timeOfDay.effect.numGroundImpactParticles; ++n) {
                        combat.particles.add(new Particle(t, this.x + (double)(gx * 16) + AGame.ANIM_R.nextDouble() * 16.0, this.y + (double)(gy * 16) - AGame.ANIM_R.nextDouble() * (double)t.startSize, t.minDx + AGame.ANIM_R.nextDouble() * (t.maxDx - t.minDx), t.minDy + AGame.ANIM_R.nextDouble() * (t.maxDy - t.minDy)));
                    }
                }
                if (lbt.hp <= 0 || !lbt.solid || lbt.hp > dmg || this.destroy[gy][gx]) continue;
                this.destroy[gy][gx] = true;
                for (int i = 0; i < 7; ++i) {
                    combat.particles.add(new Particle(snow ? Particle.Type.GROUND_SNOW : this.grid[gy][gx].destroyparticle, this.x + (double)(gx * 16) + 8.0, this.y + (double)(gy * 16) + 8.0));
                }
            }
        }
    }

    private strictfp static final class XY {
        public final int x;
        public final int y;

        public XY(int x, int y) {
            this.x = x;
            this.y = y;
        }
    }
}

