/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.Appearance;
import com.zarkonnen.airships.LandFormation;
import com.zarkonnen.airships.MyDraw;
import com.zarkonnen.airships.Rect2D;
import com.zarkonnen.airships.TimeOfDay;
import com.zarkonnen.airships.UniScreen;
import com.zarkonnen.catengine.Hook;
import com.zarkonnen.catengine.Input;
import com.zarkonnen.catengine.util.Clr;
import com.zarkonnen.catengine.util.Pt;

public class LandFormationVisualLayer
implements UniScreen.VisualLayer {
    @Override
    public void tick(Input in, int ms, UniScreen us) {
    }

    @Override
    public void draw(MyDraw d, final UniScreen us, double cropX, double cropY, double cropW, double cropH) {
        TimeOfDay tod = us.getTimeOfDay();
        boolean snow = tod == TimeOfDay.SNOW;
        Clr soilTint = tod.deepSoilTint;
        if (us.combat != null) {
            for (final LandFormation lf : us.combat.landFormations) {
                if (!Rect2D.intersects(cropX, cropY, cropW, cropH, lf.x, lf.y, lf.getBBWidth(), lf.getBBHeight())) continue;
                lf.drawSoil(d, cropX, cropY, cropW, cropH, us.lightingMap, tod.lightStrength, tod.ambient, soilTint);
                d.hook(us.worldToScreenX(lf.x), us.worldToScreenY(lf.y - 16.0), lf.getBBWidth() * us.zoom, (lf.getBBHeight() + 16.0) * us.zoom, new Hook(new Hook.Type[]{Hook.Type.MOUSE_1_CLICKED}){

                    public void run(Input in, Pt p, Hook.Type type) {
                        if (us.tool == UniScreen.NAVIGATE) {
                            us.selectedShip = null;
                            us.selectedLF = lf;
                        }
                    }
                });
            }
            Appearance.lockBevelledShader(d, us.lightingMap, tod.lightStrength, tod.ambient);
            for (final LandFormation lf : us.combat.landFormations) {
                if (!Rect2D.intersects(cropX, cropY, cropW, cropH, lf.x, lf.y, lf.getBBWidth(), lf.getBBHeight())) continue;
                lf.drawNonSoil(d, cropX, cropY, cropW, cropH, us.lightingMap, tod.lightStrength, tod.ambient, soilTint, snow);
            }
            Appearance.unlockBevelledShader(us.lightingMap != null);
        } else if (us.city != null) {
            if (Rect2D.intersects(cropX, cropY, cropW, cropH, us.city.ground.x, us.city.ground.y, us.city.ground.getBBWidth(), us.city.ground.getBBHeight())) {
                us.city.ground.drawSoil(d, cropX, cropY, cropW, cropH, us.lightingMap, tod.lightStrength, tod.ambient, soilTint);
            }
            for (LandFormation lf : us.city.floaters) {
                if (!Rect2D.intersects(cropX, cropY, cropW, cropH, lf.x, lf.y, lf.getBBWidth(), lf.getBBHeight())) continue;
                lf.drawSoil(d, cropX, cropY, cropW, cropH, us.lightingMap, tod.lightStrength, tod.ambient, soilTint);
            }
            Appearance.lockBevelledShader(d, us.lightingMap, tod.lightStrength, tod.ambient);
            if (Rect2D.intersects(cropX, cropY, cropW, cropH, us.city.ground.x, us.city.ground.y, us.city.ground.getBBWidth(), us.city.ground.getBBHeight())) {
                us.city.ground.drawNonSoil(d, cropX, cropY, cropW, cropH, us.lightingMap, tod.lightStrength, tod.ambient, soilTint, snow);
            }
            for (LandFormation lf : us.city.floaters) {
                if (!Rect2D.intersects(cropX, cropY, cropW, cropH, lf.x, lf.y, lf.getBBWidth(), lf.getBBHeight())) continue;
                lf.drawNonSoil(d, cropX, cropY, cropW, cropH, us.lightingMap, tod.lightStrength, tod.ambient, soilTint, snow);
            }
            Appearance.unlockBevelledShader(us.lightingMap != null);
        } else if (us.setupGround != null) {
            if (Rect2D.intersects(cropX, cropY, cropW, cropH, us.setupGround.x, us.setupGround.y, us.setupGround.getBBWidth(), us.setupGround.getBBHeight())) {
                us.setupGround.drawSoil(d, cropX, cropY, cropW, cropH, us.lightingMap, tod.lightStrength, tod.ambient, soilTint);
            }
            for (LandFormation lf : us.setupFloaters) {
                if (!Rect2D.intersects(cropX, cropY, cropW, cropH, lf.x, lf.y, lf.getBBWidth(), lf.getBBHeight())) continue;
                lf.drawSoil(d, cropX, cropY, cropW, cropH, us.lightingMap, tod.lightStrength, tod.ambient, soilTint);
            }
            Appearance.lockBevelledShader(d, us.lightingMap, tod.lightStrength, tod.ambient);
            if (Rect2D.intersects(cropX, cropY, cropW, cropH, us.setupGround.x, us.setupGround.y, us.setupGround.getBBWidth(), us.setupGround.getBBHeight())) {
                us.setupGround.drawNonSoil(d, cropX, cropY, cropW, cropH, us.lightingMap, tod.lightStrength, tod.ambient, soilTint, snow);
            }
            for (LandFormation lf : us.setupFloaters) {
                if (!Rect2D.intersects(cropX, cropY, cropW, cropH, lf.x, lf.y, lf.getBBWidth(), lf.getBBHeight())) continue;
                lf.drawNonSoil(d, cropX, cropY, cropW, cropH, us.lightingMap, tod.lightStrength, tod.ambient, soilTint, snow);
            }
            Appearance.unlockBevelledShader(us.lightingMap != null);
        }
    }
}

