/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Locale;
import java.util.PropertyResourceBundle;

public class Lang {
    public static Locale currentLocale = Lang.getBestLocalLocale();
    public static PropertyResourceBundle bundle = null;

    public static void setCurrentLocale(Locale l) {
        if (Lang.availableLocales().contains(l)) {
            currentLocale = l;
            bundle = null;
        }
    }

    public static String getString(String key) {
        if (bundle == null) {
            File bundleF = new File(new File(new File(AGame.getStaticGameDirectory(), "data"), "lang"), currentLocale.toLanguageTag() + ".properties");
            try {
                BufferedReader r = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(bundleF), "UTF-8"));
                bundle = new PropertyResourceBundle(r);
                r.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return bundle.containsKey(key) ? bundle.getString(key) : "[RED]" + key + "[]";
    }

    public static String _t(String key, Object ... arguments) {
        for (int i = 0; i < arguments.length; ++i) {
            if (!(arguments[i] instanceof Integer)) continue;
            arguments[i] = ((Integer)arguments[i]).toString();
        }
        return new MessageFormat(Lang.getString(key), currentLocale).format(arguments).replace("QUOTE", "'");
    }

    public static ArrayList<Locale> availableLocales() {
        ArrayList<Locale> ls = new ArrayList<Locale>();
        File langDir = new File(new File(AGame.getStaticGameDirectory(), "data"), "lang");
        for (File f : langDir.listFiles()) {
            Locale l;
            if (!f.getName().endsWith(".properties") || (l = Locale.forLanguageTag(f.getName().substring(0, f.getName().length() - ".properties".length()))) == null) continue;
            ls.add(l);
        }
        return ls;
    }

    public static Locale getBestLocalLocale() {
        Locale loc = Locale.getDefault();
        ArrayList<Locale> ls = Lang.availableLocales();
        if (ls.contains(loc)) {
            return loc;
        }
        if (ls.contains(loc = new Locale(loc.getLanguage()))) {
            return loc;
        }
        return Locale.ENGLISH;
    }
}

