/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.Combat;
import com.zarkonnen.airships.Direction;
import com.zarkonnen.airships.Foot;
import com.zarkonnen.airships.LandFormation;
import com.zarkonnen.airships.Module;
import com.zarkonnen.airships.ShipList;
import com.zarkonnen.airships.Spring;
import com.zarkonnen.catengine.Img;
import com.zarkonnen.catengine.util.Pt;
import java.util.ArrayList;

public strictfp class Leg {
    public Airship ship;
    public Module module;
    public final Spec spec;
    public double upperRotation;
    public double lowerRotation;
    public double stepProgress;
    public double srcX;
    public double srcY;
    public double targetX;
    public double targetY;
    public boolean movedFoot = true;
    public boolean inited = false;
    public boolean flipped = false;
    public boolean touchingGround = true;
    public Foot foot;
    public static final double MAX_FOOT_SPEED = 100.1;

    public Leg(Spec spec, Airship ship, Module module) {
        this.spec = spec;
        this.ship = ship;
        this.module = module;
        this.reset();
        this.foot = new Foot(ship, this, 0.0, 0.0, spec.footWidth, spec.footHeight);
        this.updateFootPosition(true);
    }

    public void reset() {
        if (this.spec.bendForwards ^ this.ship.flipped) {
            this.upperRotation = 0.5235987755982988;
            this.lowerRotation = 2.6179938779914944;
        } else {
            this.upperRotation = 2.6179938779914944;
            this.lowerRotation = 0.5235987755982988;
        }
        this.inited = false;
    }

    public final void updateFootPosition(boolean setImmediately) {
        double mx = this.ship.x + (double)(this.ship.gridXToWorldX(this.module.x, this.module.type.getW()) * 16);
        double my = this.ship.y + (double)(this.module.y * 16) + (double)(this.module.type.getH() * 16);
        double hipX = this.ship.flipped ? mx + ((double)this.module.type.getW() - this.spec.xOffset) * 16.0 : mx + this.spec.xOffset * 16.0;
        double hipY = my + this.spec.yOffset * 16.0;
        Pt footPt = this.getFootPt();
        double footX2 = hipX + footPt.x - this.spec.footWidth / 2.0;
        double footY2 = hipY + footPt.y;
        double dSq = (footX2 - this.foot.x) * (footX2 - this.foot.x) + (footY2 - this.foot.y) * (footY2 - this.foot.y);
        if (setImmediately || dSq > this.spec.footWidth * this.spec.footWidth * 4.0) {
            this.foot.x = footX2;
            this.foot.y = footY2;
            this.foot.xSpeed = 0.0;
            this.foot.ySpeed = 0.016;
        } else {
            this.foot.xSpeed = (footX2 - this.foot.x) / 16.0 * 0.1;
            this.foot.ySpeed = (footY2 - this.foot.y) / 16.0 * 0.1;
            this.foot.x += (footX2 - this.foot.x) * 0.9;
            this.foot.y += (footY2 - this.foot.y) * 0.9;
            if (this.foot.ySpeed >= 0.0) {
                this.foot.ySpeed += 0.016;
            }
        }
        this.foot.xForce = 0.0;
        this.foot.yForce = 0.0;
    }

    public boolean moveFootTo(double footX, double footY, boolean shipFlipped) {
        double r;
        double d;
        if ((d = Math.sqrt(footX * footX + (footY -= this.spec.footHeight) * footY)) > 2.0 * (r = this.spec.limbLength)) {
            this.updateFootPosition(false);
            return false;
        }
        double baseAngle = Direction.radiansFromTo(0.0, 0.0, footX, footY);
        double hipAngle = Math.acos(d / 2.0 / r);
        double newAngle1 = Direction.normalizeRadians(baseAngle + hipAngle);
        double newAngle2 = Direction.normalizeRadians(baseAngle - hipAngle);
        if (this.spec.bendForwards ^ shipFlipped) {
            this.upperRotation = newAngle2;
            this.lowerRotation = newAngle1;
        } else {
            this.upperRotation = newAngle1;
            this.lowerRotation = newAngle2;
        }
        this.updateFootPosition(false);
        return true;
    }

    public Pt getFootPt() {
        Pt kneePt = Direction.ofRadians(this.upperRotation).by(this.spec.limbLength);
        return Direction.ofRadians(this.lowerRotation).fromBy(kneePt, this.spec.limbLength);
    }

    public boolean startStep(double mx, double my, LandFormation ground, ArrayList<LandFormation> floaters, ShipList ships, boolean movingLeft, boolean shipFlipped, int moduleWidth) {
        double hipX = shipFlipped ? mx + ((double)moduleWidth - this.spec.xOffset) * 16.0 : mx + this.spec.xOffset * 16.0;
        double hipY = my + this.spec.yOffset * 16.0;
        Pt footPt = this.getFootPt();
        double footDelta = Math.min(this.spec.limbLength, Math.max(this.spec.limbLength / 2.0, Math.abs(footPt.x)));
        double d = movingLeft ? -footDelta : footDelta;
        if (Math.abs(this.targetX - (hipX + d)) < this.spec.limbLength / 4.0) {
            return false;
        }
        double newTargetX = hipX + (movingLeft ? -footDelta : footDelta);
        double groundY = this.getGroundY(10000.0, hipY, newTargetX, ground, floaters, ships);
        if (groundY - hipY > (double)this.spec.spring.baseLength) {
            double candidateX;
            boolean foundAlternate = false;
            double candidateY = 0.0;
            if (movingLeft) {
                for (candidateX = hipX - this.spec.limbLength / 2.0; candidateX <= hipX + 16.0; candidateX += 16.0) {
                    candidateY = this.getGroundY(10000.0, hipY, candidateX, ground, floaters, ships);
                    if (!(candidateY - hipY <= (double)this.spec.spring.baseLength)) continue;
                    foundAlternate = true;
                    break;
                }
            } else {
                for (candidateX = hipX + this.spec.limbLength / 2.0; candidateX >= hipX - 16.0; candidateX -= 16.0) {
                    candidateY = this.getGroundY(10000.0, hipY, candidateX, ground, floaters, ships);
                    if (!(candidateY - hipY <= (double)this.spec.spring.baseLength)) continue;
                    foundAlternate = true;
                    break;
                }
            }
            if (foundAlternate) {
                this.targetX = candidateX;
                this.targetY = candidateY;
            } else {
                this.targetX += hipX;
                this.targetY = hipY + (double)this.spec.spring.baseLength;
                return false;
            }
        }
        this.targetX = newTargetX;
        this.targetY = groundY;
        this.srcX = footPt.x + hipX;
        this.srcY = footPt.y + hipY;
        this.stepProgress = 0.0;
        return true;
    }

    public double getGroundY(double initialY, double hipY, double footX, Combat c) {
        return this.getGroundY(initialY, hipY, footX, null, c.landFormations, c);
    }

    public double getGroundY(double initialY, double hipY, double footX, LandFormation ground, ArrayList<LandFormation> floaters, ShipList ships) {
        if (ground != null) {
            initialY = Math.min(initialY, Math.min(Spring.lengthTo(ground, footX, hipY), Math.min(Spring.lengthTo(ground, footX - this.spec.footWidth / 2.0, hipY), Spring.lengthTo(ground, footX + this.spec.footWidth / 2.0, hipY))) + hipY);
        }
        for (LandFormation lf : floaters) {
            initialY = Math.min(initialY, Math.min(Spring.lengthTo(lf, footX, hipY), Math.min(Spring.lengthTo(lf, footX - this.spec.footWidth / 2.0, hipY), Spring.lengthTo(lf, footX + this.spec.footWidth / 2.0, hipY))) + hipY);
        }
        for (int si = 0; si < ships.size(); ++si) {
            Airship sh = ships.get(si);
            if (sh == this.ship) continue;
            initialY = Math.min(initialY, Math.min(Spring.lengthTo(sh, footX, hipY), Math.min(Spring.lengthTo(sh, footX - this.spec.footWidth / 2.0, hipY), Spring.lengthTo(sh, footX + this.spec.footWidth / 2.0, hipY))) + hipY);
        }
        return initialY;
    }

    public void flipIfNeeded(double mx, double my, boolean shipFlipped, int moduleWidth, Combat c) {
        if (this.flipped != shipFlipped) {
            double oldHipX = this.flipped ? mx + ((double)moduleWidth - this.spec.xOffset) * 16.0 : mx + this.spec.xOffset * 16.0;
            double hipX = shipFlipped ? mx + ((double)moduleWidth - this.spec.xOffset) * 16.0 : mx + this.spec.xOffset * 16.0;
            this.targetX = hipX - (this.targetX - oldHipX);
            this.flipped = shipFlipped;
            double hipY = my + this.spec.yOffset * 16.0;
            this.targetY = Math.max(this.targetY, hipY + this.spec.limbLength * 1.8);
            this.targetY = this.getGroundY(this.targetY, hipY, this.targetX, c);
        }
    }

    public static double shift(double src, double trg, double max) {
        if (Math.abs(trg - src) < max) {
            return trg;
        }
        if (trg < src) {
            return src - max;
        }
        return src + max;
    }

    public void moveNonStepFoot(double mx, double my, boolean shipFlipped, int moduleWidth, Combat c) {
        double groundY;
        double hipY = my + this.spec.yOffset * 16.0;
        double hipX = shipFlipped ? mx + ((double)moduleWidth - this.spec.xOffset) * 16.0 : mx + this.spec.xOffset * 16.0;
        this.updatePosition(mx, my, shipFlipped, moduleWidth, c);
        --this.foot.hasStomped;
        if (!this.movedFoot) {
            Pt footPt = this.getFootPt();
            this.targetX = footPt.x + hipX;
            this.targetY = footPt.y + hipY + this.spec.footHeight;
        }
        if (this.targetY > (groundY = this.getGroundY(100000.0, hipY, this.targetX, c))) {
            this.targetY = groundY;
            this.foot.isDown = true;
            this.foot.hasStomped = 3;
        } else {
            boolean bl = this.foot.isDown = groundY < this.targetY + 2.0;
            if (groundY - hipY > (double)this.spec.spring.baseLength) {
                this.targetX = Leg.shift(this.targetX, hipX, (double)this.spec.stepLength * 0.1);
                this.targetY = Leg.shift(this.targetY, hipY + (double)this.spec.spring.baseLength * 0.75, (double)this.spec.stepLength * 0.1);
            } else {
                this.targetY = Leg.shift(this.targetY, Math.min(groundY, hipY + this.spec.limbLength * 1.8), (double)this.spec.stepLength * 0.1);
            }
        }
        this.updatePosition(mx, my, shipFlipped, moduleWidth, c);
    }

    public void updatePosition(double mx, double my, boolean shipFlipped, int moduleWidth, Combat c) {
        this.flipIfNeeded(mx, my, shipFlipped, moduleWidth, c);
        double hipX = shipFlipped ? mx + ((double)moduleWidth - this.spec.xOffset) * 16.0 : mx + this.spec.xOffset * 16.0;
        double hipY = my + this.spec.yOffset * 16.0;
        this.movedFoot = this.moveFootTo(this.targetX - hipX, this.targetY - hipY, shipFlipped);
    }

    public boolean doStep(double mx, double my, int ms, boolean shipFlipped, int moduleWidth, Combat c) {
        double footY;
        double footX;
        double pr;
        this.flipIfNeeded(mx, my, shipFlipped, moduleWidth, c);
        double spd = Math.abs(this.ship.xSpeed);
        int stepTime = spd < 0.01 ? this.spec.maxStepTime : Math.min(this.spec.maxStepTime, (int)((double)this.spec.stepLength / spd));
        double newProgressFraction = (double)ms * 1.0 / (double)stepTime;
        this.stepProgress = Math.min(1.0, this.stepProgress + newProgressFraction);
        double topY = Math.min(this.srcY, this.targetY) - this.spec.limbLength / 2.0;
        if (this.stepProgress < 0.5) {
            pr = this.stepProgress * 2.0;
            footX = this.srcX;
            footY = this.srcY * (1.0 - pr) + topY * pr;
        } else if (this.stepProgress < 0.75) {
            pr = (this.stepProgress - 0.5) * 4.0;
            footX = this.srcX * (1.0 - pr) + this.targetX * pr;
            footY = topY;
        } else {
            pr = (this.stepProgress - 0.75) * 4.0;
            footX = this.targetX;
            footY = topY * (1.0 - pr) + this.targetY * pr;
        }
        double hipX = shipFlipped ? mx + ((double)moduleWidth - this.spec.xOffset) * 16.0 : mx + this.spec.xOffset * 16.0;
        double hipY = my + this.spec.yOffset * 16.0;
        this.movedFoot = this.moveFootTo(footX - hipX, footY - hipY, shipFlipped);
        this.foot.isDown = this.stepProgress >= 0.95;
        int n = this.foot.hasStomped = this.foot.isDown ? 3 : -1;
        if (this.stepProgress >= 1.0) {
            this.stepProgress = 0.0;
            return true;
        }
        return false;
    }

    public strictfp static class Spec {
        public final double xOffset;
        public final double yOffset;
        public final double limbLength;
        public final double footWidth;
        public final double footHeight;
        public final int stepLength;
        public final int maxStepTime;
        public final boolean bendForwards;
        public final Spring spring;
        public final Img upperLeg;
        public final Img lowerLeg;
        public final Img foot;

        public Spec(double xOffset, double yOffset, double limbLength, double footWidth, double footHeight, int stepLength, int maxStepTime, boolean bendForwards, Spring spring, Img upperLeg, Img lowerLeg, Img foot) {
            this.xOffset = xOffset;
            this.yOffset = yOffset;
            this.limbLength = limbLength;
            this.footWidth = footWidth;
            this.footHeight = footHeight;
            this.stepLength = stepLength;
            this.maxStepTime = maxStepTime;
            this.bendForwards = bendForwards;
            this.spring = spring;
            this.upperLeg = upperLeg;
            this.lowerLeg = lowerLeg;
            this.foot = foot;
        }
    }
}

