/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;

public class LightGen {
    public static void main(String[] args) throws IOException {
        int sz = Integer.parseInt(args[0]);
        BufferedImage img = new BufferedImage(sz, sz, 1);
        Graphics2D g = img.createGraphics();
        g.setColor(Color.BLACK);
        g.fillRect(0, 0, sz, sz);
        LightGen.draw(g, sz, 0.0);
        ImageIO.write((RenderedImage)img, "PNG", new File(args[1]));
    }

    static void draw(Graphics2D g, int sz, double angle) {
        for (int y = 0; y < sz; ++y) {
            for (int x = 0; x < sz; ++x) {
                double dist = Math.sqrt((x - sz / 2) * (x - sz / 2) + (y - sz / 2) * (y - sz / 2));
                double angleDelta = Math.abs(Math.atan2(y - sz / 2, x - sz / 2) - angle);
                double amount = Math.max(0.0, 1.0 - dist / (double)(sz / 2)) * (1.0 - angleDelta / 1.5707963267948966);
                if (!(amount > 0.0)) continue;
                Color c = new Color((int)(amount * 255.0), (int)(amount * 255.0), (int)(amount * 255.0));
                g.setColor(c);
                g.fillRect(x, y, 1, 1);
            }
        }
    }
}

