/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.Appearance;
import com.zarkonnen.airships.Combat;
import com.zarkonnen.airships.Module;
import com.zarkonnen.airships.ModuleType;
import com.zarkonnen.airships.MyDraw;
import com.zarkonnen.airships.Particle;
import com.zarkonnen.airships.Rect2D;
import com.zarkonnen.airships.UniScreen;
import com.zarkonnen.catengine.Input;
import com.zarkonnen.catengine.SlickEngine;
import java.io.InputStream;
import java.util.ArrayList;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;
import org.newdawn.slick.Image;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.opengl.Texture;
import org.newdawn.slick.opengl.TextureImpl;

public class LightHaloLayer
implements UniScreen.VisualLayer {
    public static Texture light;

    @Override
    public void tick(Input in, int ms, UniScreen us) {
    }

    public static Image loadImage(String name) {
        InputStream is = SlickEngine.class.getResourceAsStream("/com/zarkonnen/airships/images/" + name);
        try {
            return new Image(is, name, false);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public void draw(MyDraw d, UniScreen us, double cropX, double cropY, double cropW, double cropH) {
        if (!Appearance.useLighting || Appearance.useSimpleGraphics || Appearance.shaderLoadFailed) {
            return;
        }
        try {
            if (light == null) {
                light = Appearance.loadTex("light");
            }
            GL11.glBlendFunc((int)1, (int)1);
            GL11.glEnable((int)3553);
            GL13.glActiveTexture((int)33984);
            GL11.glBindTexture((int)3553, (int)light.getTextureID());
            GL11.glBegin((int)7);
            this.draw(d, us, us.getTimeOfDay().haloStrength, cropX, cropY, cropW, cropH);
            GL11.glEnd();
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glBlendFunc((int)770, (int)771);
            TextureImpl.bindNone();
            GL11.glDisable((int)3553);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public void draw(MyDraw __d, UniScreen us, double strength, double cropX, double cropY, double cropW, double cropH) throws SlickException {
        if (us.combat != null) {
            for (Combat.Side s : us.combat.sides) {
                for (Airship as : s.ships) {
                    if (as.showingOutside) continue;
                    this.draw(as, strength);
                }
            }
            for (Particle p : us.combat.particles) {
                double r;
                if (p.type.lightClr == null || !Rect2D.intersects(cropX, cropY, cropW, cropH, p.x - (r = (double)p.type.lightRadius * ((double)p.life * 1.0 / (double)p.lifespan) * strength), p.y - r, r * 2.0, r * 2.0)) continue;
                GL11.glColor3f((float)((float)p.type.lightClr.r / 255.0f), (float)((float)p.type.lightClr.g / 255.0f), (float)((float)p.type.lightClr.b / 255.0f));
                GL11.glTexCoord2d((double)0.0, (double)0.0);
                GL11.glVertex2d((double)((float)(p.x - r)), (double)((float)(p.y - r)));
                GL11.glTexCoord2d((double)0.0, (double)1.0);
                GL11.glVertex2d((double)((float)(p.x - r)), (double)((float)(p.y + r)));
                GL11.glTexCoord2d((double)1.0, (double)1.0);
                GL11.glVertex2d((double)((float)(p.x + r)), (double)((float)(p.y + r)));
                GL11.glTexCoord2d((double)1.0, (double)0.0);
                GL11.glVertex2d((double)((float)(p.x + r)), (double)((float)(p.y - r)));
            }
        }
        if (us.setupFleet != null) {
            for (Airship as : us.setupFleet) {
                this.draw(as, strength);
            }
        }
    }

    public void draw(Airship sh, double strength) {
        int msz = sh.modules.size();
        for (int mi = 0; mi < msz; ++mi) {
            Module m = sh.modules.get(mi);
            if (!m.running()) continue;
            ArrayList<ModuleType.ModuleLightSource> lights = m.type.getLights();
            int lsz = lights.size();
            for (int li = 0; li < lsz; ++li) {
                ModuleType.ModuleLightSource mls = lights.get(li);
                double mx = sh.x + (double)(sh.gridXToWorldX(m.x, m.type.getW()) * 16);
                mx = sh.flipped ? (mx += ((double)m.type.getW() - mls.xOffset) * 16.0) : (mx += mls.xOffset * 16.0);
                double my = sh.y + (double)(m.y * 16) + mls.yOffset * 16.0;
                double r = (double)mls.radius * strength;
                GL11.glColor3f((float)((float)mls.clr.r / 255.0f), (float)((float)mls.clr.g / 255.0f), (float)((float)mls.clr.b / 255.0f));
                GL11.glTexCoord2d((double)0.0, (double)0.0);
                GL11.glVertex2d((double)((float)(mx - r)), (double)((float)(my - r)));
                GL11.glTexCoord2d((double)0.0, (double)1.0);
                GL11.glVertex2d((double)((float)(mx - r)), (double)((float)(my + r)));
                GL11.glTexCoord2d((double)1.0, (double)1.0);
                GL11.glVertex2d((double)((float)(mx + r)), (double)((float)(my + r)));
                GL11.glTexCoord2d((double)1.0, (double)0.0);
                GL11.glVertex2d((double)((float)(mx + r)), (double)((float)(my - r)));
            }
        }
    }
}

