/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.Appearance;
import com.zarkonnen.airships.Combat;
import com.zarkonnen.airships.FBOGraphicsFactory;
import com.zarkonnen.airships.Module;
import com.zarkonnen.airships.ModuleType;
import com.zarkonnen.airships.MyDraw;
import com.zarkonnen.airships.Particle;
import com.zarkonnen.airships.Rect2D;
import com.zarkonnen.airships.TimeOfDay;
import com.zarkonnen.airships.UniScreen;
import com.zarkonnen.catengine.Input;
import java.util.ArrayList;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;
import org.newdawn.slick.Color;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.Image;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.opengl.Texture;
import org.newdawn.slick.opengl.TextureImpl;
import org.newdawn.slick.opengl.shader.ShaderProgram;

public class LightMapLayer
implements UniScreen.VisualLayer {
    public static Texture lightCones;
    public static ShaderProgram shader;

    @Override
    public void tick(Input in, int ms, UniScreen us) {
    }

    @Override
    public void draw(MyDraw __d, UniScreen us, double cropX, double cropY, double cropW, double cropH) {
        if (!Appearance.useLighting || Appearance.useSimpleGraphics || Appearance.shaderLoadFailed) {
            return;
        }
        TimeOfDay tod = us.getTimeOfDay();
        try {
            if (lightCones == null) {
                lightCones = Appearance.loadTex("lightcones");
            }
            this.draw(us.lightingMap[0], 0.0f, 0.0f, __d, us, tod.light[0], 0, cropX, cropY, cropW, cropH);
            this.draw(us.lightingMap[1], 0.5f, 0.0f, __d, us, tod.light[1], 1, cropX, cropY, cropW, cropH);
            this.draw(us.lightingMap[2], 0.0f, 0.5f, __d, us, tod.light[2], 2, cropX, cropY, cropW, cropH);
            this.draw(us.lightingMap[3], 0.5f, 0.5f, __d, us, tod.light[3], 3, cropX, cropY, cropW, cropH);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public void draw(Image img, float srcX, float srcY, MyDraw __d, UniScreen us, Color bg, int side, double cropX, double cropY, double cropW, double cropH) throws SlickException {
        Graphics g = FBOGraphicsFactory.getGraphicsForImage(img);
        g.setColor(bg);
        g.fillRect(0.0f, 0.0f, (float)__d.frame().mode().width, (float)__d.frame().mode().height);
        g.setColor(Color.white);
        g.scale(0.25f, 0.25f);
        g.scale((float)us.zoom, (float)us.zoom);
        g.translate((float)us.adjScrollX, (float)us.adjScrollY);
        GL11.glBlendFunc((int)1, (int)1);
        GL11.glEnable((int)3553);
        GL13.glActiveTexture((int)33984);
        GL11.glBindTexture((int)3553, (int)lightCones.getTextureID());
        GL11.glBegin((int)7);
        if (us.combat != null) {
            for (Combat.Side s : us.combat.sides) {
                for (Airship as : s.ships) {
                    if (as.showingOutside) continue;
                    this.draw(g, as, srcX, srcY);
                }
            }
            for (Particle p : us.combat.particles) {
                double r;
                if (p.type.lightClr == null || !Rect2D.intersects(cropX, cropY, cropW, cropH, p.x - (r = (double)p.type.lightRadius * ((double)p.life * 1.0 / (double)p.lifespan)), p.y - r, r * 2.0, r * 2.0)) continue;
                GL11.glColor3f((float)((float)p.type.lightClr.r / 255.0f), (float)((float)p.type.lightClr.g / 255.0f), (float)((float)p.type.lightClr.b / 255.0f));
                GL11.glTexCoord2d((double)srcX, (double)srcY);
                GL11.glVertex2d((double)((float)(p.x - r)), (double)((float)(p.y - r)));
                GL11.glTexCoord2d((double)srcX, (double)(srcY + 0.5f));
                GL11.glVertex2d((double)((float)(p.x - r)), (double)((float)(p.y + r)));
                GL11.glTexCoord2d((double)(srcX + 0.5f), (double)(srcY + 0.5f));
                GL11.glVertex2d((double)((float)(p.x + r)), (double)((float)(p.y + r)));
                GL11.glTexCoord2d((double)(srcX + 0.5f), (double)srcY);
                GL11.glVertex2d((double)((float)(p.x + r)), (double)((float)(p.y - r)));
            }
        }
        if (us.setupFleet != null) {
            for (Airship as : us.setupFleet) {
                this.draw(g, as, srcX, srcY);
            }
        }
        GL11.glEnd();
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glBlendFunc((int)770, (int)771);
        g.resetTransform();
        TextureImpl.bindNone();
        GL11.glDisable((int)3553);
    }

    public void draw(Graphics g, Airship sh, float srcX, float srcY) {
        int msz = sh.modules.size();
        for (int mi = 0; mi < msz; ++mi) {
            Module m = sh.modules.get(mi);
            if (!m.running()) continue;
            ArrayList<ModuleType.ModuleLightSource> lights = m.type.getLights();
            int lsz = lights.size();
            for (int li = 0; li < lsz; ++li) {
                ModuleType.ModuleLightSource mls = lights.get(li);
                double mx = sh.x + (double)(sh.gridXToWorldX(m.x, m.type.getW()) * 16);
                mx = sh.flipped ? (mx += ((double)m.type.getW() - mls.xOffset) * 16.0) : (mx += mls.xOffset * 16.0);
                double my = sh.y + (double)(m.y * 16) + mls.yOffset * 16.0;
                GL11.glColor3f((float)((float)mls.clr.r / 255.0f), (float)((float)mls.clr.g / 255.0f), (float)((float)mls.clr.b / 255.0f));
                GL11.glTexCoord2d((double)srcX, (double)srcY);
                GL11.glVertex2d((double)((float)(mx - (double)mls.radius)), (double)((float)(my - (double)mls.radius)));
                GL11.glTexCoord2d((double)srcX, (double)(srcY + 0.5f));
                GL11.glVertex2d((double)((float)(mx - (double)mls.radius)), (double)((float)(my + (double)mls.radius)));
                GL11.glTexCoord2d((double)(srcX + 0.5f), (double)(srcY + 0.5f));
                GL11.glVertex2d((double)((float)(mx + (double)mls.radius)), (double)((float)(my + (double)mls.radius)));
                GL11.glTexCoord2d((double)(srcX + 0.5f), (double)srcY);
                GL11.glVertex2d((double)((float)(mx + (double)mls.radius)), (double)((float)(my - (double)mls.radius)));
            }
        }
    }
}

