/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.TimeOfDay;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;

public class LightmapBakery {
    public static void main(String[] args) throws IOException {
        for (String[] names : new String[][]{{"spritesheet", "bump"}, {"particles", "particles_bump"}, {"clouds", "clouds_bump"}, {"backdrops", "backdrops_bump"}, {"damage_sheet", "damage_bump"}, {"wheels_and_legs", "wheels_and_legs_bump"}}) {
            for (TimeOfDay tod : TimeOfDay.values()) {
                ImageIO.write((RenderedImage)LightmapBakery.bake(names[0], names[1], tod), "png", new File("src/com/zarkonnen/airships/images/" + names[0] + tod.name() + ".png"));
            }
            ImageIO.write((RenderedImage)LightmapBakery.bakeBlueprint(names[0]), "png", new File("src/com/zarkonnen/airships/images/" + names[0] + "BLUEPRINT.png"));
        }
    }

    public static BufferedImage bakeBlueprint(String name) throws IOException {
        BufferedImage spritesheet = ImageIO.read(LightmapBakery.class.getResourceAsStream("images/" + name + ".png"));
        BufferedImage out = new BufferedImage(spritesheet.getWidth(), spritesheet.getHeight(), 2);
        for (int y = 0; y < spritesheet.getHeight(); ++y) {
            for (int x = 0; x < spritesheet.getWidth(); ++x) {
                Color originalC = new Color(spritesheet.getRGB(x, y));
                boolean doBake = true;
                if (name.equals("spritesheet") && y >= 384) {
                    doBake = false;
                }
                if (name.equals("particles")) {
                    if (y < 638) {
                        doBake = false;
                    } else if (y < 768 && x < 122) {
                        doBake = false;
                    }
                }
                Color newC = doBake ? LightmapBakery.blueprintify(originalC, spritesheet.getAlphaRaster().getSample(x, y, 0)) : new Color(originalC.getRed(), originalC.getGreen(), originalC.getBlue(), spritesheet.getAlphaRaster().getSample(x, y, 0));
                out.setRGB(x, y, newC.getRGB());
            }
        }
        return out;
    }

    public static Color blueprintify(Color c, int alpha) {
        int amt = (int)Math.min(255.0, (double)(c.getRed() / 2 + c.getGreen() / 2 + c.getBlue() / 2 + alpha / 4) * 0.3);
        return new Color(255, 255, 255, amt);
    }

    public static BufferedImage bake(String name, String bumpName, TimeOfDay tod) throws IOException {
        BufferedImage spritesheet = ImageIO.read(LightmapBakery.class.getResourceAsStream("images/" + name + ".png"));
        BufferedImage bump = ImageIO.read(LightmapBakery.class.getResourceAsStream("images/" + bumpName + ".png"));
        BufferedImage out = new BufferedImage(spritesheet.getWidth(), spritesheet.getHeight(), 2);
        for (int y = 0; y < spritesheet.getHeight(); ++y) {
            for (int x = 0; x < spritesheet.getWidth(); ++x) {
                Color originalC = new Color(spritesheet.getRGB(x, y));
                Color bumpC = new Color(bump.getRGB(x, y));
                boolean doBake = true;
                if (name.equals("spritesheet") && y >= 384) {
                    doBake = false;
                }
                if (name.equals("particles")) {
                    if (y < 638) {
                        doBake = false;
                    } else if (y < 768 && x < 122) {
                        doBake = false;
                    }
                }
                Color newC = doBake ? LightmapBakery.bake(originalC, bumpC, tod) : originalC;
                newC = new Color(newC.getRed(), newC.getGreen(), newC.getBlue(), spritesheet.getAlphaRaster().getSample(x, y, 0));
                out.setRGB(x, y, newC.getRGB());
            }
        }
        return out;
    }

    public static Color bake(Color original, Color bump, TimeOfDay tod) {
        double r = (double)original.getRed() / 255.0 * (double)tod.ambient;
        double g = (double)original.getGreen() / 255.0 * (double)tod.ambient;
        double b = (double)original.getBlue() / 255.0 * (double)tod.ambient;
        double bx = (double)bump.getRed() / 255.0;
        double by = (double)bump.getGreen() / 255.0;
        double bz = (double)bump.getBlue() / 255.0;
        double leftM = Math.max(by - 0.3, 0.0) * 2.0 * bz * (double)tod.lightStrength;
        double rightM = Math.max(0.7 - by, 0.0) * 2.0 * bz * (double)tod.lightStrength;
        double topM = Math.max(bx - 0.3, 0.0) * 2.0 * bz * (double)tod.lightStrength;
        double sideM = Math.max(leftM, rightM);
        double topR = (double)tod.light[1].r * 1.0;
        double topG = (double)tod.light[1].g * 1.0;
        double topB = (double)tod.light[1].b * 1.0;
        double sideR = (double)Math.max(tod.light[0].r, tod.light[2].r) * 1.0;
        double sideG = (double)Math.max(tod.light[0].g, tod.light[2].g) * 1.0;
        double sideB = (double)Math.max(tod.light[0].b, tod.light[2].b) * 1.0;
        r = r + topM * topR + sideM * sideR;
        g = g + topM * topG + sideM * sideG;
        b = b + topM * topB + sideM * sideB;
        return new Color(LightmapBakery.clint(r), LightmapBakery.clint(g), LightmapBakery.clint(b));
    }

    public static int clint(double x) {
        return Math.max(0, Math.min(255, (int)(x * 255.0)));
    }
}

