/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.Module;
import com.zarkonnen.airships.ModuleType;
import com.zarkonnen.airships.MyDraw;
import com.zarkonnen.airships.UniScreen;
import com.zarkonnen.catengine.Input;
import org.newdawn.slick.Graphics;

public class LightsDebugLayer
implements UniScreen.VisualLayer {
    int time = 0;

    @Override
    public void tick(Input in, int ms, UniScreen us) {
        this.time += ms;
    }

    @Override
    public void draw(MyDraw d, UniScreen us, double cropX, double cropY, double cropW, double cropH) {
        if (this.time / 2000 % 2 == 0) {
            return;
        }
        Graphics g = (Graphics)d.frame().nativeRenderer();
        g.scale(4.0f, 4.0f);
        g.drawImage(us.lightingMap[0], 0.0f, 0.0f);
        g.resetTransform();
    }

    public void draw(MyDraw d, Airship sh) {
        for (Module m : sh.modules) {
            if (!m.running()) continue;
            for (ModuleType.ModuleLightSource mls : m.type.getLights()) {
                double r = mls.radius;
                double mx = sh.x + (double)(sh.gridXToWorldX(m.x, m.type.getW()) * 16) + (double)(m.type.getW() * 16 / 2);
                double my = sh.y + (double)(m.y * 16) + (double)(m.type.getW() * 16 / 2);
                d.rect(mls.clr, mx - r, my - r, r * 2.0, r * 2.0);
            }
        }
    }
}

