/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.AirshipGame;
import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.MainMenu;
import com.zarkonnen.airships.MyDraw;
import com.zarkonnen.airships.Screen;
import com.zarkonnen.airships.TimeOfDay;
import com.zarkonnen.catengine.Hooks;
import com.zarkonnen.catengine.Img;
import com.zarkonnen.catengine.Input;
import com.zarkonnen.catengine.util.Clr;
import com.zarkonnen.catengine.util.Pt;
import com.zarkonnen.catengine.util.ScreenMode;
import com.zarkonnen.catengine.util.Utils;
import java.util.ArrayList;

public class LoadingScreen
implements Screen {
    public static final Img newLogo = new Img("newest_logo", 0, 0, 300, 339, false);
    public static final Img glow = new Img("light_b");
    public static final Img softGlow = new Img("light_soft");
    public static final Clr TITLE = Clr.fromHex((String)"f5edb5");
    public static final String[] STATIC_DIRS = new String[]{"ships", "buildings", "landships"};
    private boolean waitOnce = true;
    private int staticsCopied = 0;
    private String loadingStatus = "...";
    private int musicLoadingIndex = 0;
    private int soundLoadingIndex;
    private final String[] musics = AGame.COMBAT_MUSIC.toArray(new String[0]);
    private final String[] sounds = new String[]{"hookimpact", "throw0", "throw1", "throw2", "place_wood", "place_metal", "place_stone", "computer0", "computer1", "computer2", "motor", "hiss0", "hiss1", "hiss2", "step0", "step1", "step", "sail", "ready", "flak0", "flak1", "flak2", "flak3", "cannon0", "cannon1", "cannon2", "cannon3", "cannon4", "cannon5", "cough0", "cough1", "cough2", "cough3", "death0", "death1", "death2", "death3", "death4", "paper_lift", "engine_1600", "explosion", "fire_2000", "gatling0", "gatling1", "gatling2", "gatling3", "gatling4", "gatling5", "gatling6", "gatling7", "gatling8", "hit0", "hit1", "hit2", "hit3", "hv_cannon0", "hv_cannon1", "hv_cannon2", "large_crash", "quench0", "quench1", "quench2", "repair0", "repair1", "repair2", "repair3", "repair4", "repair5", "rifle0", "rifle1", "rocket0", "rocket1", "rocket2", "rocket3", "rocket4", "rocket5", "small_crash", "smexplosion", "suspendium_3200", "place", "remove", "spin_up", "branchcrack0", "branchcrack1", "branchcrack2", "trunkcrack0", "leaves0", "leaves1", "leaves2", "rock0", "rock1", "thunder0", "thunder1", "thunder2", "thunder3", "lightning0"};
    private AirshipGame g;

    public LoadingScreen(AirshipGame g) {
        this.g = g;
    }

    @Override
    public void input(Input in, MyDraw.State drawState, Pt cursor, Pt click, int ms) {
        if (this.waitOnce) {
            this.waitOnce = false;
            return;
        }
        if (this.staticsCopied < STATIC_DIRS.length) {
            this.loadingStatus = this.staticsCopied == STATIC_DIRS.length - 1 ? Lang._t("Loading_x", this.musics[0]) : Lang._t("Installing_x", STATIC_DIRS[this.staticsCopied + 1]);
            try {
                if (this.g.prevUserFirstTimev5) {
                    AGame.overlayStatic("default_" + STATIC_DIRS[this.staticsCopied], STATIC_DIRS[this.staticsCopied]);
                } else {
                    AGame.copyStatic("default_" + STATIC_DIRS[this.staticsCopied], STATIC_DIRS[this.staticsCopied]);
                }
            }
            catch (Exception e) {
                this.g.reportError(Lang._t("Unable_to_copy_game_files", new Object[0]), e, null, false);
            }
            ++this.staticsCopied;
            return;
        }
        if (this.musicLoadingIndex < this.musics.length) {
            in.preloadMusic(this.musics[this.musicLoadingIndex]);
            this.loadingStatus = this.musicLoadingIndex == this.musics.length - 1 ? Lang._t("Loading_x", this.sounds[0]) : Lang._t("Loading_x", this.musics[this.musicLoadingIndex + 1]);
            ++this.musicLoadingIndex;
            return;
        }
        if (this.soundLoadingIndex == this.sounds.length) {
            this.g.swallowExceptions = false;
            this.g.saveSettings();
            this.g.s = new MainMenu(this.g);
            ((MainMenu)this.g.s).afterBoot = true;
        } else {
            this.g.swallowExceptions = true;
            in.preloadSounds(Utils.l((Object[])new String[]{this.sounds[this.soundLoadingIndex++]}));
            if (this.soundLoadingIndex < this.sounds.length) {
                this.loadingStatus = Lang._t("Loading_x", this.sounds[this.soundLoadingIndex]);
            }
        }
    }

    @Override
    public void render(MyDraw d, ScreenMode sm, Hooks hs, Pt cursor) {
        d.drawBG(AGame.CAST_IRON, sm);
        int x = (sm.width - 200) / 2;
        int y = sm.height / 2 - (64 + AGame.BIG_FOUNT.height + 36 + LoadingScreen.newLogo.srcHeight + 24 + 24 + 3 + AGame.BIG_FOUNT.height) / 2;
        int glowSize = 500;
        d.blit(glow, TITLE, sm.width / 2 - glowSize / 2, y - glowSize / 2 + LoadingScreen.newLogo.srcHeight / 2 + 64 + 12 + AGame.BIG_FOUNT.height, glowSize, glowSize);
        Pt sz = d.textSize("AIRSHIPS", AGame.HUGE_FOUNT);
        d.text("[f5edb5]AIRSHIPS", AGame.HUGE_FOUNT, sm.width / 2 - (int)(sz.x / 2.0), y);
        sz = d.textSize("Conquer the Skies", AGame.BIG_FOUNT);
        d.text("[f5edb5]Conquer the Skies", AGame.BIG_FOUNT, sm.width / 2 - (int)(sz.x / 2.0), y += 64);
        d.blit(newLogo, sm.width / 2 - LoadingScreen.newLogo.srcWidth / 2, y += AGame.BIG_FOUNT.height + 12, LoadingScreen.newLogo.srcWidth, LoadingScreen.newLogo.srcHeight);
        d.progressBar(x, y += LoadingScreen.newLogo.srcHeight + 24, 200, 1.0 * (double)(this.staticsCopied + this.musicLoadingIndex + this.soundLoadingIndex) / (double)(STATIC_DIRS.length + this.musics.length + this.sounds.length));
        sz = d.textSize(this.loadingStatus, AGame.BIG_FOUNT);
        d.text("[f5edb5]" + this.loadingStatus, AGame.BIG_FOUNT, sm.width / 2 - (int)(sz.x / 2.0), y + 24 + 3);
    }

    @Override
    public ArrayList<String> music() {
        return AGame.LOADING_MUSIC;
    }

    @Override
    public String appearancePostfix() {
        return TimeOfDay.DAY.name();
    }

    @Override
    public boolean alwaysUseAppearancePostfix() {
        return false;
    }
}

