/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.ChatAdapter;
import com.zarkonnen.airships.Client;
import com.zarkonnen.airships.InputRunnable;
import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.MultiplayerSetupIntent;
import com.zarkonnen.airships.MyDraw;
import com.zarkonnen.airships.ScrollBar;
import com.zarkonnen.airships.TextField;
import com.zarkonnen.airships.UniScreen;
import com.zarkonnen.catengine.Input;
import com.zarkonnen.catengine.util.Clr;
import com.zarkonnen.catengine.util.Pt;
import com.zarkonnen.catengine.util.ScreenMode;

public class LobbyChat
implements UniScreen.InfoPanel {
    public static final Clr ALT = new Clr(44, 44, 44);
    public TextField chatField = new TextField();
    private static final ChatAdapter chatAdapter = new ChatAdapter();
    private static final ScrollBar chatScrollBar = new ScrollBar();

    @Override
    public void draw(MyDraw d, Pt cursor, ScreenMode sm, UniScreen us) {
        if (!(us.intent instanceof MultiplayerSetupIntent)) {
            return;
        }
        final MultiplayerSetupIntent msi = (MultiplayerSetupIntent)us.intent;
        int x = msi.flipped ? 10 : sm.width - 400 - 10;
        int y = 55;
        int w = 400;
        int h = sm.height - y - 24 - 3 - 10;
        chatScrollBar.draw(d, x, y, w, h, msi.chat, chatAdapter);
        this.chatField.render(x, y += h + 3, w - 80 - 3, d, sm, null, cursor);
        d.button(x + w - 80, y, 80, Lang._t("Send", new Object[0]), null, new InputRunnable(){

            @Override
            public void run(Input in) {
                LobbyChat.this.sendChat(msi);
            }
        }, msi.client.isConnected());
    }

    private void sendChat(MultiplayerSetupIntent msi) {
        if (msi.client.isConnected()) {
            msi.client.sendMessage(Client.msg("chat").put("id", msi.myID).put("text", this.chatField.text));
            this.chatField.text = "";
        }
    }

    @Override
    public void tick(Input in, int ms, UniScreen us) {
        if (!(us.intent instanceof MultiplayerSetupIntent)) {
            return;
        }
        this.chatField.input(in, null, null, null, ms);
        MultiplayerSetupIntent msi = (MultiplayerSetupIntent)us.intent;
        if (in.keyPressed("ENTER")) {
            this.sendChat(msi);
        }
    }

    @Override
    public boolean chatEnabled(UniScreen us) {
        return us.intent instanceof MultiplayerSetupIntent;
    }

    @Override
    public boolean doScroll(UniScreen us, int scrollAmt, Pt cursor, ScreenMode sm) {
        return false;
    }

    @Override
    public boolean arrowKeysInUse(UniScreen us) {
        return false;
    }
}

