/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AirshipGame;
import com.zarkonnen.airships.Errstream;
import com.zarkonnen.airships.Integration;
import com.zarkonnen.airships.SimplePref;
import com.zarkonnen.airships.WebIntegrationBackend;
import com.zarkonnen.catengine.Condition;
import com.zarkonnen.catengine.ExceptionHandler;
import com.zarkonnen.catengine.Game;
import com.zarkonnen.catengine.SlickEngine;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import javax.imageio.ImageIO;
import javax.swing.JOptionPane;
import org.lwjgl.opengl.Display;
import org.newdawn.slick.opengl.ImageIOImageData;

public class Main {
    public static void main(String[] args) {
        if (System.getProperty("os.name", "NONE").toLowerCase().contains("win")) {
            System.setProperty("org.lwjgl.librarypath", new File("").getAbsolutePath() + "\\lib\\native\\");
        }
        if (!SimplePref.WINDOW_BORDER.get()) {
            System.setProperty("org.lwjgl.opengl.Window.undecorated", "true");
        }
        try {
            Errstream.install();
            SlickEngine e = new SlickEngine("Airships", "/com/zarkonnen/airships/images/", "/com/zarkonnen/airships/sounds/", Integer.valueOf(60));
            final AirshipGame g = new AirshipGame();
            e.setExceptionHandler(new ExceptionHandler(){

                public void handle(Exception e, boolean fatal) {
                    g.reportError("OpenGL Crash", e, null, false, true);
                    JOptionPane.showMessageDialog(null, "Unable to create OpenGL window.\nPlease check that your drivers are up to date and that your graphics card supports OpenGL.");
                    System.exit(1);
                }
            });
            e.setup((Game)g);
            e.setExceptionHandler((ExceptionHandler)g);
            Display.setIcon((ByteBuffer[])new ByteBuffer[]{new ImageIOImageData().imageToByteBuffer(ImageIO.read(Main.class.getResourceAsStream("images/16x16.png")), false, false, null), new ImageIOImageData().imageToByteBuffer(ImageIO.read(Main.class.getResourceAsStream("images/32x32.png")), false, false, null)});
            e.runUntil(Condition.ALWAYS);
        }
        catch (Throwable t) {
            t.printStackTrace();
            StringWriter sw = new StringWriter();
            t.printStackTrace(new PrintWriter(sw));
            Main.reportError(sw.toString() + "\n" + Main.pathReport());
            try {
                Thread.sleep(5000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            JOptionPane.showMessageDialog(null, "Fatal error. Please report this to the developer.\n" + t.toString() + "\n" + sw.toString());
        }
    }

    public static String pathReport() {
        StringBuilder sb = new StringBuilder();
        sb.append("os.name = ").append(System.getProperty("os.name", "NONE")).append("\n");
        sb.append("java.version = ").append(System.getProperty("java.version", "NONE")).append("\n");
        sb.append("java.library.path = ").append(System.getProperty("java.library.path", "NONE")).append("\n");
        sb.append(". = ").append(new File("").getAbsolutePath()).append("\n");
        if (System.getProperty("java.library.path") != null) {
            File f = new File("").getAbsoluteFile();
            for (String s : System.getProperty("java.library.path").split("[/]")) {
                f = new File(f, s);
            }
            sb.append(f.getAbsolutePath()).append(" exists = ").append(f.exists()).append("\n");
            if (f.exists()) {
                for (File f2 : f.listFiles()) {
                    sb.append(" - ").append(f2.getName()).append("\n");
                }
            }
        }
        return sb.toString();
    }

    public static void reportError(String text) {
        Integration integration = new Integration(new WebIntegrationBackend("https://airships.zarkonnen.com/api/", "https://airships.zarkonnen.com/static/media/", "https://airships.zarkonnen.com/do_login/", "https://airships.zarkonnen.com/do_login_calendar/"));
        integration.sendFeedback("MAJOR ERROR: " + text);
    }
}

