/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.AchievementsScreen;
import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.AirshipGame;
import com.zarkonnen.airships.Appearance;
import com.zarkonnen.airships.Client;
import com.zarkonnen.airships.CoatEditor;
import com.zarkonnen.airships.CoatOfArms;
import com.zarkonnen.airships.Combat;
import com.zarkonnen.airships.CombatBackgroundFlavor;
import com.zarkonnen.airships.CreditsScreen;
import com.zarkonnen.airships.EditorAttractIntent;
import com.zarkonnen.airships.FollowActionButton;
import com.zarkonnen.airships.GameSetupScreen;
import com.zarkonnen.airships.HostOrJoinGameScreen;
import com.zarkonnen.airships.InputRunnable;
import com.zarkonnen.airships.Integration;
import com.zarkonnen.airships.LandBlockType;
import com.zarkonnen.airships.LandFormation;
import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.MetaLobbyScreen;
import com.zarkonnen.airships.MyDraw;
import com.zarkonnen.airships.PlaceShipTool;
import com.zarkonnen.airships.Screen;
import com.zarkonnen.airships.SettingsScreen;
import com.zarkonnen.airships.ShipType;
import com.zarkonnen.airships.SingleCombatIntent;
import com.zarkonnen.airships.SingleCombatSetupIntent;
import com.zarkonnen.airships.StandaloneEditShipIntent;
import com.zarkonnen.airships.SteamBackend;
import com.zarkonnen.airships.StrategicScreen;
import com.zarkonnen.airships.TacticalAI;
import com.zarkonnen.airships.TextField;
import com.zarkonnen.airships.TimeOfDay;
import com.zarkonnen.airships.UniScreen;
import com.zarkonnen.catengine.Hook;
import com.zarkonnen.catengine.Hooks;
import com.zarkonnen.catengine.Img;
import com.zarkonnen.catengine.Input;
import com.zarkonnen.catengine.util.Clr;
import com.zarkonnen.catengine.util.Pt;
import com.zarkonnen.catengine.util.Rect;
import com.zarkonnen.catengine.util.ScreenMode;
import com.zarkonnen.catengine.util.Utils;
import java.awt.Desktop;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.json.JSONObject;
import org.json.JSONTokener;

public class MainMenu
implements Screen {
    private final AirshipGame g;
    public static final Img SPLASH = new Img("airships_new2_splash");
    private final TextField usernameF = new TextField(false, " qwertyuiopasdfghjklzxcvbnmQWERTYUIOPASDFGHJKLZXCVBNM1234567890-=+_!?<>,.;:\"'@\u00a3$%^&*()[]{}|\\~/\u00b1\u00e4\u00f6\u00fc\u00c4\u00d6\u00dc\u00c9\u00ca\u00c8\u00e9\u00ea\u00e8\u00eb\u00c7\u00e7\u00c0\u00e0\u00e2\u00fb");
    private final TextField passwordF = new TextField(true);
    private final TextField password2F = new TextField(true);
    private final TextField emailF = new TextField();
    private final TextField codeF = new TextField();
    private final TextField feedbackF = new TextField(false, " qwertyuiopasdfghjklzxcvbnmQWERTYUIOPASDFGHJKLZXCVBNM1234567890-=+_!?<>,.;:\"'@\u00a3$%^&*()[]{}|\\~/\u00b1\u00e4\u00f6\u00fc\u00c4\u00d6\u00dc\u00c9\u00ca\u00c8\u00e9\u00ea\u00e8\u00eb\u00c7\u00e7\u00c0\u00e0\u00e2\u00fb\n");
    private boolean loginDialog;
    private boolean registerDialog;
    private boolean feedbackDialog;
    private boolean onceCodeOnly = true;
    private boolean linkDialog;
    private final TextField[] loginFields = new TextField[]{this.usernameF, this.passwordF};
    private final String[] loginFieldNames = new String[]{Lang._t("Username", new Object[0]), Lang._t("Password", new Object[0])};
    private final TextField[] registerFields = new TextField[]{this.usernameF, this.passwordF, this.password2F, this.emailF, this.codeF};
    private final String[] registerFieldNames = new String[]{Lang._t("Username", new Object[0]), Lang._t("Password", new Object[0]), Lang._t("Repeat_Password", new Object[0]), Lang._t("Email", new Object[0]), Lang._t("Registration_Code", new Object[0])};
    private final TextField[] codeFields = new TextField[]{this.codeF};
    private final String[] codeFieldNames = new String[]{Lang._t("Registration_Code", new Object[0])};
    private final TextField[] linkFields = new TextField[]{this.usernameF, this.passwordF};
    private final String[] linkFieldNames = new String[]{Lang._t("Forum_Username", new Object[0]), Lang._t("Password", new Object[0])};
    public boolean afterBoot;
    public Airship scrollingDesign;
    public double scrollDesignX;
    public double scrollDesignY;
    public double scrollDesignTime;
    public int idleTime = 0;
    public static final String USERNAME_ALLOWED = " qwertyuiopasdfghjklzxcvbnmQWERTYUIOPASDFGHJKLZXCVBNM1234567890-=+_!?<>,.;:\"'@\u00a3$%^&*()[]{}|\\~/\u00b1\u00e4\u00f6\u00fc\u00c4\u00d6\u00dc\u00c9\u00ca\u00c8\u00e9\u00ea\u00e8\u00eb\u00c7\u00e7\u00c0\u00e0\u00e2\u00fb";
    public static String introText = null;
    public static Locale introLang = Locale.ENGLISH;
    public static final int SCROLL_DESIGN_SCALE = 8;

    public MainMenu(AirshipGame g) {
        this.g = g;
        g.integration.checkForNews();
        this.passwordF.pasteButton = true;
        this.password2F.pasteButton = true;
        this.emailF.pasteButton = true;
        this.codeF.pasteButton = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getIntroText() {
        if (introText == null || !introLang.equals(Lang.currentLocale)) {
            introText = "";
            BufferedReader r = null;
            try {
                String l;
                File introF = new File(new File(new File(AGame.getStaticGameDirectory(), "data"), "lang"), Lang.currentLocale.toLanguageTag() + "_intro.txt");
                r = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(introF), "UTF-8"));
                while ((l = r.readLine()) != null) {
                    introText = introText + l + "\n";
                }
                introText = introText.substring(0, introText.length() - 1);
            }
            catch (Exception e) {
                introText = "?";
            }
            finally {
                try {
                    r.close();
                }
                catch (Exception exception) {}
            }
        }
        return introText;
    }

    private void inputIntoFields(TextField[] fs, Input in, MyDraw.State drawState, Pt cursor, Pt click, int ms) {
        for (TextField tf : fs) {
            tf.input(in, drawState, cursor, click, ms);
        }
        if (in.keyDown("TAB") && drawState.canClick()) {
            for (int i = 0; i < fs.length; ++i) {
                if (!fs[i].focus) continue;
                fs[i].focus = false;
                fs[(i + 1) % fs.length].focus = true;
                break;
            }
            drawState.hasClicked();
        }
    }

    private void setupSingleCombat() {
        Combat c = new Combat(this.g, TimeOfDay.getRandom(AGame.ANIM_R));
        Utils.Pair<LandFormation, List<LandFormation>> p = LandFormation.generate(AGame.ANIM_R);
        c.landFormations.add((LandFormation)p.a);
        c.landFormations.addAll((Collection)p.b);
        c.sides.get((int)0).arms = this.g.getBestCOA();
        c.backgroundFlavor = CombatBackgroundFlavor.values()[AGame.ANIM_R.nextInt(CombatBackgroundFlavor.values().length)];
        UniScreen us = new UniScreen(this.g, new SingleCombatSetupIntent());
        us.combat = c;
        us.mySide = c.sides.get(0);
        this.g.s = us;
    }

    private void setupConsistentSC() {
        Combat c = new Combat(this.g, TimeOfDay.DAY);
        LandFormation ground = new LandFormation(-1600.0, 512.0, 200, 16);
        for (int y = 0; y < ground.grid.length; ++y) {
            for (int x = 0; x < ground.grid[0].length; ++x) {
                ground.grid[y][x] = LandBlockType.BEDROCK;
            }
        }
        ground.crop();
        ground.immobile = true;
        c.landFormations.add(ground);
        c.backgroundFlavor = CombatBackgroundFlavor.MOUNTAIN;
        UniScreen us = new UniScreen(this.g, new SingleCombatSetupIntent());
        us.combat = c;
        us.mySide = c.sides.get(0);
        this.g.s = us;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void input(Input in, MyDraw.State drawState, Pt cursor, Pt click, int ms) {
        if (this.scrollingDesign != null && this.scrollDesignTime > 20000.0) {
            this.scrollingDesign = null;
        }
        if (this.scrollingDesign == null) {
            File[] fs = new File(AGame.getGameDirectory(), "ships").listFiles();
            int tries = 0;
            while (this.scrollingDesign == null && fs.length != 0 && tries++ < 10) {
                File f = fs[AGame.ANIM_R.nextInt(fs.length)];
                if (!f.getName().endsWith(".json")) continue;
                BufferedReader r = null;
                try {
                    r = new BufferedReader(new FileReader(f));
                    this.scrollingDesign = new Airship(new JSONObject(new JSONTokener(r)));
                    this.scrollDesignX = ((double)(in.mode().width / 2) - this.scrollingDesign.getBBWidth() * 6.0) / 8.0;
                    this.scrollDesignY = ((double)(in.mode().height / 2) - this.scrollingDesign.getBBHeight() * 4.0) / 8.0;
                    this.scrollDesignTime = 0.0;
                }
                catch (Exception e) {}
                continue;
                finally {
                    try {
                        r.close();
                    }
                    catch (Exception e) {}
                }
            }
        } else {
            this.scrollDesignTime += (double)ms;
            this.scrollDesignX += 0.0025 * (double)ms;
        }
        if (this.g.prevUserFirstTimev5) {
            if (in.keyPressed("ENTER") || in.keyPressed("ESCAPE")) {
                this.g.prevUserFirstTimev5 = false;
            }
            return;
        }
        if (!this.g.phoneHomeAsked) {
            if (in.keyPressed("Y") || in.keyPressed("ENTER")) {
                this.g.phoneHomeAsked = true;
                this.g.phoneHomeWithErrors = true;
            }
            if (in.keyPressed("N") || in.keyPressed("ESCAPE")) {
                this.g.phoneHomeAsked = true;
                this.g.phoneHomeWithErrors = false;
            }
            return;
        }
        if (!SteamBackend.isEnabled() && this.g.isIntegrated() && this.g.integration.getState() == Integration.State.REQUIRE_CODE) {
            String code;
            if (this.codeF.text.isEmpty() && (code = AGame.getCodeFromClipboard()) != null && this.onceCodeOnly) {
                this.codeF.text = code;
                this.onceCodeOnly = false;
            }
            this.inputIntoFields(this.codeFields, in, drawState, cursor, click, ms);
            if (in.keyPressed("ENTER") && drawState.canClick() && !this.codeF.text.isEmpty()) {
                this.g.integration.addCode(this.codeF.text);
                drawState.hasClicked();
            }
            if (in.keyPressed("ESCAPE") && drawState.canClick()) {
                this.g.integration.logout();
                drawState.hasClicked();
            }
            return;
        }
        if (this.feedbackDialog) {
            this.feedbackF.input(in, drawState, cursor, click, ms);
            if (in.keyPressed("ESCAPE") && drawState.canClick()) {
                this.feedbackDialog = false;
                drawState.hasClicked();
            }
        } else if (this.linkDialog) {
            this.inputIntoFields(this.linkFields, in, drawState, cursor, click, ms);
            if (in.keyPressed("ENTER") && drawState.canClick() && !this.usernameF.text.isEmpty() && !this.passwordF.text.isEmpty()) {
                this.g.integration.steamLinkUser(this.usernameF.text, this.passwordF.text);
                this.linkDialog = false;
                drawState.hasClicked();
            }
            if (in.keyPressed("ESCAPE") && drawState.canClick()) {
                this.linkDialog = false;
                drawState.hasClicked();
            }
        } else if (this.loginDialog) {
            this.inputIntoFields(this.loginFields, in, drawState, cursor, click, ms);
            if (in.keyPressed("ENTER") && drawState.canClick() && !this.usernameF.text.isEmpty() && !this.passwordF.text.isEmpty()) {
                this.g.integration.login(this.usernameF.text, this.passwordF.text);
                this.loginDialog = false;
                drawState.hasClicked();
            }
            if (in.keyPressed("ESCAPE") && drawState.canClick()) {
                this.loginDialog = false;
                drawState.hasClicked();
            }
        } else if (this.registerDialog) {
            this.inputIntoFields(this.registerFields, in, drawState, cursor, click, ms);
            if (in.keyPressed("ENTER") && drawState.canClick() && !this.usernameF.text.isEmpty() && !this.passwordF.text.isEmpty() && !this.password2F.text.isEmpty() && !this.emailF.text.isEmpty() && !this.codeF.text.isEmpty() && this.passwordF.text.equals(this.password2F.text)) {
                this.g.integration.register(this.usernameF.text, this.passwordF.text, this.emailF.text, this.codeF.text);
                this.registerDialog = false;
                drawState.hasClicked();
            }
            if (in.keyPressed("ESCAPE") && drawState.canClick()) {
                this.registerDialog = false;
                drawState.hasClicked();
            }
        } else {
            UniScreen us;
            if (in.keyPressed("N") && drawState.canClick()) {
                drawState.hasClicked();
                this.g.s = new GameSetupScreen(this.g);
                return;
            }
            if (in.keyPressed("O") && drawState.canClick()) {
                drawState.hasClicked();
                StrategicScreen ss = new StrategicScreen(this.g, null);
                ss.open(true);
                return;
            }
            if (in.keyPressed("E") && drawState.canClick()) {
                us = new UniScreen(this.g, new StandaloneEditShipIntent());
                us.standaloneEditShip = new Airship(ShipType.AIRSHIP);
                this.g.s = us;
                drawState.hasClicked();
                return;
            }
            if (in.keyPressed("B") && drawState.canClick()) {
                us = new UniScreen(this.g, new StandaloneEditShipIntent());
                us.standaloneEditShip = new Airship(ShipType.BUILDING);
                this.g.s = us;
                drawState.hasClicked();
                return;
            }
            if (in.keyPressed("L") && drawState.canClick()) {
                us = new UniScreen(this.g, new StandaloneEditShipIntent());
                us.standaloneEditShip = new Airship(ShipType.LANDSHIP);
                this.g.s = us;
                drawState.hasClicked();
                return;
            }
            if (in.keyPressed("A") && drawState.canClick() && (SteamBackend.isEnabled() || this.g.isIntegrated() && this.g.integration.getState() == Integration.State.LOGGED_IN)) {
                this.g.s = new CoatEditor(this.g, true);
                drawState.hasClicked();
                return;
            }
            if (in.keyPressed("C") && drawState.canClick()) {
                this.setupSingleCombat();
                drawState.hasClicked();
                return;
            }
            if (in.keyPressed("M") && drawState.canClick() && this.g.isIntegrated() && (this.g.integration.getState() == Integration.State.LOGGED_IN || this.g.integration.getState() == Integration.State.STEAM) && this.g.integration.backend.getMultiplayerServer() != null) {
                this.startMultiplayer();
                drawState.hasClicked();
                return;
            }
            if (in.keyPressed("H") && drawState.canClick()) {
                this.g.s = new HostOrJoinGameScreen(true, this.g);
                drawState.hasClicked();
                return;
            }
            if (in.keyPressed("J") && drawState.canClick()) {
                this.g.s = new HostOrJoinGameScreen(false, this.g);
                drawState.hasClicked();
                return;
            }
            if (!SteamBackend.isEnabled() && this.g.isIntegrated() && in.keyPressed("L") && drawState.canClick()) {
                if (this.g.integration.getState() == Integration.State.LOGGED_IN) {
                    this.g.integration.logout();
                } else if (this.g.integration.getState() == Integration.State.LOGGED_OUT) {
                    this.showLoginDialog();
                }
                drawState.hasClicked();
            }
            if (SteamBackend.isEnabled() && this.g.isIntegrated() && this.g.integration.steamUnlinked && in.keyPressed("L") && drawState.canClick()) {
                this.showLinkDialog();
                drawState.hasClicked();
            }
            if (!SteamBackend.isEnabled() && this.g.isIntegrated() && in.keyPressed("R") && drawState.canClick()) {
                if (this.g.integration.getState() == Integration.State.LOGGED_OUT) {
                    this.showRegisterDialog();
                }
                drawState.hasClicked();
            }
            if (in.keyPressed("S") && drawState.canClick()) {
                this.g.s = new SettingsScreen(this.g);
                drawState.hasClicked();
                return;
            }
            if ((in.keyPressed("Q") || in.keyPressed("ESCAPE")) && drawState.canClick()) {
                this.g.exit = true;
                drawState.hasClicked();
            }
        }
        if (!(this.loginDialog || this.registerDialog || this.feedbackDialog || this.linkDialog)) {
            this.idleTime += ms;
            if (this.idleTime > 20000 && AGame.useAttractMode()) {
                if (AGame.ANIM_R.nextBoolean()) {
                    this.startEditorAttract();
                } else {
                    this.startCombatAttract();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startEditorAttract() {
        File shipDir = new File(new File(AGame.getStaticGameDirectory(), "data"), "ships");
        File[] fs = shipDir.listFiles();
        File shipF = fs[AGame.ANIM_R.nextInt(fs.length)];
        BufferedReader r = null;
        try {
            r = new BufferedReader(new FileReader(shipF));
            Airship ship = new Airship(new JSONObject(new JSONTokener(r)));
            ship.repair();
            ship.x = 0.0;
            ship.y = 0.0;
            UniScreen us = new UniScreen(this.g, new EditorAttractIntent(ship));
            us.standaloneEditShip = new Airship(ShipType.AIRSHIP);
            us.standaloneEditShip.name = ship.name = AGame.getShipName();
            us.followShip = ship;
            us.hideUI = true;
            this.g.s = us;
        }
        catch (Exception e) {
        }
        finally {
            try {
                r.close();
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startCombatAttract() {
        Combat c = new Combat(this.g, TimeOfDay.getRandom(AGame.ANIM_R));
        Utils.Pair<LandFormation, List<LandFormation>> p = LandFormation.generate(AGame.ANIM_R);
        c.landFormations.add((LandFormation)p.a);
        if (AGame.ANIM_R.nextInt(4) == 1) {
            c.landFormations.addAll((Collection)p.b);
        }
        c.backgroundFlavor = CombatBackgroundFlavor.values()[AGame.ANIM_R.nextInt(CombatBackgroundFlavor.values().length)];
        UniScreen us = new UniScreen(this.g, new SingleCombatIntent());
        us.combat = c;
        us.mySide = c.sides.get(0);
        us.attractMode = true;
        us.hideUI = true;
        us.button(FollowActionButton.class).follow = true;
        int limit = 300 + AGame.ANIM_R.nextInt(5000);
        int numShips = 1;
        if (AGame.ANIM_R.nextInt(3) == 1) {
            numShips += AGame.ANIM_R.nextInt(5);
        }
        File shipDir = new File(new File(AGame.getStaticGameDirectory(), "data"), "ships");
        for (Combat.Side s : c.sides) {
            s.usingAI = true;
            s.arms = CoatOfArms.getRandom();
            boolean leftSide = c.sides.indexOf(s) == 0;
            int cost = 0;
            int num = 0;
            block15: while (cost < limit && num < numShips) {
                File[] fs = shipDir.listFiles();
                File shipF = fs[AGame.ANIM_R.nextInt(fs.length)];
                BufferedReader r = null;
                try {
                    r = new BufferedReader(new FileReader(shipF));
                    Airship ship = new Airship(new JSONObject(new JSONTokener(r)));
                    ship.repair();
                    ship.name = AGame.ANIM_R.nextBoolean() ? AGame.getShipName() : AGame.getAIShipName();
                    ship.flipped = !leftSide;
                    boolean bl = ship.flipTo = !leftSide;
                    if (ship.getCost() > limit || ship.getCost() < limit / 4) continue;
                    for (int attempt = 0; attempt < 20; ++attempt) {
                        int x = AGame.ANIM_R.nextInt(1500);
                        x = leftSide ? (x -= 1600) : (x += 100);
                        int y = 512 - (AGame.ANIM_R.nextInt(7) + 3) * ship.serviceCeiling() / 10;
                        if (!PlaceShipTool.canPlace(ship, x, y, leftSide ? 0 : 1, us, false)) continue;
                        ship.x = x;
                        ship.y = y;
                        s.ships.add(ship);
                        cost += ship.getCost();
                        ship.networkID = (leftSide ? "left" : "right") + num;
                        ++num;
                        continue block15;
                    }
                }
                catch (Exception e) {}
                continue;
                finally {
                    try {
                        r.close();
                    }
                    catch (Exception e) {}
                }
            }
        }
        for (Combat.Side s : c.sides) {
            Combat.Side otherSide = c.otherSide(s);
            for (Airship ship : s.ships) {
                ship.ai = new TacticalAI(ship, c, s, otherSide);
            }
        }
        this.g.s = us;
    }

    public void startMultiplayer() {
        Client cl = new Client(this.g.integration.backend.getMultiplayerServer(), this.g);
        cl.start();
        this.g.s = new MetaLobbyScreen(this.g, cl, null, SteamBackend.isEnabled() ? SteamBackend.getSteamNickDisplayName() : this.g.integration.username);
    }

    public void showLoginDialog() {
        this.loginDialog = true;
        this.registerDialog = false;
        this.usernameF.focus = true;
        this.passwordF.focus = false;
        this.password2F.focus = false;
        this.emailF.focus = false;
        this.codeF.focus = false;
        this.usernameF.reset();
    }

    public void showLinkDialog() {
        this.linkDialog = true;
        this.registerDialog = false;
        this.usernameF.focus = true;
        this.passwordF.focus = false;
        this.password2F.focus = false;
        this.emailF.focus = false;
        this.codeF.focus = false;
        this.usernameF.reset();
    }

    public void showRegisterDialog() {
        String code;
        this.loginDialog = false;
        this.registerDialog = true;
        this.usernameF.focus = true;
        this.passwordF.focus = false;
        this.password2F.focus = false;
        this.emailF.focus = false;
        this.codeF.focus = false;
        this.usernameF.reset();
        if (this.codeF.text.isEmpty() && (code = AGame.getCodeFromClipboard()) != null) {
            this.codeF.text = code;
        }
    }

    public int renderFields(final TextField[] fs, String[] ns, int x, int y, MyDraw d, ScreenMode sm, Hooks hs, Pt cursor) {
        for (int i = 0; i < fs.length; ++i) {
            d.text(ns[i], AGame.FOUNT, x, y + 5);
            fs[i].render(x + 150 + 3, y, 150, d, sm, hs, cursor);
            final TextField f = fs[i];
            d.hook(x + 155, y, 130.0, 20.0, new Hook(new Hook.Type[]{Hook.Type.MOUSE_1_CLICKED}){

                public void run(Input in, Pt p, Hook.Type type) {
                    for (TextField tf : fs) {
                        tf.focus = false;
                    }
                    f.focus = true;
                }
            });
            y += 27;
        }
        return y;
    }

    public void renderLoginDialog(MyDraw d, ScreenMode sm, Hooks hs, Pt cursor) {
        int w = 327;
        int h = 90 + AGame.BIG_FOUNT.lineHeight + 24;
        int x = sm.width / 2 - w / 2;
        int y = sm.height / 2 - h / 2;
        d.drawShadowedWindow(x, y, w, h);
        d.text(Lang._t("LOGIN", new Object[0]), AGame.BIG_FOUNT, x += 12, y += 12);
        y += AGame.BIG_FOUNT.lineHeight;
        y = this.renderFields(this.loginFields, this.loginFieldNames, x, y, d, sm, hs, cursor);
        d.button(x, y += 12, 150, Lang._t("Cancel", new Object[0]), null, new Runnable(){

            @Override
            public void run() {
                MainMenu.this.loginDialog = false;
            }
        });
        d.button(x + 150 + 3, y, 150, Lang._t("Login", new Object[0]), null, new Runnable(){

            @Override
            public void run() {
                ((MainMenu)MainMenu.this).g.integration.login(((MainMenu)MainMenu.this).usernameF.text, ((MainMenu)MainMenu.this).passwordF.text);
                MainMenu.this.loginDialog = false;
            }
        }, !this.usernameF.text.isEmpty() && !this.passwordF.text.isEmpty());
    }

    public void renderLinkDialog(MyDraw d, ScreenMode sm, Hooks hs, Pt cursor) {
        int w = 327;
        int h = 90 + AGame.BIG_FOUNT.lineHeight + 24;
        int x = sm.width / 2 - w / 2;
        int y = sm.height / 2 - h / 2;
        d.drawShadowedWindow(x, y, w, h);
        d.text(Lang._t("Link_with_forum_account", new Object[0]), AGame.BIG_FOUNT, x += 12, y += 12);
        y += AGame.BIG_FOUNT.lineHeight;
        y = this.renderFields(this.linkFields, this.linkFieldNames, x, y, d, sm, hs, cursor);
        d.button(x, y += 12, 150, "Cancel", null, new Runnable(){

            @Override
            public void run() {
                MainMenu.this.linkDialog = false;
            }
        });
        d.button(x + 150 + 3, y, 150, "Link Account", null, new Runnable(){

            @Override
            public void run() {
                ((MainMenu)MainMenu.this).g.integration.steamLinkUser(((MainMenu)MainMenu.this).usernameF.text, ((MainMenu)MainMenu.this).passwordF.text);
                MainMenu.this.linkDialog = false;
            }
        }, !this.usernameF.text.isEmpty() && !this.passwordF.text.isEmpty());
    }

    public void renderRegisterDialog(MyDraw d, ScreenMode sm, Hooks hs, Pt cursor) {
        int w = 327;
        int h = 171 + AGame.BIG_FOUNT.lineHeight + 24;
        int x = sm.width / 2 - w / 2;
        int y = sm.height / 2 - h / 2;
        d.drawShadowedWindow(x, y, w, h);
        d.text(Lang._t("REGISTER", new Object[0]), AGame.BIG_FOUNT, x += 12, y += 12);
        y += AGame.BIG_FOUNT.lineHeight;
        this.password2F.showValid = this.password2F.text.isEmpty() || this.password2F.text.equals(this.passwordF.text);
        y = this.renderFields(this.registerFields, this.registerFieldNames, x, y, d, sm, hs, cursor);
        d.button(x, y += 12, 150, Lang._t("Cancel", new Object[0]), null, new Runnable(){

            @Override
            public void run() {
                MainMenu.this.registerDialog = false;
            }
        });
        d.button(x + 150 + 3, y, 150, Lang._t("Register", new Object[0]), null, new Runnable(){

            @Override
            public void run() {
                ((MainMenu)MainMenu.this).g.integration.register(((MainMenu)MainMenu.this).usernameF.text.trim(), ((MainMenu)MainMenu.this).passwordF.text, ((MainMenu)MainMenu.this).emailF.text, ((MainMenu)MainMenu.this).codeF.text);
                MainMenu.this.registerDialog = false;
            }
        }, !this.usernameF.text.trim().isEmpty() && !this.passwordF.text.isEmpty() && !this.password2F.text.isEmpty() && !this.emailF.text.isEmpty() && !this.codeF.text.isEmpty() && this.passwordF.text.equals(this.password2F.text));
    }

    public void renderCodeDialog(MyDraw d, ScreenMode sm, Hooks hs, Pt cursor) {
        int w = 327;
        int h = 63 + AGame.BIG_FOUNT.lineHeight + 24;
        int x = sm.width / 2 - w / 2;
        int y = sm.height / 2 - h / 2;
        d.drawShadowedWindow(x, y, w, h);
        d.text(Lang._t("REGISTRATION_CODE_REQUIRED", new Object[0]), AGame.BIG_FOUNT, x += 12, y += 12);
        y += AGame.BIG_FOUNT.lineHeight;
        y = this.renderFields(this.codeFields, this.codeFieldNames, x, y, d, sm, hs, cursor);
        d.button(x, y, 150, Lang._t("Logout", new Object[0]), null, new Runnable(){

            @Override
            public void run() {
                ((MainMenu)MainMenu.this).g.integration.logout();
            }
        });
        d.button(x + 150 + 3, y, 150, Lang._t("Add_Code", new Object[0]), null, new Runnable(){

            @Override
            public void run() {
                ((MainMenu)MainMenu.this).g.integration.addCode(((MainMenu)MainMenu.this).codeF.text);
            }
        }, !this.codeF.text.isEmpty());
    }

    public void renderPhoneHomeDialog(MyDraw d, ScreenMode sm, Hooks hs, Pt cursor) {
        int w = 527;
        int h = 2 * AGame.FOUNT.lineHeight + 12 + 24 + 24;
        int x = sm.width / 2 - w / 2;
        int y = sm.height / 2 - h / 2;
        d.drawShadowedWindow(x, y, w, h);
        d.text(Lang._t("send_back_q", new Object[0]), AGame.FOUNT, x += 12, y += 12, w - 24);
        d.button(x, y += AGame.FOUNT.lineHeight * 2 + 12, 250, Lang._t("Yes_send_crash_reports", new Object[0]), "Y", new Runnable(){

            @Override
            public void run() {
                ((MainMenu)MainMenu.this).g.phoneHomeAsked = true;
                ((MainMenu)MainMenu.this).g.phoneHomeWithErrors = true;
                MainMenu.this.g.saveSettings();
            }
        });
        d.button(x + 250 + 3, y, 250, Lang._t("No_dont_send_them", new Object[0]), "N", new Runnable(){

            @Override
            public void run() {
                ((MainMenu)MainMenu.this).g.phoneHomeAsked = true;
                ((MainMenu)MainMenu.this).g.phoneHomeWithErrors = false;
                MainMenu.this.g.saveSettings();
            }
        });
    }

    public void renderFeedbackDialog(MyDraw d, ScreenMode sm, Hooks hs, Pt cursor) {
        int w = 324;
        int h = 236 + AGame.BIG_FOUNT.lineHeight + 24;
        int x = sm.width / 2 - w / 2;
        int y = sm.height / 2 - h / 2;
        d.drawShadowedWindow(x, y, w, h);
        d.text(Lang._t("FEEDBACK", new Object[0]), AGame.BIG_FOUNT, x += 12, y += 12);
        this.feedbackF.render(x, y += AGame.BIG_FOUNT.lineHeight, 300, 200, d, sm, hs, cursor);
        d.button(x, y += 212, 150, Lang._t("Cancel", new Object[0]), null, new Runnable(){

            @Override
            public void run() {
                MainMenu.this.feedbackDialog = false;
            }
        });
        d.button(x + 150 + 3, y, 150, Lang._t("Send", new Object[0]), null, new Runnable(){

            @Override
            public void run() {
                ((MainMenu)MainMenu.this).g.integration.sendFeedback(((MainMenu)MainMenu.this).feedbackF.text);
                ((MainMenu)MainMenu.this).feedbackF.text = "";
                MainMenu.this.feedbackDialog = false;
            }
        }, !this.feedbackF.text.isEmpty());
    }

    public void renderSteamIntegration(MyDraw d, ScreenMode sm, Hooks hs, Pt cursor) {
        CoatOfArms coa;
        d.drawTopBar(sm);
        d.drawPanel(3, 3, 108, 108);
        CoatOfArms coatOfArms = coa = this.g.isIntegrated() ? this.g.integration.registeredCoatOfArms : null;
        if (coa == null) {
            d.rect(Clr.DARK_GREY, 9.0, 9.0, 96.0, 96.0);
        } else {
            coa.draw(d, 9.0, 9.0, 96);
        }
        int x = 123;
        d.text(SteamBackend.getSteamNickDisplayName(), AGame.BIG_FOUNT, x, 12.0);
        if (this.g.isIntegrated() && this.g.integration.steamUnlinked && !this.g.integration.linkingUser) {
            d.button(x + 200, 11, 200, Lang._t("Link_with_forum_account", new Object[0]), "L", new Runnable(){

                @Override
                public void run() {
                    MainMenu.this.showLinkDialog();
                }
            });
        }
        if (this.g.isIntegrated()) {
            if (this.g.integration.errorMessage != null && this.g.integration.ticksSinceErrorMessage < 900) {
                d.text(this.g.integration.errorMessage, AGame.FOUNT, x + 200, 12.0);
            } else if (this.g.integration.linkingUser) {
                d.text(Lang._t("Linking_", new Object[0]), AGame.BIG_FOUNT, x + 200, 12.0);
            }
        }
        d.button(3, 114, 108, Lang._t("Edit_Arms", new Object[0]), "A", new Runnable(){

            @Override
            public void run() {
                ((MainMenu)MainMenu.this).g.s = new CoatEditor(MainMenu.this.g, true);
            }
        });
    }

    public void renderIntegration(MyDraw d, ScreenMode sm, Hooks hs, Pt cursor) {
        d.drawTopBar(sm);
        d.drawPanel(3, 3, 108, 108);
        CoatOfArms coa = this.g.integration.registeredCoatOfArms;
        if (coa == null) {
            d.rect(Clr.DARK_GREY, 9.0, 9.0, 96.0, 96.0);
        } else {
            coa.draw(d, 9.0, 9.0, 96);
        }
        int x = 123;
        switch (this.g.integration.getState()) {
            case LOGGED_IN: {
                d.text(this.g.integration.username, AGame.BIG_FOUNT, x, 12.0);
                d.button(x + 100, 11, 100, Lang._t("Logout", new Object[0]), "L", new Runnable(){

                    @Override
                    public void run() {
                        ((MainMenu)MainMenu.this).g.integration.logout();
                    }
                });
                d.button(3, 114, 108, Lang._t("Edit_Arms", new Object[0]), "A", new Runnable(){

                    @Override
                    public void run() {
                        ((MainMenu)MainMenu.this).g.s = new CoatEditor(MainMenu.this.g, true);
                    }
                });
                break;
            }
            case LOGGED_OUT: {
                d.button(x, 11, 100, Lang._t("Login", new Object[0]), "L", new Runnable(){

                    @Override
                    public void run() {
                        MainMenu.this.showLoginDialog();
                    }
                });
                d.button(x + 100 + 3, 11, 100, Lang._t("Register", new Object[0]), "R", new Runnable(){

                    @Override
                    public void run() {
                        MainMenu.this.showRegisterDialog();
                    }
                });
                break;
            }
            case LOGGING_IN: {
                d.text(Lang._t("Logging_in_", new Object[0]), AGame.BIG_FOUNT, x, 12.0);
                break;
            }
            case REGISTERING: {
                d.text(Lang._t("Registering_", new Object[0]), AGame.BIG_FOUNT, x, 12.0);
            }
        }
        if (this.g.integration.errorMessage != null && this.g.integration.ticksSinceErrorMessage < 900) {
            d.text(this.g.integration.errorMessage, AGame.BIG_FOUNT, x + 200 + 24, 11.0);
        }
    }

    @Override
    public void render(MyDraw d, ScreenMode sm, Hooks hs, Pt cursor) {
        d.drawBG(AGame.CAST_IRON, sm);
        if (this.scrollingDesign != null) {
            d.scale(8.0, 8.0);
            this.scrollingDesign.drawAsBlueprint(d, this.scrollDesignX, this.scrollDesignY, 0, false, (float)Math.min(5000.0, 10000.0 - Math.abs(this.scrollDesignTime - 10000.0)) * 2.0E-5f);
            d.resetTransforms();
        }
        int x = 123;
        int y = 55;
        d.text("[f5edb5]AIRSHIPS", AGame.HUGE_FOUNT, x, y);
        d.text("[f5edb5]" + Lang._t("a_game_by_david_stark", new Object[0]) + "\n" + "v" + "7.1.1" + (Appearance.shaderLoadFailed ? " [ff6666]" + Lang._t("Graphics_card_incompatible", new Object[0]) : ""), AGame.BIG_FOUNT, x, y += 64);
        int sideX = x + 150 + 12;
        int sideY = y += AGame.BIG_FOUNT.lineHeight * 2 + 12;
        int sideW = sm.width - sideX - 10;
        if (sideW > 600) {
            sideW = 600;
            sideX = sm.width - sideW - 10;
        }
        int textW = sideW - 24;
        if (this.g.integration.hasNews) {
            String newsText = this.g.integration.newsTitle.toUpperCase() + "\n" + this.g.integration.newsText;
            Rect newsSz = d.textSize(newsText, AGame.FOUNT, 0.0, 0.0, textW);
            if (this.g.integration.newsLink != null && this.g.integration.newsLink.startsWith("http")) {
                newsSz = new Rect(newsSz.x, newsSz.y, newsSz.width, newsSz.height + 24.0 + 3.0);
            }
            d.drawWindow(sideX, sideY, sideW, (int)newsSz.height + 24);
            d.text(newsText, AGame.FOUNT, sideX + 12, sideY + 12, textW);
            if (this.g.integration.newsLink != null && this.g.integration.newsLink.startsWith("http")) {
                d.button(sideX + 12, sideY + 12 + (int)newsSz.height - 24, 50, Lang._t("Link", new Object[0]), new InputRunnable(){

                    @Override
                    public void run(Input in) {
                        try {
                            Desktop.getDesktop().browse(new URI(((MainMenu)MainMenu.this).g.integration.newsLink));
                            in.quit();
                            System.exit(0);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                });
            }
            sideY += (int)newsSz.height + 24 + 12;
        }
        Rect textSz = d.textSize(MainMenu.getIntroText(), AGame.FOUNT, 0.0, 0.0, textW);
        d.drawWindow(sideX, sideY, sideW, (int)textSz.height + 24 + 24 + 3);
        d.text(MainMenu.getIntroText(), AGame.FOUNT, sideX + 12, sideY + 12, textW);
        if (this.g.isIntegrated()) {
            d.button(sideX + 12, sideY + 12 + (int)textSz.height + 3, 150, Lang._t("Forums", new Object[0]), null, new InputRunnable(){

                @Override
                public void run(Input in) {
                    boolean close = in.mode().fullscreen;
                    if (close) {
                        in.setMode(new ScreenMode(800, 600, false));
                        in.quit();
                    }
                    ((MainMenu)MainMenu.this).g.integration.gotoForums();
                }
            });
            d.button(sideX + 12 + 150 + 3, sideY + 12 + (int)textSz.height + 3, 150, Lang._t("Send_Feedback", new Object[0]), null, new InputRunnable(){

                @Override
                public void run(Input in) {
                    MainMenu.this.feedbackDialog = true;
                }
            });
        }
        d.button(x, y, 150, Lang._t("New_Game", new Object[0]), "N", new Runnable(){

            @Override
            public void run() {
                ((MainMenu)MainMenu.this).g.s = new GameSetupScreen(MainMenu.this.g);
            }
        });
        d.button(x, y += 27, 150, Lang._t("Open_Game", new Object[0]), "O", new Runnable(){

            @Override
            public void run() {
                StrategicScreen ss = new StrategicScreen(MainMenu.this.g, null);
                ss.open(true);
            }
        });
        d.button(x, y += 27, 150, Lang._t("Combat", new Object[0]), "C", new Runnable(){

            @Override
            public void run() {
                MainMenu.this.setupSingleCombat();
            }
        });
        y += 27;
        if (AGame.isDebug()) {
            d.button(x, y, 150, "Standard Combat", null, new Runnable(){

                @Override
                public void run() {
                    MainMenu.this.setupConsistentSC();
                }
            });
            y += 27;
        }
        d.button(x, y, 150, Lang._t("Airship_Editor", new Object[0]), "E", new Runnable(){

            @Override
            public void run() {
                UniScreen us = new UniScreen(MainMenu.this.g, new StandaloneEditShipIntent());
                us.standaloneEditShip = new Airship(ShipType.AIRSHIP);
                ((MainMenu)MainMenu.this).g.s = us;
            }
        });
        d.button(x, y += 27, 150, Lang._t("Building_Editor", new Object[0]), "B", new Runnable(){

            @Override
            public void run() {
                UniScreen us = new UniScreen(MainMenu.this.g, new StandaloneEditShipIntent());
                us.standaloneEditShip = new Airship(ShipType.BUILDING);
                ((MainMenu)MainMenu.this).g.s = us;
            }
        });
        d.button(x, y += 27, 150, Lang._t("Landship_Editor", new Object[0]), "L", new Runnable(){

            @Override
            public void run() {
                UniScreen us = new UniScreen(MainMenu.this.g, new StandaloneEditShipIntent());
                us.standaloneEditShip = new Airship(ShipType.LANDSHIP);
                ((MainMenu)MainMenu.this).g.s = us;
            }
        });
        d.button(x, y += 27, 150, Lang._t("Online_Multiplayer", new Object[0]), "M", new Runnable(){

            @Override
            public void run() {
                MainMenu.this.startMultiplayer();
            }
        }, this.g.isIntegrated() && (this.g.integration.getState() == Integration.State.LOGGED_IN || this.g.integration.getState() == Integration.State.STEAM) && this.g.integration.backend.getMultiplayerServer() != null);
        d.button(x, y += 27, 150, Lang._t("Schedule_Match_", new Object[0]), null, new InputRunnable(){

            @Override
            public void run(Input in) {
                ((MainMenu)MainMenu.this).g.integration.gotoCalendar();
                boolean close = in.mode().fullscreen;
                if (close) {
                    in.setMode(new ScreenMode(800, 600, false));
                    in.quit();
                }
            }
        }, Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE) && this.g.isIntegrated() && this.g.integration.getState() == Integration.State.LOGGED_IN && this.g.integration.backend.getMultiplayerServer() != null);
        d.button(x, y += 27, 150, Lang._t("Host_LAN_Game", new Object[0]), "H", new Runnable(){

            @Override
            public void run() {
                ((MainMenu)MainMenu.this).g.s = new HostOrJoinGameScreen(true, MainMenu.this.g);
            }
        });
        d.button(x, y += 27, 150, Lang._t("Join_LAN_Game", new Object[0]), "J", new Runnable(){

            @Override
            public void run() {
                ((MainMenu)MainMenu.this).g.s = new HostOrJoinGameScreen(false, MainMenu.this.g);
            }
        });
        d.button(x, y += 27, 150, Lang._t("Settings", new Object[0]), "S", new Runnable(){

            @Override
            public void run() {
                ((MainMenu)MainMenu.this).g.s = new SettingsScreen(MainMenu.this.g);
            }
        });
        d.button(x, y += 27, 150, Lang._t("Achievements", new Object[0]), null, new Runnable(){

            @Override
            public void run() {
                ((MainMenu)MainMenu.this).g.s = new AchievementsScreen(MainMenu.this.g);
            }
        });
        d.button(x, y += 27, 150, Lang._t("Credits", new Object[0]), null, new Runnable(){

            @Override
            public void run() {
                ((MainMenu)MainMenu.this).g.s = new CreditsScreen(MainMenu.this.g);
            }
        });
        d.button(x, y += 27, 150, Lang._t("Quit", new Object[0]), "Q", new Runnable(){

            @Override
            public void run() {
                ((MainMenu)MainMenu.this).g.exit = true;
            }
        });
        y += 27;
        if (!SteamBackend.isEnabled() && this.g.isIntegrated()) {
            this.renderIntegration(d, sm, hs, cursor);
            if (this.g.integration.getState() == Integration.State.REQUIRE_CODE) {
                d.getHooks().list.clear();
                this.renderCodeDialog(d, sm, hs, cursor);
            } else if (this.feedbackDialog) {
                this.renderFeedbackDialog(d, sm, hs, cursor);
            } else if (this.loginDialog) {
                this.renderLoginDialog(d, sm, hs, cursor);
            } else if (this.registerDialog) {
                this.renderRegisterDialog(d, sm, hs, cursor);
            }
        } else {
            if (SteamBackend.isEnabled()) {
                this.renderSteamIntegration(d, sm, hs, cursor);
            }
            if (this.g.isIntegrated() && this.feedbackDialog) {
                this.renderFeedbackDialog(d, sm, hs, cursor);
            } else if (this.g.isIntegrated() && this.linkDialog) {
                this.renderLinkDialog(d, sm, hs, cursor);
            }
        }
        if (!this.g.phoneHomeAsked) {
            this.renderPhoneHomeDialog(d, sm, hs, cursor);
        }
        if (this.g.prevUserFirstTimev5) {
            d.getHooks().list.clear();
            d.messageDialog(sm.width / 2 - 300, sm.height / 4, 600, Lang._t("v5_message", new Object[0]), new Runnable(){

                @Override
                public void run() {
                    ((MainMenu)MainMenu.this).g.prevUserFirstTimev5 = false;
                }
            });
        }
    }

    @Override
    public ArrayList<String> music() {
        return this.afterBoot ? null : AGame.MENU_MUSIC;
    }

    @Override
    public String appearancePostfix() {
        return "BLUEPRINT";
    }

    @Override
    public boolean alwaysUseAppearancePostfix() {
        return false;
    }
}

