/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.AirshipGame;
import com.zarkonnen.airships.ChatAdapter;
import com.zarkonnen.airships.ChatMsg;
import com.zarkonnen.airships.Client;
import com.zarkonnen.airships.CoatOfArms;
import com.zarkonnen.airships.HostOrJoinGameScreen;
import com.zarkonnen.airships.InputRunnable;
import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.MainMenu;
import com.zarkonnen.airships.MultiplayerSetupIntent;
import com.zarkonnen.airships.MyDraw;
import com.zarkonnen.airships.PlayerInfo;
import com.zarkonnen.airships.Screen;
import com.zarkonnen.airships.ScrollBar;
import com.zarkonnen.airships.Server;
import com.zarkonnen.airships.TextField;
import com.zarkonnen.airships.TimeOfDay;
import com.zarkonnen.airships.UniScreen;
import com.zarkonnen.catengine.Fount;
import com.zarkonnen.catengine.Hooks;
import com.zarkonnen.catengine.Input;
import com.zarkonnen.catengine.util.Clr;
import com.zarkonnen.catengine.util.Pt;
import com.zarkonnen.catengine.util.ScreenMode;
import java.util.ArrayList;
import java.util.HashMap;
import org.json.JSONArray;
import org.json.JSONObject;

public class MetaLobbyScreen
implements Screen {
    public static final Clr ALT = new Clr(44, 44, 44);
    private final CoatOfArms myArms;
    private final AirshipGame g;
    private final Client client;
    private final Server server;
    private int myID;
    private final String name;
    private boolean welcomeReceived = false;
    private boolean helloSent = false;
    private boolean channelsLoaded = false;
    private boolean joining = false;
    private final HashMap<Integer, PlayerInfo> players = new HashMap();
    private final ArrayList<ChatMsg> chat = new ArrayList();
    private final ArrayList<ChannelInfo> channels = new ArrayList();
    private final TextField chatField = new TextField();
    private String error;
    private boolean leaveAfterErrorDismiss;
    private boolean setupDialog;
    private final TextField gameNameField = new TextField();
    private int gameLimit = 2000;
    private boolean oneShipOnly = false;
    private int gameRefreshTimer = 0;
    public static final int GAME_REFRESH_INTERVAL = 3000;
    private final ScrollBar channelScrollBar = new ScrollBar();
    private final ScrollBar chatScrollBar = new ScrollBar();
    private final ChannelAdapter channelAdapter = new ChannelAdapter();
    private final ChatAdapter chatAdapter = new ChatAdapter();

    public MetaLobbyScreen(AirshipGame g, Client client, Server server, String name) {
        this.g = g;
        this.client = client;
        this.server = server;
        this.name = name;
        this.myArms = g.getBestCOA();
    }

    private void refreshChannels() {
        this.client.sendMessage(Client.msg("listChannels"));
    }

    @Override
    public void input(Input in, MyDraw.State drawState, Pt cursor, Pt click, int ms) {
        if (this.error != null) {
            return;
        }
        ScreenMode sm = in.mode();
        this.channelScrollBar.tick(in, 10, 55, 500, sm.height - 43 - 12 - 10);
        this.chatScrollBar.tick(in, 522, 55, sm.width - 500 - 12 - 20, sm.height - 43 - 12 - 10 - 24 - 3);
        if (in.keyPressed("ESCAPE")) {
            if (this.setupDialog) {
                this.setupDialog = false;
            } else {
                this.leave();
                return;
            }
        }
        if (this.client.connectionFailed() || this.client.isDisconnected()) {
            this.error = Lang._t("mp_server_conn_failed", new Object[0]);
            this.leaveAfterErrorDismiss = true;
        }
        if (this.client.isConnected()) {
            JSONObject msg;
            this.gameRefreshTimer += ms;
            if (!this.channelsLoaded || this.gameRefreshTimer >= 3000) {
                this.refreshChannels();
                this.channelsLoaded = true;
                this.gameRefreshTimer = 0;
            }
            if (this.welcomeReceived && !this.helloSent) {
                this.client.sendMessage(Client.msg("hello").put("name", this.name).put("id", this.myID).put("arms", this.myArms.toJSON()));
                this.helloSent = true;
            }
            if ((msg = this.client.pollMessage()) != null) {
                int i;
                if (msg.get("type").equals("welcome")) {
                    if (msg.getInt("channelID") == 0) {
                        this.myID = msg.getInt("playerID");
                        this.welcomeReceived = true;
                    } else {
                        MultiplayerSetupIntent mpsi = new MultiplayerSetupIntent(msg.getBoolean("flipped"), this.client, this.server, this.name, this.myArms, msg.getJSONObject("info").getInt("costLimit"), msg.getJSONObject("info").optBoolean("oneShipOnly", false));
                        mpsi.myID = msg.getInt("playerID");
                        mpsi.seed = msg.getLong("seed");
                        mpsi.channelID = msg.getInt("channelID");
                        mpsi.leaveToMetaLobby = true;
                        mpsi.welcomeReceived = true;
                        UniScreen us = new UniScreen(this.g, mpsi);
                        us.setupFleet = new ArrayList();
                        mpsi.genGround(us);
                        this.g.s = us;
                        return;
                    }
                }
                if (msg.get("type").equals("reject")) {
                    this.error = "Unable to join channel.";
                    this.joining = false;
                }
                if (msg.get("type").equals("channelList")) {
                    JSONArray l = msg.getJSONArray("channels");
                    this.channels.clear();
                    for (i = 0; i < l.length(); ++i) {
                        JSONObject o = l.getJSONObject(i);
                        int id = o.getInt("id");
                        if (id == 0 || o.getInt("players") <= 0) continue;
                        this.channels.add(new ChannelInfo(id, o.getJSONObject("info"), o.getInt("players")));
                    }
                }
                if (msg.getString("type").equals("frame")) {
                    JSONArray frameMessages = msg.getJSONArray("messages");
                    for (i = 0; i < frameMessages.length(); ++i) {
                        PlayerInfo pi;
                        JSONObject fm = frameMessages.getJSONObject(i);
                        if (fm.getString("type").equals("hello") && !this.players.containsKey(fm.getInt("id"))) {
                            pi = new PlayerInfo(fm.getInt("id"), fm.getString("name"));
                            pi.arms = new CoatOfArms(fm.getJSONObject("arms"));
                            this.players.put(pi.id, pi);
                            in.play("ready", 1.0, 1.0 * this.g.volume, 0.0, 0.0);
                            this.chat.add(new ChatMsg(pi, Lang._t("xxx_JOINED_xxx", pi.name)));
                            if (pi.id != this.myID) {
                                this.helloSent = false;
                            }
                        }
                        if (fm.getString("type").equals("leave") && (pi = this.players.get(fm.getInt("id"))) != null) {
                            this.chat.add(new ChatMsg(pi, Lang._t("xxx_LEFT_xxx", pi.name)));
                            this.players.remove(fm.getInt("id"));
                        }
                        if (fm.getString("type").equals("createGame") && (pi = this.players.get(fm.getInt("id"))) != null) {
                            this.chat.add(new ChatMsg(pi, Lang._t("xxx_NEW_GAME_xxx", pi.name, fm.getString("name"))));
                            this.players.remove(fm.getInt("id"));
                            this.gameRefreshTimer = 3000;
                        }
                        if (!fm.getString("type").equals("chat") || (pi = this.players.get(fm.getInt("id"))) == null) continue;
                        this.chat.add(new ChatMsg(pi, pi.name + ": " + fm.getString("text")));
                    }
                }
            }
            if (this.setupDialog) {
                this.gameNameField.input(in, drawState, cursor, click, ms);
                if (in.keyPressed("ENTER") && drawState.canClick() && !this.gameNameField.text.isEmpty()) {
                    this.doCreateGame(this.gameNameField.text, this.gameLimit, this.oneShipOnly);
                    drawState.hasClicked();
                    this.setupDialog = false;
                }
            } else {
                this.chatField.input(in, drawState, cursor, click, ms);
                if (in.keyDown("ENTER") && drawState.canClick() && !this.chatField.text.isEmpty()) {
                    this.sendChat();
                }
            }
        }
    }

    private void leave() {
        if (this.client.isConnected()) {
            this.client.sendMessage(Client.msg("leave").put("id", this.myID));
        }
        this.client.close();
        if (this.server != null) {
            this.server.close();
        }
        this.g.s = new MainMenu(this.g);
    }

    private void sendChat() {
        this.client.sendMessage(Client.msg("chat").put("id", this.myID).put("text", this.chatField.text));
        this.chatField.text = "";
    }

    private void createGame() {
        this.setupDialog = true;
        this.gameNameField.focus = true;
        this.gameNameField.reset();
    }

    private void doCreateGame(String name, int costLimit, boolean oneShipOnly) {
        this.joining = true;
        this.client.sendMessage(Client.msg("createGame").put("id", this.myID).put("name", name));
        this.client.sendMessage(Client.msg("createChannel").put("info", new JSONObject().put("name", name).put("costLimit", costLimit).put("oneShipOnly", oneShipOnly).put("version", 7110)));
    }

    public void renderSetupDialog(MyDraw d, ScreenMode sm, Hooks hs, Pt cursor) {
        this.gameNameField.help = Lang._t("Name", new Object[0]);
        int w = 264;
        int h = AGame.FOUNT.lineHeight * 2 + AGame.BIG_FOUNT.lineHeight + 27 * (HostOrJoinGameScreen.COST_LIMITS.length + 4) + 36 - 6;
        int x = sm.width / 2 - w / 2;
        int y = sm.height / 2 - h / 2;
        d.drawShadowedWindow(x, y, w, h);
        d.text(Lang._t("Create_Game", new Object[0]), AGame.BIG_FOUNT, x += 12, y += 12);
        this.gameNameField.render(x, y += AGame.BIG_FOUNT.lineHeight, 240, d, sm, hs, cursor);
        d.text(Lang._t("Max_Fleet_Cost", new Object[0]), AGame.FOUNT, x, y += 36);
        y += AGame.FOUNT.lineHeight;
        for (int i = 0; i < HostOrJoinGameScreen.COST_LIMITS.length; ++i) {
            final int ii = i;
            d.toggle(x, y, 240, "" + HostOrJoinGameScreen.COST_LIMITS[i], null, new InputRunnable(){

                @Override
                public void run(Input in) {
                    MetaLobbyScreen.this.gameLimit = HostOrJoinGameScreen.COST_LIMITS[ii];
                }
            }, this.gameLimit == HostOrJoinGameScreen.COST_LIMITS[i], true);
            y += 27;
        }
        d.toggle(x, y += 9, 240, Lang._t("One_Ship_Only", new Object[0]), null, new InputRunnable(){

            @Override
            public void run(Input in) {
                MetaLobbyScreen.this.oneShipOnly = !MetaLobbyScreen.this.oneShipOnly;
            }
        }, this.oneShipOnly, true);
        d.button(x, y += 36, 240, Lang._t("Create_Game", new Object[0]), null, new Runnable(){

            @Override
            public void run() {
                MetaLobbyScreen.this.doCreateGame(((MetaLobbyScreen)MetaLobbyScreen.this).gameNameField.text, MetaLobbyScreen.this.gameLimit, MetaLobbyScreen.this.oneShipOnly);
                MetaLobbyScreen.this.setupDialog = false;
            }
        }, !this.gameNameField.text.isEmpty());
        d.button(x, y += 27, 240, Lang._t("Cancel", new Object[0]), null, new Runnable(){

            @Override
            public void run() {
                MetaLobbyScreen.this.setupDialog = false;
            }
        });
    }

    @Override
    public void render(MyDraw d, ScreenMode sm, Hooks hs, Pt cursor) {
        d.rect(AGame.SKY, 0.0, 0.0, sm.width, sm.height);
        d.drawBG(AGame.CAST_IRON, sm);
        d.drawTopBar(sm);
        d.button(sm.width - 120 - 10, 11, 120, Lang._t("Leave", new Object[0]), null, new InputRunnable(){

            @Override
            public void run(Input in) {
                MetaLobbyScreen.this.leave();
            }
        }, !this.joining);
        d.button(sm.width - 10 - 120 - 3 - 120, 11, 120, Lang._t("Create_Game", new Object[0]), null, new InputRunnable(){

            @Override
            public void run(Input in) {
                MetaLobbyScreen.this.createGame();
            }
        }, this.client.isConnected() && !this.joining);
        d.button(sm.width - 10 - 240 - 6 - 120, 11, 120, Lang._t("Refresh_List", new Object[0]), null, new InputRunnable(){

            @Override
            public void run(Input in) {
                MetaLobbyScreen.this.refreshChannels();
            }
        }, this.client.isConnected() && !this.joining);
        d.text(Lang._t("Online_Multiplayer_Games", new Object[0]), AGame.BIG_FOUNT, 10.0, 12.0);
        int x = 10;
        int y = 55;
        int w = 500;
        int h = sm.height - 43 - 10 - 12;
        this.channelScrollBar.draw(d, x, y, w, h, this.channels, this.channelAdapter);
        if (this.channels.isEmpty()) {
            d.text(this.channelsLoaded ? Lang._t("No_games_available_Create_one_", new Object[0]) : Lang._t("Loading_games_", new Object[0]), AGame.FOUNT, x + 6, y + 6);
        }
        x = 522;
        w = sm.width - x - 10;
        h = h - 24 - 3;
        this.chatScrollBar.draw(d, x, y, w, h, this.chat, this.chatAdapter);
        this.chatField.render(x, sm.height - 24 - 10, w - 80 - 3, d, sm, hs, cursor);
        d.button(sm.width - 80 - 10, sm.height - 24 - 10, 80, Lang._t("Send", new Object[0]), null, new InputRunnable(){

            @Override
            public void run(Input in) {
                MetaLobbyScreen.this.sendChat();
            }
        }, this.client.isConnected() && !this.joining);
        if (this.setupDialog) {
            d.getHooks().list.clear();
            this.renderSetupDialog(d, sm, hs, cursor);
        }
        if (this.error != null) {
            d.getHooks().list.clear();
            d.messageDialog(sm.width / 2 - 200, sm.height / 2 - 200, 400, this.error, new Runnable(){

                @Override
                public void run() {
                    MetaLobbyScreen.this.error = null;
                    if (MetaLobbyScreen.this.leaveAfterErrorDismiss) {
                        MetaLobbyScreen.this.leave();
                    }
                }
            });
        }
    }

    @Override
    public ArrayList<String> music() {
        return AGame.NO_MUSIC;
    }

    @Override
    public String appearancePostfix() {
        return TimeOfDay.DAY.name();
    }

    @Override
    public boolean alwaysUseAppearancePostfix() {
        return false;
    }

    private class ChannelAdapter
    implements ScrollBar.ScrollElementAdapter<ChannelInfo> {
        private ChannelAdapter() {
        }

        @Override
        public int getHeight(ChannelInfo ci, MyDraw d, int availableWidth) {
            return Math.max((int)d.textSize((String)ci.name, (Fount)AGame.FOUNT).y, 24) + 12 - AGame.FOUNT.lineHeight + AGame.FOUNT.height + 6;
        }

        @Override
        public void draw(final ChannelInfo ci, MyDraw d, int x, int y, int width) {
            int height = Math.max((int)d.textSize((String)ci.name, (Fount)AGame.FOUNT).y, 24) + 12 - AGame.FOUNT.lineHeight + AGame.FOUNT.height;
            d.drawPanel(x, y, width, height);
            d.text(ci.name, AGame.FOUNT, x + 6, y + 6);
            d.button(x + width - 6 - 60, y + 6, 60, Lang._t("Join", new Object[0]), null, new Runnable(){

                @Override
                public void run() {
                    MetaLobbyScreen.this.joining = true;
                    MetaLobbyScreen.this.client.sendMessage(Client.msg("changeChannel").put("id", ci.id));
                }
            }, !MetaLobbyScreen.this.joining && ci.canJoin());
        }
    }

    public static class ChannelInfo {
        public final String name;
        public final int id;
        public final JSONObject info;
        public final int players;

        public ChannelInfo(int id, JSONObject info, int players) {
            this.id = id;
            this.info = info;
            this.name = (players != 1 ? "[999999]" : "") + info.optString("name", Lang._t("Nameless_Channel", new Object[0])) + ", $" + info.optInt("costLimit", 0) + (info.optBoolean("oneShipOnly", false) ? ", " + Lang._t("One_Ship_Only", new Object[0]) : "") + "\n" + (info.optInt("version", 0) == 7110 ? "" : "[ff3333]") + (info.has("version") ? "v" + info.getInt("version") + " " : "Unknown Version ") + "[999999]" + (players != 1 ? Lang._t("In_Progress", new Object[0]) : "");
            this.players = players;
        }

        public boolean canJoin() {
            return this.players == 1 && this.info.optInt("version", 0) == 7110;
        }
    }
}

