/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.Bonus;
import com.zarkonnen.airships.Combat;
import com.zarkonnen.airships.CrewType;
import com.zarkonnen.airships.Crewman;
import com.zarkonnen.airships.Direction;
import com.zarkonnen.airships.Job;
import com.zarkonnen.airships.LandFormation;
import com.zarkonnen.airships.Leg;
import com.zarkonnen.airships.ModuleType;
import com.zarkonnen.airships.Particle;
import com.zarkonnen.airships.Resource;
import com.zarkonnen.airships.ShipList;
import com.zarkonnen.airships.Shot;
import com.zarkonnen.airships.Spring;
import com.zarkonnen.airships.Tile;
import com.zarkonnen.airships.TimeOfDay;
import com.zarkonnen.airships.Trail;
import com.zarkonnen.airships.WeatherEffect;
import com.zarkonnen.airships.Wheel;
import com.zarkonnen.catengine.util.Pt;
import com.zarkonnen.catengine.util.Utils;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;
import org.json.JSONObject;

public strictfp class Module {
    public static final double ADJACENCY_BONUS = 0.5;
    public static final double ADJ_BASE = 0.6;
    public static final int INITIAL_FIRE = 5;
    public static final double FIRE_INCREASE_RATIO = 1.0E-4;
    public static final double FIRE_DAMAGE_RATIO = 2.0E-4;
    public static final double FIRE_SPREAD_RATIO = 1.3;
    public static final double EXPLODE_P = 0.2;
    public ModuleType type;
    public Airship ship;
    public int x;
    public int y;
    public int animOffset = AGame.ANIM_R.nextInt(10000);
    public int variant = AGame.ANIM_R.nextInt(100);
    public transient ArrayList<Wheel> wheels = new ArrayList();
    public transient ArrayList<Leg> legs = new ArrayList();
    public transient int legIndex = -1;
    public transient int numGuardsTmp = 0;
    public transient boolean touchingGround;
    public transient double prevShipXForWheels;
    public int ammoLeft;
    public int shootAccumulator;
    public int msUntilCoal;
    public int fire = 0;
    public transient int maxHP;
    public int hp;
    public int lowestHP;
    public int time;
    public boolean fired = false;
    public boolean damageReported = false;
    public boolean armourDamageReported = false;
    public transient boolean hidden = false;
    public transient boolean noValidTarget;
    public transient int fireSoundCounter = 0;
    public transient int msUntilNextOnFireSound = 0;
    public transient int msUntilNextEngineSound = 0;
    public transient int msUntilNextSuspendiumSound = 0;
    public transient int msUntilNextComputerSound = 0;
    public transient double weaponAngle = 0.0;
    public transient double recoil = 0.0;
    private EnumMap<Resource, Integer> resources = new EnumMap(Resource.class);
    private ArrayList<Job> jobs = new ArrayList();
    private final Module self = this;
    public Airship prevTargetShip;
    public Tile prevTarget;
    public double prevXJitter;
    public double prevYJitter;
    public boolean hasPrevJitter;
    private static EnumSet<ModuleType> INTERESTING_MODULES = EnumSet.of(ModuleType.BRIDGE, new ModuleType[]{ModuleType.CANNON, ModuleType.GATLING_GUN, ModuleType.HV_CANNON, ModuleType.RIFLE, ModuleType.TELESCOPE});

    public ArrayList<Job> jobs() {
        return this.jobs;
    }

    public void calcMaxHP() {
        int i;
        this.maxHP = this.type.getHp();
        int adjacents = 0;
        for (i = 0; i < this.type.getW(); ++i) {
            if (this.ship.tileAt(this.x + i, this.y - 1) != null) {
                ++adjacents;
            }
            if (this.ship.tileAt(this.x + i, this.y + this.type.getH()) == null) continue;
            ++adjacents;
        }
        for (i = 0; i < this.type.getH(); ++i) {
            if (this.ship.tileAt(this.x - 1, this.y + i) != null) {
                ++adjacents;
            }
            if (this.ship.tileAt(this.x + this.type.getW(), this.y + i) == null) continue;
            ++adjacents;
        }
        this.maxHP = (int)Math.ceil((double)this.maxHP * (0.09999999999999998 + 1.0 * (double)adjacents / (double)(this.type.getW() * 2 + this.type.getH() / 2)));
        if (this.ship.constructionBonuses.contains((Object)Bonus.IMPROVED_WOOD_CONSTRUCTION)) {
            this.maxHP = this.maxHP * 5 / 4;
        }
        if (this.ship.constructionBonuses.contains((Object)Bonus.ARMOURED_TANKS) && this.ship.hasModuleTypeAny(ModuleType.SMALL_TRACKS, ModuleType.BIG_TRACKS)) {
            this.maxHP = this.maxHP * 13 / 10;
        }
        this.maxHP += this.ship.getBonusHPPerTile() * this.type.getW() * this.type.getH();
    }

    public int getMaxHP() {
        return this.maxHP;
    }

    public int getMaxRepairToHP() {
        return this.maxHP - (this.maxHP - this.lowestHP) / 2;
    }

    public Crewman findOperator() {
        int csz = this.ship.crew.size();
        for (int ci = 0; ci < csz; ++ci) {
            Crewman cm = this.ship.crew.get(ci);
            if (!(cm.job instanceof StaffJob) || !this.jobs.contains(cm.job)) continue;
            return cm;
        }
        return null;
    }

    public void repairFully() {
        this.recoil = 0.0;
        this.weaponAngle = this.type.isFlipped() != this.ship.flipped ? Math.PI : 0.0;
        this.prevTarget = null;
        this.prevTargetShip = null;
        this.hasPrevJitter = false;
        this.damageReported = false;
        this.armourDamageReported = false;
        this.msUntilCoal = this.type.getCoalReload();
        this.shootAccumulator = 0;
        this.lowestHP = this.hp = this.getMaxHP();
        this.ammoLeft = this.type.getClip();
        this.fire = 0;
        if (this.type.getWater() > 0) {
            this.resources.put(Resource.WATER, this.type.getWater());
        }
        if (this.type.getRepair() > 0) {
            this.resources.put(Resource.REPAIR, this.type.getRepair());
        }
        if (this.type.getAmmo() > 0) {
            this.resources.put(Resource.AMMO, this.type.getAmmo());
        }
        if (this.type.getCoal() > 0) {
            this.resources.put(Resource.COAL, this.type.getCoal());
        }
    }

    public void dealDestructionDamage() {
        Tile t;
        int i;
        for (i = 0; i < this.type.getW(); ++i) {
            t = this.ship.tileAt(this.x + i, this.y - 1);
            if (t != null) {
                t.module.hp = (int)((double)t.module.hp - Math.ceil((double)t.module.type.getHp() * (0.09999999999999998 + 1.0 / (double)(t.module.type.getW() * 2 + t.module.type.getH() * 2))));
            }
            if ((t = this.ship.tileAt(this.x + i, this.y + this.type.getH())) == null) continue;
            t.module.hp = (int)((double)t.module.hp - Math.ceil((double)t.module.type.getHp() * (0.09999999999999998 + 1.0 / (double)(t.module.type.getW() * 2 + t.module.type.getH() * 2))));
        }
        for (i = 0; i < this.type.getH(); ++i) {
            t = this.ship.tileAt(this.x - 1, this.y + i);
            if (t != null) {
                t.module.hp = (int)((double)t.module.hp - Math.ceil((double)t.module.type.getHp() * (0.09999999999999998 + 1.0 / (double)(t.module.type.getW() * 2 + t.module.type.getH() * 2))));
            }
            if ((t = this.ship.tileAt(this.x + this.type.getW(), this.y + i)) == null) continue;
            t.module.hp = (int)((double)t.module.hp - Math.ceil((double)t.module.type.getHp() * (0.09999999999999998 + 1.0 / (double)(t.module.type.getW() * 2 + t.module.type.getH() * 2))));
        }
    }

    public int getResource(Resource r) {
        if (this.hp <= 0) {
            return 0;
        }
        return this.resources.containsKey((Object)r) ? this.resources.get((Object)r) : 0;
    }

    public boolean takeResource(Resource r) {
        if (this.getResource(r) > 0) {
            this.resources.put(r, this.getResource(r) - 1);
            return true;
        }
        return false;
    }

    public boolean fullyStaffed() {
        int jsz = this.jobs.size();
        block0: for (int ji = 0; ji < jsz; ++ji) {
            Job job = this.jobs.get(ji);
            if (!(job instanceof StaffJob)) continue;
            int csz = this.ship.crew.size();
            for (int ci = 0; ci < csz; ++ci) {
                Crewman c = this.ship.crew.get(ci);
                if (c.job == job && c.currentTile.module == this) continue block0;
            }
            return false;
        }
        return true;
    }

    public boolean somewhatStaffed() {
        if (this.type.getCrew() == 0) {
            return true;
        }
        int jsz = this.jobs.size();
        for (int j = 0; j < jsz; ++j) {
            Job job = this.jobs.get(j);
            if (!(job instanceof StaffJob)) continue;
            int sz = this.ship.crew.size();
            for (int i = 0; i < sz; ++i) {
                Crewman c = this.ship.crew.get(i);
                if (c.job != job || c.currentTile.module != this) continue;
                return true;
            }
        }
        return false;
    }

    public double staffProportion() {
        int staffJobs = 0;
        int staff = 0;
        int jsz = this.jobs.size();
        block0: for (int ji = 0; ji < jsz; ++ji) {
            Job job = this.jobs.get(ji);
            if (!(job instanceof StaffJob)) continue;
            ++staffJobs;
            int csz = this.ship.crew.size();
            for (int ci = 0; ci < csz; ++ci) {
                Crewman c = this.ship.crew.get(ci);
                if (c.job != job || c.currentTile.module != this) continue;
                ++staff;
                continue block0;
            }
        }
        return staffJobs == 0 ? 1.0 : 1.0 * (double)staff / (double)staffJobs;
    }

    public boolean canRun() {
        return this.somewhatStaffed() && this.hp > 0 && (this.type.getCoalReload() == 0 || this.msUntilCoal > 0);
    }

    public boolean running() {
        if (!this.canRun()) {
            return false;
        }
        if (this.type.getPropulsion() > 0.0 && !this.ship.enginesRunning) {
            return false;
        }
        if (!(!(this.type.getPropulsion() > 0.0) || this.type.getSprings().isEmpty() && this.type.getLegSpecs().isEmpty() || this.touchingGround)) {
            return false;
        }
        return this.type.getLift(this.ship.constructionBonuses) <= 0 || this.ship.suspendiumRunning;
    }

    public void resetLegs() {
        for (Leg leg : this.legs) {
            leg.reset();
        }
    }

    public void initLegsAndWheels(LandFormation ground, ArrayList<LandFormation> floaters, ShipList ships, boolean force) {
        double mx = this.ship.x + (double)(this.ship.gridXToWorldX(this.x, this.type.getW()) * 16);
        double my = this.ship.y + (double)(this.y * 16) + (double)(this.type.getH() * 16);
        for (Leg leg : this.legs) {
            if (leg.inited && !force) continue;
            leg.flipped = this.ship.flipped;
            leg.startStep(mx, my, ground, floaters, ships, false, this.ship.flipped, this.type.getW());
            double hipX = this.ship.flipped ? mx + ((double)this.type.getW() - leg.spec.xOffset) * 16.0 : mx + leg.spec.xOffset * 16.0;
            double hipY = my + leg.spec.yOffset * 16.0;
            leg.moveFootTo(leg.targetX - hipX, leg.targetY - hipY, this.ship.flipped);
            leg.updateFootPosition(true);
            leg.inited = true;
        }
        for (Wheel w : this.wheels) {
            w.setBodyPosition(mx, my);
        }
    }

    public boolean moving() {
        return this.ship.timeMovingInSameXDirection > 150;
    }

    public void tick(int ms, Combat c) {
        boolean canFire;
        this.touchingGround = false;
        if (this.hp > 0) {
            ArrayList<Spring> springs = this.type.getSprings();
            int ssz = springs.size();
            for (int si = 0; si < ssz; ++si) {
                Spring spring = springs.get(si);
                double l = spring.getLength(this.ship.x + (double)(this.ship.gridXToWorldX(this.x, this.type.getW()) * 16), this.ship.y + (double)(this.y * 16) + (double)(this.type.getH() * 16), c, this.ship);
                if (!(l < (double)spring.baseLength)) continue;
                if (!this.ship.sitting) {
                    this.ship.yForce -= spring.getForce(l);
                }
                this.ship.xSpeed *= 0.95;
                this.ship.ySpeed *= 0.95;
                this.touchingGround = true;
            }
            this.initLegsAndWheels(null, c.landFormations, c, false);
            int lsz = this.legs.size();
            for (int li = 0; li < lsz; ++li) {
                double legLength;
                Leg leg = this.legs.get(li);
                leg.touchingGround = false;
                Spring spring = leg.spec.spring;
                Pt fp = leg.getFootPt();
                double xOffset = fp.x / 16.0 + leg.spec.xOffset;
                double l = spring.getLength(this.ship.x + (double)(this.ship.gridXToWorldX(this.x, this.type.getW()) * 16), this.ship.y + (double)(this.y * 16) + (double)(this.type.getH() * 16), c, xOffset, this.ship);
                double d = legLength = leg.movedFoot ? Math.max(leg.spec.limbLength * 1.1, fp.y) + leg.spec.yOffset * 16.0 : 32.0;
                if (!(l < (double)spring.baseLength) || !(l < legLength)) continue;
                this.ship.yForce -= spring.getForce(l, legLength) * this.ship.legBalanceFactor;
                this.ship.xSpeed *= 0.95;
                this.ship.ySpeed *= 0.8;
                this.touchingGround = true;
                leg.touchingGround = true;
            }
            double mx = this.ship.x + (double)(this.ship.gridXToWorldX(this.x, this.type.getW()) * 16);
            double my = this.ship.y + (double)(this.y * 16) + (double)(this.type.getH() * 16);
            int wsz = this.wheels.size();
            for (int wi = 0; wi < wsz; ++wi) {
                Wheel w = this.wheels.get(wi);
                w.calcYOffset(this.ship.x + (double)(this.ship.gridXToWorldX(this.x, this.type.getW()) * 16), this.ship.y + (double)(this.y * 16) + (double)(this.type.getH() * 16), c);
                if (this.touchingGround) {
                    w.phase += (this.ship.x - this.prevShipXForWheels) / w.spec.radius;
                }
                w.setBodyPosition(mx, my);
            }
            this.prevShipXForWheels = this.ship.x;
            if (!this.legs.isEmpty() && this.touchingGround) {
                if (this.legIndex == -1 && this.moving()) {
                    boolean started = false;
                    do {
                        ++this.legIndex;
                        started = this.legs.get(this.legIndex).startStep(this.ship.x + (double)(this.ship.gridXToWorldX(this.x, this.type.getW()) * 16), this.ship.y + (double)(this.y * 16) + (double)(this.type.getH() * 16), null, c.landFormations, c, this.ship.xSpeed < -0.01, this.ship.flipped, this.type.getW());
                        if (!started) continue;
                        c.play("hiss" + AGame.ANIM_R.nextInt(3), (int)mx + this.type.getW() * 16 / 2, this.y, 0.5);
                    } while (!started && this.legIndex < this.legs.size() - 1);
                    if (!started) {
                        this.legIndex = -1;
                    }
                }
                boolean didStep = false;
                for (int li = 0; li < lsz; ++li) {
                    if (li == this.legIndex) {
                        Leg leg = this.legs.get(this.legIndex);
                        didStep = leg.doStep(this.ship.x + (double)(this.ship.gridXToWorldX(this.x, this.type.getW()) * 16), this.ship.y + (double)(this.y * 16) + (double)(this.type.getH() * 16), ms, this.ship.flipped, this.type.getW(), c);
                        if (!didStep) continue;
                        double hipX = this.ship.flipped ? mx + ((double)this.type.getW() - leg.spec.xOffset) * 16.0 : mx + leg.spec.xOffset * 16.0;
                        double hipY = my + leg.spec.yOffset * 16.0;
                        Pt footPt = leg.getFootPt();
                        c.play("step" + AGame.ANIM_R.nextInt(3), (int)(hipX + footPt.x), (int)(hipY + footPt.y), 0.8 + (double)this.ship.getWeight() / 1000.0);
                        continue;
                    }
                    this.legs.get(li).moveNonStepFoot(this.ship.x + (double)(this.ship.gridXToWorldX(this.x, this.type.getW()) * 16), this.ship.y + (double)(this.y * 16) + (double)(this.type.getH() * 16), this.ship.flipped, this.type.getW(), c);
                }
                boolean started = false;
                if (didStep && this.moving()) {
                    for (int attempt = 0; attempt < this.legs.size(); ++attempt) {
                        this.legIndex = (this.legIndex + 1) % this.legs.size();
                        started = this.legs.get(this.legIndex).startStep(this.ship.x + (double)(this.ship.gridXToWorldX(this.x, this.type.getW()) * 16), this.ship.y + (double)(this.y * 16) + (double)(this.type.getH() * 16), null, c.landFormations, c, this.ship.xSpeed < -0.01, this.ship.flipped, this.type.getW());
                        if (started) {
                            c.play("hiss" + AGame.ANIM_R.nextInt(3), (int)mx + this.type.getW() * 16 / 2, this.y, 0.5);
                        }
                        if (started) break;
                    }
                }
                if (didStep && !started) {
                    this.legIndex = -1;
                }
            } else if (!this.touchingGround) {
                for (int li = 0; li < lsz; ++li) {
                    this.legs.get(li).updateFootPosition(false);
                }
            }
        }
        if (this.recoil > 0.0) {
            this.recoil -= this.type.weaponAppearance().recoil * (double)ms / (double)Math.min(500, this.type.getReload() / 2);
            if (this.recoil < 0.0) {
                this.recoil = 0.0;
            }
        }
        if (this.prevTargetShip != null && c.sideOf(this.prevTargetShip) == c.sideOf(this.ship)) {
            this.prevTarget = null;
            this.prevTargetShip = null;
        }
        this.lowestHP = Math.min(this.hp, this.lowestHP);
        this.fired = false;
        boolean bl = canFire = c.r.nextDouble() < 0.7;
        if (canFire) {
            this.noValidTarget = false;
        }
        this.msUntilNextOnFireSound -= ms;
        this.msUntilNextEngineSound -= ms;
        this.msUntilNextSuspendiumSound -= ms;
        this.msUntilNextComputerSound -= ms;
        int soundX = this.ship.getX() + this.ship.gridXToWorldX(this.x, this.type.getW()) * 16 + this.type.getW() * 16 / 2;
        int soundY = this.ship.getY() + this.y * 16 + this.type.getH() * 16 / 2;
        if (this.msUntilNextComputerSound <= 0 && this.type == ModuleType.TARGETING_COMPUTER && this.running()) {
            this.msUntilNextComputerSound = 10000;
            c.play("computer" + AGame.ANIM_R.nextInt(3), soundX, soundY, 0.5);
        }
        if (this.msUntilNextSuspendiumSound <= 0 && this.type.getLift(this.ship.constructionBonuses) > 0 && this.type.getCoalReload() > 0 && this.running()) {
            this.msUntilNextSuspendiumSound = 3200;
            c.play("suspendium_3200", soundX, soundY, 0.01);
        }
        if (this.type == ModuleType.SAIL) {
            if (this.running()) {
                if (this.ship.msUntilNextSailFlap > 0) {
                    this.ship.msUntilNextSailFlap -= ms;
                    if (this.ship.msUntilNextSailFlap <= 0) {
                        c.play("sail", soundX, soundY, 1.3);
                    }
                }
            } else {
                this.ship.msUntilNextSailFlap = 300;
            }
        }
        if (this.running() && this.type.getPropulsion() > 0.0 && this.type.getCoalReload() > 0 && this.msUntilNextEngineSound <= 0) {
            if (!this.type.getWheelSpecs().isEmpty()) {
                this.msUntilNextEngineSound = 990;
                c.play("motor", soundX, soundY, 0.5);
            } else if (this.type.getLegSpecs().isEmpty()) {
                this.msUntilNextEngineSound = 1600;
                c.play("engine_1600", soundX, soundY, 0.4);
            }
        }
        if (this.fire > 0 && c.timeOfDay.effect.fireExtinguishChance > 0.0 && c.r.nextDouble() < c.timeOfDay.effect.fireExtinguishChance * (double)ms) {
            --this.fire;
            if (this.fire == 0) {
                c.play("quench" + AGame.ANIM_R.nextInt(3), soundX, soundY, 3.0);
            }
        }
        if (this.fire > 0) {
            if (this.msUntilNextOnFireSound <= 0) {
                this.msUntilNextOnFireSound = 2000;
                c.play("fire_2000", soundX, soundY, 0.7);
            }
            if (c.r.nextDouble() < 2.0E-4 * (double)this.fire * (double)ms) {
                --this.hp;
                int tsz = this.ship.tiles.size();
                for (int ti = 0; ti < tsz; ++ti) {
                    Tile t = this.ship.tiles.get(ti);
                    if (t.module != this) continue;
                    t.armour.hp = Math.max(0, t.armour.hp - 1);
                }
            }
            int msz = this.ship.modules.size();
            for (int mi = 0; mi < msz; ++mi) {
                Module m = this.ship.modules.get(mi);
                if (m == this || m.fire > 0 || m.hp <= 0) continue;
                boolean borders = false;
                if (m.x + m.type.getW() > this.x && m.x < this.x + this.type.getW() && (m.y + m.type.getH() == this.y || m.y == this.y + this.type.getH())) {
                    borders = true;
                }
                if (m.y + m.type.getH() > this.y && m.y < this.y + this.type.getH() && (m.x + m.type.getW() == this.x || m.x == this.x + this.type.getW())) {
                    borders = true;
                }
                if (!borders || !((double)(this.fire * ms) * 1.3 * c.r.nextDouble() * c.r.nextDouble() / (double)m.type.getW() / (double)m.type.getH() > 1.0 * (double)m.hp / (double)m.type.getFireHP() * (double)m.getMaxHP())) continue;
                m.fire = 5;
            }
            if (c.r.nextDouble() < 1.0E-4 * (double)this.fire * (double)ms) {
                ++this.fire;
            }
        }
        if (this.hp <= 0) {
            this.fire = 0;
        }
        int adjExplodeHP = this.type.getExplodeHP() * this.maxHP / this.type.getHp();
        if (this.hp > 0 && this.type.getExplodeDmg() > 0 && this.hp < adjExplodeHP && (double)(adjExplodeHP * ms) * 0.2 * c.r.nextDouble() > (double)this.hp) {
            int i;
            this.hp -= this.type.getExplodeDmg();
            int explodeX = this.ship.getX() + this.ship.gridXToWorldX(this.x, this.type.getW()) * 16 + this.type.getW() * 16 / 2;
            int explodeY = this.ship.getY() + this.y * 16 + this.type.getH() * 16 / 2;
            int parts = 8;
            for (i = 0; i < parts; ++i) {
                c.particles.add(new Particle(Particle.Type.EXPLODE_BACKS, explodeX, explodeY));
            }
            parts = 12;
            for (i = 0; i < parts; ++i) {
                c.particles.add(new Particle(Particle.Type.SMALL_SOOT, explodeX, explodeY));
                c.particles.add(new Particle(Particle.Type.LARGE_SOOT, explodeX, explodeY));
            }
            parts = 3;
            for (i = 0; i < parts; ++i) {
                c.particles.add(new Particle(Particle.Type.EXPLODE, explodeX, explodeY));
            }
            parts = 12;
            for (i = 0; i < parts; ++i) {
                c.particles.add(new Particle(Particle.Type.EXPLODE_BITS, explodeX, explodeY));
            }
            c.play("explosion", explodeX, explodeY, 3.0);
            double cX = (double)this.x + (double)this.type.getW() * 0.5;
            double cY = (double)this.y + (double)this.type.getH() * 0.5;
            int msz = this.ship.modules.size();
            for (int mi = 0; mi < msz; ++mi) {
                Module m = this.ship.modules.get(mi);
                if (m == this) continue;
                double mcX = (double)m.x + (double)m.type.getW() * 0.5;
                double mcY = (double)m.y + (double)m.type.getH() * 0.5;
                double distSq = (cX - mcX) * (cX - mcX) + (cY - mcY) * (cY - mcY);
                int dmg = (int)((double)this.type.getExplodeDmg() / Math.pow(distSq, 0.8));
                m.hp -= dmg;
            }
            int tsz = this.ship.tiles.size();
            for (int ti = 0; ti < tsz; ++ti) {
                Tile t = this.ship.tiles.get(ti);
                double mcX = (double)t.x + 0.5;
                double mcY = (double)t.y + 0.5;
                double distSq = (cX - mcX) * (cX - mcX) + (cY - mcY) * (cY - mcY);
                int dmg = (int)((double)this.type.getExplodeDmg() / distSq * 0.3);
                t.armour.hp = Math.max(0, t.armour.hp - dmg);
            }
            int csz = this.ship.crew.size();
            for (int ci = 0; ci < csz; ++ci) {
                Crewman cm = this.ship.crew.get(ci);
                double mcX = (double)cm.currentTile.x + 0.5;
                double mcY = (double)cm.currentTile.y + 0.5;
                double distSq = (cX - mcX) * (cX - mcX) + (cY - mcY) * (cY - mcY);
                int dmg = (int)Math.floor((double)this.type.getExplodeDmg() / distSq * c.r.nextDouble());
                if (dmg <= 0) continue;
                cm.hp = Math.max(0, cm.hp - dmg);
                if (cm.hp <= 0) continue;
                cm.shout("hit");
            }
        }
        if (this.running()) {
            this.time += ms;
            if (this.type.getReload() > 0 && this.ammoLeft > 0 && canFire) {
                this.shootAccumulator = (int)((double)this.shootAccumulator + (double)ms * this.staffProportion());
                if ((double)this.shootAccumulator >= (double)this.type.getReload() * this.ship.fireMode.reloadFactor) {
                    if (this.fire(c)) {
                        --this.ammoLeft;
                        this.shootAccumulator = (int)((double)this.shootAccumulator - (double)this.type.getReload() * this.ship.fireMode.reloadFactor);
                        this.fired = true;
                        if (this.type.getFireSound() != null && this.fireSoundCounter++ % this.type.getSoundEvery() == 0) {
                            Pt mz = this.currentMuzzle();
                            c.play(this.type.getFireSound() + AGame.ANIM_R.nextInt(this.type.getFireSoundCount()), (int)mz.x, (int)mz.y, 2.5);
                        }
                    } else {
                        this.shootAccumulator = Math.min(this.shootAccumulator, (int)((double)this.type.getReload() * this.ship.fireMode.reloadFactor * 1.5));
                    }
                }
            }
            if (this.type.getCoalReload() > 0) {
                this.msUntilCoal = Math.max(this.msUntilCoal - ms, 0);
            }
        }
    }

    private Combat.Side enemy(Combat c) {
        int ssz = c.sides.size();
        for (int si = 0; si < ssz; ++si) {
            Combat.Side s = c.sides.get(si);
            if (s.ships.contains(this.ship)) continue;
            return s;
        }
        return null;
    }

    private int quality(Tile t) {
        int q = 1000 / (t.armour.hp + 2);
        if (t.module.type.getCoalReload() > 0 && t.module.running()) {
            q *= 10;
        } else if (INTERESTING_MODULES.contains((Object)t.module.type)) {
            q *= 10;
        }
        if (t.module.fire > 0) {
            q /= 8;
        }
        if (t.module.hp <= 0) {
            q /= 20;
        }
        return q + 1;
    }

    private Airship targetShip(Combat c) {
        if (this.ship.fireAt != null && this.ship.fireAt.danger() > 0.0) {
            return this.ship.fireAt;
        }
        Airship s = null;
        double best = 0.0;
        ArrayList<Airship> enemyShips = this.enemy((Combat)c).ships;
        int assz = enemyShips.size();
        for (int asi = 0; asi < assz; ++asi) {
            Airship as = enemyShips.get(asi);
            double dist = Math.sqrt((this.ship.getX() - as.getX()) * (this.ship.getX() - as.getX()) + (this.ship.getY() - as.getY()) * (this.ship.getY() - as.getY()));
            double quality = as.danger() / (dist + 100.0);
            if (s != null && !(best < quality)) continue;
            s = as;
            best = quality;
        }
        return s;
    }

    public boolean canHit(Airship ts, double shipX, double shipY, double tX, double tY, boolean flipped, int inset) {
        double sX = flipped ? shipX + ((double)(this.ship.getWidth() - this.x) - this.type.muzzleCenterX()) * 16.0 : shipX + ((double)this.x + this.type.muzzleCenterX()) * 16.0;
        double sY = shipY + ((double)this.y + this.type.muzzleCenterY()) * 16.0;
        double tW = ts.getBBWidth();
        double tH = ts.getBBHeight();
        if (this.type.getFireArc().contains(Direction.DOWN) && sX > tX && sX < tX + tW && sY < tY) {
            return true;
        }
        return this.canHit(sX, sY, tX + tW / 2.0, tY + tH / 2.0, flipped, inset) || this.canHit(sX, sY, tX, tY, flipped, inset) || this.canHit(sX, sY, tX + tW, tY, flipped, inset) || this.canHit(sX, sY, tX, tY + tH, flipped, inset) || this.canHit(sX, sY, tX + tW, tY + tH, flipped, inset);
    }

    public boolean canHit(double sX, double sY, double tX, double tY, boolean flipped, int inset) {
        if (this.type.getMaxXRange() > 0 && Math.abs(tX - sX) + (double)inset > (double)(this.type.getMaxXRange() / 2)) {
            return false;
        }
        if (this.type.getMaxUpRange() > 0 && sY - tY + (double)inset > (double)(this.type.getMaxUpRange() / 2)) {
            return false;
        }
        if (flipped) {
            return this.type.getFireArc().containsVector(sX - tX, tY - sY);
        }
        return this.type.getFireArc().containsVector(tX - sX, tY - sY);
    }

    private boolean canHit(Combat c, Airship ts, Tile t, double sx, double sy) {
        int tX = ts.getX() + ts.gridXToWorldX(t.x, 1) * 16 + 8;
        int tY = ts.getY() + t.y * 16 + 8;
        if (this.type.getMaxXRange() > 0 && Math.abs((double)tX - sx) > (double)this.type.getMaxXRange()) {
            return false;
        }
        if (this.type.getMaxUpRange() > 0 && sy - (double)tY > (double)this.type.getMaxUpRange()) {
            return false;
        }
        double dir = Direction.radiansFromTo(sx, sy, tX, tY);
        if (this.ship.flipped) {
            dir = Direction.flipHorizontal(dir);
        }
        return this.type.getFireArc().contains(dir);
    }

    private Tile target(Combat c, Airship ts, double sx, double sy) {
        int qSum = 0;
        ArrayList<Tile> options = new ArrayList<Tile>();
        int tsz = ts.tiles.size();
        for (int ti = 0; ti < tsz; ++ti) {
            Tile t = ts.tiles.get(ti);
            int tX = ts.getX() + ts.gridXToWorldX(t.x, 1) * 16 + 8;
            int tY = ts.getY() + t.y * 16 + 8;
            if (this.type.getMaxXRange() > 0 && Math.abs((double)tX - sx) > (double)this.type.getMaxXRange() || this.type.getMaxUpRange() > 0 && sy - (double)tY > (double)this.type.getMaxUpRange() || (this.ship.flipped ? !this.type.getFireArc().containsVector(sx - (double)tX, (double)tY - sy) : !this.type.getFireArc().containsVector((double)tX - sx, (double)tY - sy))) continue;
            qSum += this.quality(t);
            options.add(t);
        }
        if (options.isEmpty()) {
            return null;
        }
        int roll = c.r.nextInt(qSum);
        int osz = options.size();
        for (int oi = 0; oi < osz; ++oi) {
            Tile t = (Tile)options.get(oi);
            if ((roll -= this.quality(t)) > 0) continue;
            return t;
        }
        return null;
    }

    private Utils.Pair<Airship, Pt> target(Combat c, double sx, double sy) {
        if ((this.ship.fireAt == null || this.ship.fireAt == this.prevTargetShip) && this.prevTargetShip != null && this.prevTarget.module.hp > 0 && this.prevTargetShip.tiles.contains(this.prevTarget) && this.prevTargetShip.danger() > 0.0) {
            Pt mz = this.fireFrom();
            if (this.canHit(c, this.prevTargetShip, this.prevTarget, mz.x, mz.y)) {
                return new Utils.Pair((Object)this.prevTargetShip, (Object)new Pt((double)(this.prevTargetShip.getX() + this.prevTargetShip.gridXToWorldX(this.prevTarget.x, 1) * 16 + 8), (double)(this.prevTargetShip.getY() + this.prevTarget.y * 16 + 8)));
            }
        }
        this.prevTargetShip = null;
        this.prevTarget = null;
        Airship ts = this.targetShip(c);
        if (ts == null) {
            return null;
        }
        Tile tt = this.target(c, ts, sx, sy);
        if (tt == null) {
            ArrayList<Airship> enemyShips = this.enemy((Combat)c).ships;
            int assz = enemyShips.size();
            for (int asi = 0; asi < assz; ++asi) {
                Airship as = enemyShips.get(asi);
                tt = this.target(c, as, sx, sy);
                if (tt == null) continue;
                ts = as;
                break;
            }
        }
        if (tt == null) {
            return null;
        }
        this.prevTarget = tt;
        this.prevTargetShip = ts;
        return new Utils.Pair((Object)ts, (Object)new Pt((double)(ts.getX() + ts.gridXToWorldX(tt.x, 1) * 16 + 8), (double)(ts.getY() + tt.y * 16 + 8)));
    }

    private double jitter(Combat c, double value, double dist, boolean yJitter, double mult) {
        double inaccuracy = this.type.getInaccuracy();
        if (this.type.isCannon() && this.ship.currentBonuses.contains((Object)Bonus.PRECISE_GUNNERY)) {
            inaccuracy *= 0.5;
        }
        double jitter = dist * (inaccuracy *= this.ship.getInaccuracyMultiplier()) * c.r.nextGaussian() * 16.0 * this.ship.fireMode.inaccuracyFactor;
        if (this.hasPrevJitter) {
            jitter = (1.0 - this.type.getJitterMerge()) * jitter + this.type.getJitterMerge() * (yJitter ? this.prevYJitter : this.prevXJitter);
        }
        if (yJitter) {
            this.prevYJitter = jitter;
        } else {
            this.prevXJitter = jitter;
        }
        return value + jitter * mult;
    }

    public Pt currentMuzzle() {
        double sX = (this.ship.flipped ? (double)this.ship.getX() + ((double)(this.ship.getWidth() - this.x) - this.type.muzzleCenterX()) * 16.0 : (double)this.ship.getX() + ((double)this.x + this.type.muzzleCenterX()) * 16.0) + Math.cos(this.weaponAngle) * this.type.muzzleLength() * 16.0;
        double sY = (double)this.ship.getY() + ((double)this.y + this.type.muzzleCenterY()) * 16.0 + Math.sin(this.weaponAngle) * this.type.muzzleLength() * 16.0;
        return new Pt(sX, sY);
    }

    public Pt fireFrom() {
        double sX = this.ship.flipped ? (double)this.ship.getX() + ((double)(this.ship.getWidth() - this.x) - this.type.muzzleCenterX()) * 16.0 : (double)this.ship.getX() + ((double)this.x + this.type.muzzleCenterX()) * 16.0;
        double sY = (double)this.ship.getY() + ((double)this.y + this.type.muzzleCenterY()) * 16.0;
        return new Pt(sX, sY);
    }

    public boolean fire(Combat c) {
        double sY;
        double sX = this.ship.flipped ? (double)this.ship.getX() + ((double)(this.ship.getWidth() - this.x) - this.type.muzzleCenterX()) * 16.0 : (double)this.ship.getX() + ((double)this.x + this.type.muzzleCenterX()) * 16.0;
        Utils.Pair<Airship, Pt> target = this.target(c, sX, sY = (double)this.ship.getY() + ((double)this.y + this.type.muzzleCenterY()) * 16.0);
        if (target == null) {
            this.noValidTarget = true;
            return false;
        }
        this.weaponAngle = Direction.radiansFromTo(sX, sY, ((Pt)target.b).x, ((Pt)target.b).y);
        Pt muz = this.currentMuzzle();
        sX = muz.x;
        sY = muz.y;
        Airship t = (Airship)target.a;
        double dist = Math.sqrt((sX - ((Pt)target.b).x) * (sX - ((Pt)target.b).x) + (sY - ((Pt)target.b).y) * (sY - ((Pt)target.b).y));
        if (((Pt)target.b).y < sY) {
            dist += sY - ((Pt)target.b).y;
        }
        TimeOfDay tod = c.timeOfDay;
        WeatherEffect we = tod.effect;
        double jitterMult = we.shootJitterMult;
        jitterMult = ((Pt)target.b).x > sX ? (jitterMult *= we.shootToRightJitterMult) : (jitterMult *= we.shootToLeftJitterMult);
        if (we.fog && ((Pt)target.b).y > 112.0) {
            jitterMult *= 3.0;
        }
        double tX = this.jitter(c, ((Pt)target.b).x, dist, false, jitterMult);
        double tY = this.jitter(c, ((Pt)target.b).y, dist, true, jitterMult);
        Shot shot = new Shot(t, tX, tY, this.ship, sX, sY, this.self);
        c.shots.add(shot);
        if (this.type.getShotSpeed() >= 0.5) {
            c.trails.add(new Trail(shot, (double)this.type.weaponAppearance().shot.srcHeight * 0.5 + 1.0));
        }
        this.recoil = this.type.weaponAppearance().recoil;
        if (this.ship.type.mobile && this.type.isCannon()) {
            double shotDir = Direction.radiansFromTo(sX, sY, tX, tY);
            double forceAmt = (double)this.type.getPenDmg() * 0.03;
            this.ship.xForce -= Math.cos(shotDir) * forceAmt;
            this.ship.yForce -= Math.sin(shotDir) * forceAmt;
        }
        return true;
    }

    public void giveResource(Resource r, Combat c) {
        int soundX = this.ship.getX() + this.ship.gridXToWorldX(this.x, this.type.getW()) * 16 + this.type.getW() * 16 / 2;
        int soundY = this.ship.getY() + this.y * 16 + this.type.getH() * 16 / 2;
        switch (r) {
            case AMMO: {
                this.ammoLeft += this.type.getClip();
                break;
            }
            case COAL: {
                this.msUntilCoal += this.type.getCoalReload();
                break;
            }
            case REPAIR: {
                c.play("repair" + AGame.ANIM_R.nextInt(6), soundX, soundY, 0.2);
                this.hp = Math.min(this.getMaxRepairToHP(), this.hp + (this.ship.currentBonuses.contains((Object)Bonus.EXPERT_REPAIRS) ? 30 : 20));
                if (this.hp != this.getMaxRepairToHP()) break;
                this.damageReported = false;
                break;
            }
            case WATER: {
                c.play("quench" + AGame.ANIM_R.nextInt(3), soundX, soundY, 3.0);
                this.fire = Math.max(0, this.fire - (this.ship.currentBonuses.contains((Object)Bonus.FIREFIGHTERS) ? 12 : 6));
            }
        }
    }

    public Module(Airship ship, ModuleType type, int x, int y) {
        this.ship = ship;
        this.type = type;
        this.x = x;
        this.y = y;
        this.fireSoundCounter = AGame.ANIM_R.nextInt(type.getSoundEvery());
        this.msUntilNextOnFireSound = AGame.ANIM_R.nextInt(10) * 16;
        this.msUntilNextEngineSound = AGame.ANIM_R.nextInt(10) * 16;
        this.msUntilNextSuspendiumSound = AGame.ANIM_R.nextInt(10) * 16;
        this.repairFully();
        this.setupJobs();
        for (Wheel.Spec ws : type.getWheelSpecs()) {
            this.wheels.add(new Wheel(ws, ship));
        }
        for (Leg.Spec ls : type.getLegSpecs()) {
            this.legs.add(new Leg(ls, ship, this));
        }
    }

    public JSONObject toJSON(Combat c) {
        JSONObject o = new JSONObject().put("type", this.type.name()).put("x", this.x).put("y", this.y).put("ammoLeft", this.ammoLeft).put("shootAccumulator", this.shootAccumulator).put("msUntilCoal", this.msUntilCoal).put("fire", this.fire).put("hp", this.hp).put("lowestHP", this.hp);
        for (Map.Entry<Resource, Integer> r : this.resources.entrySet()) {
            o.put(r.getKey().name(), r.getValue());
        }
        if (c != null && this.prevTarget != null && this.prevTargetShip != null && this.prevTargetShip.tiles.contains(this.prevTarget)) {
            block1: for (Combat.Side s : c.sides) {
                for (Airship as : s.ships) {
                    if (as != this.prevTargetShip) continue;
                    o.put("prevTargetShipSide", c.sides.indexOf(s));
                    o.put("prevTargetShipIndex", s.ships.indexOf(as));
                    o.put("prevTargetTileIndex", as.tiles.indexOf(this.prevTarget));
                    break block1;
                }
            }
        }
        if (this.hasPrevJitter) {
            o.put("hasPrevJitter", true);
            o.put("prevXJitter", this.prevXJitter);
            o.put("prevYJitter", this.prevYJitter);
        }
        return o;
    }

    public Module(JSONObject o, Airship ship) {
        this.ship = ship;
        this.type = ModuleType.valueOf(o.getString("type"));
        this.x = o.getInt("x");
        this.y = o.getInt("y");
        this.ammoLeft = o.getInt("ammoLeft");
        this.shootAccumulator = o.optInt("shootAccumulator", 0);
        this.msUntilCoal = o.getInt("msUntilCoal");
        this.fire = o.getInt("fire");
        this.hp = o.getInt("hp");
        this.lowestHP = o.optInt("lowestHP", this.hp);
        this.damageReported = o.optBoolean("dr", false);
        this.armourDamageReported = o.optBoolean("adr", false);
        this.fireSoundCounter = AGame.ANIM_R.nextInt(this.type.getSoundEvery());
        this.msUntilNextOnFireSound = AGame.ANIM_R.nextInt(10) * 16;
        this.msUntilNextEngineSound = AGame.ANIM_R.nextInt(10) * 16;
        this.msUntilNextSuspendiumSound = AGame.ANIM_R.nextInt(10) * 16;
        for (Resource r : Resource.values()) {
            if (!o.has(r.name())) continue;
            this.resources.put(r, o.getInt(r.name()));
        }
        this.setupJobs();
        for (Wheel.Spec ws : this.type.getWheelSpecs()) {
            this.wheels.add(new Wheel(ws, ship));
        }
        for (Leg.Spec ls : this.type.getLegSpecs()) {
            this.legs.add(new Leg(ls, ship, this));
        }
    }

    public void finish(JSONObject o, Combat c) {
        if (o.has("prevTargetShipSide")) {
            this.prevTargetShip = c.sides.get((int)o.getInt((String)"prevTargetShipSide")).ships.get(o.getInt("prevTargetShipIndex"));
            this.prevTarget = this.prevTargetShip.tiles.get(o.getInt("prevTargetTileIndex"));
        }
        if (o.optBoolean("hasPrevJitter", false)) {
            this.hasPrevJitter = true;
            this.prevXJitter = o.getDouble("prevXJitter");
            this.prevYJitter = o.getDouble("prevYJitter");
        }
    }

    private void setupJobs() {
        int i;
        for (i = 0; i < Math.min(3, this.type.getOccupableTileCount()); ++i) {
            this.jobs.add(new RepairJob(i + 1));
            this.jobs.add(new WaterJob(i + 1));
        }
        for (i = 0; i < this.type.getCrew(); ++i) {
            this.jobs.add(new StaffJob(i));
        }
        for (i = 0; i < this.type.getOptionalCrew(); ++i) {
            this.jobs.add(new ReadyJob(i + 1));
        }
        if (this.type.getClip() > 0) {
            this.jobs.add(new AmmoJob());
        }
        if (this.type.getCoalReload() > 0) {
            this.jobs.add(new CoalJob());
        }
        for (i = 0; i < this.type.getSickbay(); ++i) {
            this.jobs.add(new InjuryJob(i));
        }
        for (i = 0; i < this.type.getRecommendedGuards(); ++i) {
            this.jobs.add(new GuardJob(i + 1));
        }
        for (i = 0; i < this.type.getFixedGuards(); ++i) {
            this.jobs.add(new FixedGuardJob());
        }
    }

    private strictfp class InjuryJob
    implements Job {
        private int index;

        @Override
        public Module module() {
            return Module.this.self;
        }

        @Override
        public Resource resource() {
            return Resource.INJURED;
        }

        @Override
        public double priority() {
            return 1.2;
        }

        public InjuryJob(int index) {
            this.index = index;
        }

        @Override
        public boolean active() {
            if (Module.this.hp < 0 || !Module.this.fullyStaffed()) {
                return false;
            }
            int patients = 0;
            int csz = Module.this.ship.crew.size();
            for (int ci = 0; ci < csz; ++ci) {
                Crewman c = Module.this.ship.crew.get(ci);
                if (c.currentTile.module != Module.this.self || c.hp >= c.type.maxHP || !c.alive()) continue;
                ++patients;
            }
            return patients + this.index < Module.this.type.getSickbay();
        }

        public String toString() {
            return "Fetch injured for " + Module.this.type.getName();
        }

        @Override
        public boolean unimportant() {
            return false;
        }

        @Override
        public boolean isCaptain() {
            return false;
        }

        @Override
        public boolean requiredType(CrewType ct) {
            return true;
        }

        @Override
        public boolean requiredUnoccupied() {
            return false;
        }
    }

    private strictfp class CoalJob
    implements Job {
        private CoalJob() {
        }

        @Override
        public Module module() {
            return Module.this.self;
        }

        @Override
        public Resource resource() {
            return Resource.COAL;
        }

        @Override
        public double priority() {
            return (Module.this.fullyStaffed() ? (Module.this.type.getLift(Module.this.ship.constructionBonuses) > 0 ? 10000.0 : 1000.0) : (Module.this.ship.focusOnMoving ? 400.0 : 8.0)) / (double)(Module.this.msUntilCoal + 500);
        }

        @Override
        public boolean active() {
            return Module.this.type.getCoalReload() > 0 && Module.this.msUntilCoal < Module.this.type.getCoalReload() && Module.this.hp > 0;
        }

        public String toString() {
            return "Fetch coal for " + Module.this.type.getName();
        }

        @Override
        public boolean unimportant() {
            return false;
        }

        @Override
        public boolean isCaptain() {
            return false;
        }

        @Override
        public boolean requiredType(CrewType ct) {
            return true;
        }

        @Override
        public boolean requiredUnoccupied() {
            return Module.this.type.getLift(Bonus.STANDARD_BONUSES) == 0;
        }
    }

    private strictfp class GuardJob
    implements Job {
        int mul;

        public GuardJob(int mul) {
            this.mul = mul;
        }

        @Override
        public Module module() {
            return Module.this.self;
        }

        @Override
        public Resource resource() {
            return null;
        }

        @Override
        public double priority() {
            return 0.7 * (double)this.mul;
        }

        @Override
        public boolean active() {
            return Module.this.hp > 0 && Module.this.fire == 0;
        }

        public String toString() {
            return "Guard " + Module.this.type.getName();
        }

        @Override
        public boolean unimportant() {
            return true;
        }

        @Override
        public boolean isCaptain() {
            return false;
        }

        @Override
        public boolean requiredType(CrewType ct) {
            return ct == CrewType.MARINE || ct == CrewType.GUARD;
        }

        @Override
        public boolean requiredUnoccupied() {
            return true;
        }
    }

    public strictfp class FixedGuardJob
    implements Job {
        @Override
        public Module module() {
            return Module.this.self;
        }

        @Override
        public Resource resource() {
            return null;
        }

        @Override
        public double priority() {
            return 1000000.0;
        }

        @Override
        public boolean active() {
            return Module.this.hp > 0 && Module.this.fire == 0;
        }

        public String toString() {
            return "Guard " + Module.this.type.getName();
        }

        @Override
        public boolean unimportant() {
            return false;
        }

        @Override
        public boolean isCaptain() {
            return false;
        }

        @Override
        public boolean requiredType(CrewType ct) {
            return ct == CrewType.MARINE || ct == CrewType.GUARD;
        }

        @Override
        public boolean requiredUnoccupied() {
            return true;
        }
    }

    private strictfp class ReadyJob
    implements Job {
        int div;

        public ReadyJob(int div) {
            this.div = div;
        }

        @Override
        public Module module() {
            return Module.this.self;
        }

        @Override
        public Resource resource() {
            return null;
        }

        @Override
        public double priority() {
            return 1.0E-6 / (double)this.div;
        }

        @Override
        public boolean active() {
            return Module.this.hp > 0 && Module.this.fire == 0;
        }

        public String toString() {
            return "Be ready at " + Module.this.type.getName();
        }

        @Override
        public boolean unimportant() {
            return true;
        }

        @Override
        public boolean isCaptain() {
            return false;
        }

        @Override
        public boolean requiredType(CrewType ct) {
            return ct == CrewType.SAILOR;
        }

        @Override
        public boolean requiredUnoccupied() {
            return Module.this.type.getCoal() == 0 && Module.this.type.getWater() == 0;
        }
    }

    public strictfp class StaffJob
    implements Job {
        int n;

        public StaffJob(int n) {
            this.n = n;
        }

        @Override
        public Module module() {
            return Module.this.self;
        }

        @Override
        public Resource resource() {
            return null;
        }

        @Override
        public double priority() {
            if (Module.this.type.getLift(Module.this.ship.constructionBonuses) > 0) {
                return Module.this.ship.grounded() ? 0.001 : 20.0;
            }
            if (!Module.this.ship.type.onGround && Module.this.type.getPropulsion() > 0.0 && Module.this.ship.grounded()) {
                return 0.001;
            }
            if (Module.this.type.getPropulsion() > 0.0 && Module.this.ship.focusOnMoving) {
                return 8.9 - (double)this.n * 0.01;
            }
            if (Module.this.type.isWeapon() && Module.this.ship.focusOnShooting && ((Module)Module.this).self.ammoLeft > 0 && !((Module)Module.this).self.noValidTarget) {
                return 2.8 - (double)this.n * 0.01;
            }
            if (Module.this.type.getCommand() > 0 && this.n == 0) {
                return 40.0;
            }
            return 0.7 - (double)this.n * 0.01;
        }

        @Override
        public boolean active() {
            return Module.this.type.getCrew() > 0 && Module.this.hp > 0 && Module.this.hp > Module.this.fire * 3;
        }

        public String toString() {
            return "Man " + Module.this.type.getName();
        }

        @Override
        public boolean unimportant() {
            return false;
        }

        @Override
        public boolean isCaptain() {
            return ((Module)Module.this).self.type.getCommand() > 0 && this.n == 0;
        }

        @Override
        public boolean requiredType(CrewType ct) {
            return true;
        }

        @Override
        public boolean requiredUnoccupied() {
            return Module.this.type.getLift(Bonus.STANDARD_BONUSES) == 0;
        }
    }

    private strictfp class WaterJob
    implements Job {
        int div;

        @Override
        public Module module() {
            return Module.this.self;
        }

        public WaterJob(int div) {
            this.div = div;
        }

        @Override
        public Resource resource() {
            return Resource.WATER;
        }

        @Override
        public double priority() {
            return ((double)(Module.this.getMaxHP() - Module.this.hp) * 3.0 / (double)Module.this.getMaxHP() + (double)Module.this.fire) / (double)this.div * (double)(Module.this.ship.focusOnFirefighting ? 4 : 1);
        }

        @Override
        public boolean active() {
            return Module.this.fire > 0;
        }

        public String toString() {
            return "Put out fire at " + Module.this.type.getName();
        }

        @Override
        public boolean unimportant() {
            return false;
        }

        @Override
        public boolean isCaptain() {
            return false;
        }

        @Override
        public boolean requiredType(CrewType ct) {
            return true;
        }

        @Override
        public boolean requiredUnoccupied() {
            return false;
        }
    }

    public strictfp class AmmoJob
    implements Job {
        @Override
        public Module module() {
            return Module.this.self;
        }

        @Override
        public Resource resource() {
            return Resource.AMMO;
        }

        @Override
        public double priority() {
            return (Module.this.fullyStaffed() ? 0.5 : 0.2) / (double)(Module.this.ammoLeft + 1) * (double)(Module.this.ship.focusOnShooting ? 4 : 1);
        }

        @Override
        public boolean active() {
            return Module.this.type.getClip() > 0 && Module.this.ammoLeft < Module.this.type.getClip() && Module.this.hp > 0 && Module.this.hp > Module.this.fire * 3;
        }

        public String toString() {
            return "Fetch ammo for " + Module.this.type.getName();
        }

        @Override
        public boolean unimportant() {
            return false;
        }

        @Override
        public boolean isCaptain() {
            return false;
        }

        @Override
        public boolean requiredType(CrewType ct) {
            return true;
        }

        @Override
        public boolean requiredUnoccupied() {
            return true;
        }
    }

    private strictfp class RepairJob
    implements Job {
        int div;

        @Override
        public Module module() {
            return Module.this.self;
        }

        @Override
        public Resource resource() {
            return Resource.REPAIR;
        }

        public RepairJob(int div) {
            this.div = div;
        }

        @Override
        public double priority() {
            return ((double)((Module.this.getMaxHP() - Module.this.hp) * 2 / Module.this.getMaxHP()) + 0.05) / (double)this.div * (double)(Module.this.ship.focusOnRepair ? 4 : 1);
        }

        @Override
        public boolean active() {
            return Module.this.hp > 0 && Module.this.hp < Module.this.getMaxRepairToHP() - 20 && Module.this.fire == 0;
        }

        public String toString() {
            return "Repair " + Module.this.type.getName();
        }

        @Override
        public boolean unimportant() {
            return false;
        }

        @Override
        public boolean isCaptain() {
            return false;
        }

        @Override
        public boolean requiredType(CrewType ct) {
            return ct == CrewType.SAILOR;
        }

        @Override
        public boolean requiredUnoccupied() {
            return Module.this.type.getWater() == 0 && Module.this.type.getCoal() == 0 && Module.this.type.getLift(Bonus.STANDARD_BONUSES) == 0;
        }
    }
}

