/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.Client;
import com.zarkonnen.airships.Cursor;
import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.MyDraw;
import com.zarkonnen.airships.PlaceShipTool;
import com.zarkonnen.airships.UniScreen;
import com.zarkonnen.catengine.Input;
import com.zarkonnen.catengine.util.Clr;
import com.zarkonnen.catengine.util.Pt;
import com.zarkonnen.catengine.util.ScreenMode;

public class MoveCommandTool
implements UniScreen.Tool {
    public boolean flipped;
    public boolean ramming;

    public MoveCommandTool(UniScreen us, boolean ramming) {
        this.flipped = us.selectedShip.flipped;
        this.ramming = ramming;
    }

    @Override
    public void draw(MyDraw d, Pt cursor, ScreenMode sm, UniScreen us) {
        if (us.selectedShip == null) {
            us.tool = UniScreen.NAVIGATE;
            return;
        }
        d.state.setCursor(this.ramming ? Cursor.RAM : Cursor.GOTO, Clr.WHITE, null);
        double x = us.screenToWorldX(cursor.x);
        double y = this.getYCoord(cursor.y, x, us);
        d.scale(us.zoom, us.zoom);
        d.shift(us.adjScrollX, us.adjScrollY);
        us.selectedShip.drawOutline(d, x, y, this.flipped, this.ramming || PlaceShipTool.canPlace(us.selectedShip, x, y, -1, us, false) ? Clr.WHITE : Clr.RED);
        d.state.cursorText = "[333333]" + Lang._t("F_to_flip", new Object[0]);
        d.resetTransforms();
        double sx = us.selectedShip.x;
        double sy = us.selectedShip.y;
        boolean sf = us.selectedShip.flipped;
        us.selectedShip.x = x;
        us.selectedShip.y = y;
        us.selectedShip.setFlipped(this.flipped);
        us.selectedShip.drawFireArcs(d, us.adjScrollX, us.adjScrollY, us.zoom, true);
        us.selectedShip.x = sx;
        us.selectedShip.y = sy;
        us.selectedShip.setFlipped(sf);
        int sc = (int)us.worldToScreenY(512 - us.selectedShip.serviceCeiling());
        d.rect(Clr.WHITE, 0.0, sc, sm.width, 2.0);
        d.rect(Clr.WHITE, 0.0, sc + 4, sm.width, 1.0);
        d.text(Lang._t("Service_Ceiling", new Object[0]), AGame.BIG_FOUNT, 5.0, sc - 20);
    }

    @Override
    public boolean click(Input in, Pt click, ScreenMode sm, UniScreen us) {
        if (us.selectedShip == null) {
            us.tool = UniScreen.NAVIGATE;
            return false;
        }
        double mx = us.screenToWorldX(click.x);
        double my = this.getYCoord(click.y, mx, us);
        us.combat.giveCommand(Client.msg(this.ramming ? "ram" : "moveTo").put("id", us.combat.getShipID(us.selectedShip)).put("x", mx).put("y", my).put("flipTo", this.flipped));
        us.tool = UniScreen.NAVIGATE;
        return true;
    }

    public double getYCoord(double screenY, double worldX, UniScreen us) {
        double y = us.screenToWorldY(screenY);
        if (us.selectedShip.type.onGround) {
            y = (double)us.combat.landFormations.get(0).getVerticalPosition(us.selectedShip, (int)worldX, true) - us.selectedShip.groundOffset();
        }
        return y;
    }

    @Override
    public boolean rightClick(Input in, Pt click, ScreenMode sm, UniScreen us) {
        us.tool = UniScreen.NAVIGATE;
        return true;
    }

    @Override
    public boolean mouseDown(Input in, Pt click, ScreenMode sm, UniScreen us) {
        return false;
    }

    @Override
    public void tick(Input in, int ms, UniScreen us) {
        if (in.keyPressed("F")) {
            boolean bl = this.flipped = !this.flipped;
        }
        if (in.keyPressed("ESCAPE")) {
            us.tool = UniScreen.NAVIGATE;
        }
    }
}

