/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.Body;
import com.zarkonnen.airships.Client;
import com.zarkonnen.airships.Combat;
import com.zarkonnen.airships.Cursor;
import com.zarkonnen.airships.GridBody;
import com.zarkonnen.airships.LandFormation;
import com.zarkonnen.airships.MyDraw;
import com.zarkonnen.airships.Rect2D;
import com.zarkonnen.airships.SelectionVisualLayer;
import com.zarkonnen.airships.UniScreen;
import com.zarkonnen.catengine.Input;
import com.zarkonnen.catengine.util.Clr;
import com.zarkonnen.catengine.util.Pt;
import com.zarkonnen.catengine.util.ScreenMode;
import org.json.JSONObject;

public strictfp class MoveTroopsTool
implements UniScreen.Tool {
    @Override
    public void draw(MyDraw d, Pt cursor, ScreenMode sm, UniScreen us) {
        d.state.setCursor(Cursor.GOTO, Clr.WHITE, null);
        if (us.combat.physics == null) {
            return;
        }
        GridBody moveTo = this.hoverBody(us, cursor);
        if (moveTo == null) {
            return;
        }
        d.scale(us.zoom, us.zoom);
        d.shift(us.adjScrollX, us.adjScrollY);
        boolean doBoard = us.combat.otherSide((Combat.Side)us.mySide).ships.contains(moveTo);
        SelectionVisualLayer.drawGridBodyOutline(d, us, moveTo, doBoard ? SelectionVisualLayer.BOARD : SelectionVisualLayer.MOVE, doBoard ? SelectionVisualLayer.BOARD2 : SelectionVisualLayer.MOVE2);
        d.resetTransforms();
    }

    public GridBody hoverBody(UniScreen us, Pt pt) {
        if (pt == null) {
            return null;
        }
        double mx = us.screenToWorldX(pt.x);
        double my = us.screenToWorldY(pt.y);
        for (Body b : us.combat.physics.bodies) {
            if (b == us.selectedLF || !(b instanceof GridBody) || !Rect2D.contains(b.x, b.y, b.getBBWidth(), b.getBBHeight(), mx, my)) continue;
            return (GridBody)b;
        }
        return null;
    }

    @Override
    public boolean click(Input in, Pt click, ScreenMode sm, UniScreen us) {
        if (us.combat.physics == null) {
            return false;
        }
        GridBody moveTo = this.hoverBody(us, click);
        if (moveTo == null) {
            return false;
        }
        JSONObject msg = Client.msg("moveTroops").put("playerID", us.combat.getIDForSide(us.mySide));
        if (us.selectedLF != null) {
            msg.put("sourceLF", us.combat.landFormations.indexOf(us.selectedLF));
        } else {
            msg.put("sourceShip", us.combat.getShipID(us.selectedShip));
        }
        if (moveTo instanceof Airship) {
            msg.put("targetShip", us.combat.getShipID((Airship)moveTo));
        } else {
            msg.put("targetLF", us.combat.landFormations.indexOf((LandFormation)moveTo));
        }
        us.combat.giveCommand(msg);
        us.tool = UniScreen.NAVIGATE;
        return true;
    }

    @Override
    public boolean rightClick(Input in, Pt click, ScreenMode sm, UniScreen us) {
        return false;
    }

    @Override
    public boolean mouseDown(Input in, Pt mouseDown, ScreenMode sm, UniScreen us) {
        return false;
    }

    @Override
    public void tick(Input in, int ms, UniScreen us) {
    }
}

