/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.ChatMsg;
import com.zarkonnen.airships.Client;
import com.zarkonnen.airships.CoatOfArms;
import com.zarkonnen.airships.Combat;
import com.zarkonnen.airships.CombatBackgroundFlavor;
import com.zarkonnen.airships.LandFormation;
import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.MainMenu;
import com.zarkonnen.airships.MetaLobbyScreen;
import com.zarkonnen.airships.MultiplayerCombatIntent;
import com.zarkonnen.airships.PlayerInfo;
import com.zarkonnen.airships.Rect2D;
import com.zarkonnen.airships.RestrictsShipPlacement;
import com.zarkonnen.airships.Server;
import com.zarkonnen.airships.SingleCombatSetupIntent;
import com.zarkonnen.airships.TimeOfDay;
import com.zarkonnen.airships.UniScreen;
import com.zarkonnen.airships.ZoomToFitButton;
import com.zarkonnen.catengine.Input;
import com.zarkonnen.catengine.util.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import org.json.JSONArray;
import org.json.JSONObject;

public class MultiplayerSetupIntent
implements UniScreen.Intent,
RestrictsShipPlacement {
    public boolean flipped;
    public Client client;
    public Server server;
    public String name;
    public int myID;
    public int channelID;
    public boolean leaveToMetaLobby;
    public CoatOfArms myArms;
    public long seed;
    public ArrayList<ChatMsg> chat = new ArrayList();
    public boolean welcomeReceived = false;
    public boolean helloSent = false;
    public boolean readySent = false;
    public HashMap<Integer, PlayerInfo> players = new HashMap();
    public int costLimit;
    public boolean oneShipOnly;
    public boolean first = true;

    public MultiplayerSetupIntent(boolean flipped, Client client, Server server, String name, CoatOfArms myArms, int costLimit, boolean oneShipOnly) {
        this.flipped = flipped;
        this.client = client;
        this.server = server;
        this.name = name;
        this.myArms = myArms;
        this.costLimit = costLimit;
        this.oneShipOnly = oneShipOnly;
    }

    @Override
    public void tick(Input in, int ms, UniScreen us) {
        JSONObject msg;
        if (this.first) {
            ZoomToFitButton.zoomOut(in, us);
            this.first = false;
        }
        if (this.welcomeReceived && !this.helloSent) {
            this.client.sendMessage(Client.msg("hello").put("name", this.name).put("id", this.myID).put("arms", this.myArms.toJSON()).put("costLimit", this.costLimit).put("version", 7110));
            this.helloSent = true;
            if (this.readySent) {
                this.sendReady(us);
            }
        }
        if ((msg = this.client.pollMessage()) != null) {
            if (msg.getString("type").equals("welcome")) {
                this.seed = msg.getLong("seed");
                this.channelID = msg.getInt("channelID");
                this.myID = msg.getInt("playerID");
                this.welcomeReceived = true;
                int version = msg.optInt("version", 0);
                if (version != 7110) {
                    this.leave(us);
                    us.g.showError(Lang._t("host_version_incompatible", version, 7110));
                } else {
                    this.genGround(us);
                }
            }
            if (msg.getString("type").equals("frame")) {
                JSONArray frameMessages = msg.getJSONArray("messages");
                for (int i = 0; i < frameMessages.length(); ++i) {
                    PlayerInfo pi;
                    JSONObject fm = frameMessages.getJSONObject(i);
                    if (fm.getString("type").equals("hello")) {
                        this.processHello(us, fm);
                        if (!fm.has("version") || fm.getInt("version") != 7110) {
                            this.client.sendMessage(Client.msg("chat").put("text", "!!! Your version of the game is not compatible with the other player's. Please make sure you have both updated to the newest version of the game.").put("id", this.myID));
                            this.leave(us);
                            us.g.showError("game_version_incompatible");
                        }
                        if (fm.optInt("costLimit", 0) != 0 && this.costLimit == 0) {
                            this.costLimit = fm.getInt("costLimit");
                            this.oneShipOnly = fm.optBoolean("oneShipOnly", false);
                        }
                    }
                    if (fm.getString("type").equals("chat") && (pi = this.players.get(fm.getInt("id"))) != null) {
                        this.chat.add(new ChatMsg(pi, pi.name + ": " + fm.getString("text")));
                    }
                    if (fm.getString("type").equals("leave")) {
                        pi = this.players.get(fm.getInt("id"));
                        this.chat.add(new ChatMsg(pi, Lang._t("xxx_LEFT_xxx", pi.name)));
                        this.players.remove(fm.getInt("id"));
                        if (pi.id == 0) {
                            this.leave(us);
                        }
                    }
                    if (!fm.getString("type").equals("ready")) continue;
                    pi = this.players.get(fm.getInt("id"));
                    if (pi == null) {
                        this.processHello(us, fm);
                    }
                    pi = this.players.get(fm.getInt("id"));
                    if (pi.fleet != null) continue;
                    this.chat.add(new ChatMsg(pi, Lang._t("xxx_READY_xxx", pi.name)));
                    ArrayList<Airship> fl = new ArrayList<Airship>();
                    pi.fleet = fl;
                    JSONArray fla = fm.getJSONArray("fleet");
                    for (int j = 0; j < fla.length(); ++j) {
                        fl.add(new Airship(fla.getJSONObject(j)));
                    }
                }
            }
        }
        if (this.canStart(us)) {
            this.startGame(us);
        }
    }

    public void genGround(UniScreen us) {
        if (us.setupGround == null) {
            Random r = new Random(this.seed);
            Utils.Pair<LandFormation, List<LandFormation>> p = LandFormation.generate(r);
            us.setupGround = (LandFormation)p.a;
            us.setupFloaters = new ArrayList((Collection)p.b);
            us.setupBG = CombatBackgroundFlavor.values()[r.nextInt(CombatBackgroundFlavor.values().length)];
            us.setupTime = TimeOfDay.getRandomForTournament(r);
        }
    }

    private boolean canStart(UniScreen us) {
        if (this.players.size() < 2) {
            return false;
        }
        for (PlayerInfo pi : this.players.values()) {
            if (pi.fleet != null) continue;
            return false;
        }
        return true;
    }

    private void processHello(UniScreen us, JSONObject fm) {
        if (!this.players.containsKey(fm.getInt("id"))) {
            PlayerInfo pi = new PlayerInfo(fm.getInt("id"), fm.getString("name"));
            pi.arms = new CoatOfArms(fm.getJSONObject("arms"));
            this.players.put(pi.id, pi);
            this.chat.add(new ChatMsg(pi, Lang._t("xxx_JOINED_xxx", pi.name)));
            if (pi.id != this.myID) {
                this.helloSent = false;
            }
        }
    }

    private void startGame(UniScreen us) {
        ArrayList<PlayerInfo> ps = new ArrayList<PlayerInfo>();
        if (this.flipped) {
            for (PlayerInfo pi : this.players.values()) {
                if (pi.id == this.myID) continue;
                ps.add(pi);
            }
            ps.add(this.players.get(this.myID));
        } else {
            ps.add(this.players.get(this.myID));
            for (PlayerInfo pi : this.players.values()) {
                if (pi.id == this.myID) continue;
                ps.add(pi);
            }
        }
        Combat c = new Combat(us.g, this.client, this.server, this.myID, this.seed, ps, this.costLimit, us.setupTime);
        c.landFormations.add(us.setupGround);
        c.landFormations.addAll(us.setupFloaters);
        c.backgroundFlavor = us.setupBG;
        us.setupGround = null;
        us.setupFloaters = null;
        us.setupBG = null;
        us.combat = c;
        us.mySide = c.getSideForID(this.myID);
        us.setupFleet = null;
        us.intent = new MultiplayerCombatIntent();
    }

    public void leave(UniScreen us) {
        if (this.leaveToMetaLobby) {
            us.g.s = new MetaLobbyScreen(us.g, this.client, this.server, this.name);
            this.client.sendMessage(Client.msg("leave").put("id", this.myID));
            this.client.sendMessage(Client.msg("changeChannel").put("id", 0));
        } else {
            if (this.client.isConnected()) {
                this.client.sendMessage(Client.msg("leave").put("id", this.myID));
            }
            this.client.close();
            if (this.server != null) {
                this.server.close();
            }
            us.g.s = new MainMenu(us.g);
        }
    }

    public void sendReady(UniScreen us) {
        this.readySent = true;
        JSONArray fla = new JSONArray();
        int netID = 1;
        for (Airship s : us.setupFleet) {
            s.networkID = (this.flipped ? "right." : "left.") + netID++;
            s.chunkSubIDCounter = 1;
            fla.put(s.toJSON(null));
        }
        this.client.sendMessage(Client.msg("ready").put("id", this.myID).put("fleet", fla).put("name", this.name).put("arms", this.myArms.toJSON()).put("costLimit", this.costLimit));
    }

    @Override
    public Rect2D placementLimits(int sideIndex, UniScreen us) {
        return this.flipped ? SingleCombatSetupIntent.RIGHT_RECT : SingleCombatSetupIntent.LEFT_RECT;
    }

    public int remainingBudget(UniScreen us) {
        int b = this.costLimit;
        for (Airship ship : us.setupFleet) {
            b -= ship.getCost();
        }
        return b;
    }

    @Override
    public boolean showOutside() {
        return false;
    }

    @Override
    public boolean showDecals() {
        return true;
    }

    @Override
    public boolean drawAsBlueprint() {
        return false;
    }
}

