/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.AirshipGame;
import com.zarkonnen.airships.Cursor;
import com.zarkonnen.airships.InputRunnable;
import com.zarkonnen.airships.Integration;
import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.Rect2D;
import com.zarkonnen.airships.TexGen;
import com.zarkonnen.airships.UIGlowRect;
import com.zarkonnen.catengine.Draw;
import com.zarkonnen.catengine.Fount;
import com.zarkonnen.catengine.Frame;
import com.zarkonnen.catengine.Hook;
import com.zarkonnen.catengine.Hooks;
import com.zarkonnen.catengine.Img;
import com.zarkonnen.catengine.Input;
import com.zarkonnen.catengine.util.Clr;
import com.zarkonnen.catengine.util.Pt;
import com.zarkonnen.catengine.util.ScreenMode;
import java.util.HashMap;
import java.util.Iterator;
import java.util.regex.Pattern;
import org.newdawn.slick.Image;

public class MyDraw
extends Draw {
    public static Clr BUTTON_C_1 = Clr.fromHex((String)"84471d");
    public static Clr BUTTON_C_2 = Clr.fromHex((String)"7b421b");
    public static Clr BUTTON_C_3 = Clr.fromHex((String)"633516");
    public static Clr BUTTON_C_1_GOLD = Clr.fromHex((String)"968841");
    public static Clr BUTTON_C_2_GOLD = Clr.fromHex((String)"8c7f3d");
    public static Clr BUTTON_C_3_GOLD = Clr.fromHex((String)"7d7136");
    public static Clr BUTTON_C_1_DIS = new Clr(90, 90, 90);
    public static Clr BUTTON_C_2_DIS = Clr.GREY;
    public static final Clr SELECTED = Clr.fromHex((String)"88ee88");
    public static final Clr HOTKEY = Clr.fromHex((String)"ffce6d");
    public static final String TITLE_C = "[f5edb5]";
    public static final String SELECTED_C = "[c8b84f]";
    public static final int BUTTON_SPACING = 3;
    public static final int UI_SPACING = 12;
    public static final Img TRIANGLE_CLOSED = new Img("spritesheet", 160, 512, 16, 16, false);
    public static final Img TRIANGLE_OPEN = new Img("spritesheet", 176, 512, 16, 16, false);
    public State state;
    public Hooks hs;
    public Integration integration;
    public static final int PROGRESS_BAR_H = 24;
    public static final Clr PROGRESS_BAR_INSIDE = Clr.fromHex((String)"f5edb5");
    public static final Clr PROGRESS_BAR_DEEP_INSIDE = Clr.fromHex((String)"e2daa6");
    private static final Img PANEL_TL = new Img("spritesheet", 49, 856, 5, 5, false);
    private static final Img PANEL_TR = new Img("spritesheet", 55, 856, 5, 5, false);
    private static final Img PANEL_BL = new Img("spritesheet", 49, 862, 5, 5, false);
    private static final Img PANEL_BR = new Img("spritesheet", 55, 862, 5, 5, false);
    private static final Img PANEL_L = new Img("spritesheet", 39, 846, 4, 4, false);
    private static final Img PANEL_R = new Img("spritesheet", 44, 846, 4, 4, false);
    private static final Img PANEL_T = new Img("spritesheet", 49, 846, 4, 4, false);
    private static final Img PANEL_B = new Img("spritesheet", 49, 851, 4, 4, false);
    public static final int PANEL_INSET = 6;
    private static final Img WIN_TL = new Img("spritesheet", 19, 845, 9, 9, false);
    private static final Img WIN_TR = new Img("spritesheet", 29, 845, 9, 9, false);
    private static final Img WIN_BL = new Img("spritesheet", 19, 855, 9, 9, false);
    private static final Img WIN_BR = new Img("spritesheet", 29, 855, 9, 9, false);
    private static final Img WIN_L = new Img("spritesheet", 1, 828, 8, 6, false);
    private static final Img WIN_R = new Img("spritesheet", 10, 828, 8, 6, false);
    private static final Img WIN_T = new Img("spritesheet", 18, 827, 6, 8, false);
    private static final Img WIN_B = new Img("spritesheet", 18, 836, 6, 8, false);
    public static final int WINDOW_INSET = 12;
    public static final Clr WIN_SHADOW = new Clr(0, 0, 0, 91);
    public static final int SCROLL_EL_SPACING = 6;
    public static final int SIDE_CLEARANCE = 10;
    public static final int TOP_BAR_H = 43;
    private static final Img TOP_BAR_TOP_SEGMENT = new Img("spritesheet", 18, 827, 66, 8, false);
    private static final Img TOP_BAR_BOTTOM_SEGMENT = new Img("spritesheet", 18, 836, 66, 8, false);
    private static final Img RHS_WINDOW_SIDE_SEGMENT = new Img("spritesheet", 1, 828, 8, 60, false);
    private static final Img LHS_WINDOW_SIDE_SEGMENT = new Img("spritesheet", 10, 828, 8, 60, false);
    public static final Pattern REMOVE_FORMATTING = Pattern.compile("\\[[^\\]]+\\]");
    public static final double[][] BORDER_ADJ = new double[][]{{-0.7, -0.7}, {0.0, -1.0}, {0.7, -0.7}, {-1.0, 0.0}, {1.0, 0.0}, {-0.7, 0.7}, {0.0, 1.0}, {0.7, 0.7}};
    public static final int[][] HEAVY_ADJ = new int[][]{{-2, -2}, {-1, -2}, {0, -2}, {1, -2}, {2, -2}, {-2, -1}, {-1, -1}, {0, -1}, {1, -1}, {2, -1}, {-2, 0}, {-1, 0}, {1, 0}, {2, 0}, {-2, 1}, {-1, 1}, {0, 1}, {1, 1}, {2, 1}, {-2, 2}, {-1, 2}, {0, 2}, {1, 2}, {2, 2}};
    public static final int BUTTON_H = 24;
    private static final Img BUTTON_DIS_START = new Img("spritesheet", 1, 889, 17, 26, false);
    private static final Img BUTTON_DIS_MIDDLE = new Img("spritesheet", 18, 889, 12, 26, false);
    private static final Img BUTTON_DIS_END = new Img("spritesheet", 86, 889, 17, 26, false);
    private static final Img BUTTON_START = new Img("spritesheet", 1, 916, 17, 26, false);
    private static final Img BUTTON_MIDDLE = new Img("spritesheet", 18, 916, 12, 26, false);
    private static final Img BUTTON_END = new Img("spritesheet", 86, 916, 17, 26, false);
    private static final Img BUTTON_LIT_START = new Img("spritesheet", 1, 943, 17, 26, false);
    private static final Img BUTTON_LIT_MIDDLE = new Img("spritesheet", 18, 943, 12, 26, false);
    private static final Img BUTTON_LIT_END = new Img("spritesheet", 86, 943, 17, 26, false);
    private static final Img TOGGLE_OFF_START = new Img("spritesheet", 1, 970, 17, 26, false);
    private static final Img TOGGLE_OFF_MIDDLE = new Img("spritesheet", 18, 970, 12, 26, false);
    private static final Img TOGGLE_OFF_END = new Img("spritesheet", 86, 970, 17, 26, false);
    private static final Img TOGGLE_ON_START = new Img("spritesheet", 1, 997, 17, 26, false);
    private static final Img TOGGLE_ON_MIDDLE = new Img("spritesheet", 18, 997, 12, 26, false);
    private static final Img TOGGLE_ON_END = new Img("spritesheet", 86, 997, 17, 26, false);
    private static final Img ICON_BUTTON = new Img("spritesheet", 170, 852, 26, 26, false);
    private static final Img ICON_BUTTON_LIT = new Img("spritesheet", 143, 852, 26, 26, false);
    private static final Img ICON_TOGGLE_OFF = new Img("spritesheet", 197, 852, 26, 26, false);
    private static final Img ICON_TOGGLE_ON = new Img("spritesheet", 224, 852, 26, 26, false);
    private static final Img ICON_BUTTON_DISABLED = new Img("spritesheet", 143, 879, 26, 26, false);
    private static final Clr ICON_TINT = Clr.fromHex((String)"4a3f2f");
    private static final Clr LIT_ICON_TINT = Clr.fromHex((String)"6c6149");
    public static final int ICON_BUTTON_SZ = 24;
    public static final Clr TOGGLE_OFF_INSIDE = Clr.fromHex((String)"665b2e");

    public MyDraw(Frame f, State state, Integration integration) {
        super(f);
        this.state = state;
        this.integration = integration;
    }

    public MyDraw(Frame f, Hooks hs, State state, Integration integration) {
        super(f, hs);
        this.state = state;
        this.integration = integration;
    }

    public void drawBG(Img img, ScreenMode sm) {
        double screenAspect = (double)sm.width * 1.0 / (double)sm.height;
        double imgAspect = (double)img.srcWidth * 1.0 / (double)img.srcHeight;
        if (screenAspect >= imgAspect) {
            this.blit(img, 0.0, (double)(sm.height / 2) - (double)sm.height * screenAspect / imgAspect / 2.0, sm.width, (double)sm.height * screenAspect / imgAspect);
        } else {
            this.blit(img, (double)(sm.width / 2) - (double)sm.width * imgAspect / screenAspect / 2.0, 0.0, (double)sm.width * imgAspect / screenAspect, sm.height);
        }
    }

    public void progressBar(int x, int y, int w, double progress) {
        this.drawPanel(x, y, w, 24);
        this.rect(PROGRESS_BAR_INSIDE, x + 2, y + 2, (int)((double)(w - 4) * progress), 20.0);
        if ((int)((double)(w - 4) * progress) > 4) {
            this.rect(PROGRESS_BAR_DEEP_INSIDE, x + 4, y + 4, (int)((double)(w - 4) * progress) - 4, 16.0);
        }
    }

    public void drawWoodGrain(int x, int y, int w, int h) {
        Image wg = TexGen.woodGrain();
        for (int y2 = y; y2 < y + h; y2 += 256) {
            int h2 = Math.min(256, y + h - y2);
            for (int x2 = x; x2 < x + w; x2 += 256) {
                int w2 = Math.min(256, x + w - x2);
                wg.draw((float)x2, (float)y2, (float)(x2 + w2), (float)(y2 + h2), 0.0f, 0.0f, (float)w2, (float)h2);
            }
        }
    }

    public void drawShadowedPanel(int x, int y, int w, int h) {
        this.rect(WIN_SHADOW, x - 1, y - 1, w + 2, 2.0);
        this.rect(WIN_SHADOW, x - 1, y + h - 1, w + 2, 2.0);
        this.rect(WIN_SHADOW, x - 1, y + 1, 2.0, h - 2);
        this.rect(WIN_SHADOW, x + w - 1, y + 1, 2.0, h - 2);
        this.drawPanel(x, y, w, h);
    }

    public void drawPanel(int x, int y, int w, int h) {
        this.drawWoodGrain(x + 3, y + 3, w - 6, h - 6);
        this.drawPanelBorder(x, y, w, h);
    }

    public void drawPanelBorder(int x, int y, int w, int h) {
        for (int x2 = x + MyDraw.PANEL_TL.srcWidth; x2 < x + w - MyDraw.PANEL_TR.srcWidth; x2 += MyDraw.PANEL_T.srcWidth) {
            this.blit(PANEL_T, x2, y);
            this.blit(PANEL_B, x2, y + h - MyDraw.PANEL_B.srcHeight);
        }
        for (int y2 = y + MyDraw.PANEL_TL.srcHeight; y2 < y + h - MyDraw.PANEL_TR.srcHeight; y2 += MyDraw.PANEL_L.srcHeight) {
            this.blit(PANEL_L, x, y2);
            this.blit(PANEL_R, x + w - MyDraw.PANEL_R.srcWidth, y2);
        }
        this.blit(PANEL_TL, x, y);
        this.blit(PANEL_TR, x + w - MyDraw.PANEL_TR.srcWidth, y);
        this.blit(PANEL_BL, x, y + h - MyDraw.PANEL_BL.srcHeight);
        this.blit(PANEL_BR, x + w - MyDraw.PANEL_BR.srcWidth, y + h - MyDraw.PANEL_BR.srcHeight);
    }

    public void drawShadowedWindow(int x, int y, int w, int h) {
        this.rect(WIN_SHADOW, x - 2, y - 2, w + 4, 4.0);
        this.rect(WIN_SHADOW, x - 2, y + h - 2, w + 4, 4.0);
        this.rect(WIN_SHADOW, x - 2, y + 2, 4.0, h - 4);
        this.rect(WIN_SHADOW, x + w - 2, y + 2, 4.0, h - 4);
        this.drawWindow(x, y, w, h);
    }

    public void drawWindow(int x, int y, int w, int h) {
        this.drawWoodGrain(--x + 3, --y + 3, (w += 2) - 6, (h += 2) - 6);
        for (int x2 = x + MyDraw.WIN_TL.srcWidth; x2 < x + w - MyDraw.WIN_TR.srcWidth; x2 += MyDraw.WIN_T.srcWidth) {
            this.blit(WIN_T, x2, y);
            this.blit(WIN_B, x2, y + h - MyDraw.WIN_B.srcHeight);
        }
        for (int y2 = y + MyDraw.WIN_TL.srcHeight; y2 < y + h - MyDraw.WIN_TR.srcHeight; y2 += MyDraw.WIN_L.srcHeight) {
            this.blit(WIN_L, x, y2);
            this.blit(WIN_R, x + w - MyDraw.WIN_R.srcWidth, y2);
        }
        this.blit(WIN_TL, x, y);
        this.blit(WIN_TR, x + w - MyDraw.WIN_TR.srcWidth, y);
        this.blit(WIN_BL, x, y + h - MyDraw.WIN_BL.srcHeight);
        this.blit(WIN_BR, x + w - MyDraw.WIN_BR.srcWidth, y + h - MyDraw.WIN_BR.srcHeight);
    }

    public void drawTopBar(ScreenMode sm) {
        int x2;
        for (x2 = 0; x2 < sm.width; x2 += 256) {
            TexGen.woodGrain().draw((float)x2, 6.0f, (float)(x2 + 256), 37.0f, 0.0f, 0.0f, 256.0f, 37.0f);
        }
        for (x2 = 0; x2 < sm.width; x2 += MyDraw.TOP_BAR_BOTTOM_SEGMENT.srcWidth) {
            this.blit(TOP_BAR_TOP_SEGMENT, x2, 2.0);
            this.blit(TOP_BAR_BOTTOM_SEGMENT, x2, 36.0);
        }
    }

    public void drawRightSideWindow(ScreenMode sm, int x, int y) {
        this.drawWoodGrain(x + 3, y, sm.width - x, sm.height - y);
        for (int y2 = y; y2 < sm.height; y2 += MyDraw.RHS_WINDOW_SIDE_SEGMENT.srcHeight) {
            this.blit(RHS_WINDOW_SIDE_SEGMENT, x - 1, y2);
        }
    }

    public void drawLeftSideWindow(ScreenMode sm, int w, int y) {
        this.drawWoodGrain(0, y, w - 3, sm.height - y);
        for (int y2 = y; y2 < sm.height; y2 += MyDraw.LHS_WINDOW_SIDE_SEGMENT.srcHeight) {
            this.blit(LHS_WINDOW_SIDE_SEGMENT, w - MyDraw.LHS_WINDOW_SIDE_SEGMENT.srcWidth + 1, y2);
        }
    }

    public void drawSpecialCharge(String name, Clr c, double x, double y, double w, double h) {
        Img img;
        if (this.integration != null && (img = this.integration.getSpecialCharge(name)) != null) {
            this.blit(img, c, x, y, w, h);
        }
    }

    public void drawSpecialChargeLeft(String name, Clr c, double x, double y, double w, double h) {
        Img img;
        if (this.integration != null && (img = this.integration.getSpecialChargeLeftHalf(name)) != null) {
            this.blit(img, c, x, y, w, h);
        }
    }

    public void drawSpecialChargeRight(String name, Clr c, double x, double y, double w, double h) {
        Img img;
        if (this.integration != null && (img = this.integration.getSpecialChargeRightHalf(name)) != null) {
            this.blit(img, c, x, y, w, h);
        }
    }

    public void dottedLine(Clr c, int width, int step, double x1, double y1, double x2, double y2) {
        double l = Math.sqrt((x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2));
        int i = 0;
        while ((double)i < l) {
            this.rect(c, x1 + (x2 - x1) * (double)i / l, y1 + (y2 - y1) * (double)i / l, width, width);
            i += step;
        }
    }

    public void borderedText(String text, Fount f, Clr c, Clr border, int x, int y) {
        String shornText = "[" + border.toString() + "]" + REMOVE_FORMATTING.matcher(text).replaceAll("");
        for (int j = 0; j < BORDER_ADJ.length; ++j) {
            this.text(shornText, f, (double)x + BORDER_ADJ[j][0], (double)y + BORDER_ADJ[j][1]);
        }
        this.text("[" + c.toString() + "]" + text, f, x, y);
    }

    public void heavilyBorderedText(String text, Fount f, Fount bg, Clr c, Clr border, int x, int y, int maxW) {
        this.text("[" + border.toString() + "]" + text, bg, x, y, maxW);
        this.text("[" + c.toString() + "]" + text, f, x, y, maxW);
    }

    public void borderedBlit(Img img, Clr c, Clr border, double x, double y) {
        for (int j = 0; j < Airship.ADJ.length; ++j) {
            this.blit(img, border, 1.0, x + (double)Airship.ADJ[j][0], y + (double)Airship.ADJ[j][1], 0.0, 0.0, 0.0);
        }
        this.blit(img, c, 1.0, x, y, 0.0, 0.0, 0.0);
    }

    public static boolean in(int x, int y, int w, Pt pt) {
        return pt.x >= (double)x && pt.y >= (double)y && pt.x <= (double)(x + w) && pt.y <= (double)(y + 20);
    }

    public static boolean in(int x, int y, int w, int h, Pt pt) {
        return pt.x >= (double)x && pt.y >= (double)y && pt.x <= (double)(x + w) && pt.y <= (double)(y + h);
    }

    public void button(int x, int y, int w, String text, Runnable onClick) {
        this.button(x, y, w, text, null, onClick, null, true);
    }

    public void button(int x, int y, int w, String text, String hotkey, Runnable onClick) {
        this.button(x, y, w, text, hotkey, onClick, null, true);
    }

    public void button(int x, int y, int w, String text, String hotkey, Runnable onClick, boolean enabled) {
        this.button(x, y, w, text, hotkey, onClick, null, enabled);
    }

    public void button(int x, int y, int w, String text, String hotkey, final Runnable onClick, final InputRunnable onClick2, boolean enabled) {
        --x;
        --y;
        w += 2;
        if (enabled) {
            text = hotkey != null ? (text.contains(hotkey) ? "[463a26]" + text.substring(0, text.indexOf(hotkey)) + "[726534]" + hotkey + "[463a26]" + text.substring(text.indexOf(hotkey) + hotkey.length()) : (text.contains(hotkey.toLowerCase()) ? "[463a26]" + text.substring(0, text.indexOf(hotkey.toLowerCase())) + "[726534]" + hotkey.toLowerCase() + "[463a26]" + text.substring(text.indexOf(hotkey.toLowerCase()) + hotkey.length()) : "[463a26]" + text + " ([726534]" + hotkey + "[463a26])")) : "[463a26]" + text;
            this.hook(x, y, w, 26.0, new Hook(new Hook.Type[]{Hook.Type.MOUSE_1_CLICKED}){

                public void run(Input in, Pt p, Hook.Type type) {
                    if (MyDraw.this.state.canClick()) {
                        MyDraw.this.state.hasClicked();
                        in.play("click", 1.0, 1.0, 0.0, 0.0);
                        if (onClick != null) {
                            onClick.run();
                        }
                        if (onClick2 != null) {
                            onClick2.run(in);
                        }
                    }
                }
            });
            boolean hover = MyDraw.in(x, y, w, 24, this.state.cursor);
            this.blit(hover ? BUTTON_LIT_START : BUTTON_START, x, y);
            for (int x2 = x + MyDraw.BUTTON_START.srcWidth; x2 < x + w - MyDraw.BUTTON_END.srcWidth; x2 += MyDraw.BUTTON_MIDDLE.srcWidth) {
                this.blit(hover ? BUTTON_LIT_MIDDLE : BUTTON_MIDDLE, x2, y);
            }
            this.blit(hover ? BUTTON_LIT_END : BUTTON_END, x + w - MyDraw.BUTTON_END.srcWidth, y);
            this.state.addGlowRect(x, y, w, 26);
        } else {
            text = "[463a26]" + text;
            this.hook(x, y, w, 24.0, new Hook(new Hook.Type[]{Hook.Type.MOUSE_1_CLICKED}){

                public void run(Input in, Pt p, Hook.Type type) {
                    MyDraw.this.state.hasClicked();
                    in.play("unclick", 1.0, 1.0, 0.0, 0.0);
                }
            });
            this.blit(BUTTON_DIS_START, x, y);
            for (int x2 = x + MyDraw.BUTTON_START.srcWidth; x2 < x + w - MyDraw.BUTTON_END.srcWidth; x2 += MyDraw.BUTTON_MIDDLE.srcWidth) {
                this.blit(BUTTON_DIS_MIDDLE, x2, y);
            }
            this.blit(BUTTON_DIS_END, x + w - MyDraw.BUTTON_END.srcWidth, y);
        }
        Pt dims = this.textSize(text, AGame.BIG_FOUNT);
        this.text(text, AGame.BIG_FOUNT, x + w / 2 - (int)(dims.x / 2.0), y + 2);
    }

    public void repeatingButton(int x, int y, int w, int h, String text, String hotkey, Runnable onClick, boolean enabled) {
        this.button(x, y, w, text, hotkey, onClick, enabled);
    }

    public void button(int x, int y, int w, String text, String hotkey, InputRunnable onClick) {
        this.button(x, y, w, text, hotkey, null, onClick, true);
    }

    public void button(int x, int y, int w, String text, InputRunnable onClick) {
        this.button(x, y, w, text, null, null, onClick, true);
    }

    public void button(int x, int y, int w, String text, String hotkey, InputRunnable onClick, boolean enabled) {
        this.button(x, y, w, text, hotkey, null, onClick, enabled);
    }

    public void goldbutton(int x, int y, int w, String text, String hotkey, InputRunnable onClick, boolean enabled) {
        this.button(x, y, w, text, hotkey, null, onClick, enabled);
        if (enabled) {
            int amt = (int)(45.0 * (1.0 + Math.sin((double)this.state.time * 0.003)));
            this.rect(new Clr(245, 237, 181, amt), x - 3, y - 3, w + 6, 30.0);
            this.rect(new Clr(255, 255, 255, amt), x - 1, y - 1, w + 2, 26.0);
        }
    }

    public Clr pulse(Clr c) {
        double amt = (1.0 + Math.sin((double)this.state.time * 0.003)) / 4.0;
        return c.mix(amt, Clr.WHITE);
    }

    public Clr darkPulse(Clr c) {
        double amt = (1.0 + Math.sin((double)this.state.time * 0.003)) / 4.0;
        return c.mix(amt, Clr.BLACK);
    }

    public void toggle(int x, int y, int w, String text, String hotkey, final InputRunnable onClick, boolean selected, boolean enabled) {
        --x;
        --y;
        w += 2;
        if (enabled) {
            text = hotkey != null ? (text.contains(hotkey) ? "[463a26]" + text.substring(0, text.indexOf(hotkey)) + "[726534]" + hotkey + "[463a26]" + text.substring(text.indexOf(hotkey) + hotkey.length()) : (text.contains(hotkey.toLowerCase()) ? "[463a26]" + text.substring(0, text.indexOf(hotkey.toLowerCase())) + "[726534]" + hotkey.toLowerCase() + "[463a26]" + text.substring(text.indexOf(hotkey.toLowerCase()) + hotkey.length()) : "[463a26]" + text + " ([726534]" + hotkey + "[463a26])")) : "[463a26]" + text;
            this.hook(x, y, w, 24.0, new Hook(new Hook.Type[]{Hook.Type.MOUSE_1_CLICKED}){

                public void run(Input in, Pt p, Hook.Type type) {
                    if (MyDraw.this.state.canClick()) {
                        MyDraw.this.state.hasClicked();
                        in.play("click", 1.0, 1.0, 0.0, 0.0);
                        if (onClick != null) {
                            onClick.run(in);
                        }
                    }
                }
            });
            boolean hover = MyDraw.in(x, y, w, 24, this.state.cursor);
            this.blit(selected ? TOGGLE_ON_START : TOGGLE_OFF_START, x, y);
            for (int x2 = x + MyDraw.BUTTON_START.srcWidth; x2 < x + w - MyDraw.BUTTON_END.srcWidth; x2 += MyDraw.BUTTON_MIDDLE.srcWidth) {
                this.blit(hover ? BUTTON_LIT_MIDDLE : BUTTON_MIDDLE, x2, y);
            }
            this.blit(selected ? TOGGLE_ON_END : TOGGLE_OFF_END, x + w - MyDraw.BUTTON_END.srcWidth, y);
            this.state.addGlowRect(x, y, w, 26);
        } else {
            text = "[463a26]" + text;
            this.hook(x, y, w, 24.0, new Hook(new Hook.Type[]{Hook.Type.MOUSE_1_CLICKED}){

                public void run(Input in, Pt p, Hook.Type type) {
                    in.play("unclick", 1.0, 1.0, 0.0, 0.0);
                    MyDraw.this.state.hasClicked();
                }
            });
            this.blit(BUTTON_DIS_START, x, y);
            for (int x2 = x + MyDraw.BUTTON_START.srcWidth; x2 < x + w - MyDraw.BUTTON_END.srcWidth; x2 += MyDraw.BUTTON_MIDDLE.srcWidth) {
                this.blit(BUTTON_DIS_MIDDLE, x2, y);
            }
            this.blit(BUTTON_DIS_END, x + w - MyDraw.BUTTON_END.srcWidth, y);
        }
        Pt dims = this.textSize(text, AGame.BIG_FOUNT);
        this.text(text, AGame.BIG_FOUNT, x + w / 2 - (int)(dims.x / 2.0), y + 2);
    }

    public void confirmDialog(int x, int y, int w, String text, Runnable onOK, Runnable onCancel) {
        this.confirmDialog(x, y, w, text, Lang._t("OK", new Object[0]), Lang._t("Cancel", new Object[0]), onOK, onCancel);
    }

    public void confirmDialog(int x, int y, int w, String text, String ok, String cancel, Runnable onOK, Runnable onCancel) {
        int h = (int)this.textSize((String)text, (Fount)AGame.FOUNT, (double)0.0, (double)0.0, (int)(w - 24)).height + 12 + 24 + 24;
        this.drawShadowedWindow(x, y, w, h);
        this.text(text, AGame.FOUNT, x + 12, y + 12, w - 24);
        this.button(x + 12, y + h - 12 - 24, 100, ok, onOK);
        this.button(x + 12 + 100 + 3, y + h - 12 - 24, 100, cancel, onCancel);
    }

    public void messageDialog(int x, int y, int w, String text, Runnable onOK) {
        int h = (int)this.textSize((String)text, (Fount)AGame.FOUNT, (double)0.0, (double)0.0, (int)(w - 24)).height + 12 + 24 + 24;
        this.drawShadowedWindow(x, y, w, h);
        if (text.contains("{0}")) {
            AirshipGame.report(text);
        }
        this.text(text, AGame.FOUNT, x + 12, y + 12, w - 24);
        this.button(x + 12, y + h - 12 - 24, 100, Lang._t("OK", new Object[0]), onOK);
    }

    public void repeatingIconButton(int x, int y, Img icon, Runnable onClick, boolean enabled) {
        this.iconButton(x, y, icon, onClick, null, enabled, true);
    }

    public void iconButton(int x, int y, Img icon, Runnable onClick, boolean enabled) {
        this.iconButton(x, y, icon, onClick, null, enabled, false);
    }

    public void iconButton(int x, int y, Img icon, final Runnable onClick, final InputRunnable onClick2, boolean enabled, boolean repeating) {
        if (enabled) {
            boolean hover = MyDraw.in(x, y, 24, 24, this.state.cursor);
            if (hover) {
                this.blit(ICON_BUTTON_LIT, x - 1, y - 1);
                this.blit(icon, LIT_ICON_TINT, x + 4, y + 4);
            } else {
                this.blit(ICON_BUTTON, x - 1, y - 1);
                this.blit(icon, ICON_TINT, x + 4, y + 4);
            }
            if (repeating) {
                this.hook(x, y, 24.0, 24.0, new Hook(new Hook.Type[]{Hook.Type.MOUSE_1_DOWN}){

                    public void run(Input in, Pt p, Hook.Type type) {
                        if (onClick != null) {
                            onClick.run();
                        }
                        if (onClick2 != null) {
                            onClick2.run(in);
                        }
                    }
                });
            } else {
                this.hook(x, y, 24.0, 24.0, new Hook(new Hook.Type[]{Hook.Type.MOUSE_1_CLICKED}){

                    public void run(Input in, Pt p, Hook.Type type) {
                        if (MyDraw.this.state.canClick()) {
                            MyDraw.this.state.hasClicked();
                            in.play("click", 1.0, 1.0, 0.0, 0.0);
                            if (onClick != null) {
                                onClick.run();
                            }
                            if (onClick2 != null) {
                                onClick2.run(in);
                            }
                        }
                    }
                });
            }
            this.state.addGlowRect(x, y, 24, 24);
        } else {
            this.blit(ICON_BUTTON_DISABLED, x - 1, y - 1);
            this.blit(icon, ICON_TINT, x + 4, y + 4);
            this.hook(x, y, 24.0, 24.0, new Hook(new Hook.Type[]{Hook.Type.MOUSE_1_CLICKED}){

                public void run(Input in, Pt p, Hook.Type type) {
                    in.play("unclick", 1.0, 1.0, 0.0, 0.0);
                }
            });
        }
    }

    public void iconToggle(int x, int y, Img icon, Runnable onClick, boolean selected, boolean enabled) {
        this.iconToggle(x, y, icon, onClick, null, selected, enabled);
    }

    public void iconToggle(int x, int y, Img icon, final Runnable onClick, final InputRunnable onClick2, boolean selected, boolean enabled) {
        if (enabled || selected) {
            boolean hover = MyDraw.in(x, y, 24, 24, this.state.cursor);
            if (hover) {
                this.blit(ICON_BUTTON_LIT, x - 1, y - 1);
                this.blit(icon, LIT_ICON_TINT, x + 4, y + 4);
            } else {
                this.blit(selected ? ICON_TOGGLE_ON : ICON_TOGGLE_OFF, x - 1, y - 1);
                this.blit(icon, ICON_TINT, x + 4, y + 4);
            }
            this.hook(x, y, 24.0, 24.0, new Hook(new Hook.Type[]{Hook.Type.MOUSE_1_CLICKED}){

                public void run(Input in, Pt p, Hook.Type type) {
                    if (MyDraw.this.state.canClick()) {
                        MyDraw.this.state.hasClicked();
                        in.play("click", 1.0, 1.0, 0.0, 0.0);
                        if (onClick != null) {
                            onClick.run();
                        }
                        if (onClick2 != null) {
                            onClick2.run(in);
                        }
                    }
                }
            });
            this.state.addGlowRect(x, y, 24, 24);
        } else {
            this.blit(ICON_BUTTON_DISABLED, x - 1, y - 1);
            this.blit(icon, ICON_TINT, x + 4, y + 4);
            this.hook(x, y, 24.0, 24.0, new Hook(new Hook.Type[]{Hook.Type.MOUSE_1_CLICKED}){

                public void run(Input in, Pt p, Hook.Type type) {
                    in.play("unclick", 1.0, 1.0, 0.0, 0.0);
                }
            });
        }
    }

    public void iconButton(int x, int y, Img icon, InputRunnable onClick, boolean enabled) {
        this.iconButton(x, y, icon, null, onClick, enabled, false);
    }

    public void iconToggle(int x, int y, Img icon, InputRunnable onClick, boolean selected, boolean enabled) {
        this.iconToggle(x, y, icon, null, onClick, selected, enabled);
    }

    public void tooltip(double x, double y, double w, double h, final String text) {
        this.hook(x, y, w, h, new Hook(new Hook.Type[]{Hook.Type.HOVER}){

            public void run(Input in, Pt p, Hook.Type type) {
                MyDraw.this.state.newtooltipText = text;
            }
        });
    }

    public void slider(int x, int y, int w, final SliderModel m) {
        int range = m.max() - m.min();
        int steps = Math.min(range + 1, w / 9);
        int stepXStep = w / steps;
        for (int i = 0; i < steps; ++i) {
            final int value = i == 0 ? m.min() : (i == steps - 1 ? m.max() : m.min() + (int)Math.ceil((double)(range * i) * 1.0 / (double)steps));
            boolean selected = value == m.getValue();
            this.drawPanel(x + stepXStep * i, y, stepXStep - 1, 24);
            Clr inside = TOGGLE_OFF_INSIDE;
            if (selected) {
                inside = PROGRESS_BAR_INSIDE;
            } else if (MyDraw.in(x + stepXStep * i, y, stepXStep - 1, this.state.cursor)) {
                inside = PROGRESS_BAR_DEEP_INSIDE;
            }
            this.rect(inside, x + stepXStep * i + 2, y + 2, stepXStep - 5, 20.0);
            this.hook(x + stepXStep * i, y, stepXStep - 1, 24.0, new Hook(new Hook.Type[]{Hook.Type.MOUSE_1_CLICKED}){

                public void run(Input in, Pt p, Hook.Type type) {
                    m.setValue(value);
                }
            });
        }
    }

    public static interface SliderModel {
        public int min();

        public int max();

        public int getValue();

        public void setValue(int var1);
    }

    public static class State {
        Cursor cursorAppearance = Cursor.POINTER;
        Clr cursorTint = Clr.WHITE;
        String cursorText = null;
        String tooltipText = "";
        String newtooltipText = "";
        int ticksSinceMouseMoved = 0;
        int time = 0;
        HashMap<UIGlowRect, UIGlowRect> glowRects = new HashMap();
        int msSinceLastClick = 0;
        Pt cursor = new Pt(0.0, 0.0);

        public void addGlowRect(int x, int y, int w, int h) {
            UIGlowRect r = new UIGlowRect(x, y, w, h);
            if (this.glowRects.containsKey(r)) {
                r = this.glowRects.get(r);
                r.confirmed = true;
            } else {
                this.glowRects.put(r, r);
            }
        }

        public void removeIntersectingGlowRects(int x, int y, int w, int h) {
            Iterator<UIGlowRect> it = this.glowRects.keySet().iterator();
            while (it.hasNext()) {
                UIGlowRect gr = it.next();
                if (!Rect2D.intersects(gr.x, gr.y, gr.w, gr.h, x, y, w, h)) continue;
                it.remove();
            }
        }

        public void resetCursor() {
            this.cursorAppearance = Cursor.POINTER;
            this.cursorTint = Clr.WHITE;
            this.cursorText = null;
        }

        public void setCursor(Cursor cursorAppearance, Clr cursorTint, String cursorText) {
            this.cursorAppearance = cursorAppearance;
            this.cursorTint = cursorTint;
            this.cursorText = cursorText;
        }

        public void tick(int ms, Pt cursor) {
            this.time += ms;
            this.msSinceLastClick += ms;
            if (!this.tooltipText.equals(this.newtooltipText)) {
                if (this.cursor == null || cursor == null || !this.cursor.equals((Object)cursor)) {
                    this.ticksSinceMouseMoved = 0;
                }
                this.tooltipText = this.newtooltipText;
            }
            this.newtooltipText = "";
            this.cursor = cursor;
            ++this.ticksSinceMouseMoved;
        }

        public boolean canClick() {
            return this.msSinceLastClick > 100;
        }

        public void hasClicked() {
            this.msSinceLastClick = 0;
        }
    }
}

