/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.AffordableFilter;
import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.AirshipGame;
import com.zarkonnen.airships.Bonus;
import com.zarkonnen.airships.EditShipIntent;
import com.zarkonnen.airships.Empire;
import com.zarkonnen.airships.FileScreen;
import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.PlaceShipTool;
import com.zarkonnen.airships.PriceInlineInfo;
import com.zarkonnen.airships.RefitFromDefencesIntent;
import com.zarkonnen.airships.RefitFromStrategicIntent;
import com.zarkonnen.airships.ShipEditorUtils;
import com.zarkonnen.airships.ShipHelperWidget;
import com.zarkonnen.airships.UniScreen;
import com.zarkonnen.catengine.Input;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import org.json.JSONObject;
import org.json.JSONTokener;

public class OpenDesignButton
extends UniScreen.Button {
    @Override
    public boolean visible(UniScreen us) {
        return us.intent instanceof EditShipIntent;
    }

    @Override
    public String text(UniScreen us) {
        return Lang._t("Open_design", new Object[0]);
    }

    @Override
    public void click(Input in, UniScreen us) {
        EditShipIntent esi = (EditShipIntent)us.intent;
        Empire e = esi.getPlayerEmpire();
        if (e == null) {
            ShipHelperWidget shw = ShipHelperWidget.get(new File(AGame.getGameDirectory(), esi.type((UniScreen)us).dirName), us.g.getBestCOA(), Bonus.STANDARD_BONUSES, 0);
            us.g.s = new FileScreen(ShipEditorUtils.shipsList(esi.type(us), shw), new OpenShipMission(us.g, us), shw, new PriceInlineInfo(shw, esi.getOriginal(us)));
        } else {
            ShipHelperWidget shw = ShipHelperWidget.get(new File(AGame.getGameDirectory(), esi.type((UniScreen)us).dirName), e.arms, e.bonuses(), e.money);
            if (esi instanceof RefitFromDefencesIntent || esi instanceof RefitFromStrategicIntent) {
                shw.original = esi.getOriginal(us);
            }
            FileScreen fs = new FileScreen(ShipEditorUtils.shipsList(esi.type(us), shw), new OpenShipMission(us.g, us), shw, new PriceInlineInfo(shw, esi.getOriginal(us)));
            fs.enabledFilter = new AffordableFilter(e.money, e.bonuses(), shw, esi.getOriginal(us));
            fs.allowOpeningDisabledItems = true;
            us.g.s = fs;
        }
    }

    @Override
    public String hotkey(UniScreen us) {
        return "O";
    }

    private static class OpenShipMission
    implements FileScreen.Mission {
        private final AirshipGame g;
        private final UniScreen us;

        public OpenShipMission(AirshipGame g, UniScreen us) {
            this.g = g;
            this.us = us;
        }

        @Override
        public FileScreen.Mode mode() {
            return FileScreen.Mode.OPEN;
        }

        @Override
        public String text() {
            return Lang._t("Open_", new Object[0]);
        }

        @Override
        public String fileSelectionText() {
            return Lang._t("Open", new Object[0]);
        }

        @Override
        public String initialInput() {
            return "";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void fileSelected(String name) {
            this.g.s = this.us;
            EditShipIntent esi = (EditShipIntent)this.us.intent;
            BufferedReader r = null;
            try {
                r = new BufferedReader(new FileReader(new File(new File(AGame.getGameDirectory(), esi.type((UniScreen)this.us).dirName), name + ".json")));
                Airship ship = new Airship(new JSONObject(new JSONTokener(r)));
                ship.repair();
                Airship prevShip = esi.getShip(this.us);
                ship.x = prevShip.x;
                if (ship.type.onGround) {
                    ship.y = PlaceShipTool.getAdjustedY(ship, ship.x, ship.y, this.us, false);
                } else {
                    ship.y = prevShip.y;
                    if (ship.y < (double)(512 - ship.serviceCeiling())) {
                        ship.y = 512 - ship.serviceCeiling();
                    }
                }
                esi.setShip(this.us, ship);
                esi.centerShip(this.us);
                esi.justSaved = true;
            }
            catch (Exception e) {
                this.g.reportError(Lang._t("Unable_to_load_ship_or_building", new Object[0]), e, null, false);
            }
            finally {
                try {
                    r.close();
                }
                catch (Exception e) {}
            }
        }

        @Override
        public void cancelled() {
            this.g.s = this.us;
        }
    }
}

