/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.catengine.Fount;
import com.zarkonnen.catengine.Img;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.HashMap;
import javax.imageio.ImageIO;

public class OutlineRenderer {
    public static void main(String[] args) throws IOException {
        BufferedImage srcImg = ImageIO.read(new File(args[0]));
        Fount srcFount = Fount.fromResource(null, (String)args[1]);
        BufferedImage trgImg = new BufferedImage(srcImg.getWidth() * 2, srcImg.getHeight() * 2, 2);
        HashMap<String, Object> letters = new HashMap<String, Object>();
        for (int i = 0; i < srcFount.imgs.length; ++i) {
            if (srcFount.imgs[i] == null) continue;
            letters.put(new String(new char[]{(char)i}), srcFount.imgs[i]);
        }
        for (Integer k : srcFount.extended.keySet()) {
            letters.put(new String(new char[]{(char)k.intValue()}), srcFount.extended.get(k));
        }
        PrintWriter out = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(new File(args[3])), "UTF-8"));
        out.println("letterSpacing -5");
        out.println("letterXOffset -2");
        Graphics2D g = trgImg.createGraphics();
        for (String letter : letters.keySet()) {
            Img img = (Img)letters.get(letter);
            int trgX = img.srcX * 3 / 2 + 1;
            int trgY = img.srcY * 3 / 2 + 1;
            out.println(letter);
            System.out.println(letter);
            out.println(trgX + " " + trgY + " " + (img.srcWidth + 5) + " " + (img.srcHeight + 5));
            for (int dy = 0; dy < 5; ++dy) {
                for (int dx = 0; dx < 5; ++dx) {
                    g.drawImage(srcImg, trgX + dx, trgY + dy, trgX + dx + img.srcWidth, trgY + dy + img.srcHeight, img.srcX, img.srcY, img.srcX + img.srcWidth, img.srcY + img.srcHeight, null);
                }
            }
        }
        out.close();
        ImageIO.write((RenderedImage)trgImg, "PNG", new File(args[2]));
    }
}

