/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.ArmourType;
import com.zarkonnen.airships.CoatOfArms;
import com.zarkonnen.airships.MyDraw;
import com.zarkonnen.airships.PlaceModuleTool;
import com.zarkonnen.airships.PlaceTool;
import com.zarkonnen.airships.Tile;
import com.zarkonnen.airships.UniScreen;
import com.zarkonnen.catengine.Input;
import com.zarkonnen.catengine.util.Pt;
import com.zarkonnen.catengine.util.ScreenMode;

public class PaintArmourTool
extends PlaceTool {
    public CoatOfArms.Tincture tinc;

    public PaintArmourTool(CoatOfArms.Tincture paint) {
        this.tinc = paint;
    }

    @Override
    public void scaledDraw(MyDraw d, double x, double y, int gridX, int gridY, UniScreen us) {
        if (this.tinc == null) {
            PlaceModuleTool.REMOVE.draw(d, x, y, 0, false);
        } else {
            d.rect(this.tinc.tint, x, y, 16.0, 16.0);
        }
    }

    @Override
    public void unscaledDraw(MyDraw d, Pt cursor, ScreenMode sm, UniScreen us) {
    }

    @Override
    public boolean click(Input in, Pt click, ScreenMode sm, UniScreen us) {
        int[] sp;
        if (click.x < 300.0) {
            return false;
        }
        Airship ship = this.ship(us);
        Tile t = ship.tileAt((sp = this.localShipPt(click, us, 1))[0], sp[1]);
        if (t != null && t.armour.type != ArmourType.NONE) {
            t.armour.paint = this.tinc;
            this.modified(us);
            return true;
        }
        return false;
    }

    @Override
    public boolean rightClick(Input in, Pt click, ScreenMode sm, UniScreen us) {
        int[] sp;
        if (click.x < 300.0) {
            return false;
        }
        Airship ship = this.ship(us);
        Tile t = ship.tileAt((sp = this.localShipPt(click, us, 1))[0], sp[1]);
        if (t != null) {
            this.tinc = t.armour.paint;
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseDown(Input in, Pt mouseDown, ScreenMode sm, UniScreen us) {
        return this.click(in, mouseDown, sm, us);
    }

    @Override
    public void tick(Input in, int ms, UniScreen us) {
    }
}

