/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.Appearance;
import com.zarkonnen.airships.Body;
import com.zarkonnen.airships.Combat;
import com.zarkonnen.catengine.Draw;
import com.zarkonnen.catengine.util.Clr;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL20;

public class Particle {
    public Type type;
    public double x;
    public double y;
    public double dx;
    public double dy;
    public int life;
    public int lifespan;
    public final int variant;
    public final double startSize;
    private Clr ambientedClrCache;
    private float ambientedClrValue = -1.0f;

    public Particle(Type type, double x, double y) {
        this.type = type;
        double direction = AGame.ANIM_R.nextDouble() * Math.PI * 2.0;
        double dirDist = AGame.ANIM_R.nextDouble();
        this.x = x + Math.cos(direction) * type.offset * dirDist;
        this.y = y + Math.sin(direction) * type.offset * dirDist;
        this.dx = type.minDx + AGame.ANIM_R.nextDouble() * (type.maxDx - type.minDx);
        this.dy = type.minDy + AGame.ANIM_R.nextDouble() * (type.maxDy - type.minDy);
        this.life = this.lifespan = type.minLifespan + AGame.ANIM_R.nextInt(type.maxLifespan - type.minLifespan);
        this.variant = type.pt == null ? 0 : AGame.ANIM_R.nextInt(type.pt.numVariants);
        this.startSize = (double)type.startSize * 1.0 * (0.8 + AGame.ANIM_R.nextDouble() * 0.5);
    }

    public Particle(Type type, double x, double y, double dx, double dy) {
        this.type = type;
        this.x = x;
        this.y = y;
        this.dx = dx;
        this.dy = dy;
        this.life = this.lifespan = type.minLifespan + AGame.ANIM_R.nextInt(type.maxLifespan - type.minLifespan);
        this.variant = type.pt == null ? 0 : AGame.ANIM_R.nextInt(type.pt.numVariants);
        this.startSize = (double)type.startSize * 1.0 * (0.8 + AGame.ANIM_R.nextDouble() * 0.5);
    }

    public boolean tick(int ms, double wind, Combat c) {
        this.dy += this.type.grav;
        this.dx += wind * this.type.windMult;
        this.y += this.dy;
        this.x += this.dx;
        this.life -= ms;
        if (this.life > 0 && this.type.stickSpeed > 0.0 && this.dx * this.dx + this.dy * this.dy < this.type.stickSpeed * this.type.stickSpeed) {
            int bsz = c.physics.bodies.size();
            for (int bi = 0; bi < bsz; ++bi) {
                Body b = c.physics.bodies.get(bi);
                if (b == c.landFormations.get(0) || !b.canParticleStick(this.x, this.y)) continue;
                b.stuckParticles.add(this);
                this.x -= b.x;
                this.y -= b.y;
                this.lifespan = this.type.maxLifespan * 64;
                this.life *= 64;
                return true;
            }
        }
        return this.life <= 0;
    }

    public void drawAsSquare(Draw d, double xShift, double yShift, float ambient) {
        if (this.life > this.lifespan) {
            this.life = this.lifespan;
        }
        double sz = this.startSize + 1.0 * ((double)this.type.endSize - this.startSize) * (double)(this.lifespan - this.life) / (double)this.lifespan;
        Clr c = this.type.gradient[(this.type.gradient.length - 1) * (this.lifespan - this.life) / this.lifespan];
        if (this.type.lightClr == null) {
            if (ambient != this.ambientedClrValue) {
                this.ambientedClrCache = new Clr((int)((float)c.r * ambient), (int)((float)c.g * ambient), (int)((float)c.b * ambient), c.a);
                this.ambientedClrValue = ambient;
            }
            c = this.ambientedClrCache;
        }
        d.rect(c, this.x + xShift - sz / 2.0, this.y + yShift - sz / 2.0, sz, sz);
    }

    public void drawAsPicture(Draw d, double xShift, double yShift) {
        double sz = this.startSize + 1.0 * ((double)this.type.endSize - this.startSize) * (double)(this.lifespan - this.life) / (double)this.lifespan;
        Clr c = this.type.gradient[(this.type.gradient.length - 1) * (this.lifespan - this.life) / this.lifespan];
        GL11.glColor4f((float)((float)c.r / 255.0f), (float)((float)c.g / 255.0f), (float)((float)c.b / 255.0f), (float)((float)c.a / 255.0f));
        double srcX = this.type.pt.xOffsets[this.variant];
        double srcY = this.type.pt.yOffsets[this.variant];
        double srcX2 = srcX + this.type.pt.size;
        double srcY2 = srcY + this.type.pt.size;
        GL11.glTexCoord2d((double)srcX, (double)srcY);
        GL11.glVertex2d((double)(this.x + xShift - sz / 2.0), (double)(this.y + yShift - sz / 2.0));
        GL11.glTexCoord2d((double)srcX, (double)srcY2);
        GL11.glVertex2d((double)(this.x + xShift - sz / 2.0), (double)(this.y + yShift + sz / 2.0));
        GL11.glTexCoord2d((double)srcX2, (double)srcY2);
        GL11.glVertex2d((double)(this.x + xShift + sz / 2.0), (double)(this.y + yShift + sz / 2.0));
        GL11.glTexCoord2d((double)srcX2, (double)srcY);
        GL11.glVertex2d((double)(this.x + xShift + sz / 2.0), (double)(this.y + yShift - sz / 2.0));
    }

    public void drawAsShadedPicture(Draw d, float ambient) {
        double sz = this.startSize + 1.0 * ((double)this.type.endSize - this.startSize) * (double)(this.lifespan - this.life) / (double)this.lifespan;
        Clr c = this.type.tintGradient[(this.type.tintGradient.length - 1) * (this.lifespan - this.life) / this.lifespan];
        GL20.glVertexAttrib4f((int)Appearance.lsp.getAttributeID("tint"), (float)((float)c.r / 255.0f * ambient), (float)((float)c.g / 255.0f * ambient), (float)((float)c.b / 255.0f * ambient), (float)((float)c.a / 255.0f));
        double srcX = this.type.pt.xOffsets[this.variant] * 1024.0;
        double srcY = this.type.pt.yOffsets[this.variant] * 1024.0;
        double srcX2 = srcX + this.type.pt.size * 1024.0;
        double srcY2 = srcY + this.type.pt.size * 1024.0;
        GL11.glTexCoord2d((double)srcX, (double)srcY);
        GL11.glVertex2d((double)(this.x - sz / 2.0), (double)(this.y - sz / 2.0));
        GL11.glTexCoord2d((double)srcX, (double)srcY2);
        GL11.glVertex2d((double)(this.x - sz / 2.0), (double)(this.y + sz / 2.0));
        GL11.glTexCoord2d((double)srcX2, (double)srcY2);
        GL11.glVertex2d((double)(this.x + sz / 2.0), (double)(this.y + sz / 2.0));
        GL11.glTexCoord2d((double)srcX2, (double)srcY);
        GL11.glVertex2d((double)(this.x + sz / 2.0), (double)(this.y - sz / 2.0));
    }

    public static enum Type {
        SMOKE(PictureType.SMOKE, true, new Clr(200, 200, 200, 200), new Clr(255, 255, 255, 0), 0.0, false, -0.008, 1.0, 0.0, -0.1, 0.03, -0.03, 0.05, 3000, 6000, 10, 40, new Clr(80, 80, 80, 180), null, new Clr(210, 210, 200, 0), null, 0),
        FIRE_SMOKE(PictureType.SMOKE, true, new Clr(200, 200, 200, 230), new Clr(255, 255, 255, 100), 0.0, false, -0.008, 1.0, 9.0, -0.1, 0.03, -0.03, 0.05, 3000, 6000, 15, 30, new Clr(80, 80, 80, 180), null, new Clr(210, 210, 200, 0), null, 0),
        TRAILING_SMOKE(PictureType.SMOKE, true, new Clr(200, 200, 200, 150), new Clr(255, 255, 255, 0), 0.0, false, 0.0, 0.5, 1.5, -0.1, 0.1, -0.1, 0.1, 300, 1000, 8, 16, new Clr(80, 80, 80, 180), null, new Clr(210, 210, 200, 0), null, 0),
        MUZZLE_SMALL(PictureType.FLASH, false, Clr.WHITE, new Clr(255, 255, 255, 0), 0.0, false, 0.0, 0.0, 2.0, 0.0, 0.0, 0.0, 0.0, 20, 30, 6, 12, new Clr(255, 255, 220, 180), null, new Clr(255, 255, 200, 80), new Clr(43, 40, 28), 50),
        MUZZLE(PictureType.FLASH, false, Clr.WHITE, new Clr(255, 255, 255, 0), 0.0, false, 0.0, 0.0, 5.0, 0.0, 0.0, 0.0, 0.0, 60, 80, 18, 36, new Clr(255, 255, 220, 180), null, new Clr(255, 255, 200, 80), new Clr(86, 80, 56), 150),
        MUZZLE_CHUNK(PictureType.PUFF, true, Clr.fromHex((String)"bb421d"), Clr.fromHex((String)"613f2d55"), 0.0, false, 0.0, 0.0, 9.0, 0.0, 0.0, 0.0, 0.0, 300, 500, 9, 1, Clr.fromHex((String)"bb421d"), null, Clr.fromHex((String)"613f2d55"), null, 0),
        IMPACT(PictureType.FLASH, false, Clr.WHITE, new Clr(255, 255, 255, 0), 0.0, false, 0.0, 0.3, 6.0, 0.0, 0.0, 0.0, 0.0, 50, 90, 7, 4, new Clr(255, 255, 220, 180), null, new Clr(255, 200, 200, 80), new Clr(43, 40, 28), 50),
        FRAGMENT(null, false, null, null, 0.0, false, 0.016, 0.3, 12.0, -0.8, 0.8, -0.8, 0.8, 300, 900, 3, 3, Clr.fromHex((String)"613f2d"), null, Clr.fromHex((String)"613f2d00"), null, 0),
        FIRE(null, false, null, null, 0.0, false, -0.012, 0.1, 10.0, -0.01, 0.01, -0.01, 0.01, 1000, 2000, 10, 5, new Clr(225, 223, 126, 150), new Clr(255, 178, 42, 150), new Clr(255, 64, 3, 0), new Clr(17, 12, 3), 60),
        ROCKET_EXHAUST(null, false, null, null, 0.0, false, 0.0, 0.0, 3.0, 0.0, 0.0, 0.0, 0.0, 200, 250, 4, 1, new Clr(225, 223, 126, 150), new Clr(255, 178, 42, 150), new Clr(255, 64, 3, 0), new Clr(17, 12, 3), 40),
        GRENADE_SPARK(null, false, null, null, 0.0, false, 0.016, 0.0, 3.0, 0.0, 0.0, 0.0, 0.0, 50, 200, 3, 1, new Clr(225, 223, 126, 200), new Clr(255, 178, 42, 150), new Clr(255, 64, 3, 0), new Clr(17, 12, 3), 40),
        EXPLODE(PictureType.EXPLOSION, false, Clr.WHITE, new Clr(255, 255, 255, 0), 0.0, false, 0.0, 0.0, 30.0, 0.0, 0.0, 0.0, 0.0, 100, 150, 60, 90, new Clr(255, 255, 255, 180), null, Clr.fromHex((String)"bb421d00"), Clr.fromHex((String)"bb421d"), 400),
        EXPLODE_BACKS(PictureType.PUFF, true, Clr.fromHex((String)"613f2d"), Clr.fromHex((String)"613f2d00"), 0.0, false, 0.0, 0.0, 24.0, 0.0, 0.0, 0.0, 0.0, 300, 500, 32, 3, Clr.fromHex((String)"613f2d"), null, Clr.fromHex((String)"613f2d00"), null, 0),
        EXPLODE_BITS(PictureType.PUFF, true, Clr.fromHex((String)"bb421d"), Clr.fromHex((String)"613f2d55"), 0.0, false, 0.0, 0.0, 24.0, 0.0, 0.0, 0.0, 0.0, 300, 500, 24, 3, Clr.fromHex((String)"bb421d"), null, Clr.fromHex((String)"613f2d55"), null, 0),
        BLOOD_SPRAY(null, false, null, null, 1.0, false, 0.016, 0.1, 5.0, -1.5, 1.5, -1.5, 1.5, 300, 600, 3, 2, Clr.fromHex((String)"b14727"), null, Clr.fromHex((String)"b1472700"), null, 0),
        HEALING(null, false, null, null, 0.0, false, -0.09, 0.0, 7.0, 0.0, 0.0, -1.0, -2.0, 300, 600, 3, 2, Clr.fromHex((String)"729c2f"), null, Clr.fromHex((String)"729c2f00"), new Clr(18, 24, 7), 10),
        DUST(PictureType.PUFF, true, Clr.fromHex((String)"613f2d88"), Clr.fromHex((String)"613f2d00"), 0.0, false, 0.01, 0.7, 7.0, -1.0, 1.0, -0.5, -2.0, 600, 1200, 30, 50, Clr.fromHex((String)"4b2d1888"), null, Clr.fromHex((String)"4b2d1800"), null, 0),
        ROCK_BIT(null, false, null, null, 0.0, false, 0.016, 0.1, 12.0, -0.8, 0.8, -0.8, 0.8, 1000, 2000, 3, 3, Clr.fromHex((String)"6a6968"), null, Clr.fromHex((String)"141414"), null, 0),
        SUSP_SPARK(null, false, null, null, 0.0, false, -0.2, 0.1, 2.0, -0.1, 0.1, -0.1, 0.1, 100, 200, 3, 1, Clr.fromHex((String)"f5edb5"), null, Clr.fromHex((String)"f5edb550"), new Clr(29, 28, 21), 20),
        WATER(null, false, null, null, 0.0, false, 0.05, 0.1, 10.0, -1.0, 1.0, -1.0, 0.2, 400, 600, 4, 2, Clr.fromHex((String)"709bcc"), null, Clr.fromHex((String)"709bcc"), null, 0),
        EMBER(null, false, null, null, 0.0, false, -0.012, 0.5, 2.0, -0.01, 0.01, -0.01, 0.01, 300, 600, 2, 1, new Clr(255, 178, 42, 150), null, new Clr(255, 64, 3, 0), new Clr(17, 12, 3), 30),
        SUSP_CHAMBER_SPARK(null, false, null, null, 0.0, false, -0.2, 0.1, 12.0, -0.1, 0.1, -0.01, 0.01, 150, 300, 3, 1, Clr.fromHex((String)"f5edb5"), null, Clr.fromHex((String)"f5edb550"), new Clr(29, 28, 21), 20),
        SMALL_SUSP_CHAMBER_SPARK(null, false, null, null, 0.0, false, -0.2, 0.1, 5.0, -0.1, 0.1, -0.01, 0.01, 100, 200, 3, 1, Clr.fromHex((String)"f5edb5"), null, Clr.fromHex((String)"f5edb550"), new Clr(29, 28, 21), 20),
        LARGE_SUSP_CHAMBER_SPARK(null, false, null, null, 0.0, false, -0.2, 0.1, 20.0, -0.1, 0.1, -0.01, 0.01, 120, 240, 3, 1, Clr.fromHex((String)"f5edb5"), null, Clr.fromHex((String)"f5edb550"), new Clr(29, 28, 21), 20),
        SUSP_BLOCK_SPARK(null, false, null, null, 0.0, false, -0.2, 0.1, 9.0, -0.1, 0.1, -0.01, 0.01, 1200, 2400, 3, 1, Clr.fromHex((String)"f5edb5"), null, Clr.fromHex((String)"f5edb550"), new Clr(29, 28, 21), 20),
        SPLINTER(null, false, null, null, 0.0, false, 0.016, 0.5, 12.0, -0.8, 0.8, -0.8, 0.8, 1000, 2000, 3, 3, Clr.fromHex((String)"613f2d"), null, Clr.fromHex((String)"613f2d"), null, 0),
        LEAF(null, false, null, null, 0.2, false, 0.01, 4.0, 12.0, -1.0, 1.0, -0.3, 0.3, 1000, 2000, 2, 2, Clr.fromHex((String)"729c2f"), null, Clr.fromHex((String)"729c2f"), null, 0),
        FALLING_LEAF(null, false, null, null, 0.0, false, 0.01, 4.0, 12.0, 0.0, 0.0, 0.0, 0.0, 1000, 1200, 2, 2, Clr.fromHex((String)"729c2f"), null, Clr.fromHex((String)"729c2f"), null, 0),
        FALLING_SNOW(null, false, null, null, 0.0, false, 0.02, 4.0, 12.0, 0.0, 0.0, 0.0, 0.0, 500, 800, 2, 2, Clr.WHITE, null, Clr.WHITE, null, 0),
        LIGHTNING_SPARK(null, false, null, null, 0.0, false, 0.03, 0.0, 30.0, -5.0, 5.0, -5.0, 5.0, 300, 600, 3, 1, Clr.WHITE, null, Clr.WHITE, Clr.WHITE, 10),
        LIGHTNING_FLASH(PictureType.FLASH, false, Clr.WHITE, new Clr(255, 255, 0), 0.0, false, 0.0, 0.0, 30.0, -1.0, 1.0, -1.0, 1.0, 100, 150, 20, 60, new Clr(255, 255, 255, 180), null, new Clr(255, 255, 255, 0), new Clr(128, 128, 128), 600),
        GROUND_SOIL(null, false, null, null, 0.5, false, 0.016, 0.2, 12.0, -0.5, 0.5, -0.2, -0.2, 400, 800, 4, 2, Clr.fromHex((String)"7b421b"), null, Clr.fromHex((String)"613f2d"), null, 0),
        GROUND_MUD(null, false, null, null, 0.3, false, 0.016, 0.2, 12.0, -1.0, 1.0, -1.0, -0.3, 400, 800, 3, 1, Clr.fromHex((String)"613f2d"), null, Clr.fromHex((String)"613f2d"), null, 0),
        GROUND_SNOW(null, false, null, null, 0.5, false, 0.008, 0.2, 12.0, -0.7, 0.7, -0.7, -0.2, 400, 800, 4, 2, Clr.WHITE, null, Clr.WHITE, null, 0),
        SMALL_SOOT(null, false, null, null, 1.5, true, 0.016, 0.1, 20.0, -2.0, 2.0, -2.0, 2.0, 200, 300, 1, 1, Clr.fromHex((String)"141414cc"), null, Clr.fromHex((String)"14141455"), null, 0),
        LARGE_SOOT(null, false, null, null, 1.3, true, 0.016, 0.1, 20.0, -1.5, 1.5, -1.5, 1.5, 150, 250, 2, 2, Clr.fromHex((String)"14141499"), null, Clr.fromHex((String)"14141444"), null, 0);

        public final PictureType pt;
        public final boolean lit;
        public final int maxSize;
        public final boolean dissolveWhenStuck;
        public final double stickSpeed;
        public final double grav;
        public final double windMult;
        public final double offset;
        public final double minDx;
        public final double maxDx;
        public final double minDy;
        public final double maxDy;
        public final int minLifespan;
        public final int maxLifespan;
        public final int startSize;
        public final int endSize;
        public final Clr startClr;
        public final Clr endClr;
        public final Clr[] gradient = new Clr[30];
        public final Clr[] tintGradient = new Clr[30];
        public final Clr lightClr;
        public final int lightRadius;

        private Type(PictureType pt, boolean lit, Clr tintStartClr, Clr tintEndClr, double stickSpeed, boolean dissolveWhenStuck, double grav, double windMult, double offset, double minDx, double maxDx, double minDy, double maxDy, int minLifespan, int maxLifespan, int startSize, int endSize, Clr startClr, Clr earlyClr, Clr endClr, Clr lightClr, int lightRadius) {
            int i;
            this.pt = pt;
            this.lit = lit;
            this.stickSpeed = stickSpeed;
            this.dissolveWhenStuck = dissolveWhenStuck;
            this.grav = grav;
            this.windMult = windMult;
            this.offset = offset;
            this.minDx = minDx;
            this.maxDx = maxDx;
            this.minDy = minDy;
            this.maxDy = maxDy;
            this.minLifespan = minLifespan;
            this.maxLifespan = maxLifespan;
            this.startSize = startSize;
            this.endSize = endSize;
            this.startClr = startClr;
            this.endClr = endClr;
            if (earlyClr != null) {
                for (i = 0; i < 3; ++i) {
                    this.gradient[i] = startClr.mix(1.0 * (double)i / 5.0, earlyClr);
                }
                for (i = 3; i < this.gradient.length; ++i) {
                    this.gradient[i] = earlyClr.mix(1.0 * (double)(i - 3) / (double)(this.gradient.length - 3), endClr);
                }
            } else {
                for (i = 0; i < this.gradient.length; ++i) {
                    this.gradient[i] = startClr.mix(1.0 * (double)i / (double)this.gradient.length, endClr);
                }
            }
            if (tintStartClr != null) {
                for (i = 0; i < this.tintGradient.length; ++i) {
                    this.tintGradient[i] = tintStartClr.mix(1.0 * (double)i / (double)this.tintGradient.length, tintEndClr);
                }
            }
            this.maxSize = Math.max(startSize, endSize);
            this.lightClr = lightClr;
            this.lightRadius = lightRadius;
        }
    }

    public static enum PictureType {
        FLASH(0, 9),
        EXPLOSION(9, 9),
        PUFF(18, 23),
        SMOKE(41, 23);

        public final double[] xOffsets;
        public final double[] yOffsets;
        public final double size = 0.125;
        public final int numVariants;

        private PictureType(int start, int numVariants) {
            this.numVariants = numVariants;
            this.xOffsets = new double[numVariants];
            this.yOffsets = new double[numVariants];
            for (int i = start; i < start + numVariants; ++i) {
                int x = i % 8 * 128;
                int y = i / 8 * 128;
                this.xOffsets[i - start] = (double)x * 1.0 / 1024.0;
                this.yOffsets[i - start] = (double)y * 1.0 / 1024.0;
            }
        }
    }

    public static class Emitter {
        public Type t;
        public double emitProbability;

        public Particle emit(double x, double y, int ms) {
            if (AGame.ANIM_R.nextDouble() < this.emitProbability * (double)ms) {
                return new Particle(this.t, x, y);
            }
            return null;
        }

        public Emitter(Type t, double emitProbability) {
            this.t = t;
            this.emitProbability = emitProbability;
        }
    }
}

