/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.Appearance;
import com.zarkonnen.airships.Body;
import com.zarkonnen.airships.MyDraw;
import com.zarkonnen.airships.Particle;
import com.zarkonnen.airships.Rect2D;
import com.zarkonnen.airships.TimeOfDay;
import com.zarkonnen.airships.UniScreen;
import com.zarkonnen.catengine.Input;
import java.util.HashMap;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;
import org.lwjgl.opengl.GL20;
import org.newdawn.slick.Image;
import org.newdawn.slick.opengl.Texture;
import org.newdawn.slick.opengl.TextureImpl;
import org.newdawn.slick.opengl.shader.ShaderProgram;

public class ParticleVisualLayer
implements UniScreen.VisualLayer {
    public static Texture particles;
    public static Texture bump;
    private static String currentPostfix;
    private static final HashMap<String, Texture> postfixToTex;

    @Override
    public void tick(Input in, int ms, UniScreen us) {
    }

    @Override
    public void draw(MyDraw d, UniScreen us, double cropX, double cropY, double cropW, double cropH) {
        if (us.combat == null) {
            return;
        }
        TimeOfDay tod = us.getTimeOfDay();
        if (!Appearance.currentPostfix.equals(currentPostfix)) {
            currentPostfix = Appearance.currentPostfix;
            if (!postfixToTex.containsKey(currentPostfix)) {
                postfixToTex.put(currentPostfix, Appearance.loadTex("particles" + currentPostfix));
            }
            particles = postfixToTex.get(currentPostfix);
        }
        if (us.combat.physics != null) {
            for (Body b : us.combat.physics.bodies) {
                if (b instanceof Airship && !((Airship)b).showingOutside) continue;
                for (Particle p : b.stuckParticles) {
                    double px = b.x + p.x;
                    double py = b.y + p.y;
                    if (p.type.pt != null || !Rect2D.intersects(cropX, cropY, cropW, cropH, px, py, p.type.maxSize, p.type.maxSize)) continue;
                    p.drawAsSquare(d, (int)b.x, (int)b.y, tod.ambient);
                }
            }
        }
        for (Particle p : us.combat.particles) {
            if (p.type.pt != null || !Rect2D.intersects(cropX, cropY, cropW, cropH, p.x, p.y, p.type.maxSize, p.type.maxSize)) continue;
            p.drawAsSquare(d, 0.0, 0.0, tod.ambient);
        }
        GL11.glEnable((int)3553);
        GL13.glActiveTexture((int)33984);
        GL11.glBindTexture((int)3553, (int)particles.getTextureID());
        GL11.glBegin((int)7);
        for (Particle p : us.combat.particles) {
            if (p.type.pt == null || p.type.lit && Appearance.useLighting && !Appearance.useSimpleGraphics && !Appearance.shaderLoadFailed || !Rect2D.intersects(cropX, cropY, cropW, cropH, p.x, p.y, p.type.maxSize, p.type.maxSize)) continue;
            p.drawAsPicture(d, 0.0, 0.0);
        }
        GL11.glEnd();
        TextureImpl.bindNone();
        if (!Appearance.useLighting || Appearance.useSimpleGraphics || Appearance.shaderLoadFailed) {
            return;
        }
        Image[] light = us.lightingMap;
        float lightStrength = us.getTimeOfDay().lightStrength;
        float ambient = us.getTimeOfDay().ambient;
        if (bump == null) {
            bump = Appearance.loadTex("particles_bump");
        }
        if (Appearance.lsp == null) {
            try {
                Appearance.lsp = ShaderProgram.loadProgram((String)AGame.getGameDirectoryPath("data/litfrag.vert"), (String)AGame.getGameDirectoryPath("data/litfrag.frag"));
            }
            catch (Exception e) {
                e.printStackTrace();
                Appearance.shaderLoadFailed = true;
                return;
            }
        }
        Appearance.lsp.bind();
        GL13.glActiveTexture((int)33985);
        GL11.glBindTexture((int)3553, (int)bump.getTextureID());
        Appearance.lsp.setUniform1i("bump", 1);
        GL13.glActiveTexture((int)33986);
        GL11.glBindTexture((int)3553, (int)light[0].getTexture().getTextureID());
        Appearance.lsp.setUniform1i("lightFromLeft", 2);
        GL13.glActiveTexture((int)33987);
        GL11.glBindTexture((int)3553, (int)light[1].getTexture().getTextureID());
        Appearance.lsp.setUniform1i("lightFromTop", 3);
        GL13.glActiveTexture((int)33988);
        GL11.glBindTexture((int)3553, (int)light[2].getTexture().getTextureID());
        Appearance.lsp.setUniform1i("lightFromRight", 4);
        GL13.glActiveTexture((int)33989);
        GL11.glBindTexture((int)3553, (int)light[3].getTexture().getTextureID());
        Appearance.lsp.setUniform1i("lightFromBottom", 5);
        GL13.glActiveTexture((int)33984);
        GL11.glBindTexture((int)3553, (int)particles.getTextureID());
        Appearance.lsp.setUniform1i("tex", 0);
        Appearance.lsp.setUniform1f("strength", lightStrength);
        Appearance.lsp.setUniform2f("lightSize", (float)light[0].getTexture().getTextureWidth(), (float)light[0].getTexture().getTextureHeight());
        Appearance.lsp.setUniform1f("screenHeight", (float)d.frame().mode().height);
        Appearance.lsp.enableVertexAttribute("flipped");
        Appearance.lsp.enableVertexAttribute("tint");
        GL11.glBegin((int)7);
        GL20.glVertexAttrib1f((int)Appearance.lsp.getAttributeID("flipped"), (float)0.0f);
        for (Particle p : us.combat.particles) {
            if (p.type.pt == null || !p.type.lit || !Rect2D.intersects(cropX, cropY, cropW, cropH, p.x, p.y, p.type.maxSize, p.type.maxSize)) continue;
            p.drawAsShadedPicture(d, ambient);
        }
        GL11.glEnd();
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        Appearance.lsp.unbind();
        TextureImpl.bindNone();
    }

    static {
        currentPostfix = "NULL";
        postfixToTex = new HashMap();
    }
}

