/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.Body;
import com.zarkonnen.airships.GridBody;
import com.zarkonnen.airships.MyDraw;
import com.zarkonnen.airships.UniScreen;
import com.zarkonnen.catengine.Input;
import java.util.ArrayList;
import org.newdawn.slick.Color;
import org.newdawn.slick.Graphics;

public class PathingLayer
implements UniScreen.VisualLayer {
    @Override
    public void tick(Input in, int ms, UniScreen us) {
        if (us.combat != null) {
            us.combat.bodyPathing.update(us.combat);
        }
    }

    @Override
    public void draw(MyDraw d, UniScreen us, double cropX, double cropY, double cropW, double cropH) {
        int dstY;
        int dstX;
        int srcY;
        int srcX;
        if (us.combat == null) {
            return;
        }
        Graphics g = (Graphics)d.frame().nativeRenderer();
        if (us.combat.physics == null) {
            return;
        }
        g.setColor(Color.black);
        int bsz = us.combat.physics.bodies.size();
        for (int srcBi = 0; srcBi < bsz; ++srcBi) {
            Body srcB = us.combat.physics.bodies.get(srcBi);
            for (int dstBi = 0; dstBi < bsz; ++dstBi) {
                Body dstB = us.combat.physics.bodies.get(dstBi);
                int linkAmt = us.combat.bodyPathing.matrix[srcBi][dstBi];
                if (linkAmt <= 0) continue;
                g.setColor(Color.black);
                srcX = (int)(srcB.x + srcB.getBBWidth() / 2.0);
                srcY = (int)(srcB.y + srcB.getBBHeight() / 2.0) - 16;
                dstX = (int)(dstB.x + dstB.getBBWidth() / 2.0);
                dstY = (int)(dstB.y + dstB.getBBHeight() / 2.0) + 16;
                g.setLineWidth(12.0f);
                g.drawLine((float)srcX, (float)srcY, (float)(srcX / 2 + dstX / 2), (float)(srcY / 2 + dstY / 2));
                g.setLineWidth(6.0f);
                g.drawLine((float)(srcX / 2 + dstX / 2), (float)(srcY / 2 + dstY / 2), (float)dstX, (float)dstY);
                g.setColor(linkAmt == 2 ? Color.green : Color.yellow);
                g.setLineWidth(6.0f);
                g.drawLine((float)srcX, (float)srcY, (float)(srcX / 2 + dstX / 2), (float)(srcY / 2 + dstY / 2));
                g.setLineWidth(3.0f);
                g.drawLine((float)(srcX / 2 + dstX / 2), (float)(srcY / 2 + dstY / 2), (float)dstX, (float)dstY);
            }
        }
        if (!us.combat.sides.get((int)0).ships.isEmpty() && !us.combat.sides.get((int)1).ships.isEmpty()) {
            boolean needsGrappling = false;
            ArrayList<GridBody> path = us.combat.bodyPathing.getPath(us.combat.sides.get((int)0).ships.get(0), us.combat.sides.get((int)1).ships.get(0), 2, us.combat);
            if (path == null) {
                path = us.combat.bodyPathing.getPath(us.combat.sides.get((int)0).ships.get(0), us.combat.sides.get((int)1).ships.get(0), 1, us.combat);
                needsGrappling = true;
            }
            if (path != null) {
                path.add(0, us.combat.sides.get((int)0).ships.get(0));
                for (int pi = 0; pi < path.size() - 1; ++pi) {
                    GridBody srcB = path.get(pi);
                    GridBody dstB = path.get(pi + 1);
                    srcX = (int)(srcB.x + srcB.getBBWidth() / 2.0);
                    srcY = (int)(srcB.y + srcB.getBBHeight() / 2.0);
                    dstX = (int)(dstB.x + dstB.getBBWidth() / 2.0);
                    dstY = (int)(dstB.y + dstB.getBBHeight() / 2.0);
                    g.setColor(Color.black);
                    g.setLineWidth(6.0f);
                    g.drawLine((float)srcX, (float)srcY, (float)dstX, (float)dstY);
                    g.setColor(needsGrappling ? Color.red : Color.blue);
                    g.setLineWidth(3.0f);
                    g.drawLine((float)srcX, (float)srcY, (float)dstX, (float)dstY);
                }
            }
        }
        g.setLineWidth(1.0f);
        g.setColor(Color.white);
    }
}

