/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.Combat;
import com.zarkonnen.catengine.util.ScreenMode;
import org.json.JSONObject;

public class PerfReport {
    public static final int[] FRAME_TIME_BOUNDARIES = new int[]{15, 18, 21, 34, 50, 100};
    public final int[] frameTimeCounts = new int[FRAME_TIME_BOUNDARIES.length + 1];
    public int totalMs;
    public int totalFrames;
    public int numShips;
    public int numModules;
    public int screenW;
    public int screenH;

    public PerfReport(Combat c, ScreenMode sm) {
        for (Combat.Side s : c.sides) {
            this.numShips += s.ships.size();
            for (Airship ship : s.ships) {
                this.numModules += ship.modules.size();
            }
        }
        this.screenW = sm.width;
        this.screenH = sm.height;
    }

    public void countFrameTime(int ms) {
        this.totalMs += ms;
        ++this.totalFrames;
        for (int i = 0; i < FRAME_TIME_BOUNDARIES.length; ++i) {
            if (ms >= FRAME_TIME_BOUNDARIES[i]) continue;
            int n = i;
            this.frameTimeCounts[n] = this.frameTimeCounts[n] + 1;
            return;
        }
        int n = this.frameTimeCounts.length - 1;
        this.frameTimeCounts[n] = this.frameTimeCounts[n] + 1;
    }

    public String toString() {
        JSONObject o = new JSONObject();
        for (int i = 0; i < FRAME_TIME_BOUNDARIES.length; ++i) {
            o.put("" + FRAME_TIME_BOUNDARIES[i], this.frameTimeCounts[i]);
        }
        o.put("more", this.frameTimeCounts[this.frameTimeCounts.length - 1]);
        o.put("numShips", this.numShips);
        o.put("numModules", this.numModules);
        o.put("avg", this.totalMs / this.totalFrames);
        o.put("screenW", this.screenW);
        o.put("screenH", this.screenH);
        return o.toString(4);
    }
}

