/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.Body;
import com.zarkonnen.airships.Combat;
import com.zarkonnen.airships.Rect2D;
import java.util.ArrayList;

public strictfp class Physics {
    public static final double AT_SPEED_BOUNDARY = 0.005;
    public double gravity = 0.0;
    public ArrayList<Body> bodies = new ArrayList();

    public void tickRepeatedly(int iters, int msPerIter, Combat combat) {
        for (int i = 0; i < iters; ++i) {
            this.tick(msPerIter, combat);
        }
    }

    private boolean addToColliderGroup(Body a, Body b, ArrayList<ArrayList<Body>> groups) {
        if (a.colliderGroup != null) {
            if (b.colliderGroup != null) {
                if (a.colliderGroup != b.colliderGroup) {
                    a.colliderGroup.addAll(b.colliderGroup);
                    for (Body body : b.colliderGroup) {
                        body.colliderGroup = a.colliderGroup;
                    }
                    return true;
                }
                return false;
            }
            b.colliderGroup = a.colliderGroup;
            b.colliderGroup.add(b);
            return true;
        }
        if (b.colliderGroup != null) {
            a.colliderGroup = b.colliderGroup;
            a.colliderGroup.add(a);
            return true;
        }
        ArrayList<Body> newGroup = new ArrayList<Body>();
        groups.add(newGroup);
        newGroup.add(a);
        newGroup.add(b);
        a.colliderGroup = newGroup;
        b.colliderGroup = newGroup;
        return true;
    }

    public void tick(int ms, Combat combat) {
        int sz = this.bodies.size();
        for (int i = 0; i < sz; ++i) {
            Body b = this.bodies.get(i);
            b.particlesTick(ms, combat);
            if (b.removeMe()) {
                this.bodies.remove(i);
                --sz;
                --i;
                continue;
            }
            if (b.x < -1600.0) {
                b.xForce += (double)b.getMass() * (-1600.0 - b.x) * 1.0E-4;
                continue;
            }
            if (!(b.x + b.getBBWidth() > 1600.0)) continue;
            b.xForce -= (double)b.getMass() * (b.x + b.getBBWidth() - 1600.0) * 1.0E-4;
        }
        for (Body b : this.bodies) {
            b.colliderGroup = null;
            if (b.isImmobile()) {
                b.xSpeed = 0.0;
                b.ySpeed = 0.0;
                b.oldX = b.x;
                b.newX = b.x;
                b.oldY = b.y;
                b.newY = b.y;
                b.postCollideXSpeed = 0.0;
                b.postCollideYSpeed = 0.0;
                b.groupXSpeed = 0.0;
                b.groupYSpeed = 0.0;
            } else {
                b.xSpeed += b.xForce * (double)ms / (double)b.getMass();
                b.ySpeed += b.yForce * (double)ms / (double)b.getMass();
                b.ySpeed += this.gravity * (double)ms;
                double airSlowdown = b.xSpeed * b.xSpeed * b.horizontalAirFriction() * (double)ms + b.ySpeed * b.ySpeed * b.verticalAirFriction() * (double)ms;
                if (b.xSpeed > 0.0) {
                    b.xSpeed = Math.max(b.xSpeed - airSlowdown, 0.0);
                }
                if (b.xSpeed < 0.0) {
                    b.xSpeed = Math.min(0.0, b.xSpeed + airSlowdown);
                }
                if (b.ySpeed > 0.0) {
                    b.ySpeed = Math.max(b.ySpeed - airSlowdown, 0.0);
                }
                if (b.ySpeed < 0.0) {
                    b.ySpeed = Math.min(0.0, b.ySpeed + airSlowdown);
                }
                b.oldX = b.x;
                b.oldY = b.y;
                b.newX = b.x + b.xSpeed * (double)ms;
                b.newY = b.y + b.ySpeed * (double)ms;
                b.postCollideXSpeed = b.xSpeed;
                b.postCollideYSpeed = b.ySpeed;
                b.groupXSpeed = b.xSpeed;
                b.groupYSpeed = b.ySpeed;
            }
            b.xForce = 0.0;
            b.yForce = 0.0;
        }
        for (Body b1 : this.bodies) {
            for (Body body : this.bodies) {
                if (b1 == body) continue;
                b1.x = b1.newX;
                b1.y = b1.newY;
                body.x = body.newX;
                body.y = body.newY;
                if (!Rect2D.intersects(b1.x, b1.y, b1.getBBWidth(), b1.getBBHeight(), body.x, body.y, body.getBBWidth(), body.getBBHeight()) || !b1.collidesWith(body) && !body.collidesWith(b1)) continue;
                double speedDeltaSquared = (b1.xSpeed - body.xSpeed) * (b1.xSpeed - body.xSpeed) + (b1.ySpeed - body.ySpeed) * (b1.ySpeed - body.ySpeed);
                b1.doCollision(body, speedDeltaSquared * (double)(b1.getCollisionMass() + body.getCollisionMass()), combat, (b1.isAtSpeed() || body.isAtSpeed()) && speedDeltaSquared > 2.5E-5);
                if (b1.isImmobile()) continue;
                if (body.isImmobile()) {
                    b1.postCollideXSpeed = b1.xSpeed * -1.0 * b1.elasticity() * body.elasticity();
                    b1.postCollideYSpeed = b1.ySpeed * -1.0 * b1.elasticity() * body.elasticity();
                } else {
                    b1.postCollideXSpeed = (b1.elasticity() * body.elasticity() * (double)body.getMass() * (body.xSpeed - b1.xSpeed) + (double)b1.getMass() * b1.xSpeed + (double)body.getMass() * body.xSpeed) / (double)(b1.getMass() + body.getMass());
                    b1.postCollideYSpeed = (b1.elasticity() * body.elasticity() * (double)body.getMass() * (body.ySpeed - b1.ySpeed) + (double)b1.getMass() * b1.ySpeed + (double)body.getMass() * body.ySpeed) / (double)(b1.getMass() + body.getMass());
                }
                b1.groupXSpeed = b1.postCollideXSpeed;
                b1.groupYSpeed = b1.postCollideYSpeed;
            }
        }
        boolean newGroups = true;
        ArrayList<ArrayList<Body>> colliderGroups = new ArrayList<ArrayList<Body>>();
        while (newGroups) {
            newGroups = false;
            for (Body body : this.bodies) {
                if (body.isImmobile()) {
                    body.x = body.oldX;
                    body.y = body.oldY;
                    continue;
                }
                body.x = body.oldX + body.groupXSpeed * (double)ms;
                body.y = body.oldY + body.groupYSpeed * (double)ms;
            }
            for (Body body : this.bodies) {
                for (Body b2 : this.bodies) {
                    if (body == b2 || body.colliderGroup != null && body.colliderGroup.contains(b2) || !Rect2D.intersects(body.x, body.y, body.getBBWidth(), body.getBBHeight(), b2.x, b2.y, b2.getBBWidth(), b2.getBBHeight()) || !body.collidesWith(b2)) continue;
                    newGroups |= this.addToColliderGroup(body, b2, colliderGroups);
                }
            }
            for (ArrayList arrayList : colliderGroups) {
                double sumOfXMomenta = 0.0;
                double sumOfYMomenta = 0.0;
                double sumOfMasses = 0.0;
                boolean immobile = false;
                for (Body b : arrayList) {
                    sumOfXMomenta += b.postCollideXSpeed * (double)b.getMass();
                    sumOfYMomenta += b.postCollideYSpeed * (double)b.getMass();
                    sumOfMasses += (double)b.getMass();
                    immobile |= b.isImmobile();
                }
                double groupXSpeed = sumOfXMomenta / sumOfMasses;
                double groupYSpeed = immobile ? 0.0 : sumOfYMomenta / sumOfMasses;
                for (Body b : arrayList) {
                    b.groupXSpeed = groupXSpeed;
                    b.groupYSpeed = groupYSpeed;
                }
            }
        }
        for (Body body : this.bodies) {
            if (body.isImmobile()) {
                body.x = body.oldX;
                body.y = body.oldY;
                continue;
            }
            body.x = body.oldX + body.groupXSpeed * (double)ms;
            body.y = body.oldY + body.groupYSpeed * (double)ms;
            body.xSpeed = body.groupXSpeed;
            body.ySpeed = body.groupYSpeed;
        }
    }

    public boolean isClean() {
        for (Body b1 : this.bodies) {
            for (Body b2 : this.bodies) {
                if (b1 == b2 || !Rect2D.intersects(b1.x, b1.y, b1.getBBWidth(), b1.getBBHeight(), b2.x, b2.y, b2.getBBWidth(), b2.getBBHeight()) || !b1.collidesWith(b2)) continue;
                return false;
            }
        }
        return true;
    }
}

