/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.CoatOfArms;
import com.zarkonnen.airships.DecalType;
import com.zarkonnen.airships.EditShipIntent;
import com.zarkonnen.airships.MyDraw;
import com.zarkonnen.airships.PlaceModuleTool;
import com.zarkonnen.airships.PlaceTool;
import com.zarkonnen.airships.SingleShipIntent;
import com.zarkonnen.airships.UniScreen;
import com.zarkonnen.catengine.Input;
import com.zarkonnen.catengine.util.Pt;
import com.zarkonnen.catengine.util.ScreenMode;

public class PlaceDecalTool
extends PlaceTool {
    public DecalType dt;

    public PlaceDecalTool(DecalType dt) {
        this.dt = dt;
    }

    public CoatOfArms coa(UniScreen us) {
        if (us.intent instanceof EditShipIntent) {
            return ((EditShipIntent)us.intent).getArms(us);
        }
        return us.g.getBestCOA();
    }

    @Override
    public void scaledDraw(MyDraw d, double x, double y, int gridX, int gridY, UniScreen us) {
        if (this.dt == null) {
            PlaceModuleTool.REMOVE.draw(d, x, y, 0, false);
        } else {
            String shipName = "NAME";
            boolean flipped = false;
            if (us.intent instanceof SingleShipIntent) {
                shipName = ((SingleShipIntent)((Object)us.intent)).getShip((UniScreen)us).name;
                flipped = ((SingleShipIntent)((Object)us.intent)).getShip((UniScreen)us).flipped;
            }
            this.dt.draw(d, x, y, 0, flipped, this.coa(us), shipName, null, 1.0f, 1.0f);
            this.dt.drawNonShader(d, x, y, 0, flipped, this.coa(us), shipName, null);
        }
    }

    @Override
    public void unscaledDraw(MyDraw d, Pt cursor, ScreenMode sm, UniScreen us) {
    }

    @Override
    public boolean click(Input in, Pt click, ScreenMode sm, UniScreen us) {
        if (click.x < 300.0) {
            return false;
        }
        Airship ship = this.ship(us);
        int[] sp = this.localShipPt(click, us, this.dt == null ? 1 : this.dt.w);
        if (this.dt == null) {
            if (ship.removeDecalAt(sp[0], sp[1]) != null) {
                in.play("remove", 1.0, 1.0 * us.g.volume, 0.0, 0.0);
                this.modified(us);
                return true;
            }
        } else if (ship.canAddDecal(this.dt, sp[0], sp[1])) {
            ship.addDecal(this.dt, sp[0], sp[1]);
            in.play("place", 1.0, 1.0 * us.g.volume, 0.0, 0.0);
            this.modified(us);
            return true;
        }
        return false;
    }

    @Override
    public boolean rightClick(Input in, Pt click, ScreenMode sm, UniScreen us) {
        if (click.x < 300.0) {
            return false;
        }
        Airship ship = this.ship(us);
        int[] sp = this.localShipPt(click, us, this.dt == null ? 1 : this.dt.w);
        this.dt = ship.removeDecalAt(sp[0], sp[1]);
        if (this.dt != null) {
            in.play("paper_lift", 1.0, 1.0 * us.g.volume, 0.0, 0.0);
            this.modified(us);
        }
        return this.dt != null;
    }

    @Override
    public boolean mouseDown(Input in, Pt click, ScreenMode sm, UniScreen us) {
        return false;
    }

    @Override
    public void tick(Input in, int ms, UniScreen us) {
    }
}

