/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.Appearance;
import com.zarkonnen.airships.Combat;
import com.zarkonnen.airships.EditPalettePanel;
import com.zarkonnen.airships.Fleet;
import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.Module;
import com.zarkonnen.airships.ModuleType;
import com.zarkonnen.airships.MyDraw;
import com.zarkonnen.airships.PlaceTool;
import com.zarkonnen.airships.Rect2D;
import com.zarkonnen.airships.UniScreen;
import com.zarkonnen.catengine.Input;
import com.zarkonnen.catengine.util.Clr;
import com.zarkonnen.catengine.util.Pt;
import com.zarkonnen.catengine.util.ScreenMode;

public class PlaceModuleTool
extends PlaceTool {
    public static final Appearance REMOVE = new Appearance(4, 16);
    public ModuleType mt;
    public int ms = 0;
    public static final Clr NO_OBSTRUCTION = new Clr(90, 255, 90, 100);
    public static final Clr OBSTRUCTED = new Clr(255, 90, 90, 100);

    public PlaceModuleTool(ModuleType mt) {
        this.mt = mt;
    }

    private boolean checkLimits(ModuleType mt, UniScreen us) {
        Airship ship = this.ship(us);
        return mt.getQuarters() + ship.getAllQuartered() <= 120 && mt.getCost(ship.constructionBonuses) + ship.getCost() <= 20000;
    }

    public void drawBeam(Airship ship, MyDraw d, int modX, int modY, ModuleType type, boolean left, Clr c) {
        if (left != ship.flipped) {
            d.rect(c, -5000.0, ship.y + (double)(modY * 16), 5000.0 + ship.x + (double)(modX * 16), type.getH() * 16);
        } else {
            d.rect(c, ship.x + (double)((modX + type.getW()) * 16), ship.y + (double)(modY * 16), 5000.0, type.getH() * 16);
        }
    }

    public void drawVerticalBeam(Airship ship, MyDraw d, int modX, int modY, ModuleType type, boolean top, Clr c) {
        d.rect(c, ship.x + (double)(modX * 16), top ? ship.y + (double)(modY * 16) - 5000.0 : ship.y + (double)((modY + type.getH()) * 16), type.getW() * 16, 5000.0);
    }

    @Override
    public void scaledDraw(MyDraw d, double x, double y, int modX, int modY, UniScreen us) {
        if (this.mt != null) {
            Clr highlight;
            boolean modGood;
            int obX;
            Module obstructing;
            this.mt.draw(d, x, y, 0, this.ship((UniScreen)us).flipped, 0);
            Airship ship = this.ship(us);
            int flippedModX = ship.gridXToWorldX(modX, this.mt.getW());
            if (this.mt.isFrontOnly()) {
                this.drawBeam(ship, d, modX, modY, this.mt, false, ship.frontObstructed(this.mt, flippedModX, modY) ? OBSTRUCTED : NO_OBSTRUCTION);
            }
            if (this.mt.isBackOnly()) {
                this.drawBeam(ship, d, modX, modY, this.mt, true, ship.backObstructed(this.mt, flippedModX, modY) ? OBSTRUCTED : NO_OBSTRUCTION);
            }
            if (this.mt.isBottomOnly()) {
                this.drawVerticalBeam(ship, d, modX, modY, this.mt, false, ship.bottomObstructed(this.mt, flippedModX, modY) ? OBSTRUCTED : NO_OBSTRUCTION);
            }
            if (this.mt.isTopOnly()) {
                this.drawVerticalBeam(ship, d, modX, modY, this.mt, true, ship.topObstructed(this.mt, flippedModX, modY) ? OBSTRUCTED : NO_OBSTRUCTION);
            }
            if ((obstructing = ship.frontObstructing(this.mt, flippedModX, modY)) != null) {
                obX = ship.gridXToWorldX(obstructing.x, obstructing.type.getW());
                this.drawBeam(ship, d, obX, obstructing.y, obstructing.type, false, OBSTRUCTED);
            }
            if ((obstructing = ship.backObstructing(this.mt, flippedModX, modY)) != null) {
                obX = ship.gridXToWorldX(obstructing.x, obstructing.type.getW());
                this.drawBeam(ship, d, obX, obstructing.y, obstructing.type, true, OBSTRUCTED);
            }
            if ((obstructing = ship.bottomObstructing(this.mt, flippedModX, modY)) != null) {
                obX = ship.gridXToWorldX(obstructing.x, obstructing.type.getW());
                this.drawVerticalBeam(ship, d, obX, obstructing.y, obstructing.type, false, OBSTRUCTED);
            }
            if ((obstructing = ship.topObstructing(this.mt, flippedModX, modY)) != null) {
                obX = ship.gridXToWorldX(obstructing.x, obstructing.type.getW());
                this.drawVerticalBeam(ship, d, obX, obstructing.y, obstructing.type, true, OBSTRUCTED);
            }
            boolean modPermitted = this.checkLimits(this.mt, us) && this.noOverlapsOrObstructions(ship, us, this.mt, ship.gridXToWorldX(modX, this.mt.getW()), modY);
            boolean bl = modGood = modPermitted && ship.canAddModule(this.mt, ship.gridXToWorldX(modX, this.mt.getW()), modY);
            Clr clr = modGood ? AGame.HIGHLIGHT : (highlight = modPermitted ? AGame.DISCOURAGED : AGame.FORBIDDEN);
            if (this.mt.weaponAppearance() != null && this.mt.weaponAppearance().barrel != null) {
                if (ship.flipped) {
                    d.blit(this.mt.weaponAppearance().barrel.flip(), x + (double)(this.mt.getW() * 16) - this.mt.weaponAppearance().barrelOffset.x - (double)this.mt.weaponAppearance().barrel.srcWidth, y + this.mt.weaponAppearance().barrelOffset.y);
                } else {
                    d.blit(this.mt.weaponAppearance().barrel, x + this.mt.weaponAppearance().barrelOffset.x, y + this.mt.weaponAppearance().barrelOffset.y);
                }
            }
            this.mt.draw(d, x, y, this.ms, highlight, ship.flipped, 0, null, 1.0f, 1.0f);
            if (this.mt.isOccupable()) {
                if (ship.flipped) {
                    int i;
                    if (!this.mt.isBackOnly()) {
                        boolean[] leftDoors = this.mt.getLeftDoors();
                        for (i = 0; i < leftDoors.length; ++i) {
                            if (!leftDoors[i]) continue;
                            d.rect(Airship.DOOR_FREE, x + (double)(this.mt.getW() * 16), y + (double)(i * 16) + 4.0 - 1.0, 1.0, 6.0);
                            d.rect(Airship.DOOR_FREE, x + (double)(this.mt.getW() * 16) - 1.0, y + (double)(i * 16) + 4.0 - 1.0, 1.0, 12.0);
                        }
                    }
                    if (!this.mt.isFrontOnly()) {
                        boolean[] rightDoors = this.mt.getRightDoors();
                        for (i = 0; i < rightDoors.length; ++i) {
                            if (!rightDoors[i]) continue;
                            d.rect(Airship.DOOR_FREE, x - 1.0, y + (double)(i * 16) + 4.0 - 1.0 + 6.0, 1.0, 6.0);
                            d.rect(Airship.DOOR_FREE, x, y + (double)(i * 16) + 4.0 - 1.0, 1.0, 12.0);
                        }
                    }
                    boolean[] upDoors = this.mt.getUpDoors();
                    for (i = 0; i < upDoors.length; ++i) {
                        if (upDoors[i]) {
                            d.rect(Airship.DOOR_FREE, x + (double)((this.mt.getW() - i - 1) * 16) + 8.0, y - 1.0, 3.0, 1.0);
                            d.rect(Airship.DOOR_FREE, x + (double)((this.mt.getW() - i - 1) * 16) + 8.0, y, 6.0, 1.0);
                        }
                        d.rect(Airship.DOOR_FREE, x + (double)(i * 16) + 8.0 + 4.0 - 1.0, y + (double)(this.mt.getH() * 16), 3.0, 1.0);
                        d.rect(Airship.DOOR_FREE, x + (double)(i * 16) + 8.0, y + (double)(this.mt.getH() * 16) - 1.0, 6.0, 1.0);
                    }
                } else {
                    int i;
                    if (!this.mt.isBackOnly()) {
                        boolean[] leftDoors = this.mt.getLeftDoors();
                        for (i = 0; i < leftDoors.length; ++i) {
                            if (!leftDoors[i]) continue;
                            d.rect(Airship.DOOR_FREE, x - 1.0, y + (double)(i * 16) + 4.0 - 1.0, 1.0, 6.0);
                            d.rect(Airship.DOOR_FREE, x, y + (double)(i * 16) + 4.0 - 1.0, 1.0, 12.0);
                        }
                    }
                    if (!this.mt.isFrontOnly()) {
                        boolean[] rightDoors = this.mt.getRightDoors();
                        for (i = 0; i < rightDoors.length; ++i) {
                            if (!rightDoors[i]) continue;
                            d.rect(Airship.DOOR_FREE, x + (double)(this.mt.getW() * 16), y + (double)(i * 16) + 4.0 - 1.0 + 6.0, 1.0, 6.0);
                            d.rect(Airship.DOOR_FREE, x + (double)(this.mt.getW() * 16) - 1.0, y + (double)(i * 16) + 4.0 - 1.0, 1.0, 12.0);
                        }
                    }
                    boolean[] upDoors = this.mt.getUpDoors();
                    for (i = 0; i < upDoors.length; ++i) {
                        if (upDoors[i]) {
                            d.rect(Airship.DOOR_FREE, x + (double)(i * 16) + 8.0, y - 1.0, 3.0, 1.0);
                            d.rect(Airship.DOOR_FREE, x + (double)(i * 16) + 8.0, y, 6.0, 1.0);
                        }
                        d.rect(Airship.DOOR_FREE, x + (double)(i * 16) + 8.0 + 4.0 - 1.0, y + (double)(this.mt.getH() * 16), 3.0, 1.0);
                        d.rect(Airship.DOOR_FREE, x + (double)(i * 16) + 8.0, y + (double)(this.mt.getH() * 16) - 1.0, 6.0, 1.0);
                    }
                }
            }
        } else {
            REMOVE.draw(d, x, y, 0, false);
        }
    }

    public boolean noOverlapsOrObstructions(Airship shipToPlace, UniScreen us, ModuleType mt, int modX, int modY) {
        block8: {
            int worldH;
            int worldW;
            int worldY;
            int worldX;
            block9: {
                block7: {
                    if (!shipToPlace.noModuleOverlapsOrObstructions(mt, modX, modY)) {
                        return false;
                    }
                    worldX = shipToPlace.getX() + modX * 16;
                    worldY = shipToPlace.getY() + modY * 16;
                    worldW = mt.getW() * 16;
                    worldH = mt.getH() * 16;
                    if (us.combat == null) break block7;
                    for (Combat.Side side : us.combat.sides) {
                        for (Airship ship : side.ships) {
                            if (ship == shipToPlace || !this.overlaps(ship, worldX, worldY, worldW, worldH)) continue;
                            return false;
                        }
                    }
                    break block8;
                }
                if (us.city == null) break block9;
                Fleet garrison = us.wm.getGarrison(us.city);
                for (Airship bld : us.city.getDefences()) {
                    if (bld == shipToPlace || !this.overlaps(bld, worldX, worldY, worldW, worldH)) continue;
                    return false;
                }
                if (garrison == null) break block8;
                for (Airship ship : garrison.actives) {
                    if (ship == shipToPlace || !this.overlaps(ship, worldX, worldY, worldW, worldH)) continue;
                    return false;
                }
                break block8;
            }
            if (us.setupFleet != null) {
                for (Airship ship : us.setupFleet) {
                    if (ship == shipToPlace || !this.overlaps(ship, worldX, worldY, worldW, worldH)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private boolean overlaps(Airship ship, int worldX, int worldY, int worldW, int worldH) {
        return Rect2D.intersects(ship.getX(), ship.getY(), ship.getBBWidth(), ship.getBBHeight(), worldX, worldY, worldW, worldH);
    }

    @Override
    public void unscaledDraw(MyDraw d, Pt cursor, ScreenMode sm, UniScreen us) {
        Pt sz = d.textSize(Lang._t("Left_click_to_place_right_click_to_pick_up", new Object[0]), AGame.FOUNT);
        d.text(Lang._t("Left_click_to_place_right_click_to_pick_up", new Object[0]), AGame.FOUNT, (int)((double)sm.width - sz.x - 5.0), (double)sm.height - sz.y - 3.0);
    }

    @Override
    public boolean click(Input in, Pt click, ScreenMode sm, UniScreen us) {
        if (click.x < 300.0) {
            return false;
        }
        if (this.ms < 100) {
            return true;
        }
        Airship ship = this.ship(us);
        int[] sp = this.localShipPt(click, us, this.mt == null ? 1 : this.mt.getW());
        if (this.mt == null) {
            if (ship.removeModuleAt(sp[0], sp[1]) != null) {
                in.play("remove", 1.0, 1.0 * us.g.volume, 0.0, 0.0);
                this.modified(us);
                return true;
            }
        } else if (this.noOverlapsOrObstructions(ship, us, this.mt, sp[0], sp[1])) {
            ship.addModule(this.mt, sp[0], sp[1], us.panel(EditPalettePanel.class).lastArmourType);
            double volume = Math.min(1.0, Math.sqrt((double)(this.mt.getW() * this.mt.getH()) * 0.2));
            in.play("place", 1.0 / volume, volume * us.g.volume, 0.0, 0.0);
            this.modified(us);
            return true;
        }
        return false;
    }

    @Override
    public boolean rightClick(Input in, Pt click, ScreenMode sm, UniScreen us) {
        int[] sp;
        if (click.x < 300.0) {
            return false;
        }
        if (this.ms < 100) {
            return true;
        }
        Airship ship = this.ship(us);
        Module victim = ship.removeModuleAt((sp = this.localShipPt(click, us, this.mt == null ? 1 : this.mt.getW()))[0], sp[1]);
        if (victim != null) {
            this.mt = victim.type;
            in.play("paper_lift", 1.0, 1.0 * us.g.volume, 0.0, 0.0);
            this.modified(us);
        } else {
            this.mt = null;
        }
        return true;
    }

    @Override
    public boolean mouseDown(Input in, Pt click, ScreenMode sm, UniScreen us) {
        return this.ship((UniScreen)us).modules.size() < 1 ? false : this.click(in, click, sm, us);
    }

    @Override
    public void tick(Input in, int ms, UniScreen us) {
        this.ms += ms;
    }
}

