/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.CampaignCombatIntent;
import com.zarkonnen.airships.City;
import com.zarkonnen.airships.Combat;
import com.zarkonnen.airships.EmptyShipList;
import com.zarkonnen.airships.Fleet;
import com.zarkonnen.airships.LandFormation;
import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.MyDraw;
import com.zarkonnen.airships.Rect2D;
import com.zarkonnen.airships.RestrictsShipPlacement;
import com.zarkonnen.airships.ShipArrayList;
import com.zarkonnen.airships.UniScreen;
import com.zarkonnen.catengine.Input;
import com.zarkonnen.catengine.util.Clr;
import com.zarkonnen.catengine.util.Pt;
import com.zarkonnen.catengine.util.ScreenMode;

public class PlaceShipTool
implements UniScreen.Tool {
    public Airship shipToPlace;
    public boolean cancelPutsBack;
    public boolean flipped;
    public int sideIndex;
    public Combat.Side side;
    public boolean forConstruction;
    public boolean fromReserve;
    public boolean ignoreServiceCeiling;

    public PlaceShipTool(Airship shipToPlace, boolean cancelPutsBack, int sideIndex) {
        this.shipToPlace = shipToPlace;
        this.cancelPutsBack = cancelPutsBack;
        this.sideIndex = sideIndex;
        this.flipped = shipToPlace.flipped;
    }

    public PlaceShipTool(Airship shipToPlace, boolean cancelPutsBack, int sideIndex, boolean ignoreServiceCeiling) {
        this.shipToPlace = shipToPlace;
        this.cancelPutsBack = cancelPutsBack;
        this.sideIndex = sideIndex;
        this.ignoreServiceCeiling = ignoreServiceCeiling;
        this.flipped = shipToPlace.flipped;
    }

    public PlaceShipTool(Airship shipToPlace, boolean cancelPutsBack, Combat.Side side, int sideIndex) {
        this.shipToPlace = shipToPlace;
        this.cancelPutsBack = cancelPutsBack;
        this.side = side;
        this.sideIndex = sideIndex;
        this.flipped = shipToPlace.flipped;
    }

    public PlaceShipTool(Airship shipToPlace, boolean cancelPutsBack, Combat.Side side, int sideIndex, boolean forConstruction) {
        this.shipToPlace = shipToPlace;
        this.cancelPutsBack = cancelPutsBack;
        this.side = side;
        this.sideIndex = sideIndex;
        this.forConstruction = forConstruction;
        this.flipped = shipToPlace.flipped;
    }

    public PlaceShipTool(Airship shipToPlace, boolean fromReserve) {
        this.shipToPlace = shipToPlace;
        this.fromReserve = fromReserve;
        this.flipped = shipToPlace.flipped;
    }

    public PlaceShipTool(Airship shipToPlace, Combat.Side side, int sideIndex, boolean fromReserve) {
        this.shipToPlace = shipToPlace;
        this.fromReserve = fromReserve;
        this.side = side;
        this.sideIndex = sideIndex;
        this.flipped = shipToPlace.flipped;
    }

    public static boolean intersects(Airship shipToPlace, double x, double y, LandFormation lf) {
        if (!Rect2D.intersects(x, y, shipToPlace.getBBWidth(), shipToPlace.getBBHeight(), lf.x, lf.y, lf.getBBWidth(), lf.getBBHeight())) {
            return false;
        }
        double ox = shipToPlace.x;
        double oy = shipToPlace.y;
        shipToPlace.x = x;
        shipToPlace.y = y;
        boolean iSects = shipToPlace.overlapsWith(lf, false);
        shipToPlace.x = ox;
        shipToPlace.y = oy;
        return iSects;
    }

    public static boolean intersects(Airship shipToPlace, double x, double y, Airship ship2) {
        if (!Rect2D.intersects(x, y, shipToPlace.getBBWidth(), shipToPlace.getBBHeight(), ship2.x, ship2.y, ship2.getBBWidth(), ship2.getBBHeight())) {
            return false;
        }
        double ox = shipToPlace.x;
        double oy = shipToPlace.y;
        shipToPlace.x = x;
        shipToPlace.y = y;
        boolean iSects = shipToPlace.overlapsWith(ship2);
        shipToPlace.x = ox;
        shipToPlace.y = oy;
        return iSects;
    }

    public static boolean canPlace(Airship shipToPlace, double x, double y, Combat c, boolean ignoreServiceCeiling) {
        y = PlaceShipTool.getAdjustedY(shipToPlace, x, y, c.landFormations.get(0), ignoreServiceCeiling);
        for (Combat.Side s : c.sides) {
            for (Airship ship : s.ships) {
                if (ship == shipToPlace || !PlaceShipTool.intersects(shipToPlace, x, y, ship)) continue;
                return false;
            }
        }
        for (LandFormation lf : c.landFormations) {
            if (!PlaceShipTool.intersects(shipToPlace, x, y, lf)) continue;
            return false;
        }
        return shipToPlace.type.mobile || !shipToPlace.type.onGround || c.landFormations.get(0).isFullySupported(shipToPlace, x);
    }

    public static boolean canPlace(Airship shipToPlace, double x, double y, int sideIndex, UniScreen us, boolean ignoreServiceCeiling) {
        Rect2D r;
        y = PlaceShipTool.getAdjustedY(shipToPlace, x, y, us, ignoreServiceCeiling);
        if (us.intent instanceof RestrictsShipPlacement && (r = ((RestrictsShipPlacement)((Object)us.intent)).placementLimits(sideIndex, us)) != null && !r.contains(x, y, shipToPlace.getBBWidth(), shipToPlace.getBBHeight())) {
            return false;
        }
        if (us.combat != null) {
            return PlaceShipTool.canPlace(shipToPlace, x, y, us.combat, ignoreServiceCeiling);
        }
        if (us.city != null) {
            for (Airship bld : us.city.getDefences()) {
                if (bld == shipToPlace || !PlaceShipTool.intersects(shipToPlace, x, y, bld)) continue;
                return false;
            }
            if (us.city.constructing != null && us.city.constructing != shipToPlace && PlaceShipTool.intersects(shipToPlace, x, y, us.city.constructing)) {
                return false;
            }
            Fleet garrison = us.wm.getGarrison(us.city);
            if (garrison != null) {
                for (Airship ship : garrison.actives) {
                    if (ship == shipToPlace || !PlaceShipTool.intersects(shipToPlace, x, y, ship)) continue;
                    return false;
                }
            }
            if (!shipToPlace.type.onGround && Rect2D.intersects(x, y, shipToPlace.getBBWidth(), shipToPlace.getBBHeight(), us.city.ground.x, us.city.ground.y, us.city.ground.getBBWidth(), us.city.ground.getBBHeight())) {
                return false;
            }
            for (LandFormation lf : us.city.floaters) {
                if (!PlaceShipTool.intersects(shipToPlace, x, y, lf)) continue;
                return false;
            }
            if (!shipToPlace.type.mobile && shipToPlace.type.onGround && !us.city.ground.isFullySupported(shipToPlace, x)) {
                return false;
            }
        } else if (us.setupFleet != null) {
            for (Airship ship : us.setupFleet) {
                if (ship == shipToPlace || !PlaceShipTool.intersects(shipToPlace, x, y, ship)) continue;
                return false;
            }
            if (us.setupGround != null && !shipToPlace.type.onGround && PlaceShipTool.intersects(shipToPlace, x, y, us.setupGround)) {
                return false;
            }
            if (us.setupFloaters != null) {
                for (LandFormation lf : us.setupFloaters) {
                    if (!PlaceShipTool.intersects(shipToPlace, x, y, lf)) continue;
                    return false;
                }
            }
            if (!shipToPlace.type.mobile && shipToPlace.type.onGround && us.setupGround != null && !us.setupGround.isFullySupported(shipToPlace, x)) {
                return false;
            }
        }
        return true;
    }

    private void placeShip(double x, double y, UniScreen us, Input in) {
        double volume = Math.min(1.0, (double)this.shipToPlace.getWeight() / 5000.0);
        in.play("place", 1.0 / volume, volume * us.g.volume, 0.0, 0.0);
        this.shipToPlace.x = x;
        this.shipToPlace.y = y;
        this.shipToPlace.setFlipped(this.flipped);
        this.shipToPlace.flipTo = this.flipped;
        if (us.combat != null) {
            this.shipToPlace.initLegs(null, us.combat.landFormations, us.combat);
        }
        if (us.combat != null && this.side != null) {
            if (!this.side.ships.contains(this.shipToPlace)) {
                this.side.ships.add(this.shipToPlace);
            }
            this.side.reserve.remove(this.shipToPlace);
        } else if (us.city != null) {
            Fleet garrison = us.wm.getGarrison(us.city);
            this.shipToPlace.initLegs(us.city.ground, us.city.floaters, garrison == null ? EmptyShipList.INSTANCE : garrison);
            if (this.forConstruction) {
                if (us.city.constructing != this.shipToPlace) {
                    us.city.constructing = this.shipToPlace;
                    us.city.constructionCost = this.shipToPlace.getCost();
                    us.city.constructionProgress = 0;
                    us.wm.owner((City)us.city).money -= this.shipToPlace.getCost();
                }
            } else if (this.shipToPlace.type.mobile) {
                if (garrison != null) {
                    if (!garrison.actives.contains(this.shipToPlace)) {
                        garrison.actives.add(this.shipToPlace);
                    }
                    garrison.reserve.remove(this.shipToPlace);
                } else {
                    Fleet newFleet = new Fleet(us.city);
                    newFleet.actives.add(this.shipToPlace);
                    us.wm.owner((City)us.city).fleets.add(newFleet);
                }
            } else if (!us.city.hasDefence(this.shipToPlace)) {
                us.city.addDefence(this.shipToPlace);
            }
        } else if (us.setupFleet != null) {
            this.shipToPlace.initLegs(us.setupGround, us.setupFloaters, new ShipArrayList(us.setupFleet));
            if (!us.setupFleet.contains(this.shipToPlace)) {
                us.setupFleet.add(this.shipToPlace);
            }
        }
    }

    public static double getAdjustedY(Airship shipToPlace, double x, double y, UniScreen us, boolean ignoreServiceCeiling) {
        if (us.combat != null) {
            return PlaceShipTool.getAdjustedY(shipToPlace, x, y, us.combat.landFormations.get(0), ignoreServiceCeiling);
        }
        if (us.city != null) {
            return PlaceShipTool.getAdjustedY(shipToPlace, x, y, us.city.ground, ignoreServiceCeiling);
        }
        if (us.setupGround != null) {
            return PlaceShipTool.getAdjustedY(shipToPlace, x, y, us.setupGround, ignoreServiceCeiling);
        }
        return PlaceShipTool.getAdjustedY(shipToPlace, x, y, (LandFormation)null, ignoreServiceCeiling);
    }

    public static double getAdjustedY(Airship shipToPlace, double x, double y, LandFormation ground, boolean ignoreServiceCeiling) {
        if (shipToPlace.type.onGround) {
            y = ground != null ? (double)ground.getVerticalPosition(shipToPlace, (int)x, false) - shipToPlace.groundOffset() : 512.0 - shipToPlace.getBBHeight() - shipToPlace.groundOffset();
        }
        if (!shipToPlace.type.onGround && !ignoreServiceCeiling) {
            y = Math.max(y, (double)(512 - shipToPlace.availableServiceCeiling()));
        }
        return y;
    }

    @Override
    public void draw(MyDraw d, Pt cursor, ScreenMode sm, UniScreen us) {
        Rect2D limits = null;
        if (us.intent instanceof RestrictsShipPlacement) {
            limits = ((RestrictsShipPlacement)((Object)us.intent)).placementLimits(this.sideIndex, us);
        }
        double x = us.screenToWorldX(cursor.x);
        double y = PlaceShipTool.getAdjustedY(this.shipToPlace, x, us.screenToWorldY(cursor.y), us, this.ignoreServiceCeiling);
        if (this.fromReserve && us.intent instanceof CampaignCombatIntent) {
            x = this.sideIndex == 0 ? -1600.0 : 1600.0 - this.shipToPlace.getBBWidth();
        }
        d.scale(us.zoom, us.zoom);
        d.shift(us.adjScrollX, us.adjScrollY);
        if (limits != null) {
            d.rect(Clr.WHITE, limits.x - 2.0, limits.y - 2.0, limits.w + 4.0, 2.0);
            d.rect(Clr.WHITE, limits.x - 2.0, limits.y + limits.h, limits.w + 4.0, 2.0);
            d.rect(Clr.WHITE, limits.x - 2.0, limits.y - 2.0, 2.0, limits.h + 4.0);
            d.rect(Clr.WHITE, limits.x + limits.w, limits.y - 2.0, 2.0, limits.h + 4.0);
        }
        this.shipToPlace.drawOutline(d, x, y, this.flipped, PlaceShipTool.canPlace(this.shipToPlace, x, y, this.sideIndex, us, this.ignoreServiceCeiling) ? Clr.WHITE : Clr.RED);
        if (!us.textInputOccurring()) {
            d.state.cursorText = "[333333]" + Lang._t("F_to_flip", new Object[0]);
        }
        d.resetTransforms();
        double sx = this.shipToPlace.x;
        double sy = this.shipToPlace.y;
        boolean sf = this.shipToPlace.flipped;
        this.shipToPlace.x = x;
        this.shipToPlace.y = y;
        this.shipToPlace.setFlipped(this.flipped);
        this.shipToPlace.drawFireArcs(d, us.adjScrollX, us.adjScrollY, us.zoom, true);
        this.shipToPlace.x = sx;
        this.shipToPlace.y = sy;
        this.shipToPlace.setFlipped(sf);
        if (!this.shipToPlace.type.onGround && !this.ignoreServiceCeiling) {
            int sc = (int)us.worldToScreenY(512 - this.shipToPlace.serviceCeiling());
            d.rect(Clr.WHITE, 0.0, sc, sm.width, 2.0);
            d.rect(Clr.WHITE, 0.0, sc + 4, sm.width, 1.0);
            d.text(Lang._t("Service_Ceiling", new Object[0]), AGame.BIG_FOUNT, 5.0, sc - 20);
        }
    }

    @Override
    public boolean click(Input in, Pt click, ScreenMode sm, UniScreen us) {
        double x = us.screenToWorldX(click.x);
        double y = PlaceShipTool.getAdjustedY(this.shipToPlace, x, us.screenToWorldY(click.y), us, this.ignoreServiceCeiling);
        if (this.fromReserve && us.intent instanceof CampaignCombatIntent) {
            x = this.sideIndex == 0 ? -1600.0 : 1600.0 - this.shipToPlace.getBBWidth();
        }
        if (PlaceShipTool.canPlace(this.shipToPlace, x, y, this.sideIndex, us, this.ignoreServiceCeiling)) {
            this.placeShip(x, y, us, in);
            us.tool = UniScreen.NAVIGATE;
            return true;
        }
        return false;
    }

    @Override
    public boolean rightClick(Input in, Pt click, ScreenMode sm, UniScreen us) {
        if (this.cancelPutsBack) {
            this.placeShip(this.shipToPlace.x, this.shipToPlace.y, us, in);
        }
        us.tool = UniScreen.NAVIGATE;
        return true;
    }

    @Override
    public boolean mouseDown(Input in, Pt click, ScreenMode sm, UniScreen us) {
        return false;
    }

    @Override
    public void tick(Input in, int ms, UniScreen us) {
        if (!us.textInputOccurring() && in.keyPressed("F")) {
            boolean bl = this.flipped = !this.flipped;
        }
        if (in.keyPressed("ESCAPE")) {
            if (this.cancelPutsBack) {
                this.placeShip(this.shipToPlace.x, this.shipToPlace.y, us, in);
            }
            us.tool = UniScreen.NAVIGATE;
        }
    }
}

