/*
 * Decompiled with CFR 0.152.
 */
package com.zarkonnen.airships;

import com.zarkonnen.airships.AGame;
import com.zarkonnen.airships.Airship;
import com.zarkonnen.airships.City;
import com.zarkonnen.airships.Combat;
import com.zarkonnen.airships.DefencesIntent;
import com.zarkonnen.airships.GroundTool;
import com.zarkonnen.airships.LandBlockType;
import com.zarkonnen.airships.LandFormation;
import com.zarkonnen.airships.Lang;
import com.zarkonnen.airships.MyDraw;
import com.zarkonnen.airships.SingleCombatSetupIntent;
import com.zarkonnen.airships.UniScreen;
import com.zarkonnen.catengine.Draw;
import com.zarkonnen.catengine.Input;
import com.zarkonnen.catengine.util.Pt;

public class PlaceSoilTool
extends GroundTool {
    public boolean canPlace(LandFormation ground, int cursorX, int cursorY) {
        if (cursorY == ground.grid.length - 1) {
            return false;
        }
        if (ground.grid[cursorY][cursorX] != LandBlockType.AIR) {
            return false;
        }
        if (ground.grid[cursorY + 1][cursorX] == LandBlockType.AIR) {
            return false;
        }
        if (cursorX == 0 || cursorX == ground.grid[0].length - 1) {
            return true;
        }
        return ground.grid[cursorY + 1][cursorX - 1] != LandBlockType.AIR || ground.grid[cursorY + 1][cursorX + 1] != LandBlockType.AIR;
    }

    @Override
    public void drawScaled(MyDraw d, UniScreen us, LandFormation ground, int cursorX, int cursorY) {
        if (this.canPlace(ground, cursorX, cursorY)) {
            double x = ground.x + (double)(cursorX * 16);
            double y = ground.y + (double)(cursorY * 16);
            boolean allowed = us.intent instanceof SingleCombatSetupIntent || us.wm.owner((City)us.city).money >= 3;
            LandBlockType.SOIL.app.draw((Draw)d, x, y, 16.0, 16.0, 0, allowed ? AGame.HIGHLIGHT : AGame.FORBIDDEN, false);
        }
    }

    @Override
    public void drawUnscaled(MyDraw d, UniScreen us, LandFormation ground, int cursorX, int cursorY, Pt cursor) {
        if (this.canPlace(ground, cursorX, cursorY)) {
            boolean allowed = us.intent instanceof SingleCombatSetupIntent || us.wm.owner((City)us.city).money >= 3;
            d.text(allowed ? Lang._t("Place_x_Sy", LandBlockType.SOIL.getName(), 3) : "[ff9999]" + Lang._t("Place_x_Sy", LandBlockType.SOIL.getName(), 3), AGame.FOUNT, (int)cursor.x + 16, (int)cursor.y);
        }
    }

    @Override
    public boolean click(Input in, UniScreen us, LandFormation ground, int clickX, int clickY) {
        if (this.canPlace(ground, clickX, clickY) && (us.intent instanceof SingleCombatSetupIntent || us.wm.owner((City)us.city).money >= 3)) {
            ground.grid[clickY][clickX] = LandBlockType.SOIL;
            if (ground.grid[clickY + 1][clickX] == LandBlockType.GRASS) {
                ground.grid[clickY + 1][clickX] = LandBlockType.SOIL;
            }
            ground.crop();
            PlaceSoilTool.adjustBuildingVerticals(us);
            if (us.intent instanceof DefencesIntent) {
                us.wm.owner((City)us.city).money -= 3;
            }
        }
        return false;
    }

    public static void adjustBuildingVerticals(UniScreen us) {
        if (us.intent instanceof DefencesIntent) {
            for (Airship bld : us.city.getDefences()) {
                bld.y = us.city.ground.getVerticalPosition(bld, (int)bld.x, false);
            }
        }
        if (us.intent instanceof SingleCombatSetupIntent) {
            for (Combat.Side side : us.combat.sides) {
                for (Airship a : side.ships) {
                    if (!a.type.onGround) continue;
                    a.y = (double)us.combat.landFormations.get(0).getVerticalPosition(a, (int)a.x, false) - a.groundOffset();
                }
            }
        }
    }

    @Override
    public boolean rightClick(Input in, UniScreen us, LandFormation ground, int clickX, int clickY) {
        return false;
    }

    @Override
    public boolean mouseDown(Input in, UniScreen us, LandFormation ground, int clickX, int clickY) {
        return this.click(in, us, ground, clickX, clickY);
    }

    @Override
    public void tick(Input in, int ms, UniScreen us) {
    }
}

